package example;

import java.io.DataInputStream;
import java.io.IOException;

import jade.core.AID;
import jade.core.Agent;
import jade.core.Location;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;

public class WorkerAgent extends Agent {

	public Location destination;
	public String masterName;
	
	public int state = 0;
	
	protected void setup()
	{
		System.out.println("Worker agent started...");
		
		Object[] args = getArguments();
		this.destination = (Location)args[0];
		this.masterName = (String)args[1];
		
		this.addBehaviour(new OneShotBehaviour(this){

			public void action() 
			{
				System.out.println("Worker Agent: My state is " + state);
				state++;
				System.out.println("Worker agent:  migrating...");
				myAgent.doMove(destination);
				System.out.println("Worker Agent: My state is " + state);
				state++;
			}
			
		});
		
		this.addBehaviour(new OneShotBehaviour(this){

			public void action() 
			{
				System.out.println("Worker agent successfully migrated...");
				System.out.println("Worker Agent: My state is " + state);
			}
			
		});
		
		this.addBehaviour(new OneShotBehaviour(this){
			
			public void action()
			{
				System.out.println("Worker Agent: Press \"Enter\" to send message to master agent...");
				try 
				{
					(new DataInputStream(System.in)).readByte();			
				} catch (IOException e) {
					e.printStackTrace();
				}
				
				ACLMessage msg = new ACLMessage(ACLMessage.INFORM);
				String receiver = ((WorkerAgent)myAgent).masterName;
				msg.addReceiver(new AID(receiver,AID.ISLOCALNAME));
				msg.setContent("Hello from " + myAgent.getName() + "!!!");
				myAgent.send(msg);
			}
			
		});
		
	}
	
	protected void beforeMove()
	{
		System.out.println("============================================");
		System.out.println("Inside beforeMove: before worker agent migration...");
		System.out.println("============================================");
	}
	
	protected void afterMove()
	{
		System.out.println("============================================");
		System.out.println("Inside afterMove: after worker agent migration");
		System.out.println("============================================");
	}
	
}
