package example;

import java.io.DataInputStream;
import java.io.IOException;

import jade.content.lang.sl.SLCodec;
import jade.core.Agent;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.SequentialBehaviour;
import jade.domain.FIPANames;
import jade.domain.mobility.MobilityOntology;
import jade.lang.acl.ACLMessage;
import jade.wrapper.AgentContainer;
import jade.wrapper.AgentController;
import jade.wrapper.StaleProxyException;

public class MasterAgent extends Agent {

	private Object[] availableLocations;
	
	protected void setup()
	{
		System.out.println("Master agent has started...");
		
		//register the SL0 content language
		getContentManager().registerLanguage(new SLCodec(), FIPANames.ContentLanguage.FIPA_SL0);
		// register the mobility ontology
		getContentManager().registerOntology(MobilityOntology.getInstance());
		
		System.out.println("Master Agent: Press \"Enter\" to continue execution...");
		
		try 
		{
			(new DataInputStream(System.in)).readByte();			
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		SequentialBehaviour seq = new SequentialBehaviour();
		
		seq.addSubBehaviour(new GetAvailableContainersBehaviour(this));
		
	    seq.addSubBehaviour(new OneShotBehaviour(this){
	    	
	    	

			public void action()
	    	{
	    		//create new agent...
				AgentContainer container = myAgent.getContainerController();
				Object[] args = new Object[2];
				args[0] = ((MasterAgent)myAgent).getAvailableLocations()[1];
				args[1] = myAgent.getName();
				try{
					AgentController controller = container.createNewAgent("Worker Agent","example.WorkerAgent",args);
					controller.start();
				}catch(StaleProxyException e)
				{
					e.printStackTrace();
				}
				
				//wait for a message...
				System.out.println("Master Agent: Waiting for message from worker agent...");
				
				ACLMessage msg = myAgent.blockingReceive();
				
				System.out.println(msg.getContent());
				
	    	}
	    	
	    });
		
	    this.addBehaviour(seq);
	}

	
	public void setAvailableLocations(Object[] locations)
	{
		this.availableLocations = locations;
	}

	public Object[] getAvailableLocations()
	{
		return availableLocations;
	}
	
	protected void takeDown()
	{
		
	}
	
}
