package example;

import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.domain.FIPANames;
import jade.domain.JADEAgentManagement.QueryPlatformLocationsAction;
import jade.domain.mobility.MobilityOntology;
import jade.lang.acl.ACLMessage;
import jade.proto.SimpleAchieveREInitiator;

public class GetAvailableContainersBehaviour extends SimpleAchieveREInitiator {

	/**
	 * 
	 */

	private ACLMessage request;
	
	public GetAvailableContainersBehaviour(MasterAgent master)
	{
		//call the constructor of SimpleAchieveREInitiator Behaviour
		super(master,new ACLMessage(ACLMessage.REQUEST));
		//get the request message to be sent from the DataStore
		request = (ACLMessage)getDataStore().get(REQUEST_KEY);
		
		//fill the parameters of the request ACLMessage
		request.clearAllReceiver();
		request.addReceiver(myAgent.getAMS());
		request.setLanguage(FIPANames.ContentLanguage.FIPA_SL0);
		request.setOntology(jade.domain.mobility.MobilityOntology.NAME);
		request.setProtocol(FIPANames.InteractionProtocol.FIPA_REQUEST);
		
		//create the content of the ACLMessage
		try
		{
			Action action  = new Action();
			action.setActor(master.getAMS());
			action.setAction(new QueryPlatformLocationsAction());
			master.getContentManager().fillContent(request,action);			
		}catch(Exception e)
		{
			e.printStackTrace();
		}
		
		//reset the SimpleAchieveREInitiator with the new request message
		reset(request);
	}
	
	protected void handleNotUnderstood(ACLMessage reply)
	{
		System.out.println(myAgent.getLocalName() + "handleNotUnderstood" + reply.toString());
	}
	
	protected void handleRefuse(ACLMessage reply)
	{
		System.out.println(myAgent.getLocalName()+ " handleRefuse : "+reply.toString());
	}

	protected void handleFailure(ACLMessage reply) 
	{
		System.out.println(myAgent.getLocalName()+ " handleFailure : "+reply.toString());
	}

	protected void handleAgree(ACLMessage reply) 
	{
		
	}
	
	protected void handleInform(ACLMessage inform)
	{
		try
		{
			Result results = (Result)myAgent.getContentManager().extractContent(inform);
			((MasterAgent)myAgent).setAvailableLocations(results.getItems().toArray());
		}
		catch(Exception e)
		{
			System.out.println(e.toString());
		}
	}
}
