/*
 * Decompiled with CFR 0.152.
 */
package jade.wrapper;

import jade.core.Agent;
import jade.core.behaviours.CyclicBehaviour;
import jade.util.Event;
import jade.util.Logger;
import java.util.HashMap;
import java.util.Iterator;

public abstract class GatewayAgent
extends Agent {
    private final HashMap commandQueue = new HashMap(2);
    private final Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    protected abstract void processCommand(Object var1);

    public final void releaseCommand(Object object) {
        Event event;
        if (this.myLogger.isLoggable(Logger.INFO)) {
            this.myLogger.log(Logger.INFO, this.getLocalName() + " terminated execution of command " + object);
        }
        if ((event = (Event)this.commandQueue.remove(object)) != null) {
            event.notifyProcessed(null);
        }
    }

    public GatewayAgent() {
        this.setEnabledO2ACommunication(true, 0);
    }

    protected final void setup() {
        if (this.myLogger.isLoggable(Logger.INFO)) {
            this.myLogger.log(Logger.INFO, "Started GatewayAgent " + this.getLocalName());
        }
        DispatchCommandBehaviour dispatchCommandBehaviour = new DispatchCommandBehaviour();
        this.addBehaviour(dispatchCommandBehaviour);
    }

    protected void takeDown() {
        if (this.myLogger.isLoggable(Logger.INFO)) {
            this.myLogger.log(Logger.INFO, "Terminated GatewayAgent " + this.getLocalName());
        }
        Iterator iterator = this.commandQueue.values().iterator();
        while (iterator.hasNext()) {
            ((Event)iterator.next()).notifyProcessed(null);
        }
    }

    class DispatchCommandBehaviour
    extends CyclicBehaviour {
        DispatchCommandBehaviour() {
        }

        public void action() {
            Event event = (Event)GatewayAgent.this.getO2AObject();
            if (event == null) {
                this.block();
                return;
            }
            GatewayAgent.this.commandQueue.put(event.getSource(), event);
            if (GatewayAgent.this.myLogger.isLoggable(Logger.INFO)) {
                GatewayAgent.this.myLogger.log(Logger.INFO, GatewayAgent.this.getLocalName() + " started execution of command " + event.getSource());
            }
            GatewayAgent.this.processCommand(event.getSource());
        }
    }
}

