/*
 * Decompiled with CFR 0.152.
 */
package jade.util;

import jade.util.Logger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class AccessControlList {
    private static Logger logger = Logger.getMyLogger((class$jade$util$AccessControlList == null ? (class$jade$util$AccessControlList = AccessControlList.class$("jade.util.AccessControlList")) : class$jade$util$AccessControlList).getName());
    private String blackFileName = null;
    private String whiteFileName = null;
    private InternalACL black_iacl;
    private InternalACL white_iacl;
    static /* synthetic */ Class class$jade$util$AccessControlList;

    public void setBlack(String string) {
        this.blackFileName = string;
        this.refresh_black();
    }

    public void setWhite(String string) {
        this.whiteFileName = string;
        this.refresh_white();
    }

    public boolean isAllowed(String string, String string2) {
        boolean bl = false;
        if (logger.isLoggable(Logger.FINER)) {
            logger.log(Logger.FINER, "Current dir: " + System.getProperty("user.dir") + "\n" + "\nChecking files:\n    black=" + this.blackFileName + "\n    white=" + this.whiteFileName + "\n");
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.black_iacl != null) {
            bl2 = this.isInList(this.black_iacl, string, string2);
        }
        if (this.white_iacl != null) {
            bl3 = this.isInList(this.white_iacl, string, string2);
        }
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, " isInBlack=" + bl2 + " isInWhite=" + bl3);
        }
        bl = !bl2 && bl3;
        return bl;
    }

    private boolean isInList(InternalACL internalACL, String string, String string2) {
        boolean bl = false;
        try {
            String string3 = "";
            int n = 0;
            while (n < internalACL.size) {
                if (internalACL.sectionName[++n] != null) {
                    string3 = internalACL.sectionName[n];
                    logger.log(Logger.FINER, "Encountered section named: '" + string3 + "'");
                    continue;
                }
                if (!string3.equals(string) || internalACL.pat[n] == null) continue;
                Matcher matcher = null;
                matcher = internalACL.pat[n].matcher(string2);
                if (logger.isLoggable(Logger.FINER)) {
                    logger.log(Logger.FINER, "(" + internalACL.fileName + ")  " + "  pattern=" + internalACL.pat[n].pattern() + "  matcher=" + string2 + "\n");
                }
                boolean bl2 = matcher.matches();
                if (logger.isLoggable(Logger.FINER)) {
                    logger.log(Logger.FINER, "     " + string2 + "->" + bl2 + "\n");
                }
                if (!bl2) continue;
                bl = true;
            }
        }
        catch (Throwable throwable) {
            logger.log(Logger.WARNING, "Exception while checking " + internalACL.fileName, throwable);
            bl = false;
        }
        return bl;
    }

    public void refresh() {
        this.refresh_black();
        this.refresh_white();
    }

    private void refresh_black() {
        try {
            this.black_iacl = this.file2iacl(this.blackFileName);
        }
        catch (IOException iOException) {
            logger.log(Logger.WARNING, "Exception while checking: " + this.blackFileName, iOException);
        }
    }

    private void refresh_white() {
        try {
            this.white_iacl = this.file2iacl(this.whiteFileName);
        }
        catch (IOException iOException) {
            logger.log(Logger.WARNING, "Exception while checking: " + this.whiteFileName, iOException);
        }
    }

    private InternalACL file2iacl(String string) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        int n = 0;
        while (bufferedReader.readLine() != null) {
            ++n;
        }
        bufferedReader.close();
        InternalACL internalACL = new InternalACL(n + 1);
        internalACL.fileName = string;
        logger.log(Logger.FINER, "Opening acc.control list file:" + string + " (" + n + " lines)");
        bufferedReader = new BufferedReader(new FileReader(string));
        int n2 = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            ++n2;
            if ((string2 = string2.trim()).startsWith("#")) continue;
            if (string2.endsWith(":")) {
                internalACL.sectionName[n2] = string2.substring(0, string2.length() - 1);
                continue;
            }
            try {
                internalACL.pat[n2] = Pattern.compile(string2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                logger.log(Logger.WARNING, "Error in expression acc.control list file:" + string + " (line:" + n2 + ")");
            }
        }
        bufferedReader.close();
        return internalACL;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class InternalACL {
        public Pattern[] pat;
        public String[] sectionName;
        public int size;
        public String fileName;

        public InternalACL(int n) {
            this.size = n;
            this.pat = new Pattern[n + 1];
            this.sectionName = new String[n + 1];
        }
    }
}

