/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.testagent;

import jade.Boot;
import jade.content.AgentAction;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.basic.Action;
import jade.core.AID;
import jade.core.Agent;
import jade.domain.FIPAAgentManagement.AMSAgentDescription;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.Deregister;
import jade.domain.FIPAAgentManagement.FIPAManagementOntology;
import jade.domain.FIPAAgentManagement.Register;
import jade.domain.FIPAAgentManagement.Search;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.lang.acl.ACLMessage;
import jade.tools.testagent.ReceiveCyclicBehaviour;
import jade.tools.testagent.TestAgentFrame;
import jade.util.Logger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;

public class TestAgent
extends Agent {
    private static Logger logger = Logger.getMyLogger((class$jade$tools$testagent$TestAgent == null ? (class$jade$tools$testagent$TestAgent = TestAgent.class$("jade.tools.testagent.TestAgent")) : class$jade$tools$testagent$TestAgent).getName());
    boolean pingBehaviour = true;
    ImageIcon dummyIcon = new ImageIcon(this.getClass().getResource("images/dummy.gif"));
    SplashScreen splash;
    TestAgentFrame itsFrame;
    static /* synthetic */ Class class$jade$tools$testagent$TestAgent;

    public static void main(String[] stringArray) {
        String string = "cross.hq.acklin.nl";
        String[] stringArray2 = new String[]{"-host", string, "-container", "ruurd:jade.tools.testagent.TestAgent"};
        Boot.main(stringArray2);
    }

    public ACLMessage getPlatformRequest() {
        ACLMessage aCLMessage = new ACLMessage(16);
        aCLMessage.setSender(this.getAID());
        aCLMessage.setEncoding("String");
        aCLMessage.setLanguage("fipa-sl0");
        aCLMessage.setOntology("FIPA-Agent-Management");
        aCLMessage.setProtocol("fipa-request");
        aCLMessage.setReplyWith("Req" + new Date().getTime());
        aCLMessage.setConversationId("Req" + new Date().getTime());
        return aCLMessage;
    }

    public void doRegisterAMS() {
        AMSAgentDescription aMSAgentDescription = new AMSAgentDescription();
        aMSAgentDescription.setName(this.getAID());
        aMSAgentDescription.setOwnership(this.getHap());
        aMSAgentDescription.setState("ACTIVE");
        Register register = new Register();
        register.setDescription(aMSAgentDescription);
        ACLMessage aCLMessage = this.createRequestMessage(this, this.getAMS(), register);
        this.itsFrame.setItsMsg(aCLMessage);
    }

    public void doRegisterDF() {
        ServiceDescription serviceDescription = new ServiceDescription();
        serviceDescription.setName("testagent");
        serviceDescription.setOwnership(this.getHap());
        serviceDescription.setType("jade.testagent");
        DFAgentDescription dFAgentDescription = new DFAgentDescription();
        dFAgentDescription.setName(this.getAID());
        dFAgentDescription.addOntologies("FIPA-Agent-Management");
        dFAgentDescription.addLanguages("fipa-sl0");
        dFAgentDescription.addServices(serviceDescription);
        Register register = new Register();
        register.setDescription(dFAgentDescription);
        ACLMessage aCLMessage = this.createRequestMessage(this, this.getDefaultDF(), register);
        this.itsFrame.setItsMsg(aCLMessage);
    }

    public void doDeregisterDF() {
        DFAgentDescription dFAgentDescription = new DFAgentDescription();
        dFAgentDescription.setName(this.getAID());
        Deregister deregister = new Deregister();
        deregister.setDescription(dFAgentDescription);
        ACLMessage aCLMessage = this.createRequestMessage(this, this.getDefaultDF(), deregister);
        this.itsFrame.setItsMsg(aCLMessage);
    }

    public void doDeRegisterAMS() {
        AMSAgentDescription aMSAgentDescription = new AMSAgentDescription();
        aMSAgentDescription.setName(this.getAID());
        Deregister deregister = new Deregister();
        deregister.setDescription(aMSAgentDescription);
        ACLMessage aCLMessage = this.createRequestMessage(this, this.getAMS(), deregister);
        this.itsFrame.setItsMsg(aCLMessage);
    }

    public void doSearchAMS() {
        AMSAgentDescription aMSAgentDescription = new AMSAgentDescription();
        SearchConstraints searchConstraints = new SearchConstraints();
        searchConstraints.setMaxDepth(new Long(100L));
        searchConstraints.setMaxResults(new Long(100L));
        Search search = new Search();
        search.setConstraints(searchConstraints);
        search.setDescription(aMSAgentDescription);
        ACLMessage aCLMessage = this.createRequestMessage(this, this.getAMS(), search);
        this.itsFrame.setItsMsg(aCLMessage);
    }

    public void doSearchDF() {
        DFAgentDescription dFAgentDescription = new DFAgentDescription();
        SearchConstraints searchConstraints = new SearchConstraints();
        searchConstraints.setMaxDepth(new Long(100L));
        searchConstraints.setMaxResults(new Long(100L));
        Search search = new Search();
        search.setConstraints(searchConstraints);
        search.setDescription(dFAgentDescription);
        ACLMessage aCLMessage = this.createRequestMessage(this, this.getDefaultDF(), search);
        this.itsFrame.setItsMsg(aCLMessage);
    }

    public void doLausannePing() {
        ACLMessage aCLMessage = new ACLMessage(13);
        aCLMessage.setSender(this.getAID());
        AID aID = new AID("acl_ping", true);
        aID.setName("acl_ping@beta.lausanne.agentcities.net");
        aID.addAddresses("http://srv02.lausanne.agentcities.net:8080/acc");
        aCLMessage.addReceiver(aID);
        aCLMessage.setReplyWith("Req" + new Date().getTime());
        aCLMessage.setConversationId("Req" + new Date().getTime());
        aCLMessage.setContent("ping");
        this.itsFrame.setItsMsg(aCLMessage);
    }

    public void doLocalPing() {
        ACLMessage aCLMessage = new ACLMessage(13);
        aCLMessage.setSender(this.getAID());
        aCLMessage.addReceiver(this.getAID());
        aCLMessage.setReplyWith("Req" + new Date().getTime());
        aCLMessage.setConversationId("Req" + new Date().getTime());
        aCLMessage.setContent("ping");
        this.itsFrame.setItsMsg(aCLMessage);
    }

    public void doHelloWorld() {
        ACLMessage aCLMessage = new ACLMessage(7);
        aCLMessage.setSender(this.getAID());
        aCLMessage.addReceiver(this.getAID());
        aCLMessage.setContent("Hello World!");
        aCLMessage.setLanguage("Plain English");
        aCLMessage.setOntology("World Domination");
        aCLMessage.addUserDefinedParameter("key1", "value1");
        aCLMessage.addUserDefinedParameter("key2", "value2");
        aCLMessage.addUserDefinedParameter("key3", "value3");
        this.itsFrame.setItsMsg(aCLMessage);
    }

    public void doSystemOut() {
        System.out.println(this.itsFrame.getItsMsg());
    }

    public void doExit() {
        this.doDelete();
        System.exit(0);
    }

    public void doNewMessage() {
        ACLMessage aCLMessage = new ACLMessage(7);
        aCLMessage.setSender(this.getAID());
        this.itsFrame.setItsMsg(aCLMessage);
    }

    public void sendMessage() {
        ACLMessage aCLMessage = this.itsFrame.getItsMsg();
        this.itsFrame.addMessageNode("out", aCLMessage);
        this.send(aCLMessage);
        this.doNewMessage();
    }

    public void processIncomingMessage(ACLMessage aCLMessage) {
        this.itsFrame.addMessageNode("in", aCLMessage);
        if (this.pingBehaviour) {
            if (aCLMessage.getContent() == null) {
                return;
            }
            if (aCLMessage.getPerformative() == 13 && (aCLMessage.getContent().equalsIgnoreCase("ping") || aCLMessage.getContent().equalsIgnoreCase("(ping)"))) {
                ACLMessage aCLMessage2 = aCLMessage.createReply();
                aCLMessage2.setPerformative(7);
                aCLMessage2.setSender(this.getAID());
                aCLMessage2.setContent("alive");
                this.send(aCLMessage2);
                this.itsFrame.addMessageNode("out", aCLMessage2);
            }
        }
    }

    public void doReply() {
        ACLMessage aCLMessage = this.itsFrame.aclTreePanel.getCurrentACL();
        if (aCLMessage == null) {
            return;
        }
        ACLMessage aCLMessage2 = aCLMessage.createReply();
        aCLMessage2.setSender(this.getAID());
        this.itsFrame.aclPanel.setItsMsg(aCLMessage2);
    }

    protected void setup() {
        super.setup();
        this.splash = new SplashScreen();
        this.splash.show();
        this.splash.setProgress(25);
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "starting up: " + this.getAID().toString());
        }
        try {
            this.getContentManager().registerLanguage(new SLCodec(), "fipa-sl0");
            this.getContentManager().registerOntology(FIPAManagementOntology.getInstance(), "FIPA-Agent-Management");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.splash.setProgress(50);
        this.itsFrame = new TestAgentFrame(this);
        this.splash.setProgress(75);
        this.addBehaviour(new ReceiveCyclicBehaviour(this));
        this.splash.setProgress(100);
        this.splash.hide();
    }

    ACLMessage createRequestMessage(Agent agent, AID aID, AgentAction agentAction) {
        ACLMessage aCLMessage = new ACLMessage(16);
        aCLMessage.setSender(agent.getAID());
        aCLMessage.addReceiver(aID);
        aCLMessage.setProtocol("fipa-request");
        aCLMessage.setLanguage("fipa-sl0");
        aCLMessage.setEncoding("String");
        aCLMessage.setOntology("FIPA-Agent-Management");
        aCLMessage.setReplyWith("rw" + agent.getName() + new Date().getTime());
        aCLMessage.setConversationId("conv" + agent.getName() + new Date().getTime());
        Action action = new Action();
        action.setActor(aID);
        action.setAction(agentAction);
        try {
            this.getContentManager().fillContent(aCLMessage, action);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return aCLMessage;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SplashScreen
    extends JWindow {
        GridBagLayout gridBagLayout1 = new GridBagLayout();
        JPanel jPanel1 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        JLabel jLabel1 = new JLabel();
        JProgressBar theProgressBar = new JProgressBar();

        public SplashScreen() {
            try {
                this.jbInit();
                this.setSize(400, 50);
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                this.setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
                this.setVisible(true);
                this.requestFocus();
                Toolkit.getDefaultToolkit().sync();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void setProgress(int n) {
            this.theProgressBar.setValue(n);
        }

        void jbInit() {
            this.getContentPane().setLayout(this.gridBagLayout1);
            this.getContentPane().setBackground(Color.white);
            this.addFocusListener(new FocusAdapter(this){
                private final /* synthetic */ SplashScreen this$1;
                {
                    this.this$1 = splashScreen;
                }

                public void focusLost(FocusEvent focusEvent) {
                }
            });
            this.jPanel1.setBorder(BorderFactory.createLineBorder(Color.black));
            this.jPanel1.setLayout(this.gridBagLayout2);
            this.jLabel1.setBackground(Color.white);
            this.jLabel1.setForeground(Color.blue);
            this.jLabel1.setOpaque(true);
            this.jLabel1.setHorizontalAlignment(0);
            this.jLabel1.setText("loading, please wait...");
            this.jLabel1.setIcon(TestAgent.this.dummyIcon);
            this.theProgressBar.setBackground(Color.white);
            this.theProgressBar.setForeground(Color.blue);
            this.theProgressBar.setValue(5);
            this.theProgressBar.setStringPainted(true);
            this.getContentPane().add((Component)this.jPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel1.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel1.add((Component)this.theProgressBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 14, 2, new Insets(2, 5, 2, 5), 0, 0));
        }
    }
}

