/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.sniffer;

import jade.content.AgentAction;
import jade.content.ContentElement;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Done;
import jade.core.AID;
import jade.core.ContainerID;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.SenderBehaviour;
import jade.core.behaviours.SequentialBehaviour;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.domain.JADEAgentManagement.SniffOff;
import jade.domain.JADEAgentManagement.SniffOn;
import jade.domain.introspection.AMSSubscriber;
import jade.domain.introspection.AddedContainer;
import jade.domain.introspection.BornAgent;
import jade.domain.introspection.DeadAgent;
import jade.domain.introspection.Event;
import jade.domain.introspection.EventRecord;
import jade.domain.introspection.MovedAgent;
import jade.domain.introspection.Occurred;
import jade.domain.introspection.PostedMessage;
import jade.domain.introspection.RemovedContainer;
import jade.domain.introspection.ResetEvents;
import jade.domain.introspection.SentMessage;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.lang.acl.StringACLCodec;
import jade.proto.SimpleAchieveREInitiator;
import jade.proto.SimpleAchieveREResponder;
import jade.tools.ToolAgent;
import jade.tools.sniffer.ActionProcessor;
import jade.tools.sniffer.Agent;
import jade.tools.sniffer.DoNotSnifferAction;
import jade.tools.sniffer.DoSnifferAction;
import jade.tools.sniffer.MainWindow;
import jade.tools.sniffer.Message;
import jade.util.ExpandedProperties;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class Sniffer
extends ToolAgent {
    public static final boolean SNIFF_ON = true;
    public static final boolean SNIFF_OFF = false;
    private Set allAgents = null;
    private Hashtable preload = null;
    private ExpandedProperties properties = null;
    private static Logger logger = Logger.getMyLogger((class$jade$tools$sniffer$Sniffer == null ? (class$jade$tools$sniffer$Sniffer = Sniffer.class$("jade.tools.sniffer.Sniffer")) : class$jade$tools$sniffer$Sniffer).getName());
    private ArrayList agentsUnderSniff = new ArrayList();
    private SequentialBehaviour AMSSubscribe = new SequentialBehaviour();
    private MainWindow myGUI;
    private String myContainerName;
    static /* synthetic */ Class class$jade$tools$sniffer$Sniffer;

    protected String preloadContains(String string) {
        Enumeration enumeration = this.preload.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this.isMatch(string2, string)) continue;
            return string2;
        }
        return null;
    }

    protected boolean isMatch(String string, String string2) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '*') {
                return true;
            }
            if (n2 == string2.length()) {
                return false;
            }
            if (c != '?' && c != string2.charAt(n2)) {
                return false;
            }
            ++n2;
        }
        return n == string2.length();
    }

    public void toolSetup() {
        String string;
        ExpandedProperties expandedProperties = new ExpandedProperties();
        Object[] objectArray = this.getArguments();
        if (objectArray != null && objectArray.length > 0) {
            string = "";
            int n = 0;
            while (n < objectArray.length) {
                string = string + objectArray[n].toString();
                ++n;
            }
            expandedProperties.setProperty("preload", string);
        } else {
            string = this.locateFile("sniffer.properties");
            if (string != null) {
                try {
                    expandedProperties.addFromFile(string);
                }
                catch (IOException iOException) {}
            } else {
                string = this.locateFile("sniffer.inf");
                if (string != null) {
                    this.loadSnifferConfigurationFile(string, expandedProperties);
                }
            }
        }
        this.allAgents = new HashSet();
        this.preload = new Hashtable();
        string = expandedProperties.getProperty("preload", null);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreElements()) {
                this.parsePreloadDescription(stringTokenizer.nextToken());
            }
        }
        this.AMSSubscribe.addSubBehaviour(new SenderBehaviour(this, this.getSubscribe()));
        this.AMSSubscribe.addSubBehaviour(new SnifferAMSListenerBehaviour());
        this.addBehaviour(new RequestListenerBehaviour());
        this.addBehaviour(this.AMSSubscribe);
        this.addBehaviour(new SniffListenerBehaviour());
        this.myGUI = new MainWindow(this, expandedProperties);
        this.myGUI.ShowCorrect();
    }

    private void addAgent(AID aID) {
        ActionProcessor actionProcessor = this.myGUI.actPro;
        DoSnifferAction doSnifferAction = (DoSnifferAction)ActionProcessor.actions.get("DoSnifferAction");
        doSnifferAction.doSniff(aID.getName());
    }

    private void removeAgent(AID aID) {
        ActionProcessor actionProcessor = this.myGUI.actPro;
        DoNotSnifferAction doNotSnifferAction = (DoNotSnifferAction)ActionProcessor.actions.get("DoNotSnifferAction");
        doNotSnifferAction.doNotSniff(aID.getName());
    }

    private void loadSnifferConfigurationFile(String string, ExpandedProperties expandedProperties) {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            boolean bl = false;
            while (!bl) {
                String string2 = bufferedReader.readLine();
                boolean bl2 = bl = string2 == null;
                if (bl || (string2 = string2.trim()).length() <= 0) continue;
                stringBuffer.append(string2);
                stringBuffer.append(";");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (stringBuffer.length() > 0) {
            expandedProperties.setProperty("preload", stringBuffer.toString());
        }
    }

    private String locateFile(String string) {
        try {
            String string2 = new File(".").getAbsolutePath();
            while (string2 != null) {
                File file;
                File file2;
                if ((string2 = string2.replace('\\', '/')).endsWith(".")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                if (string2.endsWith("/")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                if ((file2 = new File(file = new File(string2), string)).exists()) {
                    return file2.getCanonicalPath();
                }
                string2 = file.getParent();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private void parsePreloadDescription(String string) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken();
        if (!string2.endsWith("*") && (n = string2.lastIndexOf(64)) == -1) {
            string2 = string2 + "@" + this.getHap();
        }
        n = ACLMessage.getAllPerformativeNames().length;
        boolean[] blArray = new boolean[n];
        boolean bl = !stringTokenizer.hasMoreTokens();
        int n2 = 0;
        while (n2 < n) {
            blArray[n2] = bl;
            ++n2;
        }
        while (stringTokenizer.hasMoreTokens()) {
            int n3 = ACLMessage.getInteger(stringTokenizer.nextToken());
            if (n3 == -1) continue;
            blArray[n3] = true;
        }
        this.preload.put(string2, blArray);
    }

    protected void toolTakeDown() {
        List list = (List)this.agentsUnderSniff.clone();
        ACLMessage aCLMessage = this.getSniffMsg(list, false);
        try {
            if (aCLMessage != null) {
                FIPAService.doFipaRequestClient(this, aCLMessage);
            }
        }
        catch (FIPAException fIPAException) {
            // empty catch block
        }
        this.myGUI.mainPanel.panelcan.canvMess.ml.removeAllMessages();
        this.send(this.getCancel());
        this.myGUI.disposeAsync();
    }

    public void sniffMsg(List list, boolean bl) {
        ACLMessage aCLMessage = this.getSniffMsg(list, bl);
        if (aCLMessage != null) {
            this.addBehaviour(new AMSClientBehaviour(bl ? "SniffAgentOn" : "SniffAgentOff", aCLMessage));
        }
    }

    public ACLMessage getSniffMsg(List list, boolean bl) {
        block8: {
            jade.util.leap.Serializable serializable;
            Serializable serializable2;
            Iterator iterator;
            block7: {
                jade.util.leap.Serializable serializable3;
                Serializable serializable4;
                iterator = list.iterator();
                if (!bl) break block7;
                SniffOn sniffOn = new SniffOn();
                sniffOn.setSniffer(this.getAID());
                boolean bl2 = true;
                while (iterator.hasNext()) {
                    serializable4 = (Agent)iterator.next();
                    serializable3 = new AID();
                    ((AID)serializable3).setName(((Agent)serializable4).agentName + '@' + this.getHap());
                    if (this.agentsUnderSniff.contains(serializable4)) continue;
                    this.agentsUnderSniff.add(serializable4);
                    sniffOn.addSniffedAgents((AID)serializable3);
                    bl2 = false;
                }
                if (bl2) break block8;
                try {
                    serializable4 = new Action();
                    ((Action)serializable4).setActor(this.getAMS());
                    ((Action)serializable4).setAction(sniffOn);
                    serializable3 = this.getRequest();
                    ((ACLMessage)serializable3).setOntology("JADE-Agent-Management");
                    this.getContentManager().fillContent((ACLMessage)serializable3, (ContentElement)serializable4);
                    return serializable3;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break block8;
            }
            SniffOff sniffOff = new SniffOff();
            sniffOff.setSniffer(this.getAID());
            boolean bl3 = true;
            while (iterator.hasNext()) {
                serializable2 = (Agent)iterator.next();
                serializable = new AID();
                ((AID)serializable).setName(((Agent)serializable2).agentName + '@' + this.getHap());
                if (!this.agentsUnderSniff.contains(serializable2)) continue;
                this.agentsUnderSniff.remove(serializable2);
                sniffOff.addSniffedAgents((AID)serializable);
                bl3 = false;
            }
            if (!bl3) {
                try {
                    serializable2 = new Action();
                    ((Action)serializable2).setActor(this.getAMS());
                    ((Action)serializable2).setAction(sniffOff);
                    serializable = this.getRequest();
                    ((ACLMessage)serializable).setOntology("JADE-Agent-Management");
                    this.getContentManager().fillContent((ACLMessage)serializable, (ContentElement)serializable2);
                    ((ACLMessage)serializable).setReplyWith(this.getName() + new Date().getTime());
                    return serializable;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ String access$502(Sniffer sniffer, String string) {
        sniffer.myContainerName = string;
        return sniffer.myContainerName;
    }

    private class RequestListenerBehaviour
    extends SimpleAchieveREResponder {
        private Action requestAction;
        private AgentAction aa;

        RequestListenerBehaviour() {
            super(Sniffer.this, MessageTemplate.and(MessageTemplate.MatchPerformative(16), MessageTemplate.MatchOntology("JADE-Agent-Management")));
        }

        protected ACLMessage prepareResponse(ACLMessage aCLMessage) {
            ACLMessage aCLMessage2;
            block5: {
                aCLMessage2 = aCLMessage.createReply();
                try {
                    this.requestAction = (Action)Sniffer.this.getContentManager().extractContent(aCLMessage);
                    this.aa = (AgentAction)this.requestAction.getAction();
                    if (this.aa instanceof SniffOn || this.aa instanceof SniffOff) {
                        if (Sniffer.this.getAID().equals(this.requestAction.getActor())) {
                            aCLMessage2.setPerformative(1);
                            aCLMessage2.setContent(aCLMessage.getContent());
                        } else {
                            aCLMessage2.setPerformative(14);
                            aCLMessage2.setContent("((unrecognised-parameter-value actor " + this.requestAction.getActor() + "))");
                        }
                        break block5;
                    }
                    aCLMessage2.setPerformative(14);
                    aCLMessage2.setContent("((unsupported-act " + this.aa.getClass().getName() + "))");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    aCLMessage2.setPerformative(10);
                }
            }
            return aCLMessage2;
        }

        protected ACLMessage prepareResultNotification(ACLMessage aCLMessage, ACLMessage aCLMessage2) {
            int n;
            jade.util.leap.Serializable serializable;
            jade.util.leap.Serializable serializable2;
            if (this.aa instanceof SniffOn) {
                serializable2 = (SniffOn)this.aa;
                serializable = ((SniffOn)serializable2).getCloneOfSniffedAgents();
                n = 0;
                while (n < serializable.size()) {
                    AID aID = (AID)serializable.get(n);
                    if (Sniffer.this.allAgents.contains(aID)) {
                        Sniffer.this.addAgent(aID);
                    } else {
                        int n2 = ACLMessage.getAllPerformativeNames().length;
                        boolean[] blArray = new boolean[n2];
                        int n3 = 0;
                        while (n3 < n2) {
                            blArray[n3] = true;
                            ++n3;
                        }
                        Sniffer.this.preload.put(aID.getName(), blArray);
                    }
                    ++n;
                }
            } else {
                serializable2 = (SniffOff)this.aa;
                serializable = ((SniffOff)serializable2).getCloneOfSniffedAgents();
                n = 0;
                while (n < serializable.size()) {
                    AID aID = (AID)serializable.get(n);
                    Sniffer.this.removeAgent(aID);
                    ++n;
                }
            }
            serializable2 = aCLMessage.createReply();
            ((ACLMessage)serializable2).setPerformative(7);
            serializable = new Done(this.requestAction);
            try {
                this.myAgent.getContentManager().fillContent((ACLMessage)serializable2, (ContentElement)serializable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return serializable2;
        }
    }

    class SnifferAMSListenerBehaviour
    extends ToolAgent.AMSListenerBehaviour {
        SnifferAMSListenerBehaviour() {
        }

        protected void installHandlers(Map map) {
            map.put("meta_reset-events", new AMSSubscriber.EventHandler(this){
                private final /* synthetic */ SnifferAMSListenerBehaviour this$1;
                {
                    this.this$1 = snifferAMSListenerBehaviour;
                }

                public void handle(Event event) {
                    ResetEvents resetEvents = (ResetEvents)event;
                    Sniffer.access$000(SnifferAMSListenerBehaviour.access$400(this.this$1)).resetTree();
                }
            });
            map.put("added-container", new AMSSubscriber.EventHandler(this){
                private final /* synthetic */ SnifferAMSListenerBehaviour this$1;
                {
                    this.this$1 = snifferAMSListenerBehaviour;
                }

                public void handle(Event event) {
                    AddedContainer addedContainer = (AddedContainer)event;
                    ContainerID containerID = addedContainer.getContainer();
                    String string = containerID.getName();
                    String string2 = containerID.getAddress();
                    try {
                        InetAddress inetAddress = InetAddress.getByName(string2);
                        Sniffer.access$000(SnifferAMSListenerBehaviour.access$400(this.this$1)).addContainer(string, inetAddress);
                    }
                    catch (UnknownHostException unknownHostException) {
                        Sniffer.access$000(SnifferAMSListenerBehaviour.access$400(this.this$1)).addContainer(string, null);
                    }
                }
            });
            map.put("removed-container", new AMSSubscriber.EventHandler(this){
                private final /* synthetic */ SnifferAMSListenerBehaviour this$1;
                {
                    this.this$1 = snifferAMSListenerBehaviour;
                }

                public void handle(Event event) {
                    RemovedContainer removedContainer = (RemovedContainer)event;
                    ContainerID containerID = removedContainer.getContainer();
                    String string = containerID.getName();
                    Sniffer.access$000(SnifferAMSListenerBehaviour.access$400(this.this$1)).removeContainer(string);
                }
            });
            map.put("born-agent", new AMSSubscriber.EventHandler(this){
                private final /* synthetic */ SnifferAMSListenerBehaviour this$1;
                {
                    this.this$1 = snifferAMSListenerBehaviour;
                }

                public void handle(Event event) {
                    BornAgent bornAgent = (BornAgent)event;
                    ContainerID containerID = bornAgent.getWhere();
                    String string = containerID.getName();
                    AID aID = bornAgent.getAgent();
                    Sniffer.access$000(SnifferAMSListenerBehaviour.access$400(this.this$1)).addAgent(string, aID);
                    if (aID.equals(SnifferAMSListenerBehaviour.access$400(this.this$1).getAID())) {
                        Sniffer.access$502(SnifferAMSListenerBehaviour.access$400(this.this$1), string);
                    }
                    if (SnifferAMSListenerBehaviour.access$400(this.this$1).preloadContains(aID.getName()) != null) {
                        ActionProcessor actionProcessor = Sniffer.access$000((Sniffer)SnifferAMSListenerBehaviour.access$400((SnifferAMSListenerBehaviour)this.this$1)).actPro;
                        DoSnifferAction doSnifferAction = (DoSnifferAction)ActionProcessor.actions.get("DoSnifferAction");
                        doSnifferAction.doSniff(aID.getName());
                    }
                }
            });
            map.put("dead-agent", new AMSSubscriber.EventHandler(this){
                private final /* synthetic */ SnifferAMSListenerBehaviour this$1;
                {
                    this.this$1 = snifferAMSListenerBehaviour;
                }

                public void handle(Event event) {
                    DeadAgent deadAgent = (DeadAgent)event;
                    ContainerID containerID = deadAgent.getWhere();
                    String string = containerID.getName();
                    AID aID = deadAgent.getAgent();
                    Sniffer.access$000(SnifferAMSListenerBehaviour.access$400(this.this$1)).removeAgent(string, aID);
                }
            });
            map.put("moved-agent", new AMSSubscriber.EventHandler(this){
                private final /* synthetic */ SnifferAMSListenerBehaviour this$1;
                {
                    this.this$1 = snifferAMSListenerBehaviour;
                }

                public void handle(Event event) {
                    MovedAgent movedAgent = (MovedAgent)event;
                    AID aID = movedAgent.getAgent();
                    ContainerID containerID = movedAgent.getFrom();
                    Sniffer.access$000(SnifferAMSListenerBehaviour.access$400(this.this$1)).removeAgent(containerID.getName(), aID);
                    ContainerID containerID2 = movedAgent.getTo();
                    Sniffer.access$000(SnifferAMSListenerBehaviour.access$400(this.this$1)).addAgent(containerID2.getName(), aID);
                }
            });
        }

        static /* synthetic */ Sniffer access$400(SnifferAMSListenerBehaviour snifferAMSListenerBehaviour) {
            return snifferAMSListenerBehaviour.Sniffer.this;
        }
    }

    private class SniffListenerBehaviour
    extends CyclicBehaviour {
        private MessageTemplate listenSniffTemplate;

        SniffListenerBehaviour() {
            this.listenSniffTemplate = MessageTemplate.MatchConversationId(Sniffer.this.getName() + "-event");
        }

        public void action() {
            block14: {
                ACLMessage aCLMessage = Sniffer.this.receive(this.listenSniffTemplate);
                if (aCLMessage != null) {
                    try {
                        String string;
                        String string2;
                        Object object;
                        Occurred occurred = (Occurred)Sniffer.this.getContentManager().extractContent(aCLMessage);
                        EventRecord eventRecord = occurred.getWhat();
                        Event event = eventRecord.getWhat();
                        String string3 = null;
                        Envelope envelope = null;
                        AID aID = null;
                        if (event instanceof SentMessage) {
                            string3 = ((SentMessage)event).getMessage().getPayload();
                            envelope = ((SentMessage)event).getMessage().getEnvelope();
                            aID = ((SentMessage)event).getReceiver();
                        } else if (event instanceof PostedMessage) {
                            string3 = ((PostedMessage)event).getMessage().getPayload();
                            envelope = ((PostedMessage)event).getMessage().getEnvelope();
                            aID = ((PostedMessage)event).getReceiver();
                        } else {
                            return;
                        }
                        StringACLCodec stringACLCodec = new StringACLCodec();
                        String string4 = null;
                        if (envelope == null || (string4 = envelope.getPayloadEncoding()) == null) {
                            string4 = "US-ASCII";
                        }
                        ACLMessage aCLMessage2 = stringACLCodec.decode(string3.getBytes(string4), string4);
                        aCLMessage2.setEnvelope(envelope);
                        Message message = new Message(aCLMessage2, aID);
                        if (event instanceof PostedMessage) {
                            object = new Agent(message.getSender());
                            if (Sniffer.this.agentsUnderSniff.contains(object)) {
                                return;
                            }
                        }
                        if ((string2 = Sniffer.this.preloadContains(string = message.getSender().getName())) != null) {
                            object = (boolean[])Sniffer.this.preload.get(string2);
                            if (message.getPerformative() >= 0 && object[message.getPerformative()] != false) {
                                ((Sniffer)Sniffer.this).myGUI.mainPanel.panelcan.canvMess.recMessage(message);
                            }
                            break block14;
                        }
                        ((Sniffer)Sniffer.this).myGUI.mainPanel.panelcan.canvMess.recMessage(message);
                    }
                    catch (Throwable throwable) {
                        Sniffer.this.myGUI.showError("An error occurred parsing the incoming message.\n          The message was lost.");
                        if (logger.isLoggable(Logger.WARNING)) {
                            logger.log(Logger.WARNING, "The sniffer lost the following message because of a parsing error:" + aCLMessage);
                        }
                        throwable.printStackTrace();
                    }
                } else {
                    this.block();
                }
            }
        }
    }

    private class AMSClientBehaviour
    extends SimpleAchieveREInitiator {
        private String actionName;

        public AMSClientBehaviour(String string, ACLMessage aCLMessage) {
            super(Sniffer.this, aCLMessage);
            this.actionName = string;
        }

        protected void handleNotUnderstood(ACLMessage aCLMessage) {
            Sniffer.this.myGUI.showError("NOT-UNDERSTOOD received during " + this.actionName);
        }

        protected void handleRefuse(ACLMessage aCLMessage) {
            Sniffer.this.myGUI.showError("REFUSE received during " + this.actionName);
        }

        protected void handleAgree(ACLMessage aCLMessage) {
            if (logger.isLoggable(Logger.FINE)) {
                logger.log(Logger.FINE, "AGREE received");
            }
        }

        protected void handleFailure(ACLMessage aCLMessage) {
            Sniffer.this.myGUI.showError("FAILURE received during " + this.actionName);
        }

        protected void handleInform(ACLMessage aCLMessage) {
            if (logger.isLoggable(Logger.FINE)) {
                logger.log(Logger.FINE, "INFORM received");
            }
        }
    }
}

