/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.rma;

import jade.core.AID;
import jade.core.ContainerID;
import jade.domain.FIPAAgentManagement.AMSAgentDescription;
import jade.domain.FIPAAgentManagement.APDescription;
import jade.domain.JADEAgentManagement.InstallMTP;
import jade.domain.JADEAgentManagement.UninstallMTP;
import jade.gui.APDescriptionPanel;
import jade.gui.AclGui;
import jade.gui.AgentTree;
import jade.gui.AgentTreeModel;
import jade.lang.acl.ACLMessage;
import jade.tools.rma.ActionProcessor;
import jade.tools.rma.InstallMTPDialog;
import jade.tools.rma.MainMenu;
import jade.tools.rma.MainPanel;
import jade.tools.rma.MainWindow;
import jade.tools.rma.ManageMTPsDialog;
import jade.tools.rma.PopupMenuAgent;
import jade.tools.rma.PopupMenuContainer;
import jade.tools.rma.PopupMenuFrozenAgent;
import jade.tools.rma.PopupMenuPlatform;
import jade.tools.rma.PopupMenuRemotePlatform;
import jade.tools.rma.RMAAction;
import jade.tools.rma.ToolBar;
import jade.tools.rma.WindowCloser;
import jade.tools.rma.rma;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class MainWindow
extends JFrame {
    private MainPanel tree;
    private ActionProcessor actPro;
    private PopupMenuAgent popA;
    private PopupMenuFrozenAgent popFA;
    private PopupMenuContainer popC;
    private PopupMenuPlatform popP;
    private PopupMenuRemotePlatform popRP;
    private InstallMTPDialog installDlg = new InstallMTPDialog((Frame)this, true);
    private ManageMTPsDialog manageDlg;
    private String logojade = "images/logosmall.jpg";
    private List containerNames = new LinkedList();
    private Map addresses = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    public MainWindow(rma rma2) {
        super(rma2.getName() + " - JADE Remote Agent Management GUI");
        this.manageDlg = new ManageMTPsDialog(rma2, this, false, this.addresses);
        this.tree = new MainPanel(rma2, this);
        this.actPro = new ActionProcessor(rma2, this, this.tree);
        this.setJMenuBar(new MainMenu(this, this.actPro));
        this.popA = new PopupMenuAgent(this.actPro);
        this.popFA = new PopupMenuFrozenAgent(this.actPro);
        this.popC = new PopupMenuContainer(this.actPro);
        this.popP = new PopupMenuPlatform(this.actPro);
        this.popRP = new PopupMenuRemotePlatform(this.actPro);
        this.tree.treeAgent.register("FIPAAGENT", this.popA, "images/runtree.gif");
        this.tree.treeAgent.register("FROZENAGENT", this.popFA, "images/freezeagent.gif");
        this.tree.treeAgent.register("FROZENCONTAINER", null, "images/frozenagents.gif");
        this.tree.treeAgent.register("FIPACONTAINER", this.popC, "images/foldergreen.gif");
        this.tree.treeAgent.register("REMOTEPLATFORM", this.popRP, "images/folderlightblue.gif");
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = jPopupMenu.add((RMAAction)ActionProcessor.actions.get("Custom Agent"));
        jMenuItem.setIcon(null);
        jMenuItem = jPopupMenu.add((RMAAction)ActionProcessor.actions.get("Register Remote Agent with local AMS"));
        jMenuItem.setIcon(null);
        jMenuItem.setEnabled(false);
        this.tree.treeAgent.register("REMOTEAGENT", jPopupMenu, "images/runtree.gif");
        this.tree.treeAgent.setNewPopupMenu("SUPERCONTAINER", this.popP);
        JPopupMenu jPopupMenu2 = new JPopupMenu();
        JMenuItem jMenuItem2 = jPopupMenu2.add((RMAAction)ActionProcessor.actions.get("View AP Description"));
        jMenuItem2.setIcon(null);
        jPopupMenu2.add((RMAAction)ActionProcessor.actions.get("Manage Installed MTPs"));
        this.tree.treeAgent.setNewPopupMenu("LOCALPLATFORM", jPopupMenu2);
        this.setForeground(Color.black);
        this.setBackground(Color.lightGray);
        Image image = this.getToolkit().getImage(this.getClass().getResource(this.logojade));
        this.setIconImage(image);
        this.addWindowListener(new WindowCloser(rma2));
        this.getContentPane().add((Component)new ToolBar(this.tree, this, this.actPro), "North");
        this.getContentPane().add((Component)this.tree, "Center");
    }

    public void ShowCorrect() {
        this.pack();
        this.setSize(600, 400);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (int)dimension.getWidth() / 2;
        int n2 = (int)dimension.getHeight() / 2;
        this.setLocation(n - 300, n2 - 200);
        this.tree.adjustDividersLocation();
        this.setVisible(true);
        this.toFront();
    }

    public void disposeAsync() {
        class DisposeIt
        implements Runnable {
            private Window toDispose;
            private final /* synthetic */ MainWindow this$0;

            public DisposeIt(MainWindow mainWindow, Window window) {
                this.this$0 = mainWindow;
                this.toDispose = window;
            }

            public void run() {
                this.toDispose.dispose();
            }
        }
        SwingUtilities.invokeLater(new DisposeIt(this, this));
    }

    public AgentTreeModel getModel() {
        return this.tree.treeAgent.getModel();
    }

    public void resetTree() {
        Runnable runnable = new Runnable(){

            public void run() {
                ((MainWindow)MainWindow.this).tree.treeAgent.clearLocalPlatform();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void addContainer(final String string, final InetAddress inetAddress) {
        Runnable runnable = new Runnable(){

            public void run() {
                AgentTree.Node node = ((MainWindow)MainWindow.this).tree.treeAgent.createNewNode(string, 0);
                ((MainWindow)MainWindow.this).tree.treeAgent.addContainerNode((AgentTree.ContainerNode)node, "FIPACONTAINER", inetAddress);
                MainWindow.this.containerNames.add(string);
                MainWindow.this.manageDlg.setData(MainWindow.this.containerNames, MainWindow.this.addresses);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void removeContainer(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                ((MainWindow)MainWindow.this).tree.treeAgent.removeContainerNode(string);
                MainWindow.this.containerNames.remove(string);
                MainWindow.this.manageDlg.setData(MainWindow.this.containerNames, MainWindow.this.addresses);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void addAgent(final String string, final AID aID) {
        Runnable runnable = new Runnable(){

            public void run() {
                String string3 = aID.getName();
                AgentTree.Node node = ((MainWindow)MainWindow.this).tree.treeAgent.createNewNode(string3, 1);
                jade.util.leap.Iterator iterator = aID.getAllAddresses();
                String string2 = "";
                while (iterator.hasNext()) {
                    string2 = string2 + iterator.next() + " ";
                }
                ((MainWindow)MainWindow.this).tree.treeAgent.addAgentNode((AgentTree.AgentNode)node, string, string3, string2, "FIPAAGENT");
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void removeAgent(final String string, final AID aID) {
        Runnable runnable = new Runnable(){

            public void run() {
                String string2 = aID.getName();
                ((MainWindow)MainWindow.this).tree.treeAgent.removeAgentNode(string, string2);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void modifyAgent(final String string, final AID aID, final String string2, final String string3) {
        Runnable runnable = new Runnable(){

            public void run() {
                String string4 = aID.getName();
                ((MainWindow)MainWindow.this).tree.treeAgent.modifyAgentNode(string, string4, null, string2, string3);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void moveAgent(final String string, final String string2, final AID aID) {
        Runnable runnable = new Runnable(){

            public void run() {
                String string3 = aID.getName();
                ((MainWindow)MainWindow.this).tree.treeAgent.moveAgentNode(string, string2, string3);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void modifyFrozenAgent(final String string, final String string2, final AID aID) {
        Runnable runnable = new Runnable(){

            public void run() {
                String string3 = aID.getName();
                ((MainWindow)MainWindow.this).tree.treeAgent.freezeAgentNode(string, string2, string3);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void modifyThawedAgent(final String string, final String string2, final AID aID) {
        Runnable runnable = new Runnable(){

            public void run() {
                String string3 = aID.getName();
                ((MainWindow)MainWindow.this).tree.treeAgent.thawAgentNode(string, string2, string3);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void addAddress(final String string, final String string2) {
        Runnable runnable = new Runnable(){

            public void run() {
                LinkedList<String> linkedList = (LinkedList<String>)MainWindow.this.addresses.get(string2);
                if (linkedList == null) {
                    linkedList = new LinkedList<String>();
                    MainWindow.this.addresses.put(string2, linkedList);
                }
                linkedList.add(string);
                MainWindow.this.manageDlg.setData(MainWindow.this.containerNames, MainWindow.this.addresses);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void addRemotePlatformFolder() {
        Runnable runnable = new Runnable(){

            public void run() {
                PopupMenuPlatform popupMenuPlatform = new PopupMenuPlatform(MainWindow.this.actPro);
                ((MainWindow)MainWindow.this).tree.treeAgent.register("REMOTEPLATFORMS", popupMenuPlatform, "images/folderblue.gif");
                ((MainWindow)MainWindow.this).tree.treeAgent.addRemotePlatformsFolderNode();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void addRemotePlatform(AID aID, APDescription aPDescription) {
        final APDescription aPDescription2 = aPDescription;
        final AID aID2 = aID;
        Runnable runnable = new Runnable(){

            public void run() {
                ((MainWindow)MainWindow.this).tree.treeAgent.addRemotePlatformNode(aID2, aPDescription2);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void addRemoteAgentsToRemotePlatform(final APDescription aPDescription, final Iterator iterator) {
        Runnable runnable = new Runnable(){

            public void run() {
                while (iterator.hasNext()) {
                    AMSAgentDescription aMSAgentDescription = (AMSAgentDescription)iterator.next();
                    ((MainWindow)MainWindow.this).tree.treeAgent.addRemoteAgentNode(aMSAgentDescription, aPDescription.getName());
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void removeRemotePlatform(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                ((MainWindow)MainWindow.this).tree.treeAgent.removeRemotePlatformNode(string);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void removeAddress(final String string, final String string2) {
        Runnable runnable = new Runnable(){

            public void run() {
                List list = (List)MainWindow.this.addresses.get(string2);
                list.remove(string);
                if (list.isEmpty()) {
                    MainWindow.this.addresses.remove(string2);
                }
                MainWindow.this.manageDlg.setData(MainWindow.this.containerNames, MainWindow.this.addresses);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void refreshLocalPlatformName(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                ((MainWindow)MainWindow.this).tree.treeAgent.refreshLocalPlatformName(string);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void showErrorDialog(String string, ACLMessage aCLMessage) {
        String[] stringArray = new String[]{string, "", "Do you want to view the ACL message ?"};
        int n = JOptionPane.showConfirmDialog(this, stringArray, "RMA Error !!!", 0, 0);
        switch (n) {
            case 0: {
                AclGui.showMsgInDialog(aCLMessage, this);
                break;
            }
        }
    }

    public boolean showExitDialog(String string) {
        int n = JOptionPane.showConfirmDialog(this, "Are you really sure to exit ?", string, 0);
        return n == 0;
    }

    public boolean showInstallMTPDialog(InstallMTP installMTP) {
        String[] stringArray = this.containerNames.toArray(new String[0]);
        this.installDlg.reset(stringArray, installMTP.getContainer().getName());
        this.installDlg.pack();
        this.installDlg.setVisible(true);
        installMTP.setContainer(new ContainerID(this.installDlg.getContainer(), null));
        installMTP.setAddress(this.installDlg.getAddress());
        installMTP.setClassName(this.installDlg.getClassName());
        return this.installDlg.isConfirmed();
    }

    public boolean showUninstallMTPDialog(UninstallMTP uninstallMTP) {
        String string = uninstallMTP.getContainer().getName();
        List list = (List)this.addresses.get(string);
        if (list == null) {
            JOptionPane.showMessageDialog(this, "No MTPs are currently installed on this container.", "Error during MTP removal", 0);
            return false;
        }
        Object[] objectArray = list.toArray();
        String string2 = (String)JOptionPane.showInputDialog(this, "Choose the MTP to remove.", "Remove an MTP", 1, null, objectArray, objectArray[0]);
        if (string2 != null) {
            uninstallMTP.setAddress(string2);
            return true;
        }
        return false;
    }

    public void showManageMTPsDialog() {
        this.manageDlg.showCentered();
    }

    public void viewAPDescriptionDialog(APDescription aPDescription, String string) {
        if (aPDescription != null) {
            APDescriptionPanel.showAPDescriptionInDialog(aPDescription, this, string);
        }
    }

    private void setUI(String string) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf." + string);
            SwingUtilities.updateComponentTreeUI(this);
            this.pack();
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace(System.out);
        }
    }

    public void setUI2Motif() {
        this.setUI("motif.MotifLookAndFeel");
    }

    public void setUI2Windows() {
        this.setUI("windows.WindowsLookAndFeel");
    }

    public void setUI2Multi() {
        this.setUI("multi.MultiLookAndFeel");
    }

    public void setUI2Metal() {
        this.setUI("metal.MetalLookAndFeel");
    }
}

