/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.rma;

import jade.gui.AgentTree;
import jade.tools.rma.AddRemotePlatformAction;
import jade.tools.rma.AddRemotePlatformFromURLAction;
import jade.tools.rma.AgentAction;
import jade.tools.rma.ChangeAgentOwnershipAction;
import jade.tools.rma.CloneAgentAction;
import jade.tools.rma.CloseRMAAction;
import jade.tools.rma.ContainerAction;
import jade.tools.rma.CustomAction;
import jade.tools.rma.DummyAgentAction;
import jade.tools.rma.ExitAction;
import jade.tools.rma.FixedAction;
import jade.tools.rma.FreezeAgentAction;
import jade.tools.rma.GenericAction;
import jade.tools.rma.InstallMTPAction;
import jade.tools.rma.IntrospectorAction;
import jade.tools.rma.KillAction;
import jade.tools.rma.LoadAgentAction;
import jade.tools.rma.LoadContainerAction;
import jade.tools.rma.LogManagerAgentAction;
import jade.tools.rma.MainPanel;
import jade.tools.rma.MainWindow;
import jade.tools.rma.ManageMTPsAction;
import jade.tools.rma.MoveAgentAction;
import jade.tools.rma.PlatformAction;
import jade.tools.rma.RMAAction;
import jade.tools.rma.RefreshAMSAgentAction;
import jade.tools.rma.RefreshAPDescriptionAction;
import jade.tools.rma.RegisterRemoteAgentAction;
import jade.tools.rma.RemoveRemoteAMSAction;
import jade.tools.rma.ResumeAction;
import jade.tools.rma.SaveAgentAction;
import jade.tools.rma.SaveContainerAction;
import jade.tools.rma.ShowDFGuiAction;
import jade.tools.rma.ShutDownAction;
import jade.tools.rma.SnifferAction;
import jade.tools.rma.StartException;
import jade.tools.rma.StartNewAgentAction;
import jade.tools.rma.SuspendAction;
import jade.tools.rma.ThawAgentAction;
import jade.tools.rma.UninstallMTPAction;
import jade.tools.rma.ViewAPDescriptionAction;
import jade.tools.rma.rma;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;

class ActionProcessor {
    private MainPanel panel;
    private RMAAction action;
    public static final String START_ACTION = "Start new Agent";
    public static final String MANAGE_MTPS_ACTION = "Manage Installed MTPs";
    public static final String INSTALL_MTP_ACTION = "Install a new MTP";
    public static final String UNINSTALL_MTP_ACTION = "Uninstall an MTP";
    public static final String KILL_ACTION = "Kill";
    public static final String SUSPEND_ACTION = "Suspend Agent";
    public static final String RESUME_ACTION = "Resume Agent";
    public static final String CHANGE_AGENT_OWNERSHIP_ACTION = "Change Agent Ownership";
    public static final String CUSTOM_ACTION = "Custom Agent";
    public static final String SNIFFER_ACTION = "Start Sniffer";
    public static final String DUMMYAG_ACTION = "Start DummyAgent";
    public static final String LOGGERAG_ACTION = "Start LoggerAgent";
    public static final String INTROSPECTOR_ACTION = "Start IntrospectAgent ";
    public static final String CLOSE_ACTION = "Close RMA";
    public static final String EXIT_ACTION = "Exit RMA";
    public static final String SHUTDOWN_ACTION = "Shutdown action";
    public static final String SHOWDF_ACTION = "ShowDfGui Action";
    public static final String MOVEAGENT_ACTION = "Migrate Agent";
    public static final String CLONEAGENT_ACTION = "Clone Agent";
    public static final String SAVEAGENT_ACTION = "Save Agent";
    public static final String LOADAGENT_ACTION = "Load Agent";
    public static final String FREEZEAGENT_ACTION = "Freeze Agent";
    public static final String THAWAGENT_ACTION = "Thaw Agent";
    public static final String SAVECONTAINER_ACTION = "Save Container";
    public static final String LOADCONTAINER_ACTION = "Load Container";
    public static final String ADDREMOTEPLATFORM_ACTION = "Add Platform via AMS AID";
    public static final String ADDREMOTEPLATFORMFROMURL_ACTION = "Add Platform via URL";
    public static final String VIEWPLATFORM_ACTION = "View AP Description";
    public static final String REFRESHAPDESCRIPTION_ACTION = "Refresh AP Description";
    public static final String REMOVEREMOTEAMS_ACTION = "Remove Remote Platform";
    public static final String REFRESHAMSAGENT_ACTION = "Refresh Agent List";
    public static final String REGISTERREMOTEAGENTWITHAMS_ACTION = "Register Remote Agent with local AMS";
    public static final Map actions = new HashMap();

    public ActionProcessor(rma rma2, MainWindow mainWindow, MainPanel mainPanel) {
        this.panel = mainPanel;
        actions.put(START_ACTION, new StartNewAgentAction(rma2, mainWindow, this));
        actions.put(MANAGE_MTPS_ACTION, new ManageMTPsAction(mainWindow, this));
        actions.put(INSTALL_MTP_ACTION, new InstallMTPAction(rma2, this));
        actions.put(UNINSTALL_MTP_ACTION, new UninstallMTPAction(rma2, this));
        actions.put(KILL_ACTION, new KillAction(KILL_ACTION, rma2, this));
        actions.put(SUSPEND_ACTION, new SuspendAction(rma2, this));
        actions.put(RESUME_ACTION, new ResumeAction(rma2, this));
        actions.put(CHANGE_AGENT_OWNERSHIP_ACTION, new ChangeAgentOwnershipAction(rma2, this, mainWindow));
        actions.put(CUSTOM_ACTION, new CustomAction(rma2, mainWindow, this));
        actions.put(SNIFFER_ACTION, new SnifferAction(rma2, this));
        actions.put(DUMMYAG_ACTION, new DummyAgentAction(rma2, this));
        actions.put(LOGGERAG_ACTION, new LogManagerAgentAction(rma2, this));
        actions.put(INTROSPECTOR_ACTION, new IntrospectorAction(rma2, this));
        actions.put(CLOSE_ACTION, new CloseRMAAction(rma2, this));
        actions.put(EXIT_ACTION, new ExitAction(rma2, this));
        actions.put(SHUTDOWN_ACTION, new ShutDownAction(rma2, this));
        actions.put(SHOWDF_ACTION, new ShowDFGuiAction(rma2, this));
        actions.put(MOVEAGENT_ACTION, new MoveAgentAction(rma2, this, mainWindow));
        actions.put(CLONEAGENT_ACTION, new CloneAgentAction(rma2, this, mainWindow));
        actions.put(SAVEAGENT_ACTION, new SaveAgentAction(rma2, this));
        actions.put(LOADAGENT_ACTION, new LoadAgentAction(rma2, this, mainWindow));
        actions.put(FREEZEAGENT_ACTION, new FreezeAgentAction(rma2, this));
        actions.put(THAWAGENT_ACTION, new ThawAgentAction(rma2, this, mainWindow));
        actions.put(SAVECONTAINER_ACTION, new SaveContainerAction(rma2, this));
        actions.put(LOADCONTAINER_ACTION, new LoadContainerAction(rma2, this));
        actions.put(ADDREMOTEPLATFORM_ACTION, new AddRemotePlatformAction(rma2, this, mainWindow));
        actions.put(VIEWPLATFORM_ACTION, new ViewAPDescriptionAction(rma2, this));
        actions.put(REFRESHAPDESCRIPTION_ACTION, new RefreshAPDescriptionAction(rma2, this));
        actions.put(REMOVEREMOTEAMS_ACTION, new RemoveRemoteAMSAction(rma2, this));
        actions.put(REFRESHAMSAGENT_ACTION, new RefreshAMSAgentAction(rma2, this));
        actions.put(ADDREMOTEPLATFORMFROMURL_ACTION, new AddRemotePlatformFromURLAction(rma2, this, mainWindow));
        actions.put(REGISTERREMOTEAGENTWITHAMS_ACTION, new RegisterRemoteAgentAction(rma2, this));
    }

    public void process(RMAAction rMAAction) {
        this.action = rMAAction;
        TreePath[] treePathArray = this.panel.treeAgent.tree.getSelectionPaths();
        if (this.action instanceof FixedAction) {
            this.fixedAct();
        } else if (treePathArray != null) {
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                AgentTree.Node node = (AgentTree.Node)treePathArray[n2].getLastPathComponent();
                if (this.action instanceof AgentAction) {
                    this.agentAct(node);
                } else if (this.action instanceof ContainerAction) {
                    this.containerAct(node);
                } else if (this.action instanceof GenericAction) {
                    this.genericAct(node);
                } else if (this.action instanceof PlatformAction) {
                    this.platformAct(node);
                }
                ++n2;
            }
        } else if (this.action instanceof AgentAction) {
            JOptionPane.showMessageDialog(new JFrame(), "You must select an agent in the Tree", "Start Procedure Error", 0);
        } else if (this.action instanceof DummyAgentAction || this.action instanceof SnifferAction || this.action instanceof IntrospectorAction || this.action instanceof LogManagerAgentAction) {
            this.containerAct(null);
        } else if (this.action instanceof PlatformAction) {
            JOptionPane.showMessageDialog(new JFrame(), "You must select a platform", "Error", 0);
        } else {
            JOptionPane.showMessageDialog(new JFrame(), "You must select an agent-platform or a agent-container in the Tree", "Start Procedure Error", 0);
        }
    }

    private void fixedAct() {
        FixedAction fixedAction = (FixedAction)this.action;
        fixedAction.doAction();
    }

    private void agentAct(AgentTree.Node node) {
        AgentAction agentAction = (AgentAction)this.action;
        if (node instanceof AgentTree.AgentNode) {
            AgentTree.AgentNode agentNode = (AgentTree.AgentNode)node;
            agentAction.doAction(agentNode);
        }
    }

    private void containerAct(AgentTree.Node node) {
        ContainerAction containerAction = (ContainerAction)this.action;
        if ((containerAction instanceof DummyAgentAction || containerAction instanceof SnifferAction || containerAction instanceof IntrospectorAction || containerAction instanceof LogManagerAgentAction) && (node == null || node instanceof AgentTree.SuperContainer)) {
            containerAction.doAction(null);
        } else {
            try {
                if (!(node instanceof AgentTree.ContainerNode)) {
                    throw new StartException();
                }
                AgentTree.ContainerNode containerNode = (AgentTree.ContainerNode)node;
                containerAction.doAction(containerNode);
            }
            catch (StartException startException) {
                StartException.handle();
            }
        }
    }

    private void genericAct(AgentTree.Node node) {
        GenericAction genericAction = (GenericAction)this.action;
        if (node instanceof AgentTree.ContainerNode) {
            AgentTree.ContainerNode containerNode = (AgentTree.ContainerNode)node;
            genericAction.doAction(containerNode);
        } else if (node instanceof AgentTree.AgentNode) {
            AgentTree.AgentNode agentNode = (AgentTree.AgentNode)node;
            genericAction.doAction(agentNode);
        }
    }

    private void platformAct(AgentTree.Node node) {
        PlatformAction platformAction = (PlatformAction)this.action;
        if (node instanceof AgentTree.localPlatformFolderNode || node instanceof AgentTree.RemotePlatformNode) {
            platformAction.doAction(node);
        }
    }
}

