/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.introspector.gui;

import jade.core.AID;
import jade.domain.introspection.AddedBehaviour;
import jade.domain.introspection.ChangedAgentState;
import jade.domain.introspection.ChangedBehaviourState;
import jade.domain.introspection.PostedMessage;
import jade.domain.introspection.ReceivedMessage;
import jade.domain.introspection.RemovedBehaviour;
import jade.domain.introspection.SentMessage;
import jade.gui.AboutJadeAction;
import jade.gui.AgentTree;
import jade.gui.AgentTreeModel;
import jade.tools.introspector.Introspector;
import jade.tools.introspector.gui.AboutBoxAction;
import jade.tools.introspector.gui.BehaviourPanel;
import jade.tools.introspector.gui.IntrospectorGUI;
import jade.tools.introspector.gui.MainWindow;
import jade.tools.introspector.gui.MessagePanel;
import jade.tools.introspector.gui.StatePanel;
import jade.tools.introspector.gui.StateUpdater;
import jade.tools.introspector.gui.TableUpdater;
import jade.tools.introspector.gui.TreeAgentPopupMenu;
import jade.tools.introspector.gui.TreePanel;
import jade.tools.introspector.gui.TreeUpdater;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.InetAddress;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class IntrospectorGUI
extends JFrame
implements WindowListener {
    private Introspector debugger;
    private TreePanel panel;
    private JDesktopPane desk;
    private JSplitPane split;
    private JScrollPane scroll;
    private JMenuBar bar;
    private JMenu menuFile;
    private JMenu menuAbout;
    private JMenuItem item;
    private String logoIntrospector = "images/bug.gif";

    public IntrospectorGUI(Introspector introspector) {
        this.debugger = introspector;
        this.panel = new TreePanel(this);
        this.panel.treeAgent.register("FIPAAGENT", new TreeAgentPopupMenu(this.debugger, this.panel.treeAgent), "images/runtree.gif");
        this.panel.treeAgent.register("FIPACONTAINER", null, "images/foldergreen.gif");
        this.scroll = new JScrollPane();
        this.desk = new JDesktopPane();
        this.split = new JSplitPane();
        this.bar = new JMenuBar();
        this.menuFile = new JMenu();
        this.item = new JMenuItem();
        this.menuAbout = new JMenu();
        this.build();
    }

    public void build() {
        String string = this.debugger.getAID().getName();
        this.setTitle(string);
        Image image = this.getToolkit().getImage(this.getClass().getResource(this.logoIntrospector));
        this.setIconImage(image);
        Font font = new Font("Monospaced", 0, 10);
        this.split.setOrientation(1);
        this.split.setContinuousLayout(true);
        this.getContentPane().add(this.split);
        this.menuFile.setText("File");
        this.item.setText("Exit");
        this.menuFile.add(this.item);
        this.bar.add(this.menuFile);
        this.setJMenuBar(this.bar);
        this.menuAbout.setText("About");
        this.menuAbout.add(new AboutBoxAction(this));
        this.menuAbout.add(new AboutJadeAction(this));
        this.bar.add(this.menuAbout);
        this.item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntrospectorGUI.this.exit_actionPerformed(actionEvent);
            }
        });
        this.scroll.getViewport().add(this.desk);
        this.split.add((Component)this.panel, "left");
        this.split.add((Component)this.scroll, "right");
        this.split.setDividerLocation(180);
        this.addWindowListener(this);
        this.pack();
        this.setSize(new Dimension(680, 435));
        this.panel.adjustDividerLocation();
        this.setVisible(true);
    }

    void exit_actionPerformed(ActionEvent actionEvent) {
        this.debugger.doDelete();
    }

    public JDesktopPane getDesktop() {
        return this.desk;
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.exit_actionPerformed(null);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void showError(String string) {
        JOptionPane.showMessageDialog(null, string, "Error in " + this.debugger.getName(), 0);
    }

    public void messageSent(MainWindow mainWindow, SentMessage sentMessage) {
        MessagePanel messagePanel = mainWindow.getMessagePanel();
        SwingUtilities.invokeLater(new TableUpdater(messagePanel, sentMessage));
    }

    public void messagePosted(MainWindow mainWindow, PostedMessage postedMessage) {
        MessagePanel messagePanel = mainWindow.getMessagePanel();
        SwingUtilities.invokeLater(new TableUpdater(messagePanel, postedMessage));
    }

    public void messageReceived(MainWindow mainWindow, ReceivedMessage receivedMessage) {
        MessagePanel messagePanel = mainWindow.getMessagePanel();
        SwingUtilities.invokeLater(new TableUpdater(messagePanel, receivedMessage));
    }

    public void changedAgentState(MainWindow mainWindow, ChangedAgentState changedAgentState) {
        StatePanel statePanel = mainWindow.getStatePanel();
        SwingUtilities.invokeLater(new StateUpdater(statePanel, changedAgentState));
    }

    public void behaviourAdded(MainWindow mainWindow, AddedBehaviour addedBehaviour) {
        BehaviourPanel behaviourPanel = mainWindow.getBehaviourPanel();
        SwingUtilities.invokeLater(new TreeUpdater(addedBehaviour, behaviourPanel));
    }

    public void behaviourRemoved(MainWindow mainWindow, RemovedBehaviour removedBehaviour) {
        BehaviourPanel behaviourPanel = mainWindow.getBehaviourPanel();
        SwingUtilities.invokeLater(new TreeUpdater(removedBehaviour, behaviourPanel));
    }

    public void behaviourChangeState(MainWindow mainWindow, ChangedBehaviourState changedBehaviourState) {
        BehaviourPanel behaviourPanel = mainWindow.getBehaviourPanel();
        SwingUtilities.invokeLater(new TreeUpdater(changedBehaviourState, behaviourPanel));
    }

    public void addWindow(MainWindow mainWindow) {
        this.desk.add(mainWindow);
        mainWindow.pack();
        mainWindow.setSize(600, 400);
        mainWindow.setVisible(true);
        mainWindow.adjustDividerLocation();
    }

    public void disposeAsync() {
        class DisposeIt
        implements Runnable {
            private Window toDispose;
            private final /* synthetic */ IntrospectorGUI this$0;

            public DisposeIt(IntrospectorGUI introspectorGUI, Window window) {
                this.this$0 = introspectorGUI;
                this.toDispose = window;
            }

            public void run() {
                this.toDispose.dispose();
            }
        }
        SwingUtilities.invokeLater(new DisposeIt(this, this));
    }

    public void closeInternal(MainWindow mainWindow) {
        class DisposeItMain
        implements Runnable {
            MainWindow wnd;
            private final /* synthetic */ IntrospectorGUI this$0;

            DisposeItMain(IntrospectorGUI introspectorGUI, MainWindow mainWindow) {
                this.this$0 = introspectorGUI;
                this.wnd = mainWindow;
            }

            public void run() {
                this.wnd.dispose();
            }
        }
        EventQueue.invokeLater(new DisposeItMain(this, mainWindow));
    }

    public void addAgent(final String string, final AID aID) {
        Runnable runnable = new Runnable(){

            public void run() {
                String string2 = aID.getName();
                AgentTree.Node node = ((IntrospectorGUI)IntrospectorGUI.this).panel.treeAgent.createNewNode(string2, 1);
                ((IntrospectorGUI)IntrospectorGUI.this).panel.treeAgent.addAgentNode((AgentTree.AgentNode)node, string, string2, "agentAddress", "FIPAAGENT");
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void removeAgent(final String string, final AID aID) {
        Runnable runnable = new Runnable(){

            public void run() {
                String string2 = aID.getName();
                ((IntrospectorGUI)IntrospectorGUI.this).panel.treeAgent.removeAgentNode(string, string2);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public AgentTreeModel getModel() {
        return this.panel.treeAgent.getModel();
    }

    public void resetTree() {
        Runnable runnable = new Runnable(){

            public void run() {
                ((IntrospectorGUI)IntrospectorGUI.this).panel.treeAgent.clearLocalPlatform();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void addContainer(final String string, final InetAddress inetAddress) {
        Runnable runnable = new Runnable(){

            public void run() {
                AgentTree.Node node = ((IntrospectorGUI)IntrospectorGUI.this).panel.treeAgent.createNewNode(string, 0);
                ((IntrospectorGUI)IntrospectorGUI.this).panel.treeAgent.addContainerNode((AgentTree.ContainerNode)node, "FIPACONTAINER", inetAddress);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void removeContainer(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                ((IntrospectorGUI)IntrospectorGUI.this).panel.treeAgent.removeContainerNode(string);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public Introspector getAgent() {
        return this.debugger;
    }
}

