/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import jade.tools.gui.ACLSLTokenMarker;
import jade.tools.gui.ACLSyntaxUtilities;
import jade.tools.gui.ACLSytntaxStyle;
import jade.tools.gui.ACLTextArea;
import jade.tools.gui.ACLToken;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public class ACLTextAreaPainter
extends JComponent
implements TabExpander {
    protected static boolean copyAreaBroken;
    protected ACLTextArea textArea;
    protected ACLSytntaxStyle[] styles;
    protected Color caretColor;
    protected Color selectionColor;
    protected Color lineHighlightColor;
    protected Color bracketHighlightColor;
    protected Color eolMarkerColor;
    protected boolean blockCaret;
    protected boolean lineHighlight;
    protected boolean bracketHighlight;
    protected boolean eolMarkers;
    protected int cols;
    protected int rows;
    protected int tabSize;
    protected FontMetrics fm;
    protected Graphics offGfx;
    protected Image offImg;
    protected int firstInvalid;
    protected int lastInvalid;
    int currentLineIndex;
    ACLToken currentLineTokens;
    Segment currentLine;

    public ACLTextAreaPainter(ACLTextArea aCLTextArea) {
        this.textArea = aCLTextArea;
        this.currentLine = new Segment();
        this.currentLineIndex = -1;
        this.lastInvalid = -1;
        this.firstInvalid = -1;
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.setFont(new Font("Dialog", 0, 11));
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.styles = ACLSyntaxUtilities.getDefaultSyntaxStyles(this);
        this.cols = 80;
        this.rows = 5;
        this.caretColor = Color.red;
        this.selectionColor = new Color(0xCCCCFF);
        this.lineHighlightColor = new Color(0xE0E0E0);
        this.lineHighlight = true;
        this.bracketHighlightColor = Color.black;
        this.bracketHighlight = true;
        this.eolMarkerColor = new Color(39321);
        this.eolMarkers = true;
        copyAreaBroken = true;
    }

    public final boolean isManagingFocus() {
        return false;
    }

    public final ACLSytntaxStyle[] getStyles() {
        return this.styles;
    }

    public final Color getCaretColor() {
        return this.caretColor;
    }

    public final Color getSelectionColor() {
        return this.selectionColor;
    }

    public final Color getLineHighlightColor() {
        return this.lineHighlightColor;
    }

    public final boolean isLineHighlightEnabled() {
        return this.lineHighlight;
    }

    public final Color getBracketHighlightColor() {
        return this.bracketHighlightColor;
    }

    public final boolean isBracketHighlightEnabled() {
        return this.bracketHighlight;
    }

    public final boolean isBlockCaretEnabled() {
        return this.blockCaret;
    }

    public final Color getEOLMarkerColor() {
        return this.eolMarkerColor;
    }

    public final boolean isEOLMarkerEnabled() {
        return this.eolMarkers;
    }

    public final void setStyles(ACLSytntaxStyle[] aCLSytntaxStyleArray) {
        this.styles = aCLSytntaxStyleArray;
        this.invalidateOffscreen();
        this.repaint();
    }

    public final void setCaretColor(Color color) {
        this.caretColor = color;
        this.invalidateSelectedLines();
    }

    public final void setSelectionColor(Color color) {
        this.selectionColor = color;
        this.invalidateSelectedLines();
    }

    public final void setLineHighlightColor(Color color) {
        this.lineHighlightColor = color;
        this.invalidateSelectedLines();
    }

    public final void setLineHighlightEnabled(boolean bl) {
        this.lineHighlight = bl;
        this.invalidateSelectedLines();
    }

    public final void setBracketHighlightColor(Color color) {
        this.bracketHighlightColor = color;
        this.invalidateLine(this.textArea.getBracketLine());
    }

    public final void setBracketHighlightEnabled(boolean bl) {
        this.bracketHighlight = bl;
        this.invalidateLine(this.textArea.getBracketLine());
    }

    public final void setBlockCaretEnabled(boolean bl) {
        this.blockCaret = bl;
        this.invalidateSelectedLines();
    }

    public final void setEOLMarkerColor(Color color) {
        this.eolMarkerColor = color;
        this.invalidateOffscreen();
        this.repaint();
    }

    public final void setEOLMarkerEnabled(boolean bl) {
        this.eolMarkers = bl;
        this.invalidateOffscreen();
        this.repaint();
    }

    public final void fastRepaint() {
        if (this.firstInvalid == -1 && this.lastInvalid == -1) {
            this.repaint();
        } else {
            this.repaint(0, this.textArea.lineToY(this.firstInvalid) + this.fm.getLeading() + this.fm.getMaxDescent(), this.getWidth(), (this.lastInvalid - this.firstInvalid + 1) * this.fm.getHeight());
        }
    }

    public final void invalidateLine(int n) {
        this._invalidateLine(n);
        this.fastRepaint();
    }

    public final void invalidateLineRange(int n, int n2) {
        this._invalidateLineRange(n, n2);
        this.fastRepaint();
    }

    public final void invalidateSelectedLines() {
        this.invalidateLineRange(this.textArea.getSelectionStartLine(), this.textArea.getSelectionEndLine());
    }

    public final void invalidateOffscreen() {
        this.offImg = null;
        this.offGfx = null;
    }

    public FontMetrics getFontMetrics() {
        return this.fm;
    }

    public boolean isCopyAreaBroken() {
        return copyAreaBroken;
    }

    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return super.getMinimumSize();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fm = this.textArea.getFontMetrics(font);
        this.textArea.recalculateVisibleLines();
    }

    public void setCopyAreaBroken(boolean bl) {
        copyAreaBroken = bl;
    }

    public void update(Graphics graphics) {
        this.tabSize = this.fm.charWidth('w') * (Integer)this.textArea.getDocument().getProperty("tabSize");
        if (this.ensureOffscreenValid()) {
            this.firstInvalid = this.textArea.getFirstLine();
            this.lastInvalid = this.firstInvalid + this.textArea.getVisibleLines();
        }
        if (this.firstInvalid != -1 && this.lastInvalid != -1) {
            try {
                Rectangle rectangle;
                int n = this.firstInvalid == this.lastInvalid ? this.offscreenRepaintLine(this.firstInvalid, this.textArea.getHorizontalOffset()) : this.offscreenRepaintLineRange(this.firstInvalid, this.lastInvalid);
                if (this.lastInvalid - this.firstInvalid + 1 != n && !(rectangle = graphics.getClipBounds()).equals(this.getBounds())) {
                    this.repaint();
                }
            }
            catch (Exception exception) {
                System.err.println("Error repainting line range {" + this.firstInvalid + "," + this.lastInvalid + "}:");
                exception.printStackTrace();
            }
            this.lastInvalid = -1;
            this.firstInvalid = -1;
        }
        graphics.drawImage(this.offImg, 0, 0, null);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void _invalidateLine(int n) {
        int n2 = this.textArea.getFirstLine();
        int n3 = n2 + this.textArea.getVisibleLines();
        if (n < n2 || n > n3) {
            return;
        }
        if (n >= this.firstInvalid && n <= this.lastInvalid) {
            return;
        }
        if (this.firstInvalid == -1 && this.lastInvalid == -1) {
            this.firstInvalid = this.lastInvalid = n;
        } else {
            this.firstInvalid = Math.min(n, this.firstInvalid);
            this.lastInvalid = Math.max(n, this.lastInvalid);
        }
    }

    public void _invalidateLineRange(int n, int n2) {
        int n3 = this.textArea.getFirstLine();
        int n4 = n3 + this.textArea.getVisibleLines();
        if (n > n2) {
            int n5 = n;
            n = n2;
            n2 = n5;
        }
        if (n2 < n3 || n > n4) {
            return;
        }
        if (this.firstInvalid == -1 && this.lastInvalid == -1) {
            this.firstInvalid = n;
            this.lastInvalid = n2;
        } else {
            if (n >= this.firstInvalid && n2 <= this.lastInvalid) {
                return;
            }
            this.firstInvalid = Math.min(this.firstInvalid, n);
            this.lastInvalid = Math.max(this.lastInvalid, n2);
        }
        this.firstInvalid = Math.max(this.firstInvalid, n3);
        this.lastInvalid = Math.min(this.lastInvalid, n4);
    }

    public void scrollRepaint(int n, int n2) {
        if (this.offGfx == null) {
            return;
        }
        int n3 = this.textArea.getVisibleLines();
        if (copyAreaBroken || n + n3 <= n2 || n2 + n3 <= n) {
            this._invalidateLineRange(n2, n2 + n3 + 1);
        } else {
            int n4 = this.fm.getHeight() * (n - n2);
            this.offGfx.copyArea(0, 0, this.offImg.getWidth(this), this.offImg.getHeight(this), 0, n4);
            if (n < n2) {
                this._invalidateLineRange(n + n3 - 1, n2 + n3 + 1);
            } else {
                this._invalidateLineRange(n2, n);
            }
        }
    }

    public float nextTabStop(float f, int n) {
        int n2 = this.textArea.getHorizontalOffset();
        int n3 = ((int)f - n2) / this.tabSize;
        return (n3 + 1) * this.tabSize + n2;
    }

    protected boolean ensureOffscreenValid() {
        if (this.offImg == null || this.offGfx == null) {
            this.offImg = this.textArea.createImage(this.getWidth(), this.getHeight());
            this.offGfx = this.offImg.getGraphics();
            return true;
        }
        return false;
    }

    protected int offscreenRepaintLineRange(int n, int n2) {
        if (this.offGfx == null) {
            return 0;
        }
        int n3 = this.textArea.getHorizontalOffset();
        int n4 = n;
        while (n4 <= n2) {
            n4 += this.offscreenRepaintLine(n4, n3);
        }
        return n4 - n;
    }

    protected int offscreenRepaintLine(int n, int n2) {
        ACLSLTokenMarker aCLSLTokenMarker = this.textArea.getTokenMarker();
        Font font = this.getFont();
        Color color = this.getForeground();
        int n3 = this.textArea.lineToY(n);
        if (n < 0 || n >= this.textArea.getLineCount()) {
            this.paintHighlight(n, n3);
            this.styles[10].setGraphicsFlags(this.offGfx, font);
            this.offGfx.drawString(".", 0, n3 + this.fm.getHeight());
            return 1;
        }
        if (aCLSLTokenMarker == null) {
            this.currentLineIndex = n;
            this.paintPlainLine(n, font, color, n2, n3);
            return 1;
        }
        int n4 = 0;
        int n5 = Math.min(this.textArea.getLineCount(), this.textArea.getFirstLine() + this.textArea.getVisibleLines());
        do {
            this.currentLineIndex = n + n4;
            this.paintSyntaxLine(aCLSLTokenMarker, this.currentLineIndex, font, color, n2, n3);
            n3 += this.fm.getHeight();
        } while (aCLSLTokenMarker.isNextLineRequested() && n + ++n4 < n5);
        return n4;
    }

    protected void paintPlainLine(int n, Font font, Color color, int n2, int n3) {
        this.paintHighlight(n, n3);
        this.textArea.getLineText(n, this.currentLine);
        this.offGfx.setFont(font);
        this.offGfx.setColor(color);
        n2 = Utilities.drawTabbedText(this.currentLine, n2, n3 += this.fm.getHeight(), this.offGfx, (TabExpander)this, 0);
        if (this.eolMarkers) {
            this.offGfx.setColor(this.eolMarkerColor);
            this.offGfx.drawString(".", n2, n3);
        }
    }

    protected void paintSyntaxLine(ACLSLTokenMarker aCLSLTokenMarker, int n, Font font, Color color, int n2, int n3) {
        this.textArea.getLineText(this.currentLineIndex, this.currentLine);
        this.currentLineTokens = aCLSLTokenMarker.markTokens(this.currentLine, this.currentLineIndex);
        this.paintHighlight(n, n3);
        this.offGfx.setFont(font);
        this.offGfx.setColor(color);
        this.styles = ACLSyntaxUtilities.getDefaultSyntaxStyles(this);
        n2 = ACLSyntaxUtilities.paintSyntaxLine(this.currentLine, this.currentLineTokens, this.styles, this, this.offGfx, n2, n3 += this.fm.getHeight());
        if (this.eolMarkers) {
            this.offGfx.setColor(this.eolMarkerColor);
            this.offGfx.drawString(".", n2, n3);
        }
    }

    protected void paintHighlight(int n, int n2) {
        int n3 = this.fm.getMaxDescent() + this.fm.getLeading();
        this.offGfx.setColor(this.getBackground());
        this.offGfx.fillRect(0, n2 + n3, this.offImg.getWidth(this), this.fm.getHeight());
        if (n >= this.textArea.getSelectionStartLine() && n <= this.textArea.getSelectionEndLine()) {
            this.paintLineHighlight(n, n2);
        }
        if (this.bracketHighlight && n == this.textArea.getBracketLine()) {
            this.paintBracketHighlight(n, n2);
        }
        if (n == this.textArea.getCaretLine()) {
            this.paintCaret(n, n2);
        }
    }

    protected void paintLineHighlight(int n, int n2) {
        int n3;
        int n4 = this.fm.getHeight();
        n2 += this.fm.getLeading() + this.fm.getMaxDescent();
        int n5 = this.textArea.getSelectionStart();
        if (n5 == (n3 = this.textArea.getSelectionEnd())) {
            if (this.lineHighlight) {
                this.offGfx.setColor(this.lineHighlightColor);
                this.offGfx.fillRect(0, n2, this.offImg.getWidth(this), n4);
            } else {
                int n6;
                int n7;
                this.offGfx.setColor(this.selectionColor);
                int n8 = this.textArea.getSelectionStartLine();
                int n9 = this.textArea.getSelectionEndLine();
                int n10 = this.textArea.getLineStartOffset(n);
                if (n8 == n9) {
                    n7 = this.textArea.offsetToX(n, n5 - n10);
                    n6 = this.textArea.offsetToX(n, n3 - n10);
                } else if (n == n8) {
                    n7 = this.textArea.offsetToX(n, n5 - n10);
                    n6 = this.offImg.getWidth(this);
                } else if (n == n9) {
                    n7 = 0;
                    n6 = this.textArea.offsetToX(n, n3 - n10);
                } else {
                    n7 = 0;
                    n6 = this.offImg.getWidth(this);
                }
                this.offGfx.fillRect(n7, n2, n6 - n7, n4);
            }
        }
    }

    protected void paintBracketHighlight(int n, int n2) {
        int n3 = this.textArea.getBracketPosition();
        if (n3 == -1) {
            return;
        }
        int n4 = this.textArea.offsetToX(n, n3);
        this.offGfx.setColor(this.bracketHighlightColor);
        this.offGfx.drawRect(n4, n2 += this.fm.getLeading() + this.fm.getMaxDescent(), this.fm.charWidth('(') - 1, this.fm.getHeight() - 1);
    }

    protected void paintCaret(int n, int n2) {
        if (this.textArea.isCaretVisible()) {
            int n3 = this.textArea.getCaretPosition() - this.textArea.getLineStartOffset(n);
            int n4 = this.textArea.offsetToX(n, n3);
            int n5 = this.blockCaret || this.textArea.isOverwriteEnabled() ? this.fm.charWidth('w') : 1;
            n2 += this.fm.getLeading() + this.fm.getMaxDescent();
            int n6 = this.fm.getHeight();
            this.offGfx.setColor(this.caretColor);
            if (this.textArea.isOverwriteEnabled()) {
                this.offGfx.fillRect(n4, n2 + n6 - 1, n5, 1);
            } else {
                this.offGfx.drawRect(n4, n2, n5 - 1, n6 - 1);
            }
        }
    }
}

