/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import jade.lang.acl.ACLMessage;
import jade.tools.gui.ACLSLTokenMarker;
import jade.tools.gui.ACLSyntaxDocument;
import jade.tools.gui.ACLSytntaxStyle;
import jade.tools.gui.ACLTextAreaPainter;
import jade.tools.gui.ACLToken;
import jade.tools.sl.SLFormatter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public class ACLTextArea
extends JComponent {
    protected static String CENTER = "center";
    protected static String RIGHT = "right";
    protected static String BOTTOM = "bottom";
    protected static ACLTextArea focusedComponent;
    protected static Timer caretTimer;
    protected ACLTextAreaPainter painter;
    protected JPopupMenu popup;
    protected Timer scrollTimer;
    protected EventListenerList listenerList;
    protected MutableCaretEvent caretEvent;
    protected boolean caretBlinks;
    protected boolean caretVisible;
    protected boolean blink;
    protected boolean editable;
    protected int firstLine;
    protected int visibleLines;
    protected int electricScroll;
    protected int horizontalOffset;
    protected JScrollBar vertical;
    protected JScrollBar horizontal;
    protected boolean scrollBarsInitialized;
    protected InputHandler inputHandler;
    protected ACLSyntaxDocument document;
    protected DocumentHandler documentHandler;
    protected Segment lineSegment;
    protected int selectionStart;
    protected int selectionStartLine;
    protected int selectionEnd;
    protected int selectionEndLine;
    protected boolean biasLeft;
    protected int bracketPosition;
    protected int bracketLine;
    protected int magicCaret;
    protected boolean overwrite;
    private String contentLanguage = "";
    private ACLMessage msg;
    private String fieldName;
    static /* synthetic */ Class class$javax$swing$event$CaretListener;
    static /* synthetic */ Class class$java$awt$event$KeyEvent;

    public ACLTextArea() {
        this.enableEvents(8L);
        this.painter = new ACLTextAreaPainter(this);
        AutoScroll autoScroll = new AutoScroll();
        this.scrollTimer = new Timer(200, autoScroll);
        this.documentHandler = new DocumentHandler();
        this.listenerList = new EventListenerList();
        this.caretEvent = new MutableCaretEvent();
        this.lineSegment = new Segment();
        this.bracketPosition = -1;
        this.bracketLine = -1;
        this.blink = true;
        caretTimer = new Timer(500, new CaretBlinker());
        caretTimer.setInitialDelay(500);
        caretTimer.start();
        this.setBorder(new EtchedBorder(1));
        this.setLayout(new BorderLayout());
        this.add((Component)this.painter, "Center");
        this.vertical = new JScrollBar(1);
        this.add((Component)this.vertical, "East");
        this.horizontal = new JScrollBar(0);
        this.add((Component)this.horizontal, "South");
        this.vertical.addAdjustmentListener(new AdjustHandler());
        this.horizontal.addAdjustmentListener(new AdjustHandler());
        this.painter.addComponentListener(new ComponentHandler());
        this.painter.addMouseListener(new MouseHandler());
        this.painter.addMouseMotionListener(autoScroll);
        this.addFocusListener(new FocusHandler());
        InputHandler inputHandler = new InputHandler();
        inputHandler.addDefaultKeyBindings();
        this.setInputHandler(inputHandler);
        this.setDocument(new ACLSyntaxDocument());
        this.editable = true;
        this.caretVisible = true;
        this.caretBlinks = true;
        this.electricScroll = 3;
        focusedComponent = this;
        this.setTokenMarker(new ACLSLTokenMarker());
    }

    public final boolean isManagingFocus() {
        return true;
    }

    public final ACLTextAreaPainter getPainter() {
        return this.painter;
    }

    public final InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public final boolean isCaretBlinkEnabled() {
        return this.caretBlinks;
    }

    public final boolean isCaretVisible() {
        return (!this.caretBlinks || this.blink) && this.caretVisible;
    }

    public final int getElectricScroll() {
        return this.electricScroll;
    }

    public final int getFirstLine() {
        return this.firstLine;
    }

    public final int getVisibleLines() {
        return this.visibleLines;
    }

    public final int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public final ACLSyntaxDocument getDocument() {
        return this.document;
    }

    public final ACLSLTokenMarker getTokenMarker() {
        return this.document.getTokenMarker();
    }

    public final int getDocumentLength() {
        return this.document.getLength();
    }

    public final int getLineCount() {
        return this.document.getDefaultRootElement().getElementCount();
    }

    public final int getLineOfOffset(int n) {
        return this.document.getDefaultRootElement().getElementIndex(n);
    }

    public final String getText(int n, int n2) {
        try {
            return this.document.getText(n, n2);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public final void getText(int n, int n2, Segment segment) {
        try {
            this.document.getText(n, n2, segment);
        }
        catch (BadLocationException badLocationException) {
            segment.count = 0;
            segment.offset = 0;
        }
    }

    public final String getLineText(int n) {
        int n2 = this.getLineStartOffset(n);
        return this.getText(n2, this.getLineEndOffset(n) - n2 - 1);
    }

    public final void getLineText(int n, Segment segment) {
        int n2 = this.getLineStartOffset(n);
        this.getText(n2, this.getLineEndOffset(n) - n2 - 1, segment);
    }

    public final int getSelectionStart() {
        return this.selectionStart;
    }

    public final int getSelectionStartLine() {
        return this.selectionStartLine;
    }

    public final int getSelectionEnd() {
        return this.selectionEnd;
    }

    public final int getSelectionEndLine() {
        return this.selectionEndLine;
    }

    public final int getCaretPosition() {
        return this.biasLeft ? this.selectionStart : this.selectionEnd;
    }

    public final int getCaretLine() {
        return this.biasLeft ? this.selectionStartLine : this.selectionEndLine;
    }

    public final int getMarkPosition() {
        return this.biasLeft ? this.selectionEnd : this.selectionStart;
    }

    public final int getMarkLine() {
        return this.biasLeft ? this.selectionEndLine : this.selectionStartLine;
    }

    public final String getSelectedText() {
        if (this.selectionStart == this.selectionEnd) {
            return null;
        }
        return this.getText(this.selectionStart, this.selectionEnd - this.selectionStart);
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final JPopupMenu getRightClickPopup() {
        return this.popup;
    }

    public final int getMagicCaretPosition() {
        return this.magicCaret;
    }

    public final boolean isOverwriteEnabled() {
        return this.overwrite;
    }

    public final int getBracketPosition() {
        return this.bracketPosition;
    }

    public final int getBracketLine() {
        return this.bracketLine;
    }

    public final void setElectricScroll(int n) {
        this.electricScroll = n;
    }

    public final void setTokenMarker(ACLSLTokenMarker aCLSLTokenMarker) {
        this.document.setTokenMarker(aCLSLTokenMarker);
    }

    public final void setSelectionStart(int n) {
        this.select(n, this.selectionEnd);
    }

    public final void setSelectionEnd(int n) {
        this.select(this.selectionStart, n);
    }

    public final void setCaretPosition(int n) {
        this.select(n, n);
    }

    public final void setEditable(boolean bl) {
        this.editable = bl;
    }

    public final void setRightClickPopup(JPopupMenu jPopupMenu) {
        this.popup = jPopupMenu;
    }

    public final void setMagicCaretPosition(int n) {
        this.magicCaret = n;
    }

    public final void setOverwriteEnabled(boolean bl) {
        this.overwrite = bl;
        this.painter.invalidateSelectedLines();
    }

    public final void blinkCaret() {
        if (this.caretBlinks) {
            this.blink = !this.blink;
            this.painter.invalidateSelectedLines();
        } else {
            this.blink = true;
        }
    }

    public final void recalculateVisibleLines() {
        if (this.painter == null) {
            return;
        }
        int n = this.painter.getHeight();
        int n2 = this.painter.getFontMetrics().getHeight();
        int n3 = this.visibleLines;
        this.visibleLines = n / n2;
        this.painter.invalidateOffscreen();
        this.painter.repaint();
        this.updateScrollBars();
    }

    public final void selectAll() {
        this.select(0, this.getDocumentLength());
    }

    public final void addCaretListener(CaretListener caretListener) {
        this.listenerList.add(class$javax$swing$event$CaretListener == null ? (class$javax$swing$event$CaretListener = ACLTextArea.class$("javax.swing.event.CaretListener")) : class$javax$swing$event$CaretListener, caretListener);
    }

    public final void removeCaretListener(CaretListener caretListener) {
        this.listenerList.remove(class$javax$swing$event$CaretListener == null ? (class$javax$swing$event$CaretListener = ACLTextArea.class$("javax.swing.event.CaretListener")) : class$javax$swing$event$CaretListener, caretListener);
    }

    public int getLineStartOffset(int n) {
        Element element = this.document.getDefaultRootElement().getElement(n);
        if (element == null) {
            return -1;
        }
        return element.getStartOffset();
    }

    public int getLineEndOffset(int n) {
        Element element = this.document.getDefaultRootElement().getElement(n);
        if (element == null) {
            return -1;
        }
        return element.getEndOffset();
    }

    public int getLineLength(int n) {
        Element element = this.document.getDefaultRootElement().getElement(n);
        if (element == null) {
            return -1;
        }
        return element.getEndOffset() - element.getStartOffset() - 1;
    }

    public String getText() {
        try {
            return this.document.getText(0, this.document.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public void setInputHandler(InputHandler inputHandler) {
        if (this.inputHandler != null) {
            this.removeKeyListener(this.inputHandler);
        }
        if (inputHandler != null) {
            this.addKeyListener(inputHandler);
        }
        this.inputHandler = inputHandler;
    }

    public void setCaretBlinkEnabled(boolean bl) {
        this.caretBlinks = bl;
        if (!bl) {
            this.blink = false;
        }
        this.painter.invalidateSelectedLines();
    }

    public void setCaretVisible(boolean bl) {
        this.caretVisible = bl;
        this.blink = true;
        this.painter.invalidateSelectedLines();
    }

    public void setFirstLine(int n) {
        if (n == this.firstLine) {
            return;
        }
        int n2 = this.firstLine;
        this.firstLine = n;
        if (n != this.vertical.getValue()) {
            this.updateScrollBars();
        }
        this.painter.scrollRepaint(n2, n);
        this.painter.repaint();
    }

    public void setHorizontalOffset(int n) {
        if (n == this.horizontalOffset) {
            return;
        }
        this.horizontalOffset = n;
        if (n != this.horizontal.getValue()) {
            this.updateScrollBars();
        }
        this.painter.invalidateLineRange(this.firstLine, this.firstLine + this.visibleLines);
        this.painter.repaint();
    }

    public boolean setOrigin(int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        int n3 = this.firstLine;
        if (n2 != this.horizontalOffset) {
            this.horizontalOffset = n2;
            bl2 = true;
            bl = true;
        }
        if (n != this.firstLine) {
            this.firstLine = n;
            bl = true;
        }
        if (bl) {
            this.updateScrollBars();
            if (bl2) {
                this.painter._invalidateLineRange(n, n + this.visibleLines);
            } else {
                this.painter.scrollRepaint(n3, n);
            }
            this.painter.repaint();
        }
        return bl;
    }

    public void setDocument(ACLSyntaxDocument aCLSyntaxDocument) {
        if (this.document == aCLSyntaxDocument) {
            return;
        }
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentHandler);
        }
        this.document = aCLSyntaxDocument;
        aCLSyntaxDocument.addDocumentListener(this.documentHandler);
        this.select(0, 0);
        this.updateScrollBars();
        this.painter.invalidateOffscreen();
        this.painter.repaint();
    }

    public void setText(String string) {
        try {
            this.document.remove(0, this.document.getLength());
            this.document.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void setSelectedText(String string) {
        if (!this.editable) {
            throw new InternalError("Text component read only");
        }
        try {
            this.document.remove(this.selectionStart, this.selectionEnd - this.selectionStart);
            this.document.insertString(this.selectionStart, string, null);
            this.setCaretPosition(this.selectionEnd);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            throw new InternalError("Cannot replace selection");
        }
    }

    public void update() {
        this.register(this.msg, "Content");
    }

    public void register(Object object, String string) {
        this.msg = (ACLMessage)object;
        this.fieldName = string;
        this.contentLanguage = this.msg.getLanguage() != null ? this.msg.getLanguage() : "<unknown>";
        String string2 = "get" + string;
        String string3 = "";
        try {
            Method method = this.msg.getClass().getMethod(string2, null);
            string3 = (String)method.invoke((Object)this.msg, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.contentLanguage.indexOf("SL") >= 0) {
            try {
                new SLFormatter();
                string3 = SLFormatter.format(string3);
            }
            catch (Exception exception) {}
        }
        while (string3 != null && string3.indexOf(10) == 0) {
            string3 = string3.substring(1);
        }
        this.setText(string3);
        this.setCaretPosition(0);
    }

    public void unregister(Object object, String string) {
    }

    public void focusLost(FocusEvent focusEvent) {
        String string = this.getText();
        while (string != null && (string.indexOf(10) == 0 || string.indexOf(32) == 0)) {
            string = string.substring(1);
        }
        String string2 = "set" + this.fieldName;
        String string3 = "java.lang.String";
        try {
            Method method = this.msg.getClass().getMethod(string2, Class.forName(string3));
            String string4 = string;
            method.invoke((Object)this.msg, string4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void updateScrollBars() {
        if (this.vertical != null && this.visibleLines != 0) {
            this.vertical.setValues(this.firstLine, this.visibleLines, 0, this.getLineCount());
            this.vertical.setUnitIncrement(2);
            this.vertical.setBlockIncrement(this.visibleLines);
        }
        int n = this.painter.getWidth();
        if (this.horizontal != null && n != 0) {
            this.horizontal.setValues(-this.horizontalOffset, n, 0, n * 5);
            this.horizontal.setUnitIncrement(this.painter.getFontMetrics().charWidth('w'));
            this.horizontal.setBlockIncrement(n / 2);
        }
    }

    public boolean scrollToCaret() {
        int n = this.getCaretLine();
        int n2 = this.getLineStartOffset(n);
        int n3 = Math.max(0, Math.min(this.getLineLength(n) - 1, this.getCaretPosition() - n2));
        return this.scrollTo(n, n3);
    }

    public boolean scrollTo(int n, int n2) {
        if (this.visibleLines == 0) {
            this.setFirstLine(Math.max(0, n - this.electricScroll));
            return true;
        }
        int n3 = this.firstLine;
        int n4 = this.horizontalOffset;
        if (n < this.firstLine + this.electricScroll) {
            n3 = Math.max(0, n - this.electricScroll);
        } else if (n + this.electricScroll >= this.firstLine + this.visibleLines) {
            n3 = n - this.visibleLines + this.electricScroll + 1;
            if (n3 + this.visibleLines >= this.getLineCount()) {
                n3 = this.getLineCount() - this.visibleLines;
            }
            if (n3 < 0) {
                n3 = 0;
            }
        }
        int n5 = this.offsetToX(n, n2);
        int n6 = this.painter.getFontMetrics().charWidth('W');
        if (n5 < 0) {
            n4 = Math.min(0, this.horizontalOffset - n5 + n6);
        } else if (n5 + n6 >= this.painter.getWidth()) {
            n4 = this.horizontalOffset + (this.painter.getWidth() - n5) - n6;
        }
        return this.setOrigin(n3, n4);
    }

    public int lineToY(int n) {
        FontMetrics fontMetrics = this.painter.getFontMetrics();
        return (n - this.firstLine) * fontMetrics.getHeight() - (fontMetrics.getLeading() + fontMetrics.getMaxDescent());
    }

    public int yToLine(int n) {
        FontMetrics fontMetrics = this.painter.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        return Math.max(0, Math.min(this.getLineCount() - 1, n / n2 + this.firstLine));
    }

    public int offsetToX(int n, int n2) {
        ACLToken aCLToken;
        ACLSLTokenMarker aCLSLTokenMarker = this.getTokenMarker();
        FontMetrics fontMetrics = this.painter.getFontMetrics();
        this.getLineText(n, this.lineSegment);
        int n3 = this.lineSegment.offset;
        int n4 = this.horizontalOffset;
        if (aCLSLTokenMarker == null) {
            this.lineSegment.count = n2;
            return n4 + Utilities.getTabbedTextWidth(this.lineSegment, fontMetrics, n4, (TabExpander)this.painter, 0);
        }
        if (this.painter.currentLineIndex == n) {
            aCLToken = this.painter.currentLineTokens;
        } else {
            this.painter.currentLineIndex = n;
            aCLToken = this.painter.currentLineTokens = aCLSLTokenMarker.markTokens(this.lineSegment, n);
        }
        Toolkit toolkit = this.painter.getToolkit();
        Font font = this.painter.getFont();
        ACLSytntaxStyle[] aCLSytntaxStyleArray = this.painter.getStyles();
        byte by;
        while ((by = aCLToken.id) != 127) {
            fontMetrics = by == 0 ? this.painter.getFontMetrics() : aCLSytntaxStyleArray[by].getFontMetrics(font);
            int n5 = aCLToken.length;
            if (n2 + n3 < this.lineSegment.offset + n5) {
                this.lineSegment.count = n2 - (this.lineSegment.offset - n3);
                return n4 + Utilities.getTabbedTextWidth(this.lineSegment, fontMetrics, n4, (TabExpander)this.painter, 0);
            }
            this.lineSegment.count = n5;
            n4 += Utilities.getTabbedTextWidth(this.lineSegment, fontMetrics, n4, (TabExpander)this.painter, 0);
            this.lineSegment.offset += n5;
            aCLToken = aCLToken.next;
        }
        return n4;
    }

    public int xToOffset(int n, int n2) {
        ACLToken aCLToken;
        ACLSLTokenMarker aCLSLTokenMarker = this.getTokenMarker();
        FontMetrics fontMetrics = this.painter.getFontMetrics();
        this.getLineText(n, this.lineSegment);
        char[] cArray = this.lineSegment.array;
        int n3 = this.lineSegment.offset;
        int n4 = this.lineSegment.count;
        int n5 = this.horizontalOffset;
        if (aCLSLTokenMarker == null) {
            int n6 = 0;
            while (n6 < n4) {
                char c = cArray[n6 + n3];
                int n7 = c == '\t' ? (int)this.painter.nextTabStop(n5, n6) - n5 : fontMetrics.charWidth(c);
                if (this.painter.isBlockCaretEnabled()) {
                    if (n2 - n7 <= n5) {
                        return n6;
                    }
                    if (n2 - n7 / 2 <= n5) {
                        return n6;
                    }
                }
                n5 += n7;
                ++n6;
            }
            return n4;
        }
        if (this.painter.currentLineIndex == n) {
            aCLToken = this.painter.currentLineTokens;
        } else {
            this.painter.currentLineIndex = n;
            aCLToken = this.painter.currentLineTokens = aCLSLTokenMarker.markTokens(this.lineSegment, n);
        }
        int n8 = 0;
        Toolkit toolkit = this.painter.getToolkit();
        Font font = this.painter.getFont();
        ACLSytntaxStyle[] aCLSytntaxStyleArray = this.painter.getStyles();
        byte by;
        while ((by = aCLToken.id) != 127) {
            fontMetrics = by == 0 ? this.painter.getFontMetrics() : aCLSytntaxStyleArray[by].getFontMetrics(font);
            int n9 = aCLToken.length;
            int n10 = 0;
            while (n10 < n9) {
                char c = cArray[n3 + n8 + n10];
                int n11 = c == '\t' ? (int)this.painter.nextTabStop(n5, n8 + n10) - n5 : fontMetrics.charWidth(c);
                if (this.painter.isBlockCaretEnabled()) {
                    if (n2 - n11 <= n5) {
                        return n8 + n10;
                    }
                    if (n2 - n11 / 2 <= n5) {
                        return n8 + n10;
                    }
                }
                n5 += n11;
                ++n10;
            }
            n8 += n9;
            aCLToken = aCLToken.next;
        }
        return n8;
    }

    public int xyToOffset(int n, int n2) {
        int n3 = this.yToLine(n2);
        int n4 = this.getLineStartOffset(n3);
        return n4 + this.xToOffset(n3, n);
    }

    public void select(int n, int n2) {
        boolean bl;
        int n3;
        int n4;
        if (n <= n2) {
            n4 = n;
            n3 = n2;
            bl = false;
        } else {
            n4 = n2;
            n3 = n;
            bl = true;
        }
        if (n4 < 0 || n3 > this.getDocumentLength()) {
            throw new IllegalArgumentException("Bounds out of range: " + n4 + "," + n3);
        }
        if (n4 != this.selectionStart || n3 != this.selectionEnd || bl != this.biasLeft) {
            int n5 = this.getLineOfOffset(n4);
            int n6 = this.getLineOfOffset(n3);
            if (this.painter.isBracketHighlightEnabled()) {
                if (this.bracketLine != -1) {
                    this.painter._invalidateLine(this.bracketLine);
                }
                this.updateBracketHighlight(n2);
                if (this.bracketLine != -1) {
                    this.painter._invalidateLine(this.bracketLine);
                }
            }
            this.painter._invalidateLineRange(this.selectionStartLine, this.selectionEndLine);
            this.painter._invalidateLineRange(n5, n6);
            this.selectionStart = n4;
            this.selectionEnd = n3;
            this.selectionStartLine = n5;
            this.selectionEndLine = n6;
            this.biasLeft = bl;
            this.fireCaretEvent();
        }
        this.blink = true;
        caretTimer.restart();
        this.magicCaret = -1;
        if (!this.scrollToCaret()) {
            this.painter.fastRepaint();
        }
    }

    public void overwriteSetSelectedText(String string) {
        if (!this.overwrite || this.selectionStart != this.selectionEnd) {
            this.setSelectedText(string);
            return;
        }
        int n = this.getCaretPosition();
        int n2 = this.getLineEndOffset(this.getCaretLine());
        if (n2 - n <= string.length()) {
            this.setSelectedText(string);
            return;
        }
        try {
            this.document.remove(n, string.length());
            this.document.insertString(n, string, null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void cut() {
        if (this.editable) {
            this.copy();
            this.setSelectedText("");
        }
    }

    public void copy() {
        if (this.selectionStart != this.selectionEnd) {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(this.getSelectedText());
            clipboard.setContents(stringSelection, null);
        }
    }

    public void paste() {
        block2: {
            if (!this.editable) break block2;
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            try {
                String string = (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
                this.setSelectedText(string.replace('\r', '\n'));
            }
            catch (Exception exception) {
                this.getToolkit().beep();
                System.err.println("Clipboard does not contain a string");
            }
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (focusedComponent == this) {
            focusedComponent = null;
        }
        if (this.scrollTimer.isRunning()) {
            this.scrollTimer.stop();
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1005) {
            this.focusLost(focusEvent);
        }
    }

    protected void fireCaretEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$CaretListener == null ? ACLTextArea.class$("javax.swing.event.CaretListener") : class$javax$swing$event$CaretListener)) {
                ((CaretListener)objectArray[n + 1]).caretUpdate(this.caretEvent);
            }
            --n;
        }
    }

    protected void updateBracketHighlight(int n) {
        if (n == 0) {
            this.bracketLine = -1;
            this.bracketPosition = -1;
            return;
        }
        try {
            int n2 = TextUtilities.findMatchingBracket(this.document, n - 1);
            if (n2 != -1) {
                this.bracketLine = this.getLineOfOffset(n2);
                this.bracketPosition = n2 - this.getLineStartOffset(this.bracketLine);
                return;
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.bracketPosition = -1;
        this.bracketLine = -1;
    }

    protected void documentChanged(DocumentEvent documentEvent) {
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(this.document.getDefaultRootElement());
        int n = elementChange == null ? 0 : elementChange.getChildrenAdded().length - elementChange.getChildrenRemoved().length;
        if (n == 0) {
            int n2 = this.getLineOfOffset(documentEvent.getOffset());
            this.painter._invalidateLine(n2);
        } else {
            int n3 = elementChange.getIndex();
            this.painter._invalidateLineRange(n3, Math.max(this.getLineCount(), this.firstLine + this.visibleLines));
            this.updateScrollBars();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ACLTextArea.this.requestFocus();
            if ((mouseEvent.getModifiers() & 4) != 0 && ACLTextArea.this.popup != null) {
                ACLTextArea.this.popup.show(ACLTextArea.this.painter, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            int n = ACLTextArea.this.yToLine(mouseEvent.getY());
            int n2 = ACLTextArea.this.xToOffset(n, mouseEvent.getX());
            int n3 = ACLTextArea.this.getLineStartOffset(n) + n2;
            switch (mouseEvent.getClickCount()) {
                case 1: {
                    this.doSingleClick(mouseEvent, n, n2, n3);
                    break;
                }
                case 2: {
                    try {
                        this.doDoubleClick(mouseEvent, n, n2, n3);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                    break;
                }
                case 3: {
                    this.doTripleClick(mouseEvent, n, n2, n3);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (ACLTextArea.this.scrollTimer.isRunning()) {
                ACLTextArea.this.scrollTimer.stop();
            }
        }

        private void doSingleClick(MouseEvent mouseEvent, int n, int n2, int n3) {
            if ((mouseEvent.getModifiers() & 1) != 0) {
                ACLTextArea.this.setSelectionEnd(n3);
            } else {
                ACLTextArea.this.setCaretPosition(n3);
            }
        }

        private void doDoubleClick(MouseEvent mouseEvent, int n, int n2, int n3) throws BadLocationException {
            if (ACLTextArea.this.getLineLength(n) == 0) {
                return;
            }
            try {
                int n4 = TextUtilities.findMatchingBracket(ACLTextArea.this.document, Math.max(0, n3 - 1));
                if (n4 != -1) {
                    int n5 = ACLTextArea.this.getMarkPosition();
                    if (n4 > n5) {
                        ++n4;
                        --n5;
                    }
                    ACLTextArea.this.select(n5, n4);
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            String string = ACLTextArea.this.getLineText(n);
            char c = string.charAt(n2 - 1);
            String string2 = (String)ACLTextArea.this.document.getProperty("noWordSep");
            if (string2 == null) {
                string2 = "";
            }
            boolean bl = !Character.isLetterOrDigit(c) && string2.indexOf(c) == -1;
            int n6 = 0;
            int n7 = n2 - 1;
            while (n7 >= 0) {
                c = string.charAt(n7);
                if (bl ^ (!Character.isLetterOrDigit(c) && string2.indexOf(c) == -1)) {
                    n6 = n7 + 1;
                    break;
                }
                --n7;
            }
            int n8 = string.length();
            int n9 = n2;
            while (n9 < string.length()) {
                c = string.charAt(n9);
                if (bl ^ (!Character.isLetterOrDigit(c) && string2.indexOf(c) == -1)) {
                    n8 = n9;
                    break;
                }
                ++n9;
            }
            int n10 = ACLTextArea.this.getLineStartOffset(n);
            ACLTextArea.this.select(n10 + n6, n10 + n8);
        }

        private void doTripleClick(MouseEvent mouseEvent, int n, int n2, int n3) {
            ACLTextArea.this.select(ACLTextArea.this.getLineStartOffset(n), ACLTextArea.this.getLineEndOffset(n) - 1);
        }
    }

    class FocusHandler
    implements FocusListener {
        FocusHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            ACLTextArea.this.setCaretVisible(true);
            focusedComponent = ACLTextArea.this;
        }

        public void focusLost(FocusEvent focusEvent) {
            ACLTextArea.this.setCaretVisible(false);
            focusedComponent = null;
        }
    }

    class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            int n;
            int n2;
            ACLTextArea.this.documentChanged(documentEvent);
            int n3 = documentEvent.getOffset();
            int n4 = documentEvent.getLength();
            boolean bl = true;
            if (ACLTextArea.this.selectionStart >= n3) {
                n2 = ACLTextArea.this.selectionStart + n4;
                bl = false;
            } else {
                n2 = ACLTextArea.this.selectionStart;
            }
            if (ACLTextArea.this.selectionEnd >= n3) {
                n = ACLTextArea.this.selectionEnd + n4;
                bl = false;
            } else {
                n = ACLTextArea.this.selectionEnd;
            }
            ACLTextArea.this.select(n2, n);
            if (bl) {
                ACLTextArea.this.painter.fastRepaint();
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            int n;
            int n2;
            ACLTextArea.this.documentChanged(documentEvent);
            int n3 = documentEvent.getOffset();
            int n4 = documentEvent.getLength();
            boolean bl = true;
            if (ACLTextArea.this.selectionStart > n3) {
                n2 = ACLTextArea.this.selectionStart > n3 + n4 ? ACLTextArea.this.selectionStart - n4 : n3;
                bl = false;
            } else {
                n2 = ACLTextArea.this.selectionStart;
            }
            if (ACLTextArea.this.selectionEnd > n3) {
                n = ACLTextArea.this.selectionEnd > n3 + n4 ? ACLTextArea.this.selectionEnd - n4 : n3;
                bl = false;
            } else {
                n = ACLTextArea.this.selectionEnd;
            }
            ACLTextArea.this.select(n2, n);
            if (bl) {
                ACLTextArea.this.painter.fastRepaint();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    class ComponentHandler
    extends ComponentAdapter {
        ComponentHandler() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            ACLTextArea.this.recalculateVisibleLines();
            ACLTextArea.this.scrollBarsInitialized = true;
        }
    }

    class AdjustHandler
    implements AdjustmentListener {
        AdjustHandler() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (!ACLTextArea.this.scrollBarsInitialized) {
                return;
            }
            if (adjustmentEvent.getAdjustable() == ACLTextArea.this.vertical) {
                ACLTextArea.this.setFirstLine(ACLTextArea.this.vertical.getValue());
            } else {
                ACLTextArea.this.setHorizontalOffset(-ACLTextArea.this.horizontal.getValue());
            }
        }
    }

    class MutableCaretEvent
    extends CaretEvent {
        MutableCaretEvent() {
            super(ACLTextArea.this);
        }

        public int getDot() {
            return ACLTextArea.this.getCaretPosition();
        }

        public int getMark() {
            return ACLTextArea.this.getMarkPosition();
        }
    }

    class AutoScroll
    implements ActionListener,
    MouseMotionListener {
        private int x;
        private int y;

        AutoScroll() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ACLTextArea.this.select(ACLTextArea.this.getMarkPosition(), ACLTextArea.this.xyToOffset(this.x, this.y));
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (ACLTextArea.this.popup != null && ACLTextArea.this.popup.isVisible()) {
                return;
            }
            this.x = mouseEvent.getX();
            this.y = mouseEvent.getY();
            if (!ACLTextArea.this.scrollTimer.isRunning()) {
                ACLTextArea.this.scrollTimer.start();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    class ScrollLayout
    implements LayoutManager {
        private Component center;
        private Component right;
        private Component bottom;

        ScrollLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
            if (string.equals(CENTER)) {
                this.center = component;
            } else if (string.equals(RIGHT)) {
                this.right = component;
            } else if (string.equals(BOTTOM)) {
                this.bottom = component;
            }
        }

        public void removeLayoutComponent(Component component) {
            if (this.center == component) {
                this.center = null;
            }
            if (this.right == component) {
                this.right = null;
            }
            if (this.bottom == component) {
                this.bottom = null;
            }
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension();
            Insets insets = ACLTextArea.this.getInsets();
            dimension.width = insets.left + insets.right;
            dimension.height = insets.top + insets.bottom;
            Dimension dimension2 = this.center.getPreferredSize();
            dimension.height += dimension2.height;
            dimension.width += dimension2.width;
            Dimension dimension3 = this.right.getPreferredSize();
            dimension.width += dimension3.width;
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = new Dimension();
            Insets insets = ACLTextArea.this.getInsets();
            dimension.width = insets.left + insets.right;
            dimension.height = insets.top + insets.bottom;
            Dimension dimension2 = this.center.getMinimumSize();
            dimension.height += dimension2.height;
            dimension.width += dimension2.width;
            Dimension dimension3 = this.right.getMinimumSize();
            dimension.width += dimension3.width;
            Dimension dimension4 = this.bottom.getMinimumSize();
            dimension.height += dimension4.height;
            return dimension;
        }

        public void layoutContainer(Container container) {
            Dimension dimension = container.getSize();
            Insets insets = ACLTextArea.this.getInsets();
            int n = insets.top;
            int n2 = insets.left;
            int n3 = insets.bottom;
            int n4 = insets.right;
            int n5 = this.right.getPreferredSize().width;
            int n6 = this.center.getPreferredSize().height;
            this.center.setBounds(n2, n, dimension.width - n5 - n2 - n4, dimension.height - n6 - n - n3);
            this.right.setBounds(dimension.width - n5 - n4, n, n5, dimension.height - n6 - n - n3);
        }
    }

    private static class InputHandler
    implements KeyListener {
        public static final ActionListener BACKSPACE = new backspace();
        public static final ActionListener DELETE = new delete();
        public static final ActionListener END = new end(false);
        public static final ActionListener SELECT_END = new end(true);
        public static final ActionListener INSERT_BREAK = new insert_break();
        public static final ActionListener INSERT_TAB = new insert_tab();
        public static final ActionListener HOME = new home(false);
        public static final ActionListener SELECT_HOME = new home(true);
        public static final ActionListener NEXT_CHAR = new next_char(false);
        public static final ActionListener NEXT_LINE = new next_line(false);
        public static final ActionListener NEXT_PAGE = new next_page(false);
        public static final ActionListener NEXT_WORD = new next_word(false);
        public static final ActionListener SELECT_NEXT_CHAR = new next_char(true);
        public static final ActionListener SELECT_NEXT_LINE = new next_line(true);
        public static final ActionListener SELECT_NEXT_PAGE = new next_page(true);
        public static final ActionListener SELECT_NEXT_WORD = new next_word(true);
        public static final ActionListener OVERWRITE = new overwrite();
        public static final ActionListener PREV_CHAR = new prev_char(false);
        public static final ActionListener PREV_LINE = new prev_line(false);
        public static final ActionListener PREV_PAGE = new prev_page(false);
        public static final ActionListener PREV_WORD = new prev_word(false);
        public static final ActionListener SELECT_PREV_CHAR = new prev_char(true);
        public static final ActionListener SELECT_PREV_LINE = new prev_line(true);
        public static final ActionListener SELECT_PREV_PAGE = new prev_page(true);
        public static final ActionListener SELECT_PREV_WORD = new prev_word(true);
        public static final ActionListener[] ACTIONS = new ActionListener[]{BACKSPACE, DELETE, END, SELECT_END, INSERT_BREAK, INSERT_TAB, HOME, SELECT_HOME, NEXT_CHAR, NEXT_LINE, NEXT_PAGE, NEXT_WORD, SELECT_NEXT_CHAR, SELECT_NEXT_LINE, SELECT_NEXT_PAGE, SELECT_NEXT_WORD, OVERWRITE, PREV_CHAR, PREV_LINE, PREV_PAGE, PREV_WORD, SELECT_PREV_CHAR, SELECT_PREV_LINE, SELECT_PREV_PAGE, SELECT_PREV_WORD};
        public static final String[] ACTION_NAMES = new String[]{"backspace", "delete", "end", "select-end", "insert-break", "insert-tab", "home", "select-home", "next-char", "next-line", "next-page", "next-word", "select-next-char", "select-next-line", "select-next-page", "select-next-word", "overwrite", "prev-char", "prev-line", "prev-page", "prev-word", "select-prev-char", "select-prev-line", "select-prev-page", "select-prev-word"};
        private Hashtable bindings;
        private Hashtable currentBindings;

        public InputHandler() {
            this.bindings = this.currentBindings = new Hashtable();
        }

        public static ACLTextArea getTextArea(EventObject eventObject) {
            Object object;
            if (eventObject != null && (object = eventObject.getSource()) instanceof Component) {
                Component component = (Component)object;
                while (true) {
                    if (component instanceof ACLTextArea) {
                        return (ACLTextArea)component;
                    }
                    if (component == null) break;
                    if (component instanceof JPopupMenu) {
                        component = ((JPopupMenu)component).getInvoker();
                        continue;
                    }
                    component = component.getParent();
                }
            }
            System.err.println("BUG: getTextArea() returning null");
            System.err.println("Report this to Slava Pestov <sp@gjt.org>");
            return null;
        }

        public static KeyStroke parseKeyStroke(String string) {
            String string2;
            if (string == null) {
                return null;
            }
            int n = 0;
            int n2 = 0;
            int n3 = string.indexOf(43);
            if (n3 != -1) {
                int n4 = 0;
                while (n4 < n3) {
                    switch (Character.toUpperCase(string.charAt(n4))) {
                        case 'A': {
                            n |= 8;
                            break;
                        }
                        case 'C': {
                            n |= 2;
                            break;
                        }
                        case 'M': {
                            n |= 4;
                            break;
                        }
                        case 'S': {
                            n |= 1;
                        }
                    }
                    ++n4;
                }
            }
            if ((string2 = string.substring(n3 + 1)).length() == 1) {
                n2 = Character.toUpperCase(string2.charAt(0));
            } else {
                if (string2.length() == 0) {
                    System.err.println("Invalid key stroke: " + string);
                    return null;
                }
                try {
                    n2 = (class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = ACLTextArea.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getField("VK_".concat(string2)).getInt(null);
                }
                catch (Exception exception) {
                    System.err.println("Invalid key stroke: " + string);
                    return null;
                }
            }
            return KeyStroke.getKeyStroke(n2, n);
        }

        public void addDefaultKeyBindings() {
            this.addKeyBinding("BACK_SPACE", BACKSPACE);
            this.addKeyBinding("DELETE", DELETE);
            this.addKeyBinding("ENTER", INSERT_BREAK);
            this.addKeyBinding("TAB", INSERT_TAB);
            this.addKeyBinding("INSERT", OVERWRITE);
            this.addKeyBinding("HOME", HOME);
            this.addKeyBinding("END", END);
            this.addKeyBinding("S+HOME", SELECT_HOME);
            this.addKeyBinding("S+END", SELECT_END);
            this.addKeyBinding("PAGE_UP", PREV_PAGE);
            this.addKeyBinding("PAGE_DOWN", NEXT_PAGE);
            this.addKeyBinding("S+PAGE_UP", SELECT_PREV_PAGE);
            this.addKeyBinding("S+PAGE_DOWN", SELECT_NEXT_PAGE);
            this.addKeyBinding("LEFT", PREV_CHAR);
            this.addKeyBinding("S+LEFT", SELECT_PREV_CHAR);
            this.addKeyBinding("C+LEFT", PREV_WORD);
            this.addKeyBinding("CS+LEFT", SELECT_PREV_WORD);
            this.addKeyBinding("RIGHT", NEXT_CHAR);
            this.addKeyBinding("S+RIGHT", SELECT_NEXT_CHAR);
            this.addKeyBinding("C+RIGHT", NEXT_WORD);
            this.addKeyBinding("CS+RIGHT", SELECT_NEXT_WORD);
            this.addKeyBinding("UP", PREV_LINE);
            this.addKeyBinding("S+UP", SELECT_PREV_LINE);
            this.addKeyBinding("DOWN", NEXT_LINE);
            this.addKeyBinding("S+DOWN", SELECT_NEXT_LINE);
        }

        public void addKeyBinding(String string, ActionListener actionListener) {
            Hashtable hashtable = this.bindings;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                KeyStroke keyStroke = InputHandler.parseKeyStroke(stringTokenizer.nextToken());
                if (keyStroke == null) {
                    return;
                }
                if (stringTokenizer.hasMoreTokens()) {
                    Object object = hashtable.get(keyStroke);
                    if (object instanceof Hashtable) {
                        hashtable = (Hashtable)object;
                        continue;
                    }
                    object = new Hashtable();
                    hashtable.put(keyStroke, object);
                    hashtable = (Hashtable)object;
                    continue;
                }
                hashtable.put(keyStroke, actionListener);
            }
        }

        public void removeKeyBinding(String string) {
            throw new InternalError("Not yet implemented");
        }

        public void removeAllKeyBindings() {
            this.bindings.clear();
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getModifiers();
            if ((n2 & 0xFFFFFFFE) != 0 || keyEvent.isActionKey() || n == 8 || n == 127 || n == 10 || n == 9) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(n, n2);
                Object v = this.currentBindings.get(keyStroke);
                if (v == null) {
                    if (this.currentBindings != this.bindings) {
                        Toolkit.getDefaultToolkit().beep();
                        keyEvent.consume();
                    }
                    this.currentBindings = this.bindings;
                    return;
                }
                if (v instanceof ActionListener) {
                    ((ActionListener)v).actionPerformed(new ActionEvent(keyEvent.getSource(), 1001, null, n2));
                    this.currentBindings = this.bindings;
                    keyEvent.consume();
                    return;
                }
                if (v instanceof Hashtable) {
                    this.currentBindings = (Hashtable)v;
                    keyEvent.consume();
                    return;
                }
                if (n != 18 && n != 17 && n != 16 && n != 157) {
                    return;
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
            int n = keyEvent.getModifiers();
            char c = keyEvent.getKeyChar();
            if (c != '\uffff' && (n & 8) == 0 && c >= ' ' && c != '\u007f') {
                ACLTextArea aCLTextArea = InputHandler.getTextArea(keyEvent);
                if (!aCLTextArea.isEditable()) {
                    aCLTextArea.getToolkit().beep();
                    return;
                }
                this.currentBindings = this.bindings;
                aCLTextArea.overwriteSetSelectedText(String.valueOf(c));
            }
        }

        public static class prev_word
        implements ActionListener {
            private boolean select;

            public prev_word(boolean bl) {
                this.select = bl;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ACLTextArea aCLTextArea = InputHandler.getTextArea(actionEvent);
                int n = aCLTextArea.getCaretPosition();
                int n2 = aCLTextArea.getCaretLine();
                int n3 = aCLTextArea.getLineStartOffset(n2);
                String string = aCLTextArea.getLineText(aCLTextArea.getCaretLine());
                if ((n -= n3) == 0) {
                    if (n3 == 0) {
                        aCLTextArea.getToolkit().beep();
                        return;
                    }
                    --n;
                } else {
                    char c = string.charAt(n - 1);
                    String string2 = (String)aCLTextArea.getDocument().getProperty("noWordSep");
                    boolean bl = !Character.isLetterOrDigit(c) && string2.indexOf(c) == -1;
                    int n4 = 0;
                    int n5 = n - 1;
                    while (n5 >= 0) {
                        c = string.charAt(n5);
                        if (bl ^ (!Character.isLetterOrDigit(c) && string2.indexOf(c) == -1)) {
                            n4 = n5 + 1;
                            break;
                        }
                        --n5;
                    }
                    n = n4;
                }
                if (this.select) {
                    aCLTextArea.select(aCLTextArea.getMarkPosition(), n3 + n);
                } else {
                    aCLTextArea.setCaretPosition(n3 + n);
                }
            }
        }

        public static class prev_page
        implements ActionListener {
            private boolean select;

            public prev_page(boolean bl) {
                this.select = bl;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ACLTextArea aCLTextArea = InputHandler.getTextArea(actionEvent);
                int n = aCLTextArea.getFirstLine();
                int n2 = aCLTextArea.getVisibleLines();
                int n3 = aCLTextArea.getCaretLine();
                if (n < n2) {
                    n = n2;
                }
                aCLTextArea.setFirstLine(n - n2);
                int n4 = aCLTextArea.getLineStartOffset(Math.max(0, n3 - n2));
                if (this.select) {
                    aCLTextArea.select(aCLTextArea.getMarkPosition(), n4);
                } else {
                    aCLTextArea.setCaretPosition(n4);
                }
            }
        }

        public static class prev_line
        implements ActionListener {
            private boolean select;

            public prev_line(boolean bl) {
                this.select = bl;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ACLTextArea aCLTextArea = InputHandler.getTextArea(actionEvent);
                int n = aCLTextArea.getCaretPosition();
                int n2 = aCLTextArea.getCaretLine();
                if (n2 == 0) {
                    aCLTextArea.getToolkit().beep();
                    return;
                }
                int n3 = aCLTextArea.getMagicCaretPosition();
                if (n3 == -1) {
                    n3 = aCLTextArea.offsetToX(n2, n - aCLTextArea.getLineStartOffset(n2));
                }
                n = aCLTextArea.getLineStartOffset(n2 - 1) + aCLTextArea.xToOffset(n2 - 1, n3);
                if (this.select) {
                    aCLTextArea.select(aCLTextArea.getMarkPosition(), n);
                } else {
                    aCLTextArea.setCaretPosition(n);
                }
                aCLTextArea.setMagicCaretPosition(n3);
            }
        }

        public static class prev_char
        implements ActionListener {
            private boolean select;

            public prev_char(boolean bl) {
                this.select = bl;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ACLTextArea aCLTextArea = InputHandler.getTextArea(actionEvent);
                int n = aCLTextArea.getCaretPosition();
                if (n == 0) {
                    aCLTextArea.getToolkit().beep();
                    return;
                }
                if (this.select) {
                    aCLTextArea.select(aCLTextArea.getMarkPosition(), n - 1);
                } else {
                    aCLTextArea.setCaretPosition(n - 1);
                }
            }
        }

        public static class overwrite
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                ACLTextArea aCLTextArea;
                aCLTextArea.setOverwriteEnabled(!(aCLTextArea = InputHandler.getTextArea(actionEvent)).isOverwriteEnabled());
            }
        }

        public static class next_word
        implements ActionListener {
            private boolean select;

            public next_word(boolean bl) {
                this.select = bl;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                ACLTextArea aCLTextArea = InputHandler.getTextArea(actionEvent);
                int n = aCLTextArea.getCaretPosition();
                int n2 = aCLTextArea.getCaretLine();
                int n3 = aCLTextArea.getLineStartOffset(n2);
                if ((n -= n3) == (string = aCLTextArea.getLineText(aCLTextArea.getCaretLine())).length()) {
                    if (n3 + n == aCLTextArea.getDocumentLength()) {
                        aCLTextArea.getToolkit().beep();
                        return;
                    }
                    ++n;
                } else {
                    char c = string.charAt(n);
                    String string2 = (String)aCLTextArea.getDocument().getProperty("noWordSep");
                    boolean bl = !Character.isLetterOrDigit(c) && string2.indexOf(c) == -1;
                    int n4 = string.length();
                    int n5 = n;
                    while (n5 < string.length()) {
                        c = string.charAt(n5);
                        if (bl ^ (!Character.isLetterOrDigit(c) && string2.indexOf(c) == -1)) {
                            n4 = n5;
                            break;
                        }
                        ++n5;
                    }
                    n = n4;
                }
                if (this.select) {
                    aCLTextArea.select(aCLTextArea.getMarkPosition(), n3 + n);
                } else {
                    aCLTextArea.setCaretPosition(n3 + n);
                }
            }
        }

        public static class next_page
        implements ActionListener {
            private boolean select;

            public next_page(boolean bl) {
                this.select = bl;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ACLTextArea aCLTextArea = InputHandler.getTextArea(actionEvent);
                int n = aCLTextArea.getLineCount();
                int n2 = aCLTextArea.getFirstLine();
                int n3 = aCLTextArea.getVisibleLines();
                int n4 = aCLTextArea.getCaretLine();
                if ((n2 += n3) + n3 >= n - 1) {
                    n2 = n - n3;
                }
                aCLTextArea.setFirstLine(n2);
                int n5 = aCLTextArea.getLineStartOffset(Math.min(aCLTextArea.getLineCount() - 1, n4 + n3));
                if (this.select) {
                    aCLTextArea.select(aCLTextArea.getMarkPosition(), n5);
                } else {
                    aCLTextArea.setCaretPosition(n5);
                }
            }
        }

        public static class next_line
        implements ActionListener {
            private boolean select;

            public next_line(boolean bl) {
                this.select = bl;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ACLTextArea aCLTextArea = InputHandler.getTextArea(actionEvent);
                int n = aCLTextArea.getCaretPosition();
                int n2 = aCLTextArea.getCaretLine();
                if (n2 == aCLTextArea.getLineCount() - 1) {
                    aCLTextArea.getToolkit().beep();
                    return;
                }
                int n3 = aCLTextArea.getMagicCaretPosition();
                if (n3 == -1) {
                    n3 = aCLTextArea.offsetToX(n2, n - aCLTextArea.getLineStartOffset(n2));
                }
                n = aCLTextArea.getLineStartOffset(n2 + 1) + aCLTextArea.xToOffset(n2 + 1, n3);
                if (this.select) {
                    aCLTextArea.select(aCLTextArea.getMarkPosition(), n);
                } else {
                    aCLTextArea.setCaretPosition(n);
                }
                aCLTextArea.setMagicCaretPosition(n3);
            }
        }

        public static class next_char
        implements ActionListener {
            private boolean select;

            public next_char(boolean bl) {
                this.select = bl;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ACLTextArea aCLTextArea = InputHandler.getTextArea(actionEvent);
                int n = aCLTextArea.getCaretPosition();
                if (n == aCLTextArea.getDocumentLength()) {
                    aCLTextArea.getToolkit().beep();
                    return;
                }
                if (this.select) {
                    aCLTextArea.select(aCLTextArea.getMarkPosition(), n + 1);
                } else {
                    aCLTextArea.setCaretPosition(n + 1);
                }
            }
        }

        public static class insert_tab
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                ACLTextArea aCLTextArea = InputHandler.getTextArea(actionEvent);
                if (!aCLTextArea.isEditable()) {
                    aCLTextArea.getToolkit().beep();
                    return;
                }
                aCLTextArea.overwriteSetSelectedText("\t");
            }
        }

        public static class insert_break
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                ACLTextArea aCLTextArea = InputHandler.getTextArea(actionEvent);
                if (!aCLTextArea.isEditable()) {
                    aCLTextArea.getToolkit().beep();
                    return;
                }
                aCLTextArea.setSelectedText("\n");
            }
        }

        public static class home
        implements ActionListener {
            private boolean select;

            public home(boolean bl) {
                this.select = bl;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ACLTextArea aCLTextArea = InputHandler.getTextArea(actionEvent);
                int n = aCLTextArea.getCaretPosition();
                int n2 = aCLTextArea.getFirstLine();
                int n3 = aCLTextArea.getLineStartOffset(aCLTextArea.getCaretLine());
                int n4 = n2 == 0 ? 0 : n2 + aCLTextArea.getElectricScroll();
                int n5 = aCLTextArea.getLineStartOffset(n4);
                if (n == 0) {
                    aCLTextArea.getToolkit().beep();
                    return;
                }
                n = n == n5 ? 0 : (n == n3 ? n5 : n3);
                if (this.select) {
                    aCLTextArea.select(aCLTextArea.getMarkPosition(), n);
                } else {
                    aCLTextArea.setCaretPosition(n);
                }
            }
        }

        public static class end
        implements ActionListener {
            private boolean select;

            public end(boolean bl) {
                this.select = bl;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ACLTextArea aCLTextArea = InputHandler.getTextArea(actionEvent);
                int n = aCLTextArea.getCaretPosition();
                int n2 = aCLTextArea.getLineEndOffset(aCLTextArea.getCaretLine()) - 1;
                int n3 = aCLTextArea.getFirstLine() + aCLTextArea.getVisibleLines();
                n3 = n3 >= aCLTextArea.getLineCount() ? Math.min(aCLTextArea.getLineCount() - 1, n3) : (n3 -= aCLTextArea.getElectricScroll() + 1);
                int n4 = aCLTextArea.getLineEndOffset(n3) - 1;
                int n5 = aCLTextArea.getDocumentLength();
                if (n == n5) {
                    aCLTextArea.getToolkit().beep();
                    return;
                }
                n = n == n4 ? n5 : (n == n2 ? n4 : n2);
                if (this.select) {
                    aCLTextArea.select(aCLTextArea.getMarkPosition(), n);
                } else {
                    aCLTextArea.setCaretPosition(n);
                }
            }
        }

        public static class delete
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                ACLTextArea aCLTextArea = InputHandler.getTextArea(actionEvent);
                if (!aCLTextArea.isEditable()) {
                    aCLTextArea.getToolkit().beep();
                    return;
                }
                if (aCLTextArea.getSelectionStart() != aCLTextArea.getSelectionEnd()) {
                    aCLTextArea.setSelectedText("");
                } else {
                    int n = aCLTextArea.getCaretPosition();
                    if (n == aCLTextArea.getDocumentLength()) {
                        aCLTextArea.getToolkit().beep();
                        return;
                    }
                    try {
                        aCLTextArea.getDocument().remove(n, 1);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
            }
        }

        public static class backspace
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                ACLTextArea aCLTextArea = InputHandler.getTextArea(actionEvent);
                if (!aCLTextArea.isEditable()) {
                    aCLTextArea.getToolkit().beep();
                    return;
                }
                if (aCLTextArea.getSelectionStart() != aCLTextArea.getSelectionEnd()) {
                    aCLTextArea.setSelectedText("");
                } else {
                    int n = aCLTextArea.getCaretPosition();
                    if (n == 0) {
                        aCLTextArea.getToolkit().beep();
                        return;
                    }
                    try {
                        aCLTextArea.getDocument().remove(n - 1, 1);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
            }
        }
    }

    static class CaretBlinker
    implements ActionListener {
        CaretBlinker() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (focusedComponent != null && focusedComponent.hasFocus()) {
                focusedComponent.blinkCaret();
            }
        }
    }

    public static class TextUtilities {
        public static int findMatchingBracket(Document document, int n) throws BadLocationException {
            boolean bl;
            char c;
            if (document.getLength() == 0) {
                return -1;
            }
            char c2 = document.getText(n, 1).charAt(0);
            switch (c2) {
                case '(': {
                    c = ')';
                    bl = false;
                    break;
                }
                case ')': {
                    c = '(';
                    bl = true;
                    break;
                }
                case '[': {
                    c = ']';
                    bl = false;
                    break;
                }
                case ']': {
                    c = '[';
                    bl = true;
                    break;
                }
                case '{': {
                    c = '}';
                    bl = false;
                    break;
                }
                case '}': {
                    c = '{';
                    bl = true;
                    break;
                }
                default: {
                    return -1;
                }
            }
            if (bl) {
                int n2 = 1;
                String string = document.getText(0, n);
                int n3 = n - 1;
                while (n3 >= 0) {
                    char c3 = string.charAt(n3);
                    if (c3 == c2) {
                        ++n2;
                    } else if (c3 == c && --n2 == 0) {
                        return n3;
                    }
                    --n3;
                }
            } else {
                int n4 = 1;
                int n5 = document.getLength() - ++n;
                String string = document.getText(n, n5);
                int n6 = 0;
                while (n6 < n5) {
                    char c4 = string.charAt(n6);
                    if (c4 == c2) {
                        ++n4;
                    } else if (c4 == c && --n4 == 0) {
                        return n6 + n;
                    }
                    ++n6;
                }
            }
            return -1;
        }
    }
}

