/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import jade.lang.acl.ACLMessage;
import jade.util.leap.Properties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ACLPropertyList
extends JPanel {
    private boolean editable = true;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JList contentList = new JList();
    private JButton viewButton = new JButton();
    private JButton addButton = new JButton();
    private JButton deleteButton = new JButton();
    private DefaultListModel listModel = new DefaultListModel();
    private ACLPropertyListCellRenderer aclPropertyListCellRenderer = new ACLPropertyListCellRenderer();
    private ACLPropertyListener theDataListener = new ACLPropertyListener();
    private JScrollPane contentScrollPane = new JScrollPane();
    private String fieldName = "";
    private ACLMessage msg;

    public ACLPropertyList() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setEditable(boolean bl) {
        if (!bl) {
            this.editable = false;
            this.addButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
    }

    public void register(ACLMessage aCLMessage, String string) {
        this.listModel = new DefaultListModel();
        this.msg = aCLMessage;
        this.fieldName = string;
        Properties properties = aCLMessage.getAllUserDefinedParameters();
        this.aclPropertyListCellRenderer.register(aCLMessage);
        Enumeration<Object> enumeration = properties.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            this.listModel.addElement(string2);
        }
        this.contentList.setModel(this.listModel);
        this.theDataListener.register(aCLMessage, string);
        this.listModel.addListDataListener(this.theDataListener);
    }

    void doView() {
        String string;
        int n = this.contentList.getSelectedIndex();
        if (n < 0) {
            return;
        }
        String string2 = string = (String)this.listModel.getElementAt(n);
        ACLPropertyDialog aCLPropertyDialog = new ACLPropertyDialog();
        aCLPropertyDialog.setLocation((int)this.getLocationOnScreen().getX(), (int)this.getLocationOnScreen().getY());
        aCLPropertyDialog.setItskey(string2);
        aCLPropertyDialog.setItsvalue(this.msg.getAllUserDefinedParameters().getProperty(string2));
        aCLPropertyDialog.setEdit();
        aCLPropertyDialog.setEditable(this.editable);
        aCLPropertyDialog.setTitle(this.editable ? "Edit property: " + string : "View property: " + string);
        aCLPropertyDialog.show();
        if (aCLPropertyDialog.getOK()) {
            this.theDataListener.registerChangedProperty(string, aCLPropertyDialog.getItsvalue());
            this.listModel.setElementAt(string, n);
        }
    }

    void deleteButton_actionPerformed(ActionEvent actionEvent) {
        this.doDelete();
    }

    void doDelete() {
        int n = this.contentList.getSelectedIndex();
        if (n >= 0) {
            this.theDataListener.registerRemovedKey((String)this.listModel.getElementAt(n));
            this.listModel.remove(n);
        }
    }

    void addButton_actionPerformed(ActionEvent actionEvent) {
        this.doAdd();
    }

    void doAdd() {
        ACLPropertyDialog aCLPropertyDialog = new ACLPropertyDialog();
        aCLPropertyDialog.setLocation((int)this.getLocationOnScreen().getX(), (int)this.getLocationOnScreen().getY());
        aCLPropertyDialog.show();
        aCLPropertyDialog.setTitle("<new property>");
        if (aCLPropertyDialog.getOK()) {
            this.theDataListener.registerChangedProperty(aCLPropertyDialog.getItskey(), aCLPropertyDialog.getItsvalue());
            this.listModel.addElement(aCLPropertyDialog.getItskey());
        }
        this.validate();
    }

    void viewButton_actionPerformed(ActionEvent actionEvent) {
        this.doView();
    }

    void contentList_mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            this.doView();
        }
    }

    String filterEntry(String string) {
        String string2 = "<?>";
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
            string2 = (String)stringTokenizer.nextElement();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    void contentList_keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.doView();
        }
        if (!this.editable) {
            return;
        }
        if (keyEvent.getKeyCode() == 155) {
            this.doAdd();
        }
        if (keyEvent.getKeyCode() == 127) {
            this.doDelete();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.viewButton.setBackground(Color.white);
        this.viewButton.setFont(new Font("Dialog", 0, 11));
        this.viewButton.setForeground(new Color(0, 0, 83));
        this.viewButton.setMinimumSize(new Dimension(13, 5));
        this.viewButton.setPreferredSize(new Dimension(13, 11));
        this.viewButton.setToolTipText("edit/view property");
        this.viewButton.setMargin(new Insets(0, 0, 0, 0));
        this.viewButton.setText("v");
        this.viewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ACLPropertyList.this.viewButton_actionPerformed(actionEvent);
            }
        });
        this.addButton.setBackground(Color.white);
        this.addButton.setFont(new Font("Dialog", 0, 11));
        this.addButton.setForeground(new Color(0, 0, 83));
        this.addButton.setMinimumSize(new Dimension(13, 5));
        this.addButton.setPreferredSize(new Dimension(13, 11));
        this.addButton.setToolTipText("add property");
        this.addButton.setMargin(new Insets(0, 0, 0, 0));
        this.addButton.setText("+");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ACLPropertyList.this.addButton_actionPerformed(actionEvent);
            }
        });
        this.deleteButton.setBackground(Color.white);
        this.deleteButton.setFont(new Font("Dialog", 0, 11));
        this.deleteButton.setForeground(new Color(0, 0, 83));
        this.deleteButton.setMinimumSize(new Dimension(13, 5));
        this.deleteButton.setPreferredSize(new Dimension(13, 11));
        this.deleteButton.setToolTipText("delete property");
        this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteButton.setText("x");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ACLPropertyList.this.deleteButton_actionPerformed(actionEvent);
            }
        });
        this.contentList.setCellRenderer(this.aclPropertyListCellRenderer);
        this.contentList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ACLPropertyList.this.contentList_keyPressed(keyEvent);
            }
        });
        this.contentList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ACLPropertyList.this.contentList_mouseClicked(mouseEvent);
            }
        });
        this.contentScrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
        this.contentScrollPane.getViewport().add((Component)this.contentList, null);
        this.add((Component)this.contentScrollPane, new GridBagConstraints(0, 0, 1, 3, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.addButton, new GridBagConstraints(1, 1, 0, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.deleteButton, new GridBagConstraints(1, 2, 0, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.viewButton, new GridBagConstraints(1, 0, 0, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    private class ACLPropertyListener
    implements ListDataListener {
        private String fieldName = "";
        private String theRemovedKey;
        private String theChangedKey;
        private String theChangedValue;
        private ACLMessage itsMsg;

        private ACLPropertyListener() {
        }

        public void register(Object object, String string) {
            this.itsMsg = (ACLMessage)object;
            this.fieldName = string;
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            DefaultListModel defaultListModel = (DefaultListModel)listDataEvent.getSource();
            int n = listDataEvent.getIndex0();
            String string = (String)defaultListModel.elementAt(n);
            this.itsMsg.addUserDefinedParameter(this.theChangedKey, this.theChangedValue);
        }

        public void registerChangedProperty(String string, String string2) {
            this.theChangedKey = string;
            this.theChangedValue = string2;
        }

        public void registerRemovedKey(String string) {
            this.theRemovedKey = string;
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            String string = "remove" + this.fieldName;
            String string2 = "jade.core.AID";
            this.itsMsg.removeUserDefinedParameter(this.theRemovedKey);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            DefaultListModel defaultListModel = (DefaultListModel)listDataEvent.getSource();
            int n = listDataEvent.getIndex0();
            this.itsMsg.removeUserDefinedParameter(this.theChangedKey);
            this.itsMsg.addUserDefinedParameter(this.theChangedKey, this.theChangedValue);
        }
    }

    private class ACLPropertyDialog
    extends JDialog {
        private String OK = "ok";
        private String CANCELLED = "cancelled";
        private String CLOSED = "closed";
        private GridBagLayout gridBagLayout1 = new GridBagLayout();
        private JTextField keyTextField = new JTextField();
        private JLabel jLabel1 = new JLabel();
        private JButton okButton = new JButton();
        private JButton cancelButton = new JButton();
        private JLabel jLabel2 = new JLabel();
        private JTextField valueTextField = new JTextField();
        private String userAction;
        private String itsAddress;
        private String itskey;
        private String itsvalue;

        public ACLPropertyDialog() {
            this.setModal(true);
            try {
                this.jbInit();
                this.pack();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public String getUserAction() {
            return this.userAction;
        }

        public boolean getOK() {
            return this.userAction.equals(this.OK);
        }

        public String getItskey() {
            return this.itskey;
        }

        public String getItsvalue() {
            return this.itsvalue;
        }

        public void setEditable(boolean bl) {
            if (!bl) {
                this.OK = "CLOSED";
                this.cancelButton.setVisible(false);
                this.valueTextField.setEditable(false);
            }
        }

        public void setUserAction(String string) {
            this.userAction = string;
        }

        public void setItskey(String string) {
            this.keyTextField.setText(string);
            this.itskey = string;
        }

        public void setEdit() {
            this.keyTextField.setEditable(false);
        }

        public void setItsvalue(String string) {
            this.valueTextField.setText(string);
            this.itsvalue = string;
        }

        void jbInit() throws Exception {
            this.getContentPane().setLayout(this.gridBagLayout1);
            this.jLabel1.setFont(new Font("Dialog", 0, 12));
            this.jLabel1.setText("key");
            this.getContentPane().setBackground(Color.white);
            this.okButton.setBackground(Color.white);
            this.okButton.setFont(new Font("Dialog", 0, 12));
            this.okButton.setText("ok");
            this.okButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ACLPropertyDialog this$1;
                {
                    this.this$1 = aCLPropertyDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.okButton_actionPerformed(actionEvent);
                }
            });
            this.cancelButton.setBackground(Color.white);
            this.cancelButton.setFont(new Font("Dialog", 0, 12));
            this.cancelButton.setText("cancel");
            this.cancelButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ACLPropertyDialog this$1;
                {
                    this.this$1 = aCLPropertyDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.cancelButton_actionPerformed(actionEvent);
                }
            });
            this.jLabel2.setFont(new Font("Dialog", 0, 12));
            this.jLabel2.setText("value");
            this.getContentPane().add((Component)this.keyTextField, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().add((Component)this.cancelButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().add((Component)this.valueTextField, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().add((Component)this.okButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, -16, 0, 0), 0, 0));
        }

        void cancelButton_actionPerformed(ActionEvent actionEvent) {
            this.setUserAction(this.CANCELLED);
            this.hide();
        }

        void okButton_actionPerformed(ActionEvent actionEvent) {
            this.setItskey(this.keyTextField.getText());
            this.setItsvalue(this.valueTextField.getText());
            this.setUserAction(this.OK);
            this.hide();
        }
    }

    private class ACLPropertyListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private ACLMessage msg;

        public ACLPropertyListCellRenderer() {
            this.setOpaque(true);
            this.setFont(new Font("Dialog", 0, 11));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object != null && object instanceof String && this.msg != null) {
                String string = (String)object;
                String string2 = this.msg.getUserDefinedParameter(string);
                this.setText(string + " = " + string2);
            }
            this.setBackground(bl ? Color.blue : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }

        public void register(ACLMessage aCLMessage) {
            this.msg = aCLMessage;
        }
    }
}

