/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.applet;

import jade.content.Concept;
import jade.content.abs.AbsContentElement;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.domain.DFGUIManagement.DFAppletOntology;
import jade.domain.DFGUIManagement.DeregisterFrom;
import jade.domain.DFGUIManagement.Federate;
import jade.domain.DFGUIManagement.GetDescription;
import jade.domain.DFGUIManagement.GetDescriptionUsed;
import jade.domain.DFGUIManagement.GetParents;
import jade.domain.DFGUIManagement.ModifyOn;
import jade.domain.DFGUIManagement.RegisterWith;
import jade.domain.DFGUIManagement.SearchOn;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAAgentManagement.UnsupportedFunction;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.tools.applet.AppletRequestProto;
import jade.tools.applet.DFAppletCommunicator;
import jade.tools.dfgui.DFGUI;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Serializable;
import java.util.Date;

public class JADEAppletRequestProto
extends AppletRequestProto {
    Codec c;
    String action;
    private static Ontology o = DFAppletOntology.getInstance();
    AID receiver;
    AID parent;
    DFGUI gui;
    DFAppletCommunicator dfApplet;
    ACLMessage lastMsg;

    JADEAppletRequestProto(DFAppletCommunicator dFAppletCommunicator, AID aID, String string, Object object, Object object2, SearchConstraints searchConstraints) throws FIPAException {
        super(dFAppletCommunicator.getStream(), dFAppletCommunicator.getParser(), new ACLMessage(16));
        Serializable serializable;
        this.gui = dFAppletCommunicator.getGUI();
        this.dfApplet = dFAppletCommunicator;
        ACLMessage aCLMessage = new ACLMessage(16);
        aCLMessage.addReceiver(aID);
        aCLMessage.setProtocol("fipa-request");
        aCLMessage.setLanguage("fipa-sl");
        aCLMessage.setOntology("DFApplet-Management");
        aCLMessage.setReplyWith("rw" + new Date().getTime());
        aCLMessage.setConversationId("conv" + new Date().getTime());
        this.reqMsg = (ACLMessage)aCLMessage.clone();
        this.action = string;
        this.receiver = aID;
        this.parent = (AID)object2;
        Action action = new Action();
        action.setActor(aID);
        if (string.equalsIgnoreCase("federate")) {
            serializable = new Federate();
            ((Federate)serializable).setDf((AID)object2);
            ((Federate)serializable).setDescription((DFAgentDescription)object);
            action.setAction((Concept)serializable);
        } else if (string.equalsIgnoreCase("getdescription")) {
            action.setAction(new GetDescription());
        } else if (string.equalsIgnoreCase("getparents")) {
            action.setAction(new GetParents());
        } else if (string.equalsIgnoreCase("getdescriptionused")) {
            serializable = new GetDescriptionUsed();
            ((GetDescriptionUsed)serializable).setParentDF((AID)object2);
            action.setAction((Concept)serializable);
        } else if (string.equalsIgnoreCase("deregisterfrom")) {
            serializable = new DeregisterFrom();
            ((DeregisterFrom)serializable).setDf((AID)object2);
            ((DeregisterFrom)serializable).setDescription((DFAgentDescription)object);
            action.setAction((Concept)serializable);
        } else if (string.equalsIgnoreCase("registerwith")) {
            serializable = new RegisterWith();
            ((RegisterWith)serializable).setDf((AID)object2);
            ((RegisterWith)serializable).setDescription((DFAgentDescription)object);
            action.setAction((Concept)serializable);
        } else if (string.equalsIgnoreCase("searchon")) {
            serializable = new SearchOn();
            ((SearchOn)serializable).setDf((AID)object2);
            ((SearchOn)serializable).setDescription((DFAgentDescription)object);
            ((SearchOn)serializable).setConstraints(searchConstraints);
            action.setAction((Concept)serializable);
        } else if (string.equalsIgnoreCase("modifyon")) {
            serializable = new ModifyOn();
            ((ModifyOn)serializable).setDf((AID)object2);
            ((ModifyOn)serializable).setDescription((DFAgentDescription)object);
            action.setAction((Concept)serializable);
        } else {
            throw new UnsupportedFunction();
        }
        this.c = new SLCodec();
        serializable = new ArrayList();
        serializable.add(action);
        try {
            String string2 = ((SLCodec)this.c).encode(o, (AbsContentElement)o.fromObject(action));
            this.reqMsg.setContent(string2);
        }
        catch (OntologyException ontologyException) {
            ontologyException.printStackTrace();
            throw new FIPAException("Ontology error: " + ontologyException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    JADEAppletRequestProto(DFAppletCommunicator dFAppletCommunicator, AID aID, String string, Object object, Object object2) throws FIPAException {
        this(dFAppletCommunicator, aID, string, object, object2, null);
    }

    public List getResult() throws FIPAException, NotYetReady {
        if (this.notYetReady) {
            throw new NotYetReady();
        }
        if (this.lastMsg.getPerformative() != 7) {
            throw new FIPAException(this.lastMsg);
        }
        Result result = AppletRequestProto.extractContent(this.lastMsg.getContent(), (SLCodec)this.c, o);
        Iterator iterator = result.getItems().iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    protected void handleAgree(ACLMessage aCLMessage) {
        try {
            this.lastMsg = (ACLMessage)aCLMessage.clone();
            this.gui.showStatusMsg("Process your request & waiting for result...");
        }
        catch (Exception exception) {}
    }

    protected void handleInform(ACLMessage aCLMessage) {
        try {
            this.notYetReady = false;
            this.lastMsg = (ACLMessage)aCLMessage.clone();
            if (this.action.equalsIgnoreCase("federate")) {
                this.gui.showStatusMsg("Request processed. Ready for new  request.");
                this.gui.addParent(this.parent);
            } else if (this.action.equalsIgnoreCase("getdescription")) {
                try {
                    List list = this.getResult();
                    this.dfApplet.setDescription((DFAgentDescription)list.get(0));
                }
                catch (NotYetReady notYetReady) {
                    notYetReady.printStackTrace();
                }
            } else if (this.action.equalsIgnoreCase("getparents")) {
                this.gui.showStatusMsg("Request processed. Ready for new Request.");
            } else if (this.action.equalsIgnoreCase("deregisterfrom")) {
                this.gui.showStatusMsg("Request processed. Ready for a new request");
                this.gui.removeParent(this.parent);
            } else if (this.action.equalsIgnoreCase("registerwith")) {
                this.gui.showStatusMsg("Request processed. Ready for new request.");
            } else if (this.action.equalsIgnoreCase("searchon")) {
                this.gui.refreshLastSearchResults(this.getResult(), this.parent);
                this.gui.showStatusMsg("Request processed. Ready for new request.");
            } else if (this.action.equalsIgnoreCase("modifyon")) {
                this.gui.showStatusMsg("Request processed. Ready for new request.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void handleFailure(ACLMessage aCLMessage) {
        try {
            this.notYetReady = false;
            this.lastMsg = (ACLMessage)aCLMessage.clone();
            this.gui.showStatusMsg("Request refused.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void handleNotUnderstood(ACLMessage aCLMessage) {
        this.notYetReady = false;
        this.lastMsg = (ACLMessage)aCLMessage.clone();
    }

    protected void handleOtherMessage(ACLMessage aCLMessage) {
    }

    protected void handleRefuse(ACLMessage aCLMessage) {
        this.notYetReady = false;
        this.lastMsg = (ACLMessage)aCLMessage.clone();
    }

    public static class NotYetReady
    extends Exception {
        NotYetReady() {
            super("Requested message is not ready yet.");
        }
    }
}

