/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.SimpleBehaviour;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.domain.FIPANames;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.AchieveREResponder;
import jade.util.leap.Iterator;

public class SimpleAchieveREResponder
extends SimpleBehaviour
implements FIPANames.InteractionProtocol {
    private static final int WAITING_MSG_STATE = 0;
    private static final int PREPARE_RESPONSE_STATE = 1;
    private static final int SEND_RESPONSE_STATE = 2;
    private static final int PREPARE_RES_NOT_STATE = 3;
    private static final int SEND_RESULT_NOTIFICATION_STATE = 4;
    private static final int RESET_STATE = 5;
    public final String REQUEST_KEY = "_request" + this.hashCode();
    public final String RESPONSE_KEY = "_response" + this.hashCode();
    public final String RESULT_NOTIFICATION_KEY = "_result-notification" + this.hashCode();
    private MessageTemplate template;
    private int state = 0;
    private boolean finished = false;

    public static MessageTemplate createMessageTemplate(String string) {
        return AchieveREResponder.createMessageTemplate(string);
    }

    public SimpleAchieveREResponder(Agent agent, MessageTemplate messageTemplate) {
        this(agent, messageTemplate, new DataStore());
    }

    public SimpleAchieveREResponder(Agent agent, MessageTemplate messageTemplate, DataStore dataStore) {
        super(agent);
        this.setDataStore(dataStore);
        this.template = messageTemplate;
        this.finished = false;
    }

    public final void action() {
        switch (this.state) {
            case 0: {
                ACLMessage aCLMessage = this.myAgent.receive(this.template);
                if (aCLMessage != null) {
                    this.getDataStore().put(this.REQUEST_KEY, aCLMessage);
                    this.state = 1;
                    break;
                }
                this.block();
                break;
            }
            case 1: {
                DataStore dataStore = this.getDataStore();
                ACLMessage aCLMessage = (ACLMessage)dataStore.get(this.REQUEST_KEY);
                ACLMessage aCLMessage2 = null;
                this.state = 2;
                try {
                    aCLMessage2 = this.prepareResponse(aCLMessage);
                }
                catch (NotUnderstoodException notUnderstoodException) {
                    aCLMessage2 = aCLMessage.createReply();
                    aCLMessage2.setContent(notUnderstoodException.getMessage());
                    aCLMessage2.setPerformative(10);
                }
                catch (RefuseException refuseException) {
                    aCLMessage2 = aCLMessage.createReply();
                    aCLMessage2.setContent(refuseException.getMessage());
                    aCLMessage2.setPerformative(14);
                }
                dataStore.put(this.RESPONSE_KEY, aCLMessage2);
                break;
            }
            case 2: {
                DataStore dataStore = this.getDataStore();
                ACLMessage aCLMessage = (ACLMessage)dataStore.get(this.RESPONSE_KEY);
                if (aCLMessage != null) {
                    ACLMessage aCLMessage3 = (ACLMessage)dataStore.get(this.REQUEST_KEY);
                    aCLMessage = this.arrangeMessage(aCLMessage3, aCLMessage);
                    this.myAgent.send(aCLMessage);
                    if (aCLMessage.getPerformative() == 1) {
                        this.state = 3;
                        break;
                    }
                    this.state = 5;
                    break;
                }
                this.state = 3;
                break;
            }
            case 3: {
                this.state = 4;
                DataStore dataStore = this.getDataStore();
                ACLMessage aCLMessage = (ACLMessage)dataStore.get(this.REQUEST_KEY);
                ACLMessage aCLMessage4 = (ACLMessage)dataStore.get(this.RESPONSE_KEY);
                ACLMessage aCLMessage5 = null;
                try {
                    aCLMessage5 = this.prepareResultNotification(aCLMessage, aCLMessage4);
                }
                catch (FailureException failureException) {
                    aCLMessage5 = aCLMessage.createReply();
                    aCLMessage5.setContent(failureException.getMessage());
                    aCLMessage5.setPerformative(6);
                }
                dataStore.put(this.RESULT_NOTIFICATION_KEY, aCLMessage5);
                break;
            }
            case 4: {
                this.state = 5;
                DataStore dataStore = this.getDataStore();
                ACLMessage aCLMessage = (ACLMessage)dataStore.get(this.RESULT_NOTIFICATION_KEY);
                if (aCLMessage == null) break;
                ACLMessage aCLMessage6 = (ACLMessage)dataStore.get(this.REQUEST_KEY);
                this.myAgent.send(this.arrangeMessage(aCLMessage6, aCLMessage));
                break;
            }
            case 5: {
                this.reset();
            }
        }
    }

    protected ACLMessage prepareResponse(ACLMessage aCLMessage) throws NotUnderstoodException, RefuseException {
        System.out.println("prepareResponse() method not re-defined");
        return null;
    }

    protected ACLMessage prepareResultNotification(ACLMessage aCLMessage, ACLMessage aCLMessage2) throws FailureException {
        System.out.println("prepareResultNotification() method not re-defined");
        return null;
    }

    public void reset() {
        this.finished = false;
        this.state = 0;
        DataStore dataStore = this.getDataStore();
        dataStore.remove(this.REQUEST_KEY);
        dataStore.remove(this.RESPONSE_KEY);
        dataStore.remove(this.RESULT_NOTIFICATION_KEY);
        super.reset();
    }

    public void reset(MessageTemplate messageTemplate) {
        this.template = messageTemplate;
        this.reset();
    }

    public boolean done() {
        return this.finished;
    }

    private ACLMessage arrangeMessage(ACLMessage aCLMessage, ACLMessage aCLMessage2) {
        aCLMessage2.setConversationId(aCLMessage.getConversationId());
        aCLMessage2.setInReplyTo(aCLMessage.getReplyWith());
        aCLMessage2.setProtocol(aCLMessage.getProtocol());
        if (!aCLMessage2.getAllReceiver().hasNext()) {
            Iterator iterator = aCLMessage.getAllReplyTo();
            int n = 0;
            while (iterator.hasNext()) {
                aCLMessage2.addReceiver((AID)iterator.next());
                ++n;
            }
            if (n == 0) {
                aCLMessage2.addReceiver(aCLMessage.getSender());
            }
        }
        return aCLMessage2;
    }
}

