/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.Initiator;
import jade.util.leap.Iterator;
import jade.util.leap.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class ContractNetInitiator
extends Initiator {
    public final String CFP_KEY;
    public final String ALL_CFPS_KEY;
    public final String ALL_ACCEPTANCES_KEY;
    public final String REPLY_KEY;
    public final String ALL_RESPONSES_KEY;
    public final String ALL_RESULT_NOTIFICATIONS_KEY;
    private static final String HANDLE_PROPOSE = "Handle-propose";
    private static final String HANDLE_REFUSE = "Handle-refuse";
    private static final String HANDLE_INFORM = "Handle-inform";
    private static final String HANDLE_ALL_RESPONSES = "Handle-all-responses";
    private static final String HANDLE_ALL_RESULT_NOTIFICATIONS = "Handle-all-result-notifications";
    private static final int ALL_RESPONSES_RECEIVED = 1;
    private static final int ALL_RESULT_NOTIFICATIONS_RECEIVED = 2;
    private int step;
    private boolean skipNextRespFlag;
    private String[] toBeReset;

    public ContractNetInitiator(Agent agent, ACLMessage aCLMessage) {
        this(agent, aCLMessage, new DataStore());
    }

    public ContractNetInitiator(Agent agent, ACLMessage aCLMessage, DataStore dataStore) {
        super(agent, aCLMessage, dataStore);
        this.CFP_KEY = this.INITIATION_K;
        this.ALL_CFPS_KEY = this.ALL_INITIATIONS_K;
        this.ALL_ACCEPTANCES_KEY = "__all-acceptances" + this.hashCode();
        this.REPLY_KEY = this.REPLY_K;
        this.ALL_RESPONSES_KEY = "__all-responses" + this.hashCode();
        this.ALL_RESULT_NOTIFICATIONS_KEY = "__all-result-notifications" + this.hashCode();
        this.step = 1;
        this.skipNextRespFlag = false;
        this.toBeReset = null;
        this.registerTransition("Check-in-seq", HANDLE_PROPOSE, 11);
        this.registerTransition("Check-in-seq", HANDLE_REFUSE, 14);
        this.registerTransition("Check-in-seq", HANDLE_INFORM, 7);
        this.registerDefaultTransition(HANDLE_PROPOSE, "Check-sessions");
        this.registerDefaultTransition(HANDLE_REFUSE, "Check-sessions");
        this.registerDefaultTransition(HANDLE_INFORM, "Check-sessions");
        this.registerTransition("Check-sessions", HANDLE_ALL_RESPONSES, 1);
        this.registerTransition("Check-sessions", HANDLE_ALL_RESULT_NOTIFICATIONS, 2);
        this.registerDefaultTransition(HANDLE_ALL_RESPONSES, "Send-initiations", this.getToBeReset());
        OneShotBehaviour oneShotBehaviour = null;
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895819003L;

            public void action() {
                Vector vector = (Vector)this.getDataStore().get(ContractNetInitiator.this.ALL_ACCEPTANCES_KEY);
                ACLMessage aCLMessage = (ACLMessage)this.getDataStore().get(ContractNetInitiator.this.REPLY_K);
                ContractNetInitiator.this.handlePropose(aCLMessage, vector);
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_PROPOSE);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895819004L;

            public void action() {
                ContractNetInitiator.this.handleRefuse((ACLMessage)this.getDataStore().get(ContractNetInitiator.this.REPLY_K));
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_REFUSE);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818006L;

            public void action() {
                ContractNetInitiator.this.handleInform((ACLMessage)this.getDataStore().get(ContractNetInitiator.this.REPLY_K));
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_INFORM);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){

            public void action() {
                Vector vector = (Vector)this.getDataStore().get(ContractNetInitiator.this.ALL_RESPONSES_KEY);
                Vector vector2 = (Vector)this.getDataStore().get(ContractNetInitiator.this.ALL_ACCEPTANCES_KEY);
                ContractNetInitiator.this.handleAllResponses(vector, vector2);
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_ALL_RESPONSES);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){

            public void action() {
                ContractNetInitiator.this.handleAllResultNotifications((Vector)this.getDataStore().get(ContractNetInitiator.this.ALL_RESULT_NOTIFICATIONS_KEY));
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerLastState(oneShotBehaviour, HANDLE_ALL_RESULT_NOTIFICATIONS);
    }

    protected Vector prepareInitiations(ACLMessage aCLMessage) {
        return this.prepareCfps(aCLMessage);
    }

    protected void sendInitiations(Vector vector) {
        long l = System.currentTimeMillis();
        long l2 = -1L;
        long l3 = -1L;
        if (this.step == 2) {
            vector = (Vector)this.getDataStore().get(this.ALL_ACCEPTANCES_KEY);
        }
        String string = this.createConvId(vector);
        this.replyTemplate = MessageTemplate.MatchConversationId(string);
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            long l4;
            Comparable comparable;
            ACLMessage aCLMessage = (ACLMessage)enumeration.nextElement();
            if (aCLMessage == null) continue;
            ACLMessage aCLMessage2 = (ACLMessage)aCLMessage.clone();
            aCLMessage2.setConversationId(string);
            Iterator iterator = aCLMessage.getAllReceiver();
            while (iterator.hasNext()) {
                aCLMessage2.clearAllReceiver();
                comparable = (AID)iterator.next();
                aCLMessage2.addReceiver((AID)comparable);
                if (this.step == 1 || aCLMessage2.getPerformative() == 0) {
                    String string2 = "R" + this.hashCode() + "_" + Integer.toString(n);
                    aCLMessage2.setReplyWith(string2);
                    this.sessions.put(string2, new Session(this.step));
                    this.adjustReplyTemplate(aCLMessage2);
                    ++n;
                }
                this.myAgent.send(aCLMessage2);
            }
            if (this.step != 1 && aCLMessage2.getPerformative() != 0 || (comparable = aCLMessage.getReplyByDate()) == null || (l4 = ((Date)comparable).getTime() - l) <= 0L || l4 >= l2 && l2 > 0L) continue;
            l2 = l4;
            l3 = ((Date)comparable).getTime();
        }
        this.replyReceiver.setTemplate(this.replyTemplate);
        this.replyReceiver.setDeadline(l3);
    }

    protected boolean checkInSequence(ACLMessage aCLMessage) {
        boolean bl = false;
        String string = aCLMessage.getInReplyTo();
        Session session = (Session)this.sessions.get(string);
        if (session != null) {
            int n = aCLMessage.getPerformative();
            if (session.update(n)) {
                Vector vector = (Vector)this.getDataStore().get(this.step == 1 ? this.ALL_RESPONSES_KEY : this.ALL_RESULT_NOTIFICATIONS_KEY);
                vector.addElement(aCLMessage);
                bl = true;
            }
            if (session.isCompleted()) {
                this.sessions.remove(string);
            }
        }
        return bl;
    }

    protected int checkSessions(ACLMessage aCLMessage) {
        int n;
        if (this.skipNextRespFlag) {
            this.sessions.clear();
        }
        int n2 = n = this.step == 1 ? 1 : 2;
        if (aCLMessage != null) {
            if (this.sessions.size() > 0) {
                n = -1;
            }
        } else {
            this.sessions.clear();
        }
        if (n != -1) {
            ++this.step;
        }
        return n;
    }

    protected String[] getToBeReset() {
        if (this.toBeReset == null) {
            this.toBeReset = new String[]{HANDLE_PROPOSE, HANDLE_REFUSE, "Handle-not-understood", HANDLE_INFORM, "Handle-failure", "Handle-out-of-seq"};
        }
        return this.toBeReset;
    }

    protected Vector prepareCfps(ACLMessage aCLMessage) {
        Vector<ACLMessage> vector = new Vector<ACLMessage>(1);
        vector.addElement(aCLMessage);
        return vector;
    }

    protected void handlePropose(ACLMessage aCLMessage, Vector vector) {
    }

    protected void handleRefuse(ACLMessage aCLMessage) {
    }

    protected void handleInform(ACLMessage aCLMessage) {
    }

    protected void handleAllResponses(Vector vector, Vector vector2) {
    }

    protected void handleAllResultNotifications(Vector vector) {
    }

    public void registerPrepareCfps(Behaviour behaviour) {
        this.registerPrepareInitiations(behaviour);
    }

    public void registerHandlePropose(Behaviour behaviour) {
        this.registerState(behaviour, HANDLE_PROPOSE);
        behaviour.setDataStore(this.getDataStore());
    }

    public void registerHandleRefuse(Behaviour behaviour) {
        this.registerState(behaviour, HANDLE_REFUSE);
        behaviour.setDataStore(this.getDataStore());
    }

    public void registerHandleInform(Behaviour behaviour) {
        this.registerState(behaviour, HANDLE_INFORM);
        behaviour.setDataStore(this.getDataStore());
    }

    public void registerHandleAllResponses(Behaviour behaviour) {
        this.registerState(behaviour, HANDLE_ALL_RESPONSES);
        behaviour.setDataStore(this.getDataStore());
    }

    public void registerHandleAllResultNotifications(Behaviour behaviour) {
        this.registerLastState(behaviour, HANDLE_ALL_RESULT_NOTIFICATIONS);
        behaviour.setDataStore(this.getDataStore());
    }

    public void skipNextResponses() {
        this.skipNextRespFlag = true;
    }

    public void reset(ACLMessage aCLMessage) {
        super.reset(aCLMessage);
        this.step = 1;
        this.skipNextRespFlag = false;
    }

    protected void initializeDataStore(ACLMessage aCLMessage) {
        super.initializeDataStore(aCLMessage);
        DataStore dataStore = this.getDataStore();
        Vector vector = new Vector();
        dataStore.put(this.ALL_RESPONSES_KEY, vector);
        vector = new Vector();
        dataStore.put(this.ALL_RESULT_NOTIFICATIONS_KEY, vector);
        vector = new Vector();
        dataStore.put(this.ALL_ACCEPTANCES_KEY, vector);
    }

    class Session
    implements Serializable {
        static final int INIT = 0;
        static final int REPLY_RECEIVED = 1;
        private int state = 0;
        private int step;

        public Session(int n) {
            this.step = n;
        }

        public boolean update(int n) {
            if (this.state == 0) {
                if (this.step == 1) {
                    switch (n) {
                        case 6: 
                        case 10: 
                        case 11: 
                        case 14: {
                            this.state = 1;
                            return true;
                        }
                    }
                    return false;
                }
                switch (n) {
                    case 6: 
                    case 7: 
                    case 10: {
                        this.state = 1;
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        public int getState() {
            return this.state;
        }

        public boolean isCompleted() {
            return this.state == 1;
        }
    }
}

