/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.Initiator;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class AchieveREInitiator
extends Initiator {
    public final String REQUEST_KEY;
    public final String ALL_REQUESTS_KEY;
    public final String REPLY_KEY;
    public final String ALL_RESPONSES_KEY;
    public final String ALL_RESULT_NOTIFICATIONS_KEY;
    private static final String HANDLE_AGREE = "Handle-agree";
    private static final String HANDLE_REFUSE = "Handle-refuse";
    private static final String HANDLE_INFORM = "Handle-inform";
    private static final String HANDLE_ALL_RESPONSES = "Handle-all-responses";
    private static final String HANDLE_ALL_RESULT_NOTIFICATIONS = "Handle-all-result-notifications";
    private static final String CHECK_AGAIN = "Check-again";
    private static final int ALL_RESPONSES_RECEIVED = 1;
    private static final int ALL_RESULT_NOTIFICATIONS_RECEIVED = 2;
    private boolean allResponsesReceived;
    private String[] toBeReset;

    public AchieveREInitiator(Agent agent, ACLMessage aCLMessage) {
        this(agent, aCLMessage, new DataStore());
    }

    public AchieveREInitiator(Agent agent, ACLMessage aCLMessage, DataStore dataStore) {
        super(agent, aCLMessage, dataStore);
        this.REQUEST_KEY = this.INITIATION_K;
        this.ALL_REQUESTS_KEY = this.ALL_INITIATIONS_K;
        this.REPLY_KEY = this.REPLY_K;
        this.ALL_RESPONSES_KEY = "__all-responses" + this.hashCode();
        this.ALL_RESULT_NOTIFICATIONS_KEY = "__all-result-notifications" + this.hashCode();
        this.allResponsesReceived = false;
        this.toBeReset = null;
        this.registerTransition("Check-in-seq", HANDLE_AGREE, 1);
        this.registerTransition("Check-in-seq", HANDLE_INFORM, 7);
        this.registerTransition("Check-in-seq", HANDLE_REFUSE, 14);
        this.registerDefaultTransition(HANDLE_AGREE, "Check-sessions");
        this.registerDefaultTransition(HANDLE_INFORM, "Check-sessions");
        this.registerDefaultTransition(HANDLE_REFUSE, "Check-sessions");
        this.registerTransition("Check-sessions", HANDLE_ALL_RESPONSES, 1);
        this.registerTransition("Check-sessions", HANDLE_ALL_RESULT_NOTIFICATIONS, 2);
        this.registerDefaultTransition(HANDLE_ALL_RESPONSES, CHECK_AGAIN);
        this.registerTransition(CHECK_AGAIN, HANDLE_ALL_RESULT_NOTIFICATIONS, 0);
        this.registerDefaultTransition(CHECK_AGAIN, "Receive-reply", this.toBeReset);
        OneShotBehaviour oneShotBehaviour = null;
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818003L;

            public void action() {
                AchieveREInitiator.this.handleAgree((ACLMessage)this.getDataStore().get(AchieveREInitiator.this.REPLY_K));
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_AGREE);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818004L;

            public void action() {
                AchieveREInitiator.this.handleRefuse((ACLMessage)this.getDataStore().get(AchieveREInitiator.this.REPLY_K));
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_REFUSE);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818006L;

            public void action() {
                AchieveREInitiator.this.handleInform((ACLMessage)this.getDataStore().get(AchieveREInitiator.this.REPLY_K));
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_INFORM);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){

            public void action() {
                AchieveREInitiator.this.handleAllResponses((Vector)this.getDataStore().get(AchieveREInitiator.this.ALL_RESPONSES_KEY));
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_ALL_RESPONSES);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){

            public void action() {
                AchieveREInitiator.this.handleAllResultNotifications((Vector)this.getDataStore().get(AchieveREInitiator.this.ALL_RESULT_NOTIFICATIONS_KEY));
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerLastState(oneShotBehaviour, HANDLE_ALL_RESULT_NOTIFICATIONS);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){

            public void action() {
            }

            public int onEnd() {
                return AchieveREInitiator.this.sessions.size();
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, CHECK_AGAIN);
    }

    protected Vector prepareInitiations(ACLMessage aCLMessage) {
        return this.prepareRequests(aCLMessage);
    }

    protected void sendInitiations(Vector vector) {
        long l = System.currentTimeMillis();
        long l2 = -1L;
        long l3 = -1L;
        String string = this.createConvId(vector);
        this.replyTemplate = MessageTemplate.MatchConversationId(string);
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            long l4;
            Comparable<Date> comparable;
            ACLMessage aCLMessage = (ACLMessage)enumeration.nextElement();
            if (aCLMessage == null) continue;
            ACLMessage aCLMessage2 = (ACLMessage)aCLMessage.clone();
            aCLMessage2.setConversationId(string);
            Iterator iterator = aCLMessage.getAllReceiver();
            while (iterator.hasNext()) {
                aCLMessage2.clearAllReceiver();
                comparable = (AID)iterator.next();
                aCLMessage2.addReceiver((AID)comparable);
                String string2 = "R" + this.hashCode() + "_" + Integer.toString(n);
                aCLMessage2.setReplyWith(string2);
                this.sessions.put(string2, new Session());
                this.adjustReplyTemplate(aCLMessage2);
                this.myAgent.send(aCLMessage2);
                ++n;
            }
            comparable = aCLMessage.getReplyByDate();
            if (comparable == null || (l4 = ((Date)comparable).getTime() - l) <= 0L || l4 >= l2 && l2 > 0L) continue;
            l2 = l4;
            l3 = ((Date)comparable).getTime();
        }
        this.replyReceiver.setTemplate(this.replyTemplate);
        this.replyReceiver.setDeadline(l3);
    }

    protected boolean checkInSequence(ACLMessage aCLMessage) {
        int n;
        String string = aCLMessage.getInReplyTo();
        Session session = (Session)this.sessions.get(string);
        if (session != null && session.update(n = aCLMessage.getPerformative())) {
            switch (session.getState()) {
                case 1: 
                case 2: {
                    Vector vector = (Vector)this.getDataStore().get(this.ALL_RESPONSES_KEY);
                    vector.addElement(aCLMessage);
                    break;
                }
                case 3: {
                    Vector vector = (Vector)this.getDataStore().get(this.ALL_RESULT_NOTIFICATIONS_KEY);
                    vector.addElement(aCLMessage);
                    break;
                }
                default: {
                    return false;
                }
            }
            if (session.isCompleted()) {
                this.sessions.remove(string);
            }
            return true;
        }
        return false;
    }

    protected int checkSessions(ACLMessage aCLMessage) {
        Object object;
        Object object2;
        int n = -1;
        if (this.getLastExitValue() == -1001 && !this.allResponsesReceived) {
            Iterator iterator;
            object2 = new ArrayList(this.sessions.size());
            object = this.sessions.keySet().iterator();
            while (object.hasNext()) {
                iterator = object.next();
                Session session = (Session)this.sessions.get(iterator);
                if (session.getState() != 0) continue;
                object2.add(iterator);
            }
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                this.sessions.remove(iterator.next());
            }
            object2 = null;
        } else if (aCLMessage == null) {
            this.sessions.clear();
        }
        if (!this.allResponsesReceived) {
            this.allResponsesReceived = true;
            object2 = this.sessions.values().iterator();
            while (object2.hasNext()) {
                object = (Session)object2.next();
                if (((Session)object).getState() != 0) continue;
                this.allResponsesReceived = false;
                break;
            }
            if (this.allResponsesReceived) {
                this.replyReceiver.setDeadline(-1L);
                n = 1;
            }
        } else if (this.sessions.size() == 0) {
            n = 2;
        }
        return n;
    }

    protected String[] getToBeReset() {
        if (this.toBeReset == null) {
            this.toBeReset = new String[]{HANDLE_AGREE, HANDLE_REFUSE, "Handle-not-understood", HANDLE_INFORM, "Handle-failure", "Handle-out-of-seq"};
        }
        return this.toBeReset;
    }

    protected Vector prepareRequests(ACLMessage aCLMessage) {
        Vector<ACLMessage> vector = new Vector<ACLMessage>(1);
        vector.addElement(aCLMessage);
        return vector;
    }

    protected void handleAgree(ACLMessage aCLMessage) {
    }

    protected void handleRefuse(ACLMessage aCLMessage) {
    }

    protected void handleInform(ACLMessage aCLMessage) {
    }

    protected void handleAllResponses(Vector vector) {
    }

    protected void handleAllResultNotifications(Vector vector) {
    }

    public void registerPrepareRequests(Behaviour behaviour) {
        this.registerPrepareInitiations(behaviour);
    }

    public void registerHandleAgree(Behaviour behaviour) {
        this.registerState(behaviour, HANDLE_AGREE);
        behaviour.setDataStore(this.getDataStore());
    }

    public void registerHandleInform(Behaviour behaviour) {
        this.registerState(behaviour, HANDLE_INFORM);
        behaviour.setDataStore(this.getDataStore());
    }

    public void registerHandleRefuse(Behaviour behaviour) {
        this.registerState(behaviour, HANDLE_REFUSE);
        behaviour.setDataStore(this.getDataStore());
    }

    public void registerHandleAllResponses(Behaviour behaviour) {
        this.registerState(behaviour, HANDLE_ALL_RESPONSES);
        behaviour.setDataStore(this.getDataStore());
    }

    public void registerHandleAllResultNotifications(Behaviour behaviour) {
        this.registerLastState(behaviour, HANDLE_ALL_RESULT_NOTIFICATIONS);
        behaviour.setDataStore(this.getDataStore());
    }

    public void reset(ACLMessage aCLMessage) {
        super.reset(aCLMessage);
        this.allResponsesReceived = false;
    }

    public void reset() {
        this.reset(null);
    }

    protected void initializeDataStore(ACLMessage aCLMessage) {
        super.initializeDataStore(aCLMessage);
        Vector vector = new Vector();
        this.getDataStore().put(this.ALL_RESPONSES_KEY, vector);
        vector = new Vector();
        this.getDataStore().put(this.ALL_RESULT_NOTIFICATIONS_KEY, vector);
    }

    private static class Session
    implements Serializable {
        static final int INIT = 0;
        static final int POSITIVE_RESPONSE_RECEIVED = 1;
        static final int NEGATIVE_RESPONSE_RECEIVED = 2;
        static final int RESULT_NOTIFICATION_RECEIVED = 3;
        private int state = 0;

        private Session() {
        }

        boolean update(int n) {
            switch (this.state) {
                case 0: {
                    switch (n) {
                        case 1: {
                            this.state = 1;
                            return true;
                        }
                        case 10: 
                        case 14: {
                            this.state = 2;
                            return true;
                        }
                        case 6: 
                        case 7: {
                            this.state = 3;
                            return true;
                        }
                    }
                    return false;
                }
                case 1: {
                    switch (n) {
                        case 6: 
                        case 7: {
                            this.state = 3;
                            return true;
                        }
                    }
                    return false;
                }
            }
            return false;
        }

        int getState() {
            return this.state;
        }

        boolean isCompleted() {
            return this.state == 2 || this.state == 3;
        }
    }
}

