/*
 * Decompiled with CFR 0.152.
 */
package jade.mtp.http;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.ReceivedObject;
import jade.mtp.MTPException;
import jade.mtp.http.BasicFipaDateTime;
import jade.util.Logger;
import jade.util.leap.Iterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import starlight.util.Base64;

public class XMLCodec
extends DefaultHandler {
    public static final String PREAMBUL = "<?xml version=\"1.0\"?>\n";
    public static final String ENVELOPE_TAG = "envelope";
    public static final String PARAMS_TAG = "params";
    public static final String INDEX = "index";
    public static final String INDEX_ATTR = " index=\"";
    public static final String TO_TAG = "to";
    public static final String AID_TAG = "agent-identifier";
    public static final String AID_NAME = "name";
    public static final String AID_ADDRESSES = "addresses";
    public static final String AID_ADDRESS = "url";
    public static final String FROM_TAG = "from";
    public static final String COMMENTS_TAG = "comments";
    public static final String REPRESENTATION_TAG = "acl-representation";
    public static final String LENGTH_TAG = "payload-length";
    public static final String ENCODING_TAG = "payload-encoding";
    public static final String DATE_TAG = "date";
    public static final String INTENDED_TAG = "intended-receiver";
    public static final String RECEIVED_TAG = "received";
    public static final String RECEIVED_DATE = "received-date";
    public static final String RECEIVED_BY = "received-by";
    public static final String RECEIVED_FROM = "received-from";
    public static final String RECEIVED_ID = "received-id";
    public static final String RECEIVED_VIA = "received-via";
    public static final String RECEIVED_ATTR = "value";
    public static final String PROP_TAG = "user-defined";
    public static final String PROP_ATTR = "href";
    public static final String PROP_ATTR_TYPE = "type";
    public static final String PROP_STRING_TYPE = "string";
    public static final String PROP_BYTE_TYPE = "byte-array";
    public static final String PROP_SER_TYPE = "serialized";
    public static final String OT = "<";
    public static final String ET = "</";
    public static final String CT = ">";
    public static final String NULL = "";
    private XMLReader parser = null;
    private Envelope env;
    private ReceivedObject ro = null;
    private AID aid = null;
    private Property prop = null;
    private StringBuffer accumulator;
    private String propType;
    private static Logger logger = Logger.getMyLogger((class$jade$mtp$http$XMLCodec == null ? (class$jade$mtp$http$XMLCodec = XMLCodec.class$("jade.mtp.http.XMLCodec")) : class$jade$mtp$http$XMLCodec).getName());
    static /* synthetic */ Class class$jade$mtp$http$XMLCodec;

    public XMLCodec(String string) throws MTPException {
        try {
            this.parser = (XMLReader)Class.forName(string).newInstance();
            this.parser.setContentHandler(this);
            this.parser.setErrorHandler(this);
        }
        catch (Exception exception) {
            throw new MTPException(exception.toString());
        }
    }

    private static void encodeAid(StringBuffer stringBuffer, AID aID) {
        stringBuffer.append(OT).append(AID_TAG).append(CT);
        XMLCodec.encodeTag(stringBuffer, AID_NAME, aID.getName());
        stringBuffer.append(OT).append(AID_ADDRESSES).append(CT);
        String[] stringArray = aID.getAddressesArray();
        int n = 0;
        while (n < stringArray.length) {
            XMLCodec.encodeTag(stringBuffer, AID_ADDRESS, stringArray[n]);
            ++n;
        }
        stringBuffer.append(ET).append(AID_ADDRESSES).append(CT);
        stringBuffer.append(ET).append(AID_TAG).append(CT);
    }

    private static void encodeTag(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(OT).append(string).append(CT);
        stringBuffer.append(string2);
        stringBuffer.append(ET).append(string).append(CT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void encodeProp(StringBuffer stringBuffer, Property property) {
        String string = null;
        Object object = property.getValue();
        String string2 = PROP_STRING_TYPE;
        if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof byte[]) {
            string2 = PROP_BYTE_TYPE;
            string = new String(Base64.encode((byte[])object));
        } else {
            if (!(object instanceof Serializable)) return;
            string2 = PROP_SER_TYPE;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                if (byArray != null) {
                    string = new String(Base64.encode(byArray));
                }
            }
            catch (IOException iOException) {
                return;
            }
        }
        stringBuffer.append(OT).append(PROP_TAG).append(" ");
        stringBuffer.append(PROP_ATTR).append("=\"").append(property.getName()).append("\" ");
        stringBuffer.append(PROP_ATTR_TYPE).append("=\"").append(string2).append("\"");
        stringBuffer.append(CT);
        stringBuffer.append(string);
        stringBuffer.append(ET).append(PROP_TAG).append(CT);
    }

    private void decodeProp(StringBuffer stringBuffer, Property property) {
        if (this.propType.equals(PROP_SER_TYPE)) {
            try {
                char[] cArray = stringBuffer.toString().toCharArray();
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(Base64.decode(cArray)));
                property.setValue((Serializable)objectInputStream.readObject());
            }
            catch (Exception exception) {}
        } else if (this.propType.equals(PROP_BYTE_TYPE)) {
            char[] cArray = stringBuffer.toString().toCharArray();
            property.setValue(Base64.decode(cArray));
        } else {
            property.setValue(stringBuffer.toString());
        }
        this.propType = null;
    }

    private static void encodeOneLineTag(StringBuffer stringBuffer, String string, String string2, String string3) {
        stringBuffer.append(OT).append(string).append(" ");
        stringBuffer.append(string2).append("=\"").append(string3).append("\"/>");
    }

    public static synchronized String encodeXML(Envelope envelope) {
        BasicFipaDateTime basicFipaDateTime;
        StringBuffer stringBuffer = new StringBuffer(PREAMBUL);
        stringBuffer.append(OT).append(ENVELOPE_TAG).append(CT);
        stringBuffer.append(OT).append(PARAMS_TAG).append(INDEX_ATTR).append(1).append("\"").append(CT);
        Iterator iterator = envelope.getAllTo();
        while (iterator.hasNext()) {
            stringBuffer.append(OT).append(TO_TAG).append(CT);
            XMLCodec.encodeAid(stringBuffer, (AID)iterator.next());
            stringBuffer.append(ET).append(TO_TAG).append(CT);
        }
        if (envelope.getFrom() != null) {
            stringBuffer.append(OT).append(FROM_TAG).append(CT);
            XMLCodec.encodeAid(stringBuffer, envelope.getFrom());
            stringBuffer.append(ET).append(FROM_TAG).append(CT);
        }
        if (envelope.getComments() != null && envelope.getComments().length() > 0) {
            XMLCodec.encodeTag(stringBuffer, COMMENTS_TAG, envelope.getComments());
        }
        if (envelope.getAclRepresentation() != null) {
            XMLCodec.encodeTag(stringBuffer, REPRESENTATION_TAG, envelope.getAclRepresentation());
        }
        if (envelope.getPayloadLength() != null) {
            XMLCodec.encodeTag(stringBuffer, LENGTH_TAG, String.valueOf(envelope.getPayloadLength()));
        }
        if (envelope.getPayloadEncoding() != null && envelope.getPayloadEncoding().length() > 0) {
            XMLCodec.encodeTag(stringBuffer, ENCODING_TAG, envelope.getPayloadEncoding());
        }
        if ((basicFipaDateTime = new BasicFipaDateTime(envelope.getDate())) != null) {
            XMLCodec.encodeTag(stringBuffer, DATE_TAG, basicFipaDateTime.toString());
        }
        iterator = envelope.getAllIntendedReceiver();
        while (iterator.hasNext()) {
            stringBuffer.append(OT).append(INTENDED_TAG).append(CT);
            XMLCodec.encodeAid(stringBuffer, (AID)iterator.next());
            stringBuffer.append(ET).append(INTENDED_TAG).append(CT);
        }
        iterator = envelope.getAllProperties();
        while (iterator.hasNext()) {
            XMLCodec.encodeProp(stringBuffer, (Property)iterator.next());
        }
        ReceivedObject receivedObject = envelope.getReceived();
        if (receivedObject != null) {
            stringBuffer.append(OT).append(RECEIVED_TAG).append(CT);
            String string = new BasicFipaDateTime(receivedObject.getDate()).toString();
            if (string != null) {
                XMLCodec.encodeOneLineTag(stringBuffer, RECEIVED_DATE, RECEIVED_ATTR, string);
            }
            if ((string = receivedObject.getBy()) != null && !string.equals(NULL)) {
                XMLCodec.encodeOneLineTag(stringBuffer, RECEIVED_BY, RECEIVED_ATTR, string);
            }
            if ((string = receivedObject.getFrom()) != null && !string.equals(NULL)) {
                XMLCodec.encodeOneLineTag(stringBuffer, RECEIVED_FROM, RECEIVED_ATTR, string);
            }
            if ((string = receivedObject.getId()) != null && !string.equals(NULL)) {
                XMLCodec.encodeOneLineTag(stringBuffer, RECEIVED_ID, RECEIVED_ATTR, string);
            }
            if ((string = receivedObject.getVia()) != null && !string.equals(NULL)) {
                XMLCodec.encodeOneLineTag(stringBuffer, RECEIVED_VIA, RECEIVED_ATTR, string);
            }
            stringBuffer.append(ET).append(RECEIVED_TAG).append(CT);
        }
        stringBuffer.append(ET).append(PARAMS_TAG).append(CT);
        stringBuffer.append(ET).append(ENVELOPE_TAG).append(CT);
        return stringBuffer.toString();
    }

    public void startDocument() {
        this.env = new Envelope();
    }

    public void endDocument() {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        this.accumulator = new StringBuffer();
        if (TO_TAG.equalsIgnoreCase(string2)) {
            this.aid = new AID();
            this.env.addTo(this.aid);
        } else if (FROM_TAG.equalsIgnoreCase(string2)) {
            this.aid = new AID();
            this.env.setFrom(this.aid);
        } else if (INTENDED_TAG.equalsIgnoreCase(string2)) {
            this.aid = new AID();
            this.env.addIntendedReceiver(this.aid);
        } else if (RECEIVED_TAG.equalsIgnoreCase(string2)) {
            this.ro = new ReceivedObject();
            this.env.addStamp(this.ro);
        } else if (RECEIVED_BY.equalsIgnoreCase(string2)) {
            this.ro.setBy(attributes.getValue(RECEIVED_ATTR));
        } else if (RECEIVED_FROM.equalsIgnoreCase(string2)) {
            this.ro.setFrom(attributes.getValue(RECEIVED_ATTR));
        } else if (RECEIVED_DATE.equalsIgnoreCase(string2)) {
            this.ro.setDate(new BasicFipaDateTime(attributes.getValue(RECEIVED_ATTR)).getTime());
        } else if (RECEIVED_ID.equalsIgnoreCase(string2)) {
            this.ro.setId(attributes.getValue(RECEIVED_ATTR));
        } else if (RECEIVED_VIA.equalsIgnoreCase(string2)) {
            this.ro.setVia(attributes.getValue(RECEIVED_ATTR));
        } else if (PROP_TAG.equalsIgnoreCase(string2)) {
            this.prop = new Property();
            this.env.addProperties(this.prop);
            this.prop.setName(attributes.getValue(PROP_ATTR));
            this.propType = attributes.getValue(PROP_ATTR_TYPE);
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (AID_NAME.equalsIgnoreCase(string2)) {
            this.aid.setName(this.accumulator.toString());
        } else if (AID_ADDRESS.equalsIgnoreCase(string2)) {
            this.aid.addAddresses(this.accumulator.toString());
        } else if (COMMENTS_TAG.equalsIgnoreCase(string2)) {
            this.env.setComments(this.accumulator.toString());
        } else if (REPRESENTATION_TAG.equalsIgnoreCase(string2)) {
            this.env.setAclRepresentation(this.accumulator.toString());
        } else if (LENGTH_TAG.equalsIgnoreCase(string2)) {
            this.env.setPayloadLength(new Long(this.accumulator.toString()));
            if (logger.isLoggable(Logger.WARNING)) {
                logger.log(Logger.FINE, "Length: " + this.env.getPayloadLength());
            }
        } else if (ENCODING_TAG.equalsIgnoreCase(string2)) {
            this.env.setPayloadEncoding(this.accumulator.toString());
        } else if (DATE_TAG.equalsIgnoreCase(string2)) {
            this.env.setDate(new BasicFipaDateTime(this.accumulator.toString()).getTime());
        } else if (PROP_TAG.equalsIgnoreCase(string2)) {
            this.decodeProp(this.accumulator, this.prop);
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        this.accumulator.append(cArray, n, n2);
    }

    public void warning(SAXParseException sAXParseException) {
        if (logger.isLoggable(Logger.WARNING)) {
            logger.log(Logger.WARNING, " line " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage());
        }
    }

    public void error(SAXParseException sAXParseException) {
        if (logger.isLoggable(Logger.WARNING)) {
            logger.log(Logger.WARNING, "ERROR: line " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage());
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (logger.isLoggable(Logger.WARNING)) {
            logger.log(Logger.SEVERE, "FATAL: line " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage());
        }
        throw sAXParseException;
    }

    public Envelope parse(Reader reader) throws MTPException {
        try {
            this.parser.parse(new InputSource(reader));
            return this.env;
        }
        catch (Exception exception) {
            throw new MTPException(exception.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

