/*
 * Decompiled with CFR 0.152.
 */
package jade.mtp.http;

import jade.mtp.http.HTTPAddress;
import jade.util.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Vector;

public class KeepAlive {
    private static Logger logger = Logger.getMyLogger((class$jade$mtp$http$KeepAlive == null ? (class$jade$mtp$http$KeepAlive = KeepAlive.class$("jade.mtp.http.KeepAlive")) : class$jade$mtp$http$KeepAlive).getName());
    private Vector connections;
    private int dim;
    static /* synthetic */ Class class$jade$mtp$http$KeepAlive;

    public KeepAlive(int n) {
        this.connections = new Vector(n);
        this.dim = n;
    }

    public void add(KAConnection kAConnection) {
        block3: {
            try {
                if (this.connections.size() == this.dim) {
                    this.remove(0);
                }
                this.connections.addElement(kAConnection);
            }
            catch (Exception exception) {
                if (!logger.isLoggable(Logger.WARNING)) break block3;
                logger.log(Logger.WARNING, exception.getMessage());
            }
        }
    }

    private void remove(int n) {
        block2: {
            try {
                KAConnection kAConnection = this.getConnection(n);
                this.connections.removeElementAt(n);
                kAConnection.close();
            }
            catch (Exception exception) {
                if (!logger.isLoggable(Logger.WARNING)) break block2;
                logger.log(Logger.WARNING, exception.getMessage());
            }
        }
    }

    public void remove(HTTPAddress hTTPAddress) {
        this.connections.removeElement(this.search(hTTPAddress));
    }

    public void remove(KAConnection kAConnection) {
        this.connections.removeElement(kAConnection);
    }

    private KAConnection getConnection(int n) {
        return (KAConnection)this.connections.elementAt(n);
    }

    private KAConnection search(HTTPAddress hTTPAddress) {
        if (hTTPAddress != null) {
            int n = this.connections.size() - 1;
            while (n >= 0) {
                KAConnection kAConnection = this.getConnection(n);
                if (kAConnection.equals(hTTPAddress)) {
                    return kAConnection;
                }
                --n;
            }
        }
        return null;
    }

    public KAConnection getConnection(HTTPAddress hTTPAddress) {
        return this.search(hTTPAddress);
    }

    public int getDim() {
        return this.dim;
    }

    public int capacity() {
        return this.dim - this.connections.size();
    }

    public synchronized void swap(KAConnection kAConnection) {
        block3: {
            try {
                if (this.dim > 1 && this.connections.indexOf(kAConnection) != this.connections.size() - 1) {
                    this.connections.removeElement(kAConnection);
                    this.connections.addElement(kAConnection);
                }
            }
            catch (Exception exception) {
                if (!logger.isLoggable(Logger.WARNING)) break block3;
                logger.log(Logger.WARNING, exception.getMessage());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class KAConnection {
        private Socket socket;
        private OutputStream out;
        private InputStream in;
        private HTTPAddress address;
        private Vector connections;

        KAConnection(Socket socket, HTTPAddress hTTPAddress) throws IOException {
            this.socket = socket;
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
            this.in = new BufferedInputStream(this.socket.getInputStream());
            this.address = hTTPAddress;
        }

        OutputStream getOut() {
            return this.out;
        }

        InputStream getIn() {
            return this.in;
        }

        public HTTPAddress getAddress() {
            return this.address;
        }

        public boolean equals(HTTPAddress hTTPAddress) {
            return this.address.equals(hTTPAddress);
        }

        void close() {
            block2: {
                try {
                    this.in.close();
                    this.out.close();
                }
                catch (IOException iOException) {
                    if (!logger.isLoggable(Logger.WARNING)) break block2;
                    logger.log(Logger.WARNING, "Exception while closing KA connection: " + iOException);
                }
            }
        }
    }
}

