/*
 * Decompiled with CFR 0.152.
 */
package jade.mtp.http;

import jade.core.Profile;
import jade.mtp.MTPException;
import jade.mtp.http.HTTPAddress;
import jade.mtp.http.https.HTTPSKeyManager;
import jade.mtp.http.https.HTTPSTrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManager;

public class HTTPSocketFactory {
    private static HTTPSocketFactory _instance;
    private static final String PREFIX = "jade_mtp_http_https_";
    private SocketFactory _socketFactory;
    private ServerSocketFactory _serverSocketFactory;
    private boolean _needClientAuth = false;
    private boolean _usingHttps = false;

    public static HTTPSocketFactory getInstance() {
        if (_instance == null) {
            _instance = new HTTPSocketFactory();
        }
        return _instance;
    }

    public void configure(Profile profile, HTTPAddress hTTPAddress) throws Exception {
        if (hTTPAddress.getProto().equals("https")) {
            this._usingHttps = true;
            try {
                String string = profile.getParameter("jade_mtp_http_https_trustManagerClass", "jade.mtp.http.https.NoAuthentication");
                String string2 = profile.getParameter("jade_mtp_http_https_keyManagerClass", "jade.mtp.http.https.KeyStoreKeyManager");
                HTTPSTrustManager hTTPSTrustManager = (HTTPSTrustManager)Class.forName(string).newInstance();
                hTTPSTrustManager.init(profile);
                HTTPSKeyManager hTTPSKeyManager = (HTTPSKeyManager)Class.forName(string2).newInstance();
                hTTPSKeyManager.init(profile);
                if (profile.getParameter("jade_mtp_http_https_needClientAuth", "no").equals("yes")) {
                    this._needClientAuth = true;
                }
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(new KeyManager[]{hTTPSKeyManager}, new TrustManager[]{hTTPSTrustManager}, null);
                this._socketFactory = sSLContext.getSocketFactory();
                this._serverSocketFactory = sSLContext.getServerSocketFactory();
            }
            catch (Exception exception) {
                throw new MTPException("Error initializing secure conection", exception);
            }
        } else {
            this._socketFactory = SocketFactory.getDefault();
            this._serverSocketFactory = ServerSocketFactory.getDefault();
        }
    }

    public Socket createSocket(String string, int n) throws IOException {
        return this._socketFactory.createSocket(string, n);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        return this._socketFactory.createSocket(string, n, inetAddress, n2);
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        ServerSocket serverSocket = this._serverSocketFactory.createServerSocket(n);
        if (this._usingHttps) {
            ((SSLServerSocket)serverSocket).setNeedClientAuth(this._needClientAuth);
        }
        return serverSocket;
    }

    private HTTPSocketFactory() {
    }
}

