/*
 * Decompiled with CFR 0.152.
 */
package jade.gui;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.domain.FIPAAgentManagement.ReceivedObject;
import jade.gui.AIDGui;
import jade.gui.TimeChooser;
import jade.gui.VisualAIDList;
import jade.gui.VisualPropertiesList;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ACLParser;
import jade.lang.acl.ISO8601;
import jade.lang.acl.ParseException;
import jade.tools.sl.SLFormatter;
import jade.util.Logger;
import jade.util.leap.Serializable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;

public class AclGui
extends JPanel {
    static String ADD_NEW_RECEIVER = "Insert receiver";
    private Component ownerGui;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());
    AID SenderAID = new AID();
    AID newAIDSender = null;
    AID fromAID = new AID();
    AID newAIDFrom = null;
    VisualAIDList receiverListPanel;
    VisualAIDList replyToListPanel;
    VisualPropertiesList propertiesListPanel;
    private boolean guiEnabledFlag = true;
    private JTextField sender;
    private boolean senderEnabledFlag;
    private JComboBox communicativeAct;
    private JTextArea content;
    private JTextField language;
    private JTextField ontology;
    private JComboBox protocol;
    private JTextField conversationId;
    private JTextField inReplyTo;
    private JTextField replyWith;
    private JTextField replyBy;
    private JTextField encoding;
    private JButton replyBySet;
    private Date replyByDate;
    private Date dateDate;
    private Date dateRecDate;
    GridBagLayout lm = new GridBagLayout();
    GridBagConstraints constraint = new GridBagConstraints();
    private int leftBorder;
    private int rightBorder;
    private int topBorder;
    private int bottomBorder;
    private int xSpacing;
    private int ySpacing;
    private int gridNCol;
    private int gridNRow;
    private int[] colWidth;
    private static final int TEXT_SIZE = 30;
    private Vector fipaActVector;
    private static int N_FIPA_PROTOCOLS = 8;
    private static String[] fipaProtocols = new String[]{"fipa-auction-english", "fipa-auction-dutch", "fipa-contract-net", "fipa-iterated-contract-net", "fipa-query", "fipa-request", "fipa-request-when", "fipa-propose"};
    private ArrayList fipaProtocolArrayList;
    private int lastSelectedIndex;
    private String lastSelectedItem;
    private static final String LABEL_TO_ADD_PROT = "ADD USER-DEF PROTOCOL";
    private JPanel aclPanel;
    private Dimension minDim = new Dimension();
    private boolean firstPaintFlag = true;
    private static ACLMessage editedMsg;
    private JButton senderButton;
    private VisualAIDList toPanel;
    private JTextField from;
    private JTextArea comments;
    private JTextField representation;
    private JTextField payloadLength;
    private JTextField payloadEncoding;
    private JTextField date;
    private VisualAIDList intendedReceiverPanel;
    private JButton defaultEnvelopeButton;
    private JButton fromButton;
    private JButton dateButton;
    private JButton dateRecButton;
    private JTextField by;
    private JTextField fromRec;
    private JTextField dateRec;
    private JTextField via;
    private JTextField id;
    SLFormatter slFormatter;

    public AclGui(Component component) {
        this.ownerGui = component;
        JTabbedPane jTabbedPane = new JTabbedPane();
        AclMessagePanel aclMessagePanel = new AclMessagePanel();
        EnvelopePanel envelopePanel = new EnvelopePanel();
        jTabbedPane.addTab("ACLMessage", aclMessagePanel);
        jTabbedPane.addTab("Envelope", envelopePanel);
        this.updateEnabled();
        this.add(jTabbedPane);
        try {
            this.slFormatter = new SLFormatter();
        }
        catch (Exception exception) {}
    }

    private void formatGrid(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.gridNRow = n;
        this.gridNCol = n2;
        this.colWidth = new int[3];
        this.leftBorder = n3;
        this.rightBorder = n4;
        this.topBorder = n5;
        this.bottomBorder = n6;
        this.xSpacing = n7;
        this.ySpacing = n8;
    }

    private void setGridColumnWidth(int n, int n2) {
        this.colWidth[n] = n2;
    }

    private void put(JPanel jPanel, JComponent jComponent, int n, int n2, int n3, int n4, boolean bl) {
        this.constraint.gridx = n;
        this.constraint.gridy = n2;
        this.constraint.gridwidth = n3;
        this.constraint.gridheight = n4;
        this.constraint.anchor = 17;
        this.constraint.fill = bl ? 1 : 3;
        int n5 = n == 0 ? this.leftBorder : 0;
        int n6 = n + n3 == this.gridNCol ? this.rightBorder : this.xSpacing;
        int n7 = n2 == 0 ? this.topBorder : 0;
        int n8 = n2 + n4 == this.gridNRow ? this.bottomBorder : this.ySpacing;
        int n9 = 0;
        int n10 = 0;
        while (n10 < n3) {
            n9 += this.colWidth[n + n10] + this.xSpacing;
            ++n10;
        }
        int n11 = jComponent.getPreferredSize().height;
        jComponent.setPreferredSize(new Dimension(n9 -= this.xSpacing, n11));
        this.constraint.insets = new Insets(n7, n5, n8, n6);
        this.lm.setConstraints(jComponent, this.constraint);
        jPanel.add(jComponent);
    }

    private void updateEnabled() {
        this.communicativeAct.setEnabled(this.guiEnabledFlag);
        this.senderButton.setText(this.guiEnabledFlag && this.senderEnabledFlag ? "Set" : "View");
        this.receiverListPanel.setEnabled(this.guiEnabledFlag);
        this.replyToListPanel.setEnabled(this.guiEnabledFlag);
        this.propertiesListPanel.setEnabled(this.guiEnabledFlag);
        this.replyWith.setEditable(this.guiEnabledFlag);
        this.inReplyTo.setEditable(this.guiEnabledFlag);
        this.conversationId.setEditable(this.guiEnabledFlag);
        this.replyBy.setEditable(false);
        this.replyBySet.setEnabled(true);
        this.replyBySet.setText(this.guiEnabledFlag ? "Set" : "View");
        this.encoding.setEditable(this.guiEnabledFlag);
        this.protocol.setEnabled(this.guiEnabledFlag);
        this.language.setEditable(this.guiEnabledFlag);
        this.ontology.setEditable(this.guiEnabledFlag);
        this.content.setEditable(this.guiEnabledFlag);
        this.fromButton.setText(this.guiEnabledFlag && this.senderEnabledFlag ? "Set" : "View");
        this.toPanel.setEnabled(this.guiEnabledFlag);
        this.comments.setEnabled(this.guiEnabledFlag);
        this.representation.setEnabled(this.guiEnabledFlag);
        this.payloadLength.setEnabled(this.guiEnabledFlag);
        this.payloadEncoding.setEnabled(this.guiEnabledFlag);
        this.date.setEditable(false);
        this.dateButton.setText(this.guiEnabledFlag ? "Set" : "View");
        this.intendedReceiverPanel.setEnabled(this.guiEnabledFlag);
        this.defaultEnvelopeButton.setVisible(this.guiEnabledFlag);
        this.by.setEditable(this.guiEnabledFlag);
        this.fromRec.setEditable(this.guiEnabledFlag);
        this.dateRec.setEditable(false);
        this.dateRecButton.setText(this.guiEnabledFlag ? "Set" : "View");
        this.id.setEditable(this.guiEnabledFlag);
        this.via.setEditable(this.guiEnabledFlag);
    }

    private void showEnvelope(Envelope envelope) {
        Serializable serializable;
        String string;
        try {
            this.fromAID = envelope.getFrom();
            string = this.fromAID.getName();
        }
        catch (NullPointerException nullPointerException) {
            string = "";
            this.fromAID = new AID();
        }
        this.from.setText(string);
        this.toPanel.resetContent(envelope.getAllTo());
        try {
            serializable = envelope.getFrom();
            string = ((AID)serializable).getName();
        }
        catch (NullPointerException nullPointerException) {
            string = "";
        }
        this.from.setText(string);
        try {
            string = envelope.getComments();
        }
        catch (NullPointerException nullPointerException) {
            string = "";
        }
        this.comments.setText(string);
        try {
            string = envelope.getAclRepresentation();
        }
        catch (NullPointerException nullPointerException) {
            string = "";
        }
        this.representation.setText(string);
        try {
            string = envelope.getPayloadLength().toString();
        }
        catch (NullPointerException nullPointerException) {
            string = "-1";
        }
        this.payloadLength.setText(string);
        try {
            string = envelope.getPayloadEncoding();
        }
        catch (NullPointerException nullPointerException) {
            string = "";
        }
        this.payloadEncoding.setText(string);
        this.dateDate = envelope.getDate();
        if (this.dateDate != null) {
            this.date.setText(ISO8601.toString(this.dateDate));
        } else {
            this.date.setText("");
        }
        this.intendedReceiverPanel.resetContent(envelope.getAllIntendedReceiver());
        serializable = envelope.getReceived();
        try {
            string = ((ReceivedObject)serializable).getBy();
        }
        catch (NullPointerException nullPointerException) {
            string = "";
        }
        this.by.setText(string);
        try {
            string = ((ReceivedObject)serializable).getFrom();
        }
        catch (NullPointerException nullPointerException) {
            string = "";
        }
        this.fromRec.setText(string);
        try {
            this.dateRecDate = ((ReceivedObject)serializable).getDate();
            string = ISO8601.toString(this.dateRecDate);
        }
        catch (NullPointerException nullPointerException) {
            string = "";
        }
        this.dateRec.setText(string);
        try {
            string = ((ReceivedObject)serializable).getId();
        }
        catch (NullPointerException nullPointerException) {
            string = "";
        }
        this.id.setText(string);
        try {
            string = ((ReceivedObject)serializable).getVia();
        }
        catch (NullPointerException nullPointerException) {
            string = "";
        }
        this.via.setText(string);
    }

    public void setMsg(ACLMessage aCLMessage) {
        String string;
        int n = aCLMessage.getPerformative();
        String string2 = ACLMessage.getPerformative(n).toLowerCase();
        this.communicativeAct.setSelectedItem(string2);
        try {
            this.SenderAID = aCLMessage.getSender();
            string = this.SenderAID.getName();
        }
        catch (NullPointerException nullPointerException) {
            string = "";
            this.SenderAID = new AID();
        }
        this.sender.setText(string);
        this.receiverListPanel.resetContent(aCLMessage.getAllReceiver());
        this.replyToListPanel.resetContent(aCLMessage.getAllReplyTo());
        Enumeration<?> enumeration = aCLMessage.getAllUserDefinedParameters().propertyNames();
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        this.propertiesListPanel.resetContent(arrayList.iterator());
        this.propertiesListPanel.setContentProperties(aCLMessage.getAllUserDefinedParameters());
        string = aCLMessage.getReplyWith();
        if (string == null) {
            string = "";
        }
        this.replyWith.setText(string);
        string = aCLMessage.getInReplyTo();
        if (string == null) {
            string = "";
        }
        this.inReplyTo.setText(string);
        string = aCLMessage.getConversationId();
        if (string == null) {
            string = "";
        }
        this.conversationId.setText(string);
        try {
            string = ISO8601.toString(aCLMessage.getReplyByDate());
        }
        catch (Exception exception) {
            string = "";
        }
        this.replyBy.setText(string);
        string = aCLMessage.getProtocol();
        if (string == null) {
            this.protocol.setSelectedItem("Null");
        } else if (string.equals("") || string.equalsIgnoreCase("Null")) {
            this.protocol.setSelectedItem("Null");
        } else {
            string2 = string.toLowerCase();
            int n2 = this.fipaProtocolArrayList.indexOf(string2);
            if (n2 < 0) {
                this.protocol.addItem(string);
                int n3 = this.protocol.getItemCount();
                this.protocol.setSelectedItem(string);
                int n4 = this.protocol.getSelectedIndex();
                if (n4 != n3 - 1) {
                    this.protocol.removeItemAt(n3 - 1);
                }
            } else {
                this.protocol.setSelectedIndex(n2);
            }
        }
        String string3 = aCLMessage.getLanguage();
        if (string3 == null) {
            string3 = "";
        }
        this.language.setText(string3);
        string = aCLMessage.getOntology();
        if (string == null) {
            string = "";
        }
        this.ontology.setText(string);
        string = aCLMessage.getContent();
        if (string == null) {
            string = "";
        }
        if ((string3.equalsIgnoreCase("fipa-sl0") || string3.equalsIgnoreCase("fipa-sl1") || string3.equalsIgnoreCase("fipa-sl2") || string3.equalsIgnoreCase("fipa-sl")) && this.slFormatter != null) {
            string = SLFormatter.format(string);
        }
        this.content.setText(string);
        string = aCLMessage.getEncoding();
        if (string == null) {
            string = "";
        }
        this.encoding.setText(string);
        Envelope envelope = aCLMessage.getEnvelope();
        if (envelope != null) {
            this.showEnvelope(envelope);
        }
    }

    public ACLMessage getMsg() {
        Object object;
        String string = (String)this.communicativeAct.getSelectedItem();
        int n = ACLMessage.getInteger(string);
        ACLMessage aCLMessage = new ACLMessage(n);
        if (this.newAIDSender != null) {
            this.SenderAID = this.newAIDSender;
        }
        if (this.SenderAID.getName().length() > 0) {
            aCLMessage.setSender(this.SenderAID);
        }
        Enumeration enumeration = this.receiverListPanel.getContent();
        while (enumeration.hasMoreElements()) {
            aCLMessage.addReceiver((AID)enumeration.nextElement());
        }
        Enumeration enumeration2 = this.replyToListPanel.getContent();
        while (enumeration2.hasMoreElements()) {
            aCLMessage.addReplyTo((AID)enumeration2.nextElement());
        }
        Properties properties = this.propertiesListPanel.getContentProperties();
        Enumeration<?> enumeration3 = properties.propertyNames();
        while (enumeration3.hasMoreElements()) {
            object = (String)enumeration3.nextElement();
            aCLMessage.addUserDefinedParameter((String)object, properties.getProperty((String)object));
        }
        string = this.replyWith.getText().trim();
        if (string.length() > 0) {
            aCLMessage.setReplyWith(string);
        }
        if ((string = this.inReplyTo.getText().trim()).length() > 0) {
            aCLMessage.setInReplyTo(string);
        }
        if ((string = this.conversationId.getText().trim()).length() > 0) {
            aCLMessage.setConversationId(string);
        }
        string = this.replyBy.getText().trim();
        try {
            aCLMessage.setReplyByDate(ISO8601.toDate(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = (String)this.protocol.getSelectedItem();
        if (!string.equals("Null")) {
            aCLMessage.setProtocol(string);
        }
        if ((string = this.language.getText().trim()).length() > 0) {
            aCLMessage.setLanguage(string);
        }
        if ((string = this.ontology.getText().trim()).length() > 0) {
            aCLMessage.setOntology(string);
        }
        if ((string = this.content.getText().trim()).length() > 0) {
            aCLMessage.setContent(string);
        }
        if ((string = this.encoding.getText().trim()).length() > 0) {
            aCLMessage.setEncoding(string);
        }
        object = new Envelope();
        Enumeration enumeration4 = this.toPanel.getContent();
        while (enumeration4.hasMoreElements()) {
            ((Envelope)object).addTo((AID)enumeration4.nextElement());
        }
        if (this.newAIDFrom != null) {
            this.fromAID = this.newAIDFrom;
        }
        if (this.fromAID.getName().length() > 0) {
            ((Envelope)object).setFrom(this.fromAID);
        }
        if ((string = this.comments.getText().trim()).length() > 0) {
            ((Envelope)object).setComments(string);
        }
        if ((string = this.representation.getText().trim()).length() > 0) {
            ((Envelope)object).setAclRepresentation(string);
        }
        try {
            string = this.payloadLength.getText().trim();
            ((Envelope)object).setPayloadLength(new Long(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = this.payloadEncoding.getText().trim();
        if (string.length() > 0) {
            ((Envelope)object).setPayloadEncoding(string);
        }
        if (this.dateDate != null) {
            ((Envelope)object).setDate(this.dateDate);
        }
        Enumeration enumeration5 = this.intendedReceiverPanel.getContent();
        while (enumeration5.hasMoreElements()) {
            ((Envelope)object).addIntendedReceiver((AID)enumeration5.nextElement());
        }
        string = this.language.getText().trim();
        if (string.length() > 0) {
            aCLMessage.setLanguage(string);
        }
        aCLMessage.setEnvelope((Envelope)object);
        return aCLMessage;
    }

    public void setEnabled(boolean bl) {
        this.guiEnabledFlag = bl;
        this.updateEnabled();
    }

    public void setSenderEnabled(boolean bl) {
        this.senderEnabledFlag = bl;
        this.updateEnabled();
    }

    public void paint(Graphics graphics) {
        if (this.firstPaintFlag) {
            this.firstPaintFlag = false;
            this.minDim = this.aclPanel.getSize();
        } else {
            this.aclPanel.setMinimumSize(this.minDim);
        }
        super.paint(graphics);
    }

    public static void showMsgInDialog(ACLMessage aCLMessage, Frame frame) {
        final JDialog jDialog = new JDialog(frame, "ACL Message", true);
        AclGui aclGui = new AclGui(frame);
        aclGui.setEnabled(false);
        aclGui.setMsg(aCLMessage);
        JButton jButton = new JButton("OK");
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add("Center", aclGui);
        jDialog.getContentPane().add("South", jPanel);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jDialog.pack();
        jDialog.setResizable(false);
        if (frame != null) {
            int n;
            int n2 = frame.getX() + (frame.getWidth() - jDialog.getWidth()) / 2;
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n = frame.getY() + (frame.getHeight() - jDialog.getHeight()) / 2) < 0) {
                n = 0;
            }
            jDialog.setLocation(n2, n);
        }
        jDialog.show();
    }

    public static ACLMessage editMsgInDialog(ACLMessage aCLMessage, Frame frame) {
        final JDialog jDialog = new JDialog(frame, "ACL Message", true);
        final AclGui aclGui = new AclGui(frame);
        aclGui.setBorder(new BevelBorder(0));
        aclGui.setSenderEnabled(true);
        aclGui.setMsg(aCLMessage);
        JButton jButton = new JButton("OK");
        JButton jButton2 = new JButton("Cancel");
        jButton.setPreferredSize(jButton2.getPreferredSize());
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add("Center", aclGui);
        jDialog.getContentPane().add("South", jPanel);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                editedMsg = aclGui.getMsg();
                jDialog.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                editedMsg = null;
                jDialog.dispose();
            }
        });
        jDialog.pack();
        jDialog.setResizable(false);
        if (frame != null) {
            int n = frame.getX() + (frame.getWidth() - jDialog.getWidth()) / 2;
            int n2 = frame.getY() + (frame.getHeight() - jDialog.getHeight()) / 2;
            jDialog.setLocation(n > 0 ? n : 0, n2 > 0 ? n2 : 0);
        }
        jDialog.show();
        ACLMessage aCLMessage2 = null;
        if (editedMsg != null) {
            aCLMessage2 = (ACLMessage)editedMsg.clone();
        }
        return aCLMessage2;
    }

    static /* synthetic */ String access$1900(AclGui aclGui) {
        return aclGui.lastSelectedItem;
    }

    static /* synthetic */ int access$1800(AclGui aclGui) {
        return aclGui.lastSelectedIndex;
    }

    static /* synthetic */ Date access$2300(AclGui aclGui) {
        return aclGui.replyByDate;
    }

    static /* synthetic */ Date access$3500(AclGui aclGui) {
        return aclGui.dateDate;
    }

    static /* synthetic */ Date access$4100(AclGui aclGui) {
        return aclGui.dateRecDate;
    }

    static /* synthetic */ void access$4700(AclGui aclGui, Envelope envelope) {
        aclGui.showEnvelope(envelope);
    }

    private class EnvelopePanel
    extends JPanel {
        EnvelopePanel() {
            AclGui.this.aclPanel = new JPanel();
            AclGui.this.aclPanel.setLayout(AclGui.this.lm);
            AclGui.this.formatGrid(20, 3, 5, 5, 5, 5, 2, 2);
            AclGui.this.setGridColumnWidth(0, 115);
            AclGui.this.setGridColumnWidth(1, 40);
            AclGui.this.setGridColumnWidth(2, 170);
            JLabel jLabel = new JLabel("To:");
            AclGui.this.put(AclGui.this.aclPanel, jLabel, 0, 0, 1, 1, false);
            AclGui.this.toPanel = new VisualAIDList(new ArrayList().iterator(), AclGui.this.ownerGui);
            AclGui.this.toPanel.setDimension(new Dimension(205, 37));
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.toPanel, 1, 0, 2, 1, false);
            jLabel = new JLabel("From:");
            AclGui.this.put(AclGui.this.aclPanel, jLabel, 0, 1, 1, 1, false);
            AclGui.this.fromButton = new JButton("Set");
            AclGui.this.fromButton.setMargin(new Insets(2, 3, 2, 3));
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.fromButton, 1, 1, 1, 1, false);
            AclGui.this.from = new JTextField();
            AclGui.this.from.setEditable(false);
            AclGui.this.from.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.from, 2, 1, 1, 1, false);
            AclGui.this.fromButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ EnvelopePanel this$1;
                {
                    this.this$1 = envelopePanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    AIDGui aIDGui = new AIDGui(AclGui.access$1100(EnvelopePanel.access$3000(this.this$1)));
                    if (string.equals("Set")) {
                        AID aID = EnvelopePanel.access$3000((EnvelopePanel)this.this$1).fromAID;
                        if (EnvelopePanel.access$3000((EnvelopePanel)this.this$1).newAIDFrom != null) {
                            aID = EnvelopePanel.access$3000((EnvelopePanel)this.this$1).newAIDFrom;
                        }
                        if ((aID = aIDGui.ShowAIDGui(aID, true, true)) != null) {
                            EnvelopePanel.access$3000((EnvelopePanel)this.this$1).newAIDFrom = aID;
                            AclGui.access$2900(EnvelopePanel.access$3000(this.this$1)).setText(EnvelopePanel.access$3000((EnvelopePanel)this.this$1).newAIDFrom.getName());
                        }
                    } else if (string.equals("View")) {
                        aIDGui.ShowAIDGui(EnvelopePanel.access$3000((EnvelopePanel)this.this$1).fromAID, false, false);
                    }
                }
            });
            jLabel = new JLabel("Comments:");
            AclGui.this.put(AclGui.this.aclPanel, jLabel, 0, 2, 1, 1, false);
            AclGui.this.comments = new JTextArea(4, 30);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().setView(AclGui.this.comments);
            AclGui.this.put(AclGui.this.aclPanel, jScrollPane, 0, 3, 3, 4, false);
            jScrollPane.setHorizontalScrollBarPolicy(32);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jLabel = new JLabel("ACLRepresentation:");
            AclGui.this.put(AclGui.this.aclPanel, jLabel, 0, 7, 1, 1, false);
            AclGui.this.representation = new JTextField();
            AclGui.this.representation.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.representation, 1, 7, 2, 1, false);
            jLabel = new JLabel("Payload Length:");
            AclGui.this.put(AclGui.this.aclPanel, jLabel, 0, 8, 1, 1, false);
            AclGui.this.payloadLength = new JTextField();
            AclGui.this.payloadLength.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.payloadLength, 1, 8, 2, 1, false);
            jLabel = new JLabel("Payload Encoding:");
            AclGui.this.put(AclGui.this.aclPanel, jLabel, 0, 9, 1, 1, false);
            AclGui.this.payloadEncoding = new JTextField();
            AclGui.this.payloadEncoding.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.payloadEncoding, 1, 9, 2, 1, false);
            AclGui.this.dateDate = null;
            jLabel = new JLabel("Date:");
            AclGui.this.put(AclGui.this.aclPanel, jLabel, 0, 10, 1, 1, false);
            AclGui.this.dateButton = new JButton("Set");
            AclGui.this.dateButton.setMargin(new Insets(2, 3, 2, 3));
            AclGui.this.date = new JTextField();
            AclGui.this.date.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.dateButton, 1, 10, 1, 1, false);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.date, 2, 10, 1, 1, false);
            AclGui.this.dateButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ EnvelopePanel this$1;
                {
                    this.this$1 = envelopePanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    TimeChooser timeChooser;
                    String string;
                    block9: {
                        string = actionEvent.getActionCommand();
                        timeChooser = new TimeChooser();
                        String string2 = AclGui.access$3700(EnvelopePanel.access$3000(this.this$1)).getText();
                        if (!string2.equals("")) {
                            try {
                                timeChooser.setDate(ISO8601.toDate(string2));
                            }
                            catch (Exception exception) {
                                if (!AclGui.access$2600(EnvelopePanel.access$3000(this.this$1)).isLoggable(Logger.WARNING)) break block9;
                                AclGui.access$2600(EnvelopePanel.access$3000(this.this$1)).log(Logger.WARNING, "Incorrect date format");
                            }
                        }
                    }
                    if (string.equals("Set")) {
                        if (timeChooser.showEditTimeDlg(null) == 1) {
                            AclGui.access$3502(EnvelopePanel.access$3000(this.this$1), timeChooser.getDate());
                            if (AclGui.access$3500(EnvelopePanel.access$3000(this.this$1)) == null) {
                                AclGui.access$3700(EnvelopePanel.access$3000(this.this$1)).setText("");
                            } else {
                                AclGui.access$3700(EnvelopePanel.access$3000(this.this$1)).setText(ISO8601.toString(AclGui.access$3500(EnvelopePanel.access$3000(this.this$1))));
                            }
                        }
                    } else if (string.equals("View")) {
                        timeChooser.showViewTimeDlg(null);
                    }
                }
            });
            jLabel = new JLabel("Intended Receiver:");
            AclGui.this.put(AclGui.this.aclPanel, jLabel, 0, 11, 1, 1, false);
            AclGui.this.intendedReceiverPanel = new VisualAIDList(new ArrayList().iterator(), AclGui.this.ownerGui);
            AclGui.this.intendedReceiverPanel.setDimension(new Dimension(205, 37));
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.intendedReceiverPanel, 1, 11, 2, 1, false);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel.setBorder(new TitledBorder("Received Object"));
            jLabel = new JLabel("By:");
            jLabel.setPreferredSize(new Dimension(115, 24));
            jLabel.setMinimumSize(new Dimension(115, 24));
            jLabel.setMaximumSize(new Dimension(115, 24));
            jPanel2.add(jLabel);
            AclGui.this.by = new JTextField();
            AclGui.this.by.setBackground(Color.white);
            jPanel2.add(AclGui.this.by);
            jPanel.add(jPanel2);
            jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jLabel = new JLabel("From:");
            jLabel.setPreferredSize(new Dimension(115, 24));
            jLabel.setMinimumSize(new Dimension(115, 24));
            jLabel.setMaximumSize(new Dimension(115, 24));
            jPanel2.add(jLabel);
            AclGui.this.fromRec = new JTextField();
            AclGui.this.fromRec.setBackground(Color.white);
            jPanel2.add(AclGui.this.fromRec);
            jPanel.add(jPanel2);
            jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            AclGui.this.dateRecDate = null;
            jLabel = new JLabel("Date:");
            jLabel.setPreferredSize(new Dimension(115, 24));
            jLabel.setMinimumSize(new Dimension(115, 24));
            jLabel.setMaximumSize(new Dimension(115, 24));
            jPanel2.add(jLabel);
            AclGui.this.dateRecButton = new JButton("Set");
            jPanel2.add(AclGui.this.dateRecButton);
            AclGui.this.dateRecButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ EnvelopePanel this$1;
                {
                    this.this$1 = envelopePanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    TimeChooser timeChooser;
                    String string;
                    block9: {
                        string = actionEvent.getActionCommand();
                        timeChooser = new TimeChooser();
                        String string2 = AclGui.access$4300(EnvelopePanel.access$3000(this.this$1)).getText();
                        if (!string2.equals("")) {
                            try {
                                timeChooser.setDate(ISO8601.toDate(string2));
                            }
                            catch (Exception exception) {
                                if (!AclGui.access$2600(EnvelopePanel.access$3000(this.this$1)).isLoggable(Logger.WARNING)) break block9;
                                AclGui.access$2600(EnvelopePanel.access$3000(this.this$1)).log(Logger.WARNING, "Incorrect date format");
                            }
                        }
                    }
                    if (string.equals("Set")) {
                        if (timeChooser.showEditTimeDlg(null) == 1) {
                            AclGui.access$4102(EnvelopePanel.access$3000(this.this$1), timeChooser.getDate());
                            if (AclGui.access$4100(EnvelopePanel.access$3000(this.this$1)) == null) {
                                AclGui.access$4300(EnvelopePanel.access$3000(this.this$1)).setText("");
                            } else {
                                AclGui.access$4300(EnvelopePanel.access$3000(this.this$1)).setText(ISO8601.toString(AclGui.access$4100(EnvelopePanel.access$3000(this.this$1))));
                            }
                        }
                    } else if (string.equals("View")) {
                        timeChooser.showViewTimeDlg(null);
                    }
                }
            });
            AclGui.this.dateRec = new JTextField();
            AclGui.this.dateRec.setBackground(Color.white);
            jPanel2.add(AclGui.this.dateRec);
            jPanel.add(jPanel2);
            jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jLabel = new JLabel("ID:");
            jLabel.setPreferredSize(new Dimension(115, 24));
            jLabel.setMinimumSize(new Dimension(115, 24));
            jLabel.setMaximumSize(new Dimension(115, 24));
            jPanel2.add(jLabel);
            AclGui.this.id = new JTextField();
            AclGui.this.id.setBackground(Color.white);
            jPanel2.add(AclGui.this.id);
            jPanel.add(jPanel2);
            jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jLabel = new JLabel("Via:");
            jLabel.setPreferredSize(new Dimension(115, 24));
            jLabel.setMinimumSize(new Dimension(115, 24));
            jLabel.setMaximumSize(new Dimension(115, 24));
            jPanel2.add(jLabel);
            AclGui.this.via = new JTextField();
            AclGui.this.via.setBackground(Color.white);
            jPanel2.add(AclGui.this.via);
            jPanel.add(jPanel2);
            AclGui.this.put(AclGui.this.aclPanel, jPanel, 0, 12, 3, 1, false);
            JPanel jPanel3 = new JPanel();
            AclGui.this.defaultEnvelopeButton = new JButton("Set Default Envelope");
            jPanel3.add(AclGui.this.defaultEnvelopeButton);
            AclGui.this.defaultEnvelopeButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ EnvelopePanel this$1;
                {
                    this.this$1 = envelopePanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    if (string.equals("Set Default Envelope")) {
                        ACLMessage aCLMessage = EnvelopePanel.access$3000(this.this$1).getMsg();
                        aCLMessage.setDefaultEnvelope();
                        Envelope envelope = aCLMessage.getEnvelope();
                        AclGui.access$4700(EnvelopePanel.access$3000(this.this$1), envelope);
                    }
                }
            });
            AclGui.this.put(AclGui.this.aclPanel, jPanel3, 0, 17, 3, 1, false);
            this.add(AclGui.this.aclPanel);
        }

        static /* synthetic */ AclGui access$3000(EnvelopePanel envelopePanel) {
            return envelopePanel.AclGui.this;
        }
    }

    private class AclMessagePanel
    extends JPanel
    implements DropTargetListener {
        AclMessagePanel() {
            AclGui.this.fipaProtocolArrayList = new ArrayList();
            int n = 0;
            while (n < N_FIPA_PROTOCOLS) {
                AclGui.this.fipaProtocolArrayList.add(fipaProtocols[n]);
                ++n;
            }
            AclGui.this.aclPanel = new JPanel();
            new DropTarget(AclGui.this.aclPanel, this);
            AclGui.this.aclPanel.setLayout(AclGui.this.lm);
            AclGui.this.formatGrid(20, 3, 5, 5, 5, 5, 2, 2);
            AclGui.this.setGridColumnWidth(0, 115);
            AclGui.this.setGridColumnWidth(1, 40);
            AclGui.this.setGridColumnWidth(2, 170);
            JLabel jLabel = new JLabel("Sender:");
            new DropTarget(jLabel, this);
            AclGui.this.put(AclGui.this.aclPanel, jLabel, 0, 0, 1, 1, false);
            AclGui.this.senderEnabledFlag = true;
            AclGui.this.sender = new JTextField();
            AclGui.this.sender.setPreferredSize(new Dimension(80, 26));
            AclGui.this.sender.setMinimumSize(new Dimension(80, 26));
            AclGui.this.sender.setMaximumSize(new Dimension(80, 26));
            AclGui.this.sender.setEditable(false);
            AclGui.this.sender.setBackground(Color.white);
            AclGui.this.senderButton = new JButton("Set");
            AclGui.this.senderButton.setMargin(new Insets(2, 3, 2, 3));
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.senderButton, 1, 0, 1, 1, false);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.sender, 2, 0, 1, 1, false);
            AclGui.this.senderButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ AclMessagePanel this$1;
                {
                    this.this$1 = aclMessagePanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    AIDGui aIDGui = new AIDGui(AclGui.access$1100(AclMessagePanel.access$1000(this.this$1)));
                    if (string.equals("Set")) {
                        AID aID = AclMessagePanel.access$1000((AclMessagePanel)this.this$1).SenderAID;
                        if (AclMessagePanel.access$1000((AclMessagePanel)this.this$1).newAIDSender != null) {
                            aID = AclMessagePanel.access$1000((AclMessagePanel)this.this$1).newAIDSender;
                        }
                        if ((aID = aIDGui.ShowAIDGui(aID, true, true)) != null) {
                            AclMessagePanel.access$1000((AclMessagePanel)this.this$1).newAIDSender = aID;
                            AclGui.access$800(AclMessagePanel.access$1000(this.this$1)).setText(AclMessagePanel.access$1000((AclMessagePanel)this.this$1).newAIDSender.getName());
                        }
                    } else if (string.equals("View")) {
                        aIDGui.ShowAIDGui(AclMessagePanel.access$1000((AclMessagePanel)this.this$1).SenderAID, false, false);
                    }
                }
            });
            jLabel = new JLabel("Receivers:");
            new DropTarget(jLabel, this);
            AclGui.this.put(AclGui.this.aclPanel, jLabel, 0, 1, 1, 1, false);
            AclGui.this.receiverListPanel = new VisualAIDList(new ArrayList().iterator(), AclGui.this.ownerGui);
            AclGui.this.receiverListPanel.setDimension(new Dimension(205, 37));
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.receiverListPanel, 1, 1, 2, 1, false);
            jLabel = new JLabel("Reply-to:");
            new DropTarget(jLabel, this);
            AclGui.this.put(AclGui.this.aclPanel, jLabel, 0, 2, 1, 1, false);
            AclGui.this.replyToListPanel = new VisualAIDList(new ArrayList().iterator(), AclGui.this.ownerGui);
            AclGui.this.replyToListPanel.setDimension(new Dimension(205, 37));
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.replyToListPanel, 1, 2, 2, 1, false);
            jLabel = new JLabel("Communicative act:");
            new DropTarget(jLabel, this);
            AclGui.this.put(AclGui.this.aclPanel, jLabel, 0, 3, 1, 1, false);
            AclGui.this.communicativeAct = new JComboBox();
            String[] stringArray = ACLMessage.getAllPerformativeNames();
            int n2 = 0;
            while (n2 < stringArray.length) {
                AclGui.this.communicativeAct.addItem(stringArray[n2].toLowerCase());
                ++n2;
            }
            AclGui.this.communicativeAct.setSelectedIndex(0);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.communicativeAct, 1, 3, 2, 1, true);
            jLabel = new JLabel("Content:");
            new DropTarget(jLabel, this);
            AclGui.this.put(AclGui.this.aclPanel, jLabel, 0, 4, 3, 1, false);
            AclGui.this.content = new JTextArea(5, 30);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().setView(AclGui.this.content);
            AclGui.this.put(AclGui.this.aclPanel, jScrollPane, 0, 5, 3, 4, false);
            jScrollPane.setHorizontalScrollBarPolicy(32);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jLabel = new JLabel("Language:");
            new DropTarget(jLabel, this);
            AclGui.this.put(AclGui.this.aclPanel, jLabel, 0, 9, 1, 1, false);
            AclGui.this.language = new JTextField();
            AclGui.this.language.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.language, 1, 9, 2, 1, false);
            jLabel = new JLabel("Encoding:");
            new DropTarget(jLabel, this);
            AclGui.this.put(AclGui.this.aclPanel, jLabel, 0, 10, 1, 1, false);
            AclGui.this.encoding = new JTextField();
            AclGui.this.encoding.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.encoding, 1, 10, 2, 1, false);
            jLabel = new JLabel("Ontology:");
            new DropTarget(jLabel, this);
            AclGui.this.put(AclGui.this.aclPanel, jLabel, 0, 11, 1, 1, false);
            AclGui.this.ontology = new JTextField();
            AclGui.this.ontology.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.ontology, 1, 11, 2, 1, false);
            jLabel = new JLabel("Protocol:");
            new DropTarget(jLabel, this);
            AclGui.this.put(AclGui.this.aclPanel, jLabel, 0, 12, 1, 1, false);
            AclGui.this.protocol = new JComboBox();
            n = 0;
            while (n < AclGui.this.fipaProtocolArrayList.size()) {
                AclGui.this.protocol.addItem((String)AclGui.this.fipaProtocolArrayList.get(n));
                ++n;
            }
            AclGui.this.protocol.addItem(AclGui.LABEL_TO_ADD_PROT);
            AclGui.this.protocol.addItem("Null");
            AclGui.this.protocol.setSelectedItem("Null");
            AclGui.this.lastSelectedIndex = AclGui.this.protocol.getSelectedIndex();
            AclGui.this.lastSelectedItem = (String)AclGui.this.protocol.getSelectedItem();
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.protocol, 1, 12, 2, 1, true);
            AclGui.this.protocol.addActionListener(new ActionListener(this){
                private final /* synthetic */ AclMessagePanel this$1;
                {
                    this.this$1 = aclMessagePanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)AclGui.access$1700(AclMessagePanel.access$1000(this.this$1)).getSelectedItem();
                    if (!AclGui.access$1700(AclMessagePanel.access$1000(this.this$1)).isEditable()) {
                        if (AclGui.access$000(AclMessagePanel.access$1000(this.this$1)).indexOf(string) < 0 && !string.equals("Null")) {
                            AclGui.access$1700(AclMessagePanel.access$1000(this.this$1)).setEditable(true);
                        }
                    } else if (AclGui.access$000(AclMessagePanel.access$1000(this.this$1)).indexOf(string) >= 0 || string.equals("Null")) {
                        AclGui.access$1700(AclMessagePanel.access$1000(this.this$1)).setEditable(false);
                        AclGui.access$1700(AclMessagePanel.access$1000(this.this$1)).setSelectedItem(string);
                    } else if (string.equals("ADD USER-DEF PROTOCOL")) {
                        AclGui.access$1700(AclMessagePanel.access$1000(this.this$1)).setSelectedItem(string);
                    } else if (AclGui.access$1900(AclMessagePanel.access$1000(this.this$1)).equals("ADD USER-DEF PROTOCOL")) {
                        if (!string.equals("")) {
                            AclGui.access$1700(AclMessagePanel.access$1000(this.this$1)).addItem(string);
                            int n = AclGui.access$1700(AclMessagePanel.access$1000(this.this$1)).getItemCount();
                            AclGui.access$1700(AclMessagePanel.access$1000(this.this$1)).setSelectedItem(string);
                            int n2 = AclGui.access$1700(AclMessagePanel.access$1000(this.this$1)).getSelectedIndex();
                            if (n2 != n - 1) {
                                AclGui.access$1700(AclMessagePanel.access$1000(this.this$1)).removeItemAt(n - 1);
                            }
                        } else {
                            AclGui.access$1700(AclMessagePanel.access$1000(this.this$1)).setEditable(false);
                            AclGui.access$1700(AclMessagePanel.access$1000(this.this$1)).setSelectedItem("Null");
                        }
                    } else if (AclGui.access$1900(AclMessagePanel.access$1000(this.this$1)) != "ADD USER-DEF PROTOCOL") {
                        AclGui.access$1700(AclMessagePanel.access$1000(this.this$1)).removeItemAt(AclGui.access$1800(AclMessagePanel.access$1000(this.this$1)));
                        if (string.equals("")) {
                            AclGui.access$1700(AclMessagePanel.access$1000(this.this$1)).setEditable(false);
                            AclGui.access$1700(AclMessagePanel.access$1000(this.this$1)).setSelectedItem("Null");
                        } else {
                            AclGui.access$1700(AclMessagePanel.access$1000(this.this$1)).addItem(string);
                            AclGui.access$1700(AclMessagePanel.access$1000(this.this$1)).setSelectedItem(string);
                        }
                    }
                    AclGui.access$1802(AclMessagePanel.access$1000(this.this$1), AclGui.access$1700(AclMessagePanel.access$1000(this.this$1)).getSelectedIndex());
                    AclGui.access$1902(AclMessagePanel.access$1000(this.this$1), (String)AclGui.access$1700(AclMessagePanel.access$1000(this.this$1)).getSelectedItem());
                }
            });
            jLabel = new JLabel("Conversation-id:");
            new DropTarget(jLabel, this);
            AclGui.this.put(AclGui.this.aclPanel, jLabel, 0, 13, 1, 1, false);
            AclGui.this.conversationId = new JTextField();
            AclGui.this.conversationId.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.conversationId, 1, 13, 2, 1, false);
            jLabel = new JLabel("In-reply-to:");
            new DropTarget(jLabel, this);
            AclGui.this.put(AclGui.this.aclPanel, jLabel, 0, 14, 1, 1, false);
            AclGui.this.inReplyTo = new JTextField();
            AclGui.this.inReplyTo.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.inReplyTo, 1, 14, 2, 1, false);
            jLabel = new JLabel("Reply-with:");
            new DropTarget(jLabel, this);
            AclGui.this.put(AclGui.this.aclPanel, jLabel, 0, 15, 1, 1, false);
            AclGui.this.replyWith = new JTextField();
            AclGui.this.replyWith.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.replyWith, 1, 15, 2, 1, false);
            AclGui.this.replyByDate = null;
            jLabel = new JLabel("Reply-by:");
            new DropTarget(jLabel, this);
            AclGui.this.put(AclGui.this.aclPanel, jLabel, 0, 16, 1, 1, false);
            AclGui.this.replyBySet = new JButton("Set");
            AclGui.this.replyBySet.setMargin(new Insets(2, 3, 2, 3));
            AclGui.this.replyBy = new JTextField();
            AclGui.this.replyBy.setBackground(Color.white);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.replyBySet, 1, 16, 1, 1, false);
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.replyBy, 2, 16, 1, 1, false);
            AclGui.this.replyBySet.addActionListener(new ActionListener(this){
                private final /* synthetic */ AclMessagePanel this$1;
                {
                    this.this$1 = aclMessagePanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    TimeChooser timeChooser;
                    String string;
                    block9: {
                        string = actionEvent.getActionCommand();
                        timeChooser = new TimeChooser();
                        String string2 = AclGui.access$2500(AclMessagePanel.access$1000(this.this$1)).getText();
                        if (!string2.equals("")) {
                            try {
                                timeChooser.setDate(ISO8601.toDate(string2));
                            }
                            catch (Exception exception) {
                                if (!AclGui.access$2600(AclMessagePanel.access$1000(this.this$1)).isLoggable(Logger.SEVERE)) break block9;
                                AclGui.access$2600(AclMessagePanel.access$1000(this.this$1)).log(Logger.WARNING, "Incorrect date format");
                            }
                        }
                    }
                    if (string.equals("Set")) {
                        if (timeChooser.showEditTimeDlg(null) == 1) {
                            AclGui.access$2302(AclMessagePanel.access$1000(this.this$1), timeChooser.getDate());
                            if (AclGui.access$2300(AclMessagePanel.access$1000(this.this$1)) == null) {
                                AclGui.access$2500(AclMessagePanel.access$1000(this.this$1)).setText("");
                            } else {
                                AclGui.access$2500(AclMessagePanel.access$1000(this.this$1)).setText(ISO8601.toString(AclGui.access$2300(AclMessagePanel.access$1000(this.this$1))));
                            }
                        }
                    } else if (string.equals("View")) {
                        timeChooser.showViewTimeDlg(null);
                    }
                }
            });
            jLabel = new JLabel("User Properties:");
            new DropTarget(jLabel, this);
            AclGui.this.put(AclGui.this.aclPanel, jLabel, 0, 17, 1, 1, false);
            AclGui.this.propertiesListPanel = new VisualPropertiesList(new Properties(), AclGui.this.ownerGui);
            AclGui.this.propertiesListPanel.setDimension(new Dimension(205, 37));
            AclGui.this.put(AclGui.this.aclPanel, AclGui.this.propertiesListPanel, 1, 17, 2, 1, false);
            this.setLayout(new BoxLayout(this, 1));
            this.add(AclGui.this.aclPanel);
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (AclGui.this.logger.isLoggable(Logger.FINEST)) {
                AclGui.this.logger.log(Logger.FINEST, "dragOver");
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            if (AclGui.this.logger.isLoggable(Logger.FINEST)) {
                AclGui.this.logger.log(Logger.FINEST, "dropActionChanged");
            }
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (AclGui.this.logger.isLoggable(Logger.FINEST)) {
                AclGui.this.logger.log(Logger.FINEST, "dragEnter");
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            if (AclGui.this.logger.isLoggable(Logger.FINEST)) {
                AclGui.this.logger.log(Logger.FINEST, "dragExit");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            FileReader fileReader;
            Object object;
            List list;
            block16: {
                boolean bl = false;
                list = null;
                try {
                    try {
                        dropTargetDropEvent.acceptDrop(1);
                        object = dropTargetDropEvent.getTransferable();
                        list = (List)object.getTransferData(DataFlavor.javaFileListFlavor);
                        bl = true;
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        bl = false;
                        fileReader = null;
                        dropTargetDropEvent.dropComplete(bl);
                        break block16;
                    }
                    catch (IOException iOException) {
                        if (AclGui.this.logger.isLoggable(Logger.WARNING)) {
                            AclGui.this.logger.log(Logger.WARNING, "DragAndDrop operation failed: " + iOException);
                        }
                        bl = false;
                        fileReader = null;
                        dropTargetDropEvent.dropComplete(bl);
                    }
                    fileReader = null;
                    dropTargetDropEvent.dropComplete(bl);
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    dropTargetDropEvent.dropComplete(bl);
                    throw throwable;
                }
            }
            if (list != null) {
                object = list.iterator();
                ACLParser aCLParser = ACLParser.create();
                while (object.hasNext()) {
                    try {
                        File file = (File)object.next();
                        fileReader = new FileReader(file);
                        Enumeration enumeration = AclGui.this.receiverListPanel.getContent();
                        AclGui.this.setMsg(aCLParser.parse(fileReader));
                        if (!enumeration.hasMoreElements()) continue;
                        if (AclGui.this.logger.isLoggable(Logger.FINE)) {
                            AclGui.this.logger.log(Logger.FINE, "revert to saved list");
                        }
                        ArrayList arrayList = new ArrayList();
                        while (enumeration.hasMoreElements()) {
                            arrayList.add(enumeration.nextElement());
                        }
                        AclGui.this.receiverListPanel.resetContent(arrayList.iterator());
                    }
                    catch (IOException iOException) {
                        if (!AclGui.this.logger.isLoggable(Logger.WARNING)) continue;
                        AclGui.this.logger.log(Logger.WARNING, "DragAndDrop operation failed: " + iOException);
                    }
                    catch (ParseException parseException) {
                        if (!AclGui.this.logger.isLoggable(Logger.WARNING)) continue;
                        AclGui.this.logger.log(Logger.WARNING, "DragAndDrop operation failed: " + parseException);
                    }
                    catch (Exception exception) {
                        if (!AclGui.this.logger.isLoggable(Logger.WARNING)) continue;
                        AclGui.this.logger.log(Logger.WARNING, "DragAndDrop operation failed: " + exception);
                    }
                    catch (Error error) {
                        if (!AclGui.this.logger.isLoggable(Logger.WARNING)) continue;
                        AclGui.this.logger.log(Logger.WARNING, "DragAndDrop operation failed: " + error);
                    }
                    catch (Throwable throwable) {
                        if (!AclGui.this.logger.isLoggable(Logger.WARNING)) continue;
                        AclGui.this.logger.log(Logger.WARNING, "DragAndDrop operation failed: " + throwable);
                    }
                }
            }
        }

        static /* synthetic */ AclGui access$1000(AclMessagePanel aclMessagePanel) {
            return aclMessagePanel.AclGui.this;
        }
    }
}

