/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.ContentElementList;
import jade.content.Predicate;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Done;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.domain.DFAppletManagementBehaviour;
import jade.domain.DFFipaAgentManagementBehaviour;
import jade.domain.DFGUIAdapter;
import jade.domain.DFGUIInterface;
import jade.domain.DFGUIManagement.DFAppletOntology;
import jade.domain.DFGUIManagement.DeregisterFrom;
import jade.domain.DFGUIManagement.Federate;
import jade.domain.DFGUIManagement.GetDescription;
import jade.domain.DFGUIManagement.GetDescriptionUsed;
import jade.domain.DFGUIManagement.GetParents;
import jade.domain.DFGUIManagement.ModifyOn;
import jade.domain.DFGUIManagement.RegisterWith;
import jade.domain.DFGUIManagement.SearchOn;
import jade.domain.DFJadeAgentManagementBehaviour;
import jade.domain.DFKBFactory;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.AlreadyRegistered;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.Deregister;
import jade.domain.FIPAAgentManagement.FIPAManagementOntology;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.InternalError;
import jade.domain.FIPAAgentManagement.Modify;
import jade.domain.FIPAAgentManagement.NotRegistered;
import jade.domain.FIPAAgentManagement.Register;
import jade.domain.FIPAAgentManagement.Search;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAAgentManagement.Unauthorised;
import jade.domain.FIPAException;
import jade.domain.JADEAgentManagement.JADEManagementOntology;
import jade.domain.JADEAgentManagement.ShowGui;
import jade.domain.KBManagement.KB;
import jade.domain.KBManagement.LeaseManager;
import jade.domain.KBSubscriptionManager;
import jade.domain.RemoteDFRequester;
import jade.domain.introspection.AMSSubscriber;
import jade.domain.introspection.DeadAgent;
import jade.domain.introspection.Event;
import jade.gui.GuiAgent;
import jade.gui.GuiEvent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ISO8601;
import jade.lang.acl.MessageTemplate;
import jade.proto.AchieveREInitiator;
import jade.proto.SubscriptionResponder;
import jade.util.HashCache;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class df
extends GuiAgent
implements DFGUIAdapter {
    private static final int SEARCH_ID_CACHE_SIZE = 16;
    private HashCache searchIdCache = new HashCache(16);
    private int searchIdCnt = 0;
    private List children = new ArrayList();
    private List parents = new ArrayList();
    private HashMap dscDFParentMap = new HashMap();
    private HashMap pendingRequests = new HashMap();
    private DFGUIInterface gui;
    private DFAgentDescription myDescription = null;
    private Codec codec = new SLCodec();
    private DFFipaAgentManagementBehaviour fipaRequestResponder;
    private DFJadeAgentManagementBehaviour jadeRequestResponder;
    private DFAppletManagementBehaviour appletRequestResponder;
    private SubscriptionResponder dfSubscriptionResponder;
    private AMSSubscriber amsSubscriber;
    private static final String VERBOSITY = "jade_domain_df_verbosity";
    private static final String AUTOCLEANUP = "jade_domain_df_autocleanup";
    private static final String MAX_LEASE_TIME = "jade_domain_df_maxleasetime";
    private static final String MAX_RESULTS = "jade_domain_df_maxresult";
    private static final String DB_DRIVER = "jade_domain_df_db-driver";
    private static final String DB_URL = "jade_domain_df_db-url";
    private static final String DB_USERNAME = "jade_domain_df_db-username";
    private static final String DB_PASSWORD = "jade_domain_df_db-password";
    private static final String KB_FACTORY = "jade_domain_df_kb-factory";
    private static final String DB_DEFAULT = "jade_domain_df_db-default";
    private static final String CLEANTABLES = "jade_domain_df_db-cleantables";
    private static final String DEFAULT_MAX_RESULTS = "100";
    private int maxResultLimit = Integer.parseInt("100");
    private Date maxLeaseTime = null;
    private int verbosity = 0;
    private KB agentDescriptions = null;
    private KBSubscriptionManager subManager = null;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());
    private AID gatewayAID = null;
    private static final String GATEWAY_LOCAL_NAME = "wsig";

    protected void setup() {
        boolean bl;
        DFKBFactory dFKBFactory;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        block47: {
            boolean bl2;
            block46: {
                String string6;
                block45: {
                    Serializable serializable;
                    String string7;
                    String string8;
                    String string9;
                    String string10;
                    String string11;
                    block43: {
                        string11 = this.getProperty(VERBOSITY, null);
                        string5 = this.getProperty(AUTOCLEANUP, null);
                        string10 = this.getProperty(MAX_LEASE_TIME, null);
                        string9 = this.getProperty(MAX_RESULTS, DEFAULT_MAX_RESULTS);
                        string4 = this.getProperty(DB_URL, null);
                        string3 = this.getProperty(DB_DRIVER, null);
                        string2 = this.getProperty(DB_USERNAME, null);
                        string = this.getProperty(DB_PASSWORD, null);
                        string8 = this.getProperty(KB_FACTORY, null);
                        string6 = this.getProperty(DB_DEFAULT, null);
                        string7 = this.getProperty(CLEANTABLES, null);
                        dFKBFactory = new DFKBFactory();
                        Object[] objectArray = this.getArguments();
                        if (objectArray != null && objectArray.length > 0) {
                            serializable = new jade.util.leap.Properties();
                            try {
                                ((jade.util.leap.Properties)serializable).load((String)objectArray[0]);
                                string11 = ((Properties)serializable).getProperty(VERBOSITY, string11);
                                string10 = ((Properties)serializable).getProperty(MAX_LEASE_TIME, string10);
                                string9 = ((Properties)serializable).getProperty(MAX_RESULTS, string9);
                                string4 = ((Properties)serializable).getProperty(DB_URL, string4);
                                string3 = ((Properties)serializable).getProperty(DB_DRIVER, string3);
                                string2 = ((Properties)serializable).getProperty(DB_USERNAME, string2);
                                string = ((Properties)serializable).getProperty(DB_PASSWORD, string);
                                string8 = ((Properties)serializable).getProperty(KB_FACTORY, string8);
                                string6 = ((Properties)serializable).getProperty(DB_DEFAULT, string6);
                            }
                            catch (Exception exception) {
                                if (!this.logger.isLoggable(Logger.SEVERE)) break block43;
                                this.logger.log(Logger.SEVERE, "Error loading configuration from file " + objectArray[0] + " [" + exception + "].");
                            }
                        }
                    }
                    try {
                        this.verbosity = Integer.parseInt(string11);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.maxLeaseTime = new Date(Long.parseLong(string10));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.maxResultLimit = Integer.parseInt(string9);
                        if (this.maxResultLimit < 0) {
                            this.maxResultLimit = Integer.parseInt(DEFAULT_MAX_RESULTS);
                            if (this.logger.isLoggable(Logger.WARNING)) {
                                this.logger.log(Logger.WARNING, "The maxResult parameter of the DF Search Constraints can't be a negative value. It has been set to the default value: 100");
                            }
                        } else if (this.maxResultLimit > Integer.parseInt(DEFAULT_MAX_RESULTS) && this.logger.isLoggable(Logger.WARNING)) {
                            this.logger.log(Logger.WARNING, "Setting the maxResult of the DF Search Constraint to large values can cause low performance or system crash !!");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.logger.isLoggable(Logger.CONFIG)) {
                        this.logger.log(Logger.CONFIG, "DF KB configuration:");
                    }
                    if (string8 != null) {
                        block44: {
                            serializable = null;
                            try {
                                serializable = Class.forName(string8);
                                Object t = ((Class)serializable).newInstance();
                                if (t != null && t instanceof DFKBFactory) {
                                    dFKBFactory = (DFKBFactory)t;
                                    if (this.logger.isLoggable(Logger.INFO)) {
                                        this.logger.log(Logger.INFO, "Using class " + ((Class)serializable).getName() + " as KB factory for the DF.");
                                    }
                                } else if (this.logger.isLoggable(Logger.SEVERE)) {
                                    this.logger.log(Logger.SEVERE, "The class " + ((Class)serializable).getName() + " is not a valid class factory for the DF.");
                                }
                            }
                            catch (Exception exception) {
                                if (!this.logger.isLoggable(Logger.SEVERE)) break block44;
                                this.logger.log(Logger.SEVERE, "Error loading class " + string8 + ". " + exception);
                            }
                        }
                        if (this.logger.isLoggable(Logger.CONFIG)) {
                            this.logger.log(Logger.CONFIG, "- KB class factory = " + dFKBFactory.getClass().getName());
                        }
                    }
                    bl = false;
                    if (string7 != null) {
                        try {
                            bl = Boolean.valueOf(string7);
                        }
                        catch (Exception exception) {
                            if (!this.logger.isLoggable(Logger.WARNING)) break block45;
                            this.logger.log(Logger.WARNING, "Parsing error for parameter jade_domain_df_db-cleantables", exception);
                        }
                    }
                }
                bl2 = false;
                if (string6 != null) {
                    try {
                        bl2 = Boolean.valueOf(string6);
                    }
                    catch (Exception exception) {
                        if (!this.logger.isLoggable(Logger.WARNING)) break block46;
                        this.logger.log(Logger.WARNING, "Parsing error for parameter jade_domain_df_db-default", exception);
                    }
                }
            }
            if (bl2) {
                if (this.logger.isLoggable(Logger.CONFIG)) {
                    this.logger.log(Logger.CONFIG, "- Type = persistent");
                    this.logger.log(Logger.CONFIG, "- Using internal HSQL database");
                }
                try {
                    this.agentDescriptions = dFKBFactory.getDFDBKB(this.maxResultLimit, null, null, null, null, bl);
                }
                catch (Exception exception) {
                    if (!this.logger.isLoggable(Logger.SEVERE)) break block47;
                    this.logger.log(Logger.SEVERE, "Error creating persistent KB based on HSQLDB [" + exception + "]. Use a volatile KB.");
                }
            }
        }
        if (this.agentDescriptions == null && string4 != null) {
            if (this.logger.isLoggable(Logger.CONFIG)) {
                this.logger.log(Logger.CONFIG, "- Type = persistent");
                this.logger.log(Logger.CONFIG, "- DB url = " + string4);
                this.logger.log(Logger.CONFIG, "- DB driver = " + string3);
                this.logger.log(Logger.CONFIG, "- DB username = " + string2);
                this.logger.log(Logger.CONFIG, "- DB password = " + string);
            }
            try {
                this.agentDescriptions = dFKBFactory.getDFDBKB(this.maxResultLimit, string3, string4, string2, string, bl);
            }
            catch (Exception exception) {
                if (this.logger.isLoggable(Logger.SEVERE)) {
                    this.logger.log(Logger.SEVERE, "Error creating persistent KB [" + exception + "]. Use a volatile KB.");
                }
                exception.printStackTrace();
            }
        }
        if (this.agentDescriptions == null) {
            if (this.logger.isLoggable(Logger.CONFIG)) {
                this.logger.log(Logger.CONFIG, "- Type = volatile");
            }
            this.agentDescriptions = dFKBFactory.getDFMemKB(this.maxResultLimit);
        }
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "- Max lease time = " + (this.maxLeaseTime != null ? ISO8601.toRelativeTimeString(this.maxLeaseTime.getTime()) : "infinite"));
            this.logger.log(Logger.CONFIG, "- Max search result = " + this.maxResultLimit);
        }
        this.subManager = new KBSubscriptionManager(this.agentDescriptions);
        this.subManager.setContentManager(this.getContentManager());
        this.getContentManager().registerLanguage(this.codec, "fipa-sl0");
        this.getContentManager().registerLanguage(this.codec, "fipa-sl1");
        this.getContentManager().registerLanguage(this.codec, "fipa-sl2");
        this.getContentManager().registerLanguage(this.codec, "fipa-sl");
        this.getContentManager().registerOntology(FIPAManagementOntology.getInstance());
        this.getContentManager().registerOntology(JADEManagementOntology.getInstance());
        this.getContentManager().registerOntology(DFAppletOntology.getInstance());
        MessageTemplate messageTemplate = MessageTemplate.MatchPerformative(16);
        MessageTemplate messageTemplate2 = null;
        messageTemplate2 = MessageTemplate.and(messageTemplate, MessageTemplate.MatchOntology(FIPAManagementOntology.getInstance().getName()));
        this.fipaRequestResponder = new DFFipaAgentManagementBehaviour(this, messageTemplate2);
        this.addBehaviour(this.fipaRequestResponder);
        messageTemplate2 = MessageTemplate.and(messageTemplate, MessageTemplate.MatchOntology(JADEManagementOntology.getInstance().getName()));
        this.jadeRequestResponder = new DFJadeAgentManagementBehaviour(this, messageTemplate2);
        this.addBehaviour(this.jadeRequestResponder);
        messageTemplate2 = MessageTemplate.and(messageTemplate, MessageTemplate.MatchOntology(DFAppletOntology.getInstance().getName()));
        this.appletRequestResponder = new DFAppletManagementBehaviour(this, messageTemplate2);
        this.addBehaviour(this.appletRequestResponder);
        messageTemplate2 = MessageTemplate.and(MessageTemplate.MatchOntology(FIPAManagementOntology.getInstance().getName()), MessageTemplate.or(MessageTemplate.MatchPerformative(19), MessageTemplate.MatchPerformative(2)));
        this.dfSubscriptionResponder = new SubscriptionResponder(this, messageTemplate2, this.subManager){

            protected ACLMessage handleCancel(ACLMessage aCLMessage) throws FailureException {
                try {
                    Action action = (Action)this.myAgent.getContentManager().extractContent(aCLMessage);
                    ACLMessage aCLMessage2 = (ACLMessage)((Object)action.getAction());
                    SubscriptionResponder.Subscription subscription = this.createSubscription(aCLMessage2);
                    this.mySubscriptionManager.deregister(subscription);
                    subscription.close();
                }
                catch (Exception exception) {
                    if (df.this.logger.isLoggable(Logger.CONFIG)) {
                        df.this.logger.log(Logger.CONFIG, "Unknown CANCEL content. Use default handler");
                    }
                    super.handleCancel(aCLMessage);
                }
                return null;
            }
        };
        this.addBehaviour(this.dfSubscriptionResponder);
        this.setDescriptionOfThisDF(this.getDefaultDescription());
        this.agentDescriptions.setSubscriptionResponder(this.dfSubscriptionResponder);
        this.agentDescriptions.setLeaseManager(new LeaseManager(){

            public Date getLeaseTime(Object object) {
                return ((DFAgentDescription)object).getLeaseTime();
            }

            public void setLeaseTime(Object object, Date date) {
                ((DFAgentDescription)object).setLeaseTime(date);
            }

            public Object grantLeaseTime(Object object) {
                if (df.this.maxLeaseTime != null) {
                    Date date = this.getLeaseTime(object);
                    long l = System.currentTimeMillis();
                    if (date != null && date.getTime() > l + df.this.maxLeaseTime.getTime() || date == null && df.this.maxLeaseTime != null) {
                        this.setLeaseTime(object, new Date(l + df.this.maxLeaseTime.getTime()));
                    }
                }
                return object;
            }

            public boolean isExpired(Date date) {
                return date != null && date.getTime() <= System.currentTimeMillis();
            }
        });
        this.myDescription = this.getDefaultDescription();
        boolean bl3 = false;
        try {
            bl3 = Boolean.valueOf(string5);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl3) {
            this.logger.log(Logger.CONFIG, "Autocleanup activated");
            this.amsSubscriber = new AMSSubscriber(){

                protected void installHandlers(Map map) {
                    map.put("dead-agent", new AMSSubscriber.EventHandler(this){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void handle(Event event) {
                            try {
                                DeadAgent deadAgent = (DeadAgent)event;
                                AID aID = deadAgent.getAgent();
                                DFAgentDescription dFAgentDescription = new DFAgentDescription();
                                dFAgentDescription.setName(aID);
                                3.access$200(this.this$1).DFDeregister(dFAgentDescription);
                            }
                            catch (Exception exception) {}
                        }
                    });
                }

                static /* synthetic */ df access$200(3 var0) {
                    return var0.df.this;
                }
            };
            this.addBehaviour(this.amsSubscriber);
        }
    }

    protected void takeDown() {
        if (this.amsSubscriber != null) {
            this.send(this.amsSubscriber.getCancel());
        }
        if (this.gui != null) {
            this.gui.disposeAsync();
        }
        DFAgentDescription dFAgentDescription = new DFAgentDescription();
        dFAgentDescription.setName(this.getAID());
        Iterator iterator = this.parents.iterator();
        while (iterator.hasNext()) {
            AID aID = (AID)iterator.next();
            try {
                DFService.deregister(this, aID, dFAgentDescription);
            }
            catch (FIPAException fIPAException) {
                fIPAException.printStackTrace();
            }
        }
    }

    private void performRecursiveSearch(List list, DFAgentDescription dFAgentDescription, SearchConstraints searchConstraints, Search search) {
        int n = this.getActualMaxResults(searchConstraints);
        int n2 = searchConstraints.getMaxDepth().intValue();
        SearchConstraints searchConstraints2 = new SearchConstraints();
        searchConstraints2.setMaxDepth(new Long(n2 - 1));
        searchConstraints2.setMaxResults(new Long(n - list.size()));
        String string = searchConstraints.getSearchId();
        if (string == null) {
            string = this.getName() + String.valueOf(this.searchIdCnt++) + System.currentTimeMillis();
            if (this.searchIdCnt >= 16) {
                this.searchIdCnt = 0;
            }
            this.searchIdCache.add(string);
        }
        searchConstraints2.setSearchId(string);
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Activating recursive search: " + list.size() + " item(s) found locally. " + n + " expected. Search depth is " + n2 + ". Search ID is " + string + ". Propagating search to " + this.children.size() + " federated DF(s)");
        }
        this.addBehaviour(new RecursiveSearchHandler(list, dFAgentDescription, searchConstraints2, search));
    }

    void DFRegister(DFAgentDescription dFAgentDescription) throws AlreadyRegistered {
        Object object = this.agentDescriptions.register(dFAgentDescription.getName(), dFAgentDescription);
        if (object != null) {
            throw new AlreadyRegistered();
        }
        if (this.isADF(dFAgentDescription)) {
            if (this.logger.isLoggable(Logger.INFO)) {
                this.logger.log(Logger.INFO, "Added federation " + dFAgentDescription.getName().getName() + " --> " + this.getName());
            }
            this.children.add(dFAgentDescription.getName());
            try {
                this.gui.addChildren(dFAgentDescription.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.subManager.handleChange(dFAgentDescription);
        try {
            this.gui.addAgentDesc(dFAgentDescription.getName());
            this.gui.showStatusMsg("Registration of agent: " + dFAgentDescription.getName().getName() + " done.");
        }
        catch (Exception exception) {}
    }

    void DFDeregister(DFAgentDescription dFAgentDescription) throws NotRegistered {
        Object object = this.agentDescriptions.deregister(dFAgentDescription.getName());
        if (object == null) {
            throw new NotRegistered();
        }
        if (this.children.remove(dFAgentDescription.getName())) {
            try {
                this.gui.removeChildren(dFAgentDescription.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.gui.removeAgentDesc(dFAgentDescription.getName(), this.getAID());
            this.gui.showStatusMsg("Deregistration of agent: " + dFAgentDescription.getName().getName() + " done.");
        }
        catch (Exception exception) {}
    }

    void DFModify(DFAgentDescription dFAgentDescription) throws NotRegistered {
        Object object = this.agentDescriptions.register(dFAgentDescription.getName(), dFAgentDescription);
        if (object == null) {
            this.agentDescriptions.deregister(dFAgentDescription.getName());
            throw new NotRegistered();
        }
        this.subManager.handleChange(dFAgentDescription);
        try {
            this.gui.removeAgentDesc(dFAgentDescription.getName(), this.getAID());
            this.gui.addAgentDesc(dFAgentDescription.getName());
            this.gui.showStatusMsg("Modify of agent: " + dFAgentDescription.getName().getName() + " done.");
        }
        catch (Exception exception) {}
    }

    List DFSearch(DFAgentDescription dFAgentDescription, int n) {
        return this.agentDescriptions.search(dFAgentDescription, n);
    }

    void registerAction(Register register, AID aID) throws FIPAException {
        DFAgentDescription dFAgentDescription = (DFAgentDescription)register.getDescription();
        DFService.checkIsValid(dFAgentDescription, true);
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + aID.getName() + " requesting action Register for " + dFAgentDescription.getName());
        }
        if (dFAgentDescription.getName().equals(this.getAID())) {
            throw new Unauthorised();
        }
        this.DFRegister(dFAgentDescription);
        if (null == this.gatewayAID && this.isAGateway(dFAgentDescription)) {
            this.gatewayAID = dFAgentDescription.getName();
        }
    }

    void deregisterAction(Deregister deregister, AID aID) throws FIPAException {
        DFAgentDescription dFAgentDescription = (DFAgentDescription)deregister.getDescription();
        DFService.checkIsValid(dFAgentDescription, false);
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + aID.getName() + " requesting action Deregister for " + dFAgentDescription.getName());
        }
        this.DFDeregister(dFAgentDescription);
        if (dFAgentDescription.getName().equals(this.gatewayAID)) {
            this.gatewayAID = null;
        }
    }

    void modifyAction(Modify modify, AID aID) throws FIPAException {
        DFAgentDescription dFAgentDescription = (DFAgentDescription)modify.getDescription();
        DFService.checkIsValid(dFAgentDescription, true);
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + aID.getName() + " requesting action Modify for " + dFAgentDescription.getName());
        }
        this.DFModify(dFAgentDescription);
    }

    List searchAction(Search search, AID aID) throws FIPAException {
        DFAgentDescription dFAgentDescription = (DFAgentDescription)search.getDescription();
        SearchConstraints searchConstraints = search.getConstraints();
        List list = null;
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + aID.getName() + " requesting action Search");
        }
        this.checkSearchId(searchConstraints.getSearchId());
        int n = this.getActualMaxResults(searchConstraints);
        list = this.DFSearch(dFAgentDescription, n);
        if (list.size() < n) {
            Long l = searchConstraints.getMaxDepth();
            if (this.children.size() > 0 && l != null && l.intValue() > 0) {
                this.performRecursiveSearch(list, dFAgentDescription, searchConstraints, search);
                return null;
            }
        }
        return list;
    }

    void showGuiAction(ShowGui showGui, AID aID) throws FailureException {
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + aID.getName() + " requesting action ShowGui");
        }
        if (!this.showGui()) {
            throw new FailureException("Gui_is_being_shown_already");
        }
    }

    List getParentsAction(GetParents getParents, AID aID) {
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + aID + " requesting action GetParents.");
        }
        return this.parents;
    }

    List getDescriptionAction(GetDescription getDescription, AID aID) {
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + aID + " requesting action GetDescription.");
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.getDescriptionOfThisDF());
        return arrayList;
    }

    List getDescriptionUsedAction(GetDescriptionUsed getDescriptionUsed, AID aID) {
        AID aID2 = getDescriptionUsed.getParentDF();
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + aID + " requesting action GetDescriptionUsed to federate with " + aID2.getName());
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.getDescriptionOfThisDF(aID2));
        return arrayList;
    }

    void federateAction(final Federate federate, AID aID) {
        AID aID2 = federate.getDf();
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + aID + " requesting action Federate with DF " + aID2.getName());
        }
        Register register = new Register();
        DFAgentDescription dFAgentDescription = federate.getDescription();
        final DFAgentDescription dFAgentDescription2 = dFAgentDescription != null ? dFAgentDescription : this.getDescriptionOfThisDF();
        register.setDescription(dFAgentDescription2);
        RemoteDFRequester remoteDFRequester = new RemoteDFRequester(aID2, register){

            public int onEnd() {
                Object object = this.getResult();
                if (!(object instanceof InternalError)) {
                    df.this.addParent(this.getRemoteDF(), dFAgentDescription2);
                }
                df.this.sendPendingNotification(federate, object);
                return 0;
            }
        };
        this.addBehaviour(remoteDFRequester);
    }

    void registerWithAction(final RegisterWith registerWith, AID aID) {
        AID aID2 = registerWith.getDf();
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + aID + " requesting action RegisterWith on DF " + aID2.getName());
        }
        Register register = new Register();
        final DFAgentDescription dFAgentDescription = registerWith.getDescription();
        register.setDescription(dFAgentDescription);
        RemoteDFRequester remoteDFRequester = new RemoteDFRequester(aID2, register){

            public int onEnd() {
                Object object = this.getResult();
                if (!(object instanceof InternalError) && dFAgentDescription.getName().equals(this.myAgent.getAID())) {
                    df.this.addParent(this.getRemoteDF(), dFAgentDescription);
                }
                df.this.sendPendingNotification(registerWith, object);
                return 0;
            }
        };
        this.addBehaviour(remoteDFRequester);
    }

    void deregisterFromAction(final DeregisterFrom deregisterFrom, AID aID) {
        AID aID2 = deregisterFrom.getDf();
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + aID + " requesting action DeregisterFrom on DF " + aID2.getName());
        }
        Deregister deregister = new Deregister();
        final DFAgentDescription dFAgentDescription = deregisterFrom.getDescription();
        deregister.setDescription(dFAgentDescription);
        RemoteDFRequester remoteDFRequester = new RemoteDFRequester(aID2, deregister){

            public int onEnd() {
                Object object = this.getResult();
                if (!(object instanceof InternalError) && dFAgentDescription.getName().equals(this.myAgent.getAID())) {
                    df.this.removeParent(this.getRemoteDF());
                }
                df.this.sendPendingNotification(deregisterFrom, object);
                return 0;
            }
        };
        this.addBehaviour(remoteDFRequester);
    }

    void modifyOnAction(final ModifyOn modifyOn, AID aID) {
        AID aID2 = modifyOn.getDf();
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + aID + " requesting action ModifyOn on DF " + aID2.getName());
        }
        Modify modify = new Modify();
        modify.setDescription(modifyOn.getDescription());
        RemoteDFRequester remoteDFRequester = new RemoteDFRequester(aID2, modify){

            public int onEnd() {
                df.this.sendPendingNotification(modifyOn, this.getResult());
                return 0;
            }
        };
        this.addBehaviour(remoteDFRequester);
    }

    void searchOnAction(final SearchOn searchOn, AID aID) {
        AID aID2 = searchOn.getDf();
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + aID + " requesting action SearchOn on DF " + aID2.getName());
        }
        Search search = new Search();
        search.setDescription(searchOn.getDescription());
        search.setConstraints(searchOn.getConstraints());
        RemoteDFRequester remoteDFRequester = new RemoteDFRequester(aID2, search){

            public int onEnd() {
                df.this.sendPendingNotification(searchOn, this.getResult());
                return 0;
            }
        };
        this.addBehaviour(remoteDFRequester);
    }

    protected void onGuiEvent(GuiEvent guiEvent) {
        try {
            switch (guiEvent.getType()) {
                case 0: {
                    this.gui.disposeAsync();
                    this.gui = null;
                    this.doDelete();
                    break;
                }
                case 1: {
                    this.gui.disposeAsync();
                    this.gui = null;
                    break;
                }
                case 1001: {
                    AID aID = (AID)guiEvent.getParameter(0);
                    final DFAgentDescription dFAgentDescription = (DFAgentDescription)guiEvent.getParameter(1);
                    DFService.checkIsValid(dFAgentDescription, true);
                    if (this.getAID().equals(aID)) {
                        this.DFRegister(dFAgentDescription);
                        break;
                    }
                    this.gui.showStatusMsg("Processing your request & waiting for result...");
                    Register register = new Register();
                    register.setDescription(dFAgentDescription);
                    RemoteDFRequester remoteDFRequester = new RemoteDFRequester(aID, register){

                        public int onEnd() {
                            Object object = this.getResult();
                            if (!(object instanceof InternalError)) {
                                df.this.gui.showStatusMsg("Registration request processed. Ready for new request");
                                if (dFAgentDescription.getName().equals(this.myAgent.getAID())) {
                                    df.this.addParent(this.getRemoteDF(), dFAgentDescription);
                                }
                            } else {
                                df.this.gui.showStatusMsg("Error processing request. " + ((InternalError)object).getMessage());
                            }
                            return 0;
                        }
                    };
                    this.addBehaviour(remoteDFRequester);
                    break;
                }
                case 1002: {
                    AID aID = (AID)guiEvent.getParameter(0);
                    final DFAgentDescription dFAgentDescription = (DFAgentDescription)guiEvent.getParameter(1);
                    DFService.checkIsValid(dFAgentDescription, false);
                    if (this.getAID().equals(aID)) {
                        this.DFDeregister(dFAgentDescription);
                        break;
                    }
                    this.gui.showStatusMsg("Processing your request & waiting for result...");
                    Deregister deregister = new Deregister();
                    deregister.setDescription(dFAgentDescription);
                    RemoteDFRequester remoteDFRequester = new RemoteDFRequester(aID, deregister){

                        public int onEnd() {
                            Object object = this.getResult();
                            if (!(object instanceof InternalError)) {
                                df.this.gui.showStatusMsg("Deregistration request processed. Ready for new request");
                                if (dFAgentDescription.getName().equals(this.myAgent.getAID())) {
                                    df.this.removeParent(this.getRemoteDF());
                                } else {
                                    df.this.gui.removeSearchResult(dFAgentDescription.getName());
                                }
                            } else {
                                df.this.gui.showStatusMsg("Error processing request. " + ((InternalError)object).getMessage());
                            }
                            return 0;
                        }
                    };
                    this.addBehaviour(remoteDFRequester);
                    break;
                }
                case 1003: {
                    AID aID = (AID)guiEvent.getParameter(0);
                    DFAgentDescription dFAgentDescription = (DFAgentDescription)guiEvent.getParameter(1);
                    DFService.checkIsValid(dFAgentDescription, true);
                    if (this.getAID().equals(aID)) {
                        this.DFModify(dFAgentDescription);
                        break;
                    }
                    this.gui.showStatusMsg("Processing your request & waiting for result...");
                    Modify modify = new Modify();
                    modify.setDescription(dFAgentDescription);
                    RemoteDFRequester remoteDFRequester = new RemoteDFRequester(aID, modify){

                        public int onEnd() {
                            Object object = this.getResult();
                            if (!(object instanceof InternalError)) {
                                df.this.gui.showStatusMsg("Modification request processed. Ready for new request");
                            } else {
                                df.this.gui.showStatusMsg("Error processing request. " + ((InternalError)object).getMessage());
                            }
                            return 0;
                        }
                    };
                    this.addBehaviour(remoteDFRequester);
                    break;
                }
                case 1004: {
                    AID aID = (AID)guiEvent.getParameter(0);
                    DFAgentDescription dFAgentDescription = (DFAgentDescription)guiEvent.getParameter(1);
                    SearchConstraints searchConstraints = (SearchConstraints)guiEvent.getParameter(2);
                    this.gui.showStatusMsg("Processing your request & waiting for result...");
                    Search search = new Search();
                    search.setDescription(dFAgentDescription);
                    search.setConstraints(searchConstraints);
                    RemoteDFRequester remoteDFRequester = new RemoteDFRequester(aID, search){

                        public int onEnd() {
                            Object object = this.getResult();
                            if (!(object instanceof InternalError)) {
                                df.this.gui.showStatusMsg("Search request processed. Ready for new request");
                                df.this.gui.refreshLastSearchResults((List)object, this.getRemoteDF());
                            } else {
                                df.this.gui.showStatusMsg("Error processing request. " + ((InternalError)object).getMessage());
                            }
                            return 0;
                        }
                    };
                    this.addBehaviour(remoteDFRequester);
                    break;
                }
                case 1005: {
                    AID aID = (AID)guiEvent.getParameter(0);
                    final DFAgentDescription dFAgentDescription = (DFAgentDescription)guiEvent.getParameter(1);
                    this.gui.showStatusMsg("Processing your request & waiting for result...");
                    Register register = new Register();
                    register.setDescription(dFAgentDescription);
                    RemoteDFRequester remoteDFRequester = new RemoteDFRequester(aID, register){

                        public int onEnd() {
                            Object object = this.getResult();
                            if (!(object instanceof InternalError)) {
                                df.this.gui.showStatusMsg("Federation request processed. Ready for new request");
                                df.this.addParent(this.getRemoteDF(), dFAgentDescription);
                            } else {
                                df.this.gui.showStatusMsg("Error processing request. " + ((InternalError)object).getMessage());
                            }
                            return 0;
                        }
                    };
                    this.addBehaviour(remoteDFRequester);
                }
            }
        }
        catch (FIPAException fIPAException) {
            this.gui.showStatusMsg("Error processing request. " + fIPAException.getMessage());
            fIPAException.printStackTrace();
        }
    }

    public DFAgentDescription getDFAgentDsc(AID aID) throws FIPAException {
        DFAgentDescription dFAgentDescription = new DFAgentDescription();
        dFAgentDescription.setName(aID);
        List list = this.agentDescriptions.search(dFAgentDescription);
        if (list.isEmpty()) {
            return null;
        }
        return (DFAgentDescription)list.get(0);
    }

    public DFAgentDescription getDescriptionOfThisDF() {
        return this.myDescription;
    }

    public DFAgentDescription getDescriptionOfThisDF(AID aID) {
        return (DFAgentDescription)this.dscDFParentMap.get(aID);
    }

    protected boolean showGui() {
        if (this.gui == null) {
            try {
                Class<?> clazz = Class.forName("jade.tools.dfgui.DFGUI");
                this.gui = (DFGUIInterface)clazz.newInstance();
                this.gui.setAdapter(this);
                DFAgentDescription dFAgentDescription = new DFAgentDescription();
                List list = this.agentDescriptions.search(dFAgentDescription);
                ArrayList arrayList = new ArrayList();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(((DFAgentDescription)iterator.next()).getName());
                }
                this.gui.refresh(arrayList.iterator(), this.parents.iterator(), this.children.iterator());
                this.gui.setVisible(true);
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    private DFAgentDescription getDefaultDescription() {
        DFAgentDescription dFAgentDescription = new DFAgentDescription();
        dFAgentDescription.setName(this.getAID());
        dFAgentDescription.addOntologies(FIPAManagementOntology.getInstance().getName());
        dFAgentDescription.addLanguages("fipa-sl0");
        dFAgentDescription.addProtocols("fipa-request");
        ServiceDescription serviceDescription = new ServiceDescription();
        serviceDescription.setName("df-service");
        serviceDescription.setType("fipa-df");
        serviceDescription.addOntologies(FIPAManagementOntology.getInstance().getName());
        serviceDescription.addLanguages("fipa-sl0");
        serviceDescription.addProtocols("fipa-request");
        try {
            serviceDescription.setOwnership(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            serviceDescription.setOwnership("unknown");
        }
        dFAgentDescription.addServices(serviceDescription);
        return dFAgentDescription;
    }

    protected void setDescriptionOfThisDF(DFAgentDescription dFAgentDescription) {
        this.myDescription = dFAgentDescription;
        this.myDescription.setName(this.getAID());
        if (!this.isADF(this.myDescription) && this.logger.isLoggable(Logger.WARNING)) {
            this.logger.log(Logger.WARNING, "The description set for this DF does not include a \"fipa-df\" service.");
        }
    }

    protected void addParent(AID aID, DFAgentDescription dFAgentDescription) {
        this.parents.add(aID);
        if (this.gui != null) {
            this.gui.addParent(aID);
        }
        this.dscDFParentMap.put(aID, dFAgentDescription);
    }

    protected void removeParent(AID aID) {
        this.parents.remove(aID);
        if (this.gui != null) {
            this.gui.removeParent(aID);
        }
        this.dscDFParentMap.remove(aID);
    }

    void storePendingRequest(Object object, ACLMessage aCLMessage) {
        this.pendingRequests.put(object, aCLMessage);
    }

    private void sendPendingNotification(Concept concept, Object object) {
        ACLMessage aCLMessage = (ACLMessage)this.pendingRequests.remove(concept);
        if (aCLMessage != null) {
            jade.util.leap.Serializable serializable;
            ACLMessage aCLMessage2 = aCLMessage.createReply();
            ContentElement contentElement = null;
            Action action = new Action(this.getAID(), concept);
            if (object instanceof InternalError) {
                aCLMessage2.setPerformative(6);
                serializable = new ContentElementList();
                ((ContentElementList)serializable).add(action);
                ((ContentElementList)serializable).add((Predicate)object);
                contentElement = serializable;
            } else {
                aCLMessage2.setPerformative(7);
                contentElement = object != null ? new Result(action, object) : new Done(action);
            }
            try {
                this.getContentManager().fillContent(aCLMessage2, contentElement);
                this.send(aCLMessage2);
                serializable = (AID)aCLMessage2.getAllReceiver().next();
                if (this.logger.isLoggable(Logger.FINE)) {
                    this.logger.log(Logger.FINE, "Notification sent back to " + ((AID)serializable).getName());
                }
            }
            catch (Exception exception) {
                if (this.logger.isLoggable(Logger.SEVERE)) {
                    this.logger.log(Logger.SEVERE, "Error encoding pending notification content.");
                }
                exception.printStackTrace();
            }
        } else if (this.logger.isLoggable(Logger.WARNING)) {
            this.logger.log(Logger.WARNING, "Processed action request not found.");
        }
    }

    private int getActualMaxResults(SearchConstraints searchConstraints) {
        int n = searchConstraints.getMaxResults() == null ? 1 : searchConstraints.getMaxResults().intValue();
        n = n < 0 ? this.maxResultLimit : n;
        return n;
    }

    private void checkSearchId(String string) throws FIPAException {
        if (string != null) {
            if (this.searchIdCache.contains(string)) {
                throw new InternalError("search-id already served");
            }
            this.searchIdCache.add(string);
        }
    }

    private boolean isADF(DFAgentDescription dFAgentDescription) {
        try {
            return ((ServiceDescription)dFAgentDescription.getAllServices().next()).getType().equalsIgnoreCase("fipa-df");
        }
        catch (Exception exception) {
            return false;
        }
    }

    void addGatewayIfNeeded(ACLMessage aCLMessage, ACLMessage aCLMessage2) {
        if (null != this.gatewayAID && !this.isFromGatewayRegistered(aCLMessage)) {
            aCLMessage2.addReceiver(this.gatewayAID);
        }
    }

    private boolean isFromGatewayRegistered(ACLMessage aCLMessage) {
        return aCLMessage.getSender().equals(this.gatewayAID);
    }

    private boolean isAGateway(DFAgentDescription dFAgentDescription) {
        return dFAgentDescription.getName().getLocalName().equalsIgnoreCase(GATEWAY_LOCAL_NAME);
    }

    private class RecursiveSearchHandler
    extends AchieveREInitiator {
        private static final long DEFAULTTIMEOUT = 300000L;
        private List results;
        private DFAgentDescription template;
        private SearchConstraints constraints;
        private Search action;
        private int maxExpectedResults;
        private int receivedResults;

        private RecursiveSearchHandler(List list, DFAgentDescription dFAgentDescription, SearchConstraints searchConstraints, Search search) {
            super(df.this, null);
            this.results = list;
            this.template = dFAgentDescription;
            this.constraints = searchConstraints;
            this.action = search;
            this.maxExpectedResults = searchConstraints.getMaxResults().intValue();
            this.receivedResults = 0;
        }

        protected Vector prepareRequests(ACLMessage aCLMessage) {
            Vector<ACLMessage> vector = null;
            ACLMessage aCLMessage2 = (ACLMessage)df.this.pendingRequests.get(this.action);
            if (aCLMessage2 != null) {
                Date date = aCLMessage2.getReplyByDate();
                if (date == null) {
                    date = new Date(System.currentTimeMillis() + 300000L);
                }
                vector = new Vector<ACLMessage>(df.this.children.size());
                Iterator iterator = df.this.children.iterator();
                while (iterator.hasNext()) {
                    AID aID = (AID)iterator.next();
                    ACLMessage aCLMessage3 = DFService.createRequestMessage(this.myAgent, aID, "search", this.template, this.constraints);
                    aCLMessage3.setReplyByDate(date);
                    vector.addElement(aCLMessage3);
                }
            }
            return vector;
        }

        protected void handleInform(ACLMessage aCLMessage) {
            int n;
            block8: {
                if (df.this.logger.isLoggable(Logger.CONFIG)) {
                    df.this.logger.log(Logger.CONFIG, "Recursive search result received from " + aCLMessage.getSender().getName() + ".");
                }
                n = 0;
                if (this.receivedResults < this.maxExpectedResults) {
                    try {
                        DFAgentDescription[] dFAgentDescriptionArray = DFService.decodeResult(aCLMessage.getContent());
                        int n2 = 0;
                        while (n2 < dFAgentDescriptionArray.length) {
                            if (this.addResult(dFAgentDescriptionArray[n2])) {
                                ++this.receivedResults;
                                ++n;
                                if (this.receivedResults >= this.maxExpectedResults) {
                                    df.this.sendPendingNotification(this.action, this.results);
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (Exception exception) {
                        if (!df.this.logger.isLoggable(Logger.SEVERE)) break block8;
                        df.this.logger.log(Logger.SEVERE, "WARNING: Error decoding reply from federated DF " + aCLMessage.getSender().getName() + " during recursive search [" + exception.toString() + "].");
                    }
                }
            }
            if (df.this.logger.isLoggable(Logger.CONFIG)) {
                df.this.logger.log(Logger.CONFIG, n + " new items found in recursive search.");
            }
        }

        protected void handleRefuse(ACLMessage aCLMessage) {
            if (df.this.logger.isLoggable(Logger.WARNING)) {
                df.this.logger.log(Logger.WARNING, "REFUSE received from federated DF " + aCLMessage.getSender().getName() + " during recursive search.");
            }
        }

        protected void handleFailure(ACLMessage aCLMessage) {
            if (df.this.logger.isLoggable(Logger.WARNING)) {
                df.this.logger.log(Logger.WARNING, "FAILURE received from federated DF " + aCLMessage.getSender().getName() + " during recursive search.");
            }
        }

        protected void handleNotUnderstood(ACLMessage aCLMessage) {
            if (df.this.logger.isLoggable(Logger.WARNING)) {
                df.this.logger.log(Logger.WARNING, "NOT_UNDERSTOOD received from federated DF " + aCLMessage.getSender().getName() + " during recursive search.");
            }
        }

        protected void handleOutOfSequence(ACLMessage aCLMessage) {
            if (df.this.logger.isLoggable(Logger.WARNING)) {
                df.this.logger.log(Logger.WARNING, "Out of sequence message " + ACLMessage.getPerformative(aCLMessage.getPerformative()) + " received from " + aCLMessage.getSender().getName() + " during recursive search.");
            }
        }

        public int onEnd() {
            if (this.receivedResults < this.maxExpectedResults) {
                df.this.sendPendingNotification(this.action, this.results);
            }
            return super.onEnd();
        }

        private boolean addResult(DFAgentDescription dFAgentDescription) {
            Iterator iterator = this.results.iterator();
            while (iterator.hasNext()) {
                DFAgentDescription dFAgentDescription2 = (DFAgentDescription)iterator.next();
                if (!dFAgentDescription2.getName().equals(dFAgentDescription.getName())) continue;
                return false;
            }
            this.results.add(dFAgentDescription);
            return true;
        }
    }
}

