/*
 * Decompiled with CFR 0.152.
 */
package jade.core.replication;

import jade.core.AID;
import jade.core.AgentContainer;
import jade.core.BaseService;
import jade.core.ContainerID;
import jade.core.Filter;
import jade.core.GenericCommand;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.MainContainerImpl;
import jade.core.NameClashException;
import jade.core.Node;
import jade.core.NodeDescriptor;
import jade.core.NodeEventListener;
import jade.core.NodeFailureMonitor;
import jade.core.NotFoundException;
import jade.core.PlatformManager;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.Sink;
import jade.core.VerticalCommand;
import jade.core.replication.MainReplicationSlice;
import jade.domain.FIPAAgentManagement.AMSAgentDescription;
import jade.mtp.MTPDescriptor;
import jade.security.Credentials;
import jade.security.JADEPrincipal;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.Iterator;
import jade.util.leap.LinkedList;
import jade.util.leap.List;

public class MainReplicationService
extends BaseService {
    private static final boolean EXCLUDE_MYSELF = false;
    private static final boolean INCLUDE_MYSELF = true;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());
    private static final String[] OWNED_COMMANDS = new String[0];
    private AgentContainer myContainer;
    private ServiceComponent localSlice;
    private Filter outFilter;
    private Filter inFilter;
    private int myLabel = -1;
    private final List replicas = new LinkedList();
    private MainContainerImpl myMain;
    private PlatformManager myPlatformManager;

    public void init(AgentContainer agentContainer, Profile profile) throws ProfileException {
        super.init(agentContainer, profile);
        this.myContainer = agentContainer;
        this.localSlice = new ServiceComponent();
        this.outFilter = new CommandOutgoingFilter();
        this.inFilter = new CommandIncomingFilter();
    }

    public String getName() {
        return "jade.core.replication.MainReplication";
    }

    public Class getHorizontalInterface() {
        try {
            return Class.forName("jade.core.replication.MainReplicationSlice");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    public Filter getCommandFilter(boolean bl) {
        if (bl) {
            return this.outFilter;
        }
        return this.inFilter;
    }

    public Sink getCommandSink(boolean bl) {
        return null;
    }

    public String[] getOwnedCommands() {
        return OWNED_COMMANDS;
    }

    public void boot(Profile profile) throws ServiceException {
        try {
            Service.Slice[] sliceArray = this.getAllSlices();
            this.myLabel = sliceArray.length - 1;
            MainReplicationSlice[] mainReplicationSliceArray = new MainReplicationSlice[sliceArray.length];
            String string = this.getLocalNode().getName();
            int n = 0;
            while (n < sliceArray.length) {
                try {
                    MainReplicationSlice mainReplicationSlice = (MainReplicationSlice)sliceArray[n];
                    String string2 = mainReplicationSlice.getNode().getName();
                    int n2 = mainReplicationSlice.getLabel();
                    mainReplicationSliceArray[n2] = mainReplicationSlice;
                    if (!string2.equals(string)) {
                        mainReplicationSlice.addReplica(string, this.myPlatformManager.getLocalAddress(), this.myLabel);
                    }
                    if (n2 == this.myLabel - 1) {
                        this.localSlice.attachTo(n2, mainReplicationSlice);
                    }
                }
                catch (IMTPException iMTPException) {
                    // empty catch block
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < mainReplicationSliceArray.length) {
                this.replicas.add(mainReplicationSliceArray[n3]);
                ++n3;
            }
        }
        catch (IMTPException iMTPException) {
            throw new ServiceException("An error occurred during service startup.", iMTPException);
        }
    }

    private void broadcastToReplicas(HorizontalCommand horizontalCommand, boolean bl) throws IMTPException, ServiceException {
        Object[] objectArray = this.replicas.toArray();
        String string = this.getLocalNode().getName();
        int n = 0;
        while (n < objectArray.length) {
            MainReplicationSlice mainReplicationSlice = (MainReplicationSlice)objectArray[n];
            String string2 = mainReplicationSlice.getNode().getName();
            if (bl || !string2.equals(string)) {
                mainReplicationSlice.serve(horizontalCommand);
                Object object = horizontalCommand.getReturnValue();
                if (object instanceof Throwable) {
                    if (this.logger.isLoggable(Logger.SEVERE)) {
                        this.logger.log(Logger.SEVERE, "Error propagating H-command " + horizontalCommand.getName() + " to slice " + string2);
                    }
                    ((Throwable)object).printStackTrace();
                }
            }
            ++n;
        }
    }

    private class ServiceComponent
    implements Service.Slice,
    NodeEventListener {
        private NodeFailureMonitor nodeMonitor;
        private int monitoredLabel;
        private String monitoredSvcMgr;

        public ServiceComponent() {
            MainReplicationService.this.myMain = (MainContainerImpl)MainReplicationService.this.myContainer.getMain();
            MainReplicationService.this.myPlatformManager = MainReplicationService.this.myMain.getPlatformManager();
        }

        private void attachTo(int n, MainReplicationSlice mainReplicationSlice) throws IMTPException, ServiceException {
            if (this.nodeMonitor != null) {
                if (MainReplicationService.this.logger.isLoggable(Logger.CONFIG)) {
                    MainReplicationService.this.logger.log(Logger.CONFIG, "Stop monitoring node <" + this.nodeMonitor.getNode().getName() + ">");
                }
                this.nodeMonitor.stop();
            }
            this.monitoredLabel = n;
            if (this.monitoredLabel == MainReplicationService.this.myLabel) {
                return;
            }
            this.monitoredSvcMgr = mainReplicationSlice.getPlatformManagerAddress();
            this.nodeMonitor = NodeFailureMonitor.getFailureMonitor();
            this.nodeMonitor.start(mainReplicationSlice.getNode(), this);
        }

        public Service getService() {
            return MainReplicationService.this;
        }

        public Node getNode() throws ServiceException {
            try {
                return MainReplicationService.this.getLocalNode();
            }
            catch (IMTPException iMTPException) {
                throw new ServiceException("Problem in contacting the IMTP Manager", iMTPException);
            }
        }

        public VerticalCommand serve(HorizontalCommand horizontalCommand) {
            try {
                String string = horizontalCommand.getName();
                Object[] objectArray = horizontalCommand.getParams();
                if (string.equals("1")) {
                    Integer n = new Integer(this.getLabel());
                    horizontalCommand.setReturnValue(n);
                } else if (string.equals("2")) {
                    horizontalCommand.setReturnValue(this.getPlatformManagerAddress());
                } else if (string.equals("3")) {
                    String string2 = (String)objectArray[0];
                    String string3 = (String)objectArray[1];
                    int n = (Integer)objectArray[2];
                    this.addReplica(string2, string3, n);
                } else if (string.equals("4")) {
                    String string4 = (String)objectArray[0];
                    int n = (Integer)objectArray[1];
                    this.removeReplica(string4, n);
                } else if (string.equals("5")) {
                    AID[] aIDArray = (AID[])objectArray[0];
                    ContainerID[] containerIDArray = (ContainerID[])objectArray[1];
                    this.fillGADT(aIDArray, containerIDArray);
                } else if (string.equals("6")) {
                    AID aID = (AID)objectArray[0];
                    ContainerID containerID = (ContainerID)objectArray[1];
                    this.bornAgent(aID, containerID, horizontalCommand.getPrincipal(), horizontalCommand.getCredentials());
                } else if (string.equals("7")) {
                    AID aID = (AID)objectArray[0];
                    this.deadAgent(aID);
                } else if (string.equals("8")) {
                    AID aID = (AID)objectArray[0];
                    this.suspendedAgent(aID);
                } else if (string.equals("9")) {
                    AID aID = (AID)objectArray[0];
                    this.resumedAgent(aID);
                } else if (string.equals("10")) {
                    MTPDescriptor mTPDescriptor = (MTPDescriptor)objectArray[0];
                    ContainerID containerID = (ContainerID)objectArray[1];
                    this.newMTP(mTPDescriptor, containerID);
                } else if (string.equals("11")) {
                    MTPDescriptor mTPDescriptor = (MTPDescriptor)objectArray[0];
                    ContainerID containerID = (ContainerID)objectArray[1];
                    this.deadMTP(mTPDescriptor, containerID);
                } else if (string.equals("12")) {
                    AID aID = (AID)objectArray[0];
                    this.newTool(aID);
                } else if (string.equals("13")) {
                    AID aID = (AID)objectArray[0];
                    this.deadTool(aID);
                }
            }
            catch (Throwable throwable) {
                horizontalCommand.setReturnValue(throwable);
            }
            return null;
        }

        private int getLabel() throws IMTPException {
            return MainReplicationService.this.myLabel;
        }

        private String getPlatformManagerAddress() throws IMTPException {
            return MainReplicationService.this.myPlatformManager.getLocalAddress();
        }

        private void addReplica(String string, String string2, int n) throws IMTPException, ServiceException {
            MainReplicationSlice mainReplicationSlice = (MainReplicationSlice)MainReplicationService.this.getSlice(string);
            MainReplicationService.this.replicas.add(n, mainReplicationSlice);
            if (MainReplicationService.this.myLabel == 0) {
                AID[] aIDArray;
                this.attachTo(n, mainReplicationSlice);
                AID[] aIDArray2 = MainReplicationService.this.myMain.agentNames();
                ContainerID[] containerIDArray = new ContainerID[aIDArray2.length];
                int n2 = 0;
                while (n2 < aIDArray2.length) {
                    try {
                        containerIDArray[n2] = MainReplicationService.this.myMain.getContainerID(aIDArray2[n2]);
                    }
                    catch (NotFoundException notFoundException) {
                        notFoundException.printStackTrace();
                    }
                    ++n2;
                }
                mainReplicationSlice.fillGADT(aIDArray2, containerIDArray);
                AMSAgentDescription aMSAgentDescription = new AMSAgentDescription();
                aMSAgentDescription.setState("suspended");
                List list = MainReplicationService.this.myMain.amsSearch(aMSAgentDescription, -1L);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    aIDArray = (AID[])iterator.next();
                    try {
                        mainReplicationSlice.suspendedAgent(aIDArray.getName());
                    }
                    catch (NotFoundException notFoundException) {
                        notFoundException.printStackTrace();
                    }
                }
                aIDArray = MainReplicationService.this.myMain.agentTools();
                int n3 = 0;
                while (n3 < aIDArray.length) {
                    mainReplicationSlice.newTool(aIDArray[n3]);
                    ++n3;
                }
            }
        }

        private void removeReplica(String string, int n) throws IMTPException {
            MainReplicationService.this.replicas.remove(n);
            this.adjustLabels(n);
        }

        private void adjustLabels(int n) {
            if (n < MainReplicationService.this.myLabel) {
                MainReplicationService.this.myLabel--;
                --this.monitoredLabel;
                if (this.monitoredLabel == -1) {
                    this.monitoredLabel += MainReplicationService.this.replicas.size();
                }
            } else if (MainReplicationService.this.myLabel == 0) {
                --this.monitoredLabel;
            }
        }

        private void fillGADT(AID[] aIDArray, ContainerID[] containerIDArray) throws JADESecurityException {
            int n = 0;
            while (n < aIDArray.length) {
                try {
                    MainReplicationService.this.myMain.bornAgent(aIDArray[n], containerIDArray[n], null, null, true);
                    if (MainReplicationService.this.logger.isLoggable(Logger.CONFIG)) {
                        MainReplicationService.this.logger.log(Logger.CONFIG, "Agent " + aIDArray[n].getName() + " inserted into GADT");
                    }
                }
                catch (NotFoundException notFoundException) {
                    notFoundException.printStackTrace();
                }
                catch (NameClashException nameClashException) {
                    nameClashException.printStackTrace();
                }
                ++n;
            }
        }

        private void bornAgent(AID aID, ContainerID containerID, JADEPrincipal jADEPrincipal, Credentials credentials) throws NameClashException, NotFoundException {
            block7: {
                JADEPrincipal jADEPrincipal2;
                String string = "NONE";
                if (credentials != null && (jADEPrincipal2 = credentials.getOwner()) != null) {
                    string = jADEPrincipal2.getName();
                }
                try {
                    MainReplicationService.this.myMain.bornAgent(aID, containerID, jADEPrincipal, string, false);
                    if (MainReplicationService.this.logger.isLoggable(Logger.CONFIG)) {
                        MainReplicationService.this.logger.log(Logger.CONFIG, "Agent " + aID.getName() + " inserted into GADT");
                    }
                }
                catch (NameClashException nameClashException) {
                    try {
                        ContainerID containerID2 = MainReplicationService.this.myMain.getContainerID(aID);
                        Node node = MainReplicationService.this.myMain.getContainerNode(containerID2).getNode();
                        node.ping(false);
                        throw nameClashException;
                    }
                    catch (NameClashException nameClashException2) {
                        throw nameClashException2;
                    }
                    catch (Exception exception) {
                        MainReplicationService.this.myMain.bornAgent(aID, containerID, jADEPrincipal, string, true);
                        if (!MainReplicationService.this.logger.isLoggable(Logger.CONFIG)) break block7;
                        MainReplicationService.this.logger.log(Logger.CONFIG, "Agent " + aID.getName() + " inserted into GADT");
                    }
                }
            }
        }

        private void deadAgent(AID aID) throws NotFoundException {
            MainReplicationService.this.myMain.deadAgent(aID);
        }

        private void suspendedAgent(AID aID) throws NotFoundException {
            MainReplicationService.this.myMain.suspendedAgent(aID);
        }

        private void resumedAgent(AID aID) throws NotFoundException {
            MainReplicationService.this.myMain.resumedAgent(aID);
        }

        private void newMTP(MTPDescriptor mTPDescriptor, ContainerID containerID) throws IMTPException {
            MainReplicationService.this.myMain.newMTP(mTPDescriptor, containerID);
        }

        private void deadMTP(MTPDescriptor mTPDescriptor, ContainerID containerID) throws IMTPException {
            MainReplicationService.this.myMain.deadMTP(mTPDescriptor, containerID);
        }

        private void newTool(AID aID) throws IMTPException {
            MainReplicationService.this.myMain.toolAdded(aID);
        }

        private void deadTool(AID aID) throws IMTPException {
            MainReplicationService.this.myMain.toolRemoved(aID);
        }

        public void dumpReplicas() {
            try {
                System.out.println("--- " + MainReplicationService.this.getLocalNode().getName() + "[" + MainReplicationService.this.myLabel + "] ---");
                System.out.println("--- Monitoring node [" + this.monitoredLabel + "] ---");
                System.out.println("--- Replica list ---");
                Object[] objectArray = MainReplicationService.this.replicas.toArray();
                int n = 0;
                while (n < objectArray.length) {
                    MainReplicationSlice mainReplicationSlice = (MainReplicationSlice)objectArray[n];
                    System.out.println("----- " + mainReplicationSlice.getNode().getName() + "[" + n + "] -----");
                    ++n;
                }
                System.out.println("--- End ---");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        private void dumpGADT() {
            AID[] aIDArray = MainReplicationService.this.myMain.agentNames();
            System.out.println("--- Agent List ---");
            int n = 0;
            while (n < aIDArray.length) {
                System.out.println("    Agent: " + aIDArray[n].getLocalName());
                ++n;
            }
            System.out.println("------------------");
        }

        public void nodeAdded(Node node) {
            if (MainReplicationService.this.logger.isLoggable(Logger.CONFIG)) {
                MainReplicationService.this.logger.log(Logger.CONFIG, "Start monitoring node <" + node.getName() + ">");
            }
        }

        public void nodeRemoved(Node node) {
            if (MainReplicationService.this.logger.isLoggable(Logger.CONFIG)) {
                MainReplicationService.this.logger.log(Logger.CONFIG, "Node <" + node.getName() + "> TERMINATED");
            }
            try {
                MainReplicationService.this.myPlatformManager.removeReplica(this.monitoredSvcMgr, false);
                MainReplicationService.this.myPlatformManager.removeNode(new NodeDescriptor(node), false);
                MainReplicationService.this.replicas.remove(this.monitoredLabel);
                GenericCommand genericCommand = new GenericCommand("4", "jade.core.replication.MainReplication", null);
                genericCommand.addParam(this.monitoredSvcMgr);
                genericCommand.addParam(new Integer(this.monitoredLabel));
                MainReplicationService.this.broadcastToReplicas(genericCommand, false);
                int n = MainReplicationService.this.myLabel;
                this.adjustLabels(this.monitoredLabel);
                MainReplicationSlice mainReplicationSlice = (MainReplicationSlice)MainReplicationService.this.replicas.get(this.monitoredLabel);
                this.attachTo(this.monitoredLabel, mainReplicationSlice);
                if (n != 0 && MainReplicationService.this.myLabel == 0) {
                    if (MainReplicationService.this.logger.isLoggable(Logger.INFO)) {
                        MainReplicationService.this.logger.log(Logger.INFO, "-- I'm the new leader ---");
                    }
                    MainReplicationService.this.myContainer.becomeLeader();
                }
            }
            catch (IMTPException iMTPException) {
                iMTPException.printStackTrace();
            }
            catch (ServiceException serviceException) {
                serviceException.printStackTrace();
            }
        }

        public void nodeUnreachable(Node node) {
            if (MainReplicationService.this.logger.isLoggable(Logger.CONFIG)) {
                MainReplicationService.this.logger.log(Logger.CONFIG, "Node <" + node.getName() + "> UNREACHABLE");
            }
        }

        public void nodeReachable(Node node) {
            if (MainReplicationService.this.logger.isLoggable(Logger.CONFIG)) {
                MainReplicationService.this.logger.log(Logger.CONFIG, "Node <" + node.getName() + "> REACHABLE");
            }
        }
    }

    private class CommandIncomingFilter
    extends Filter {
        private CommandIncomingFilter() {
        }

        public boolean accept(VerticalCommand verticalCommand) {
            try {
                String string = verticalCommand.getName();
                if (string.equals("Inform-Created")) {
                    this.handleInformCreated(verticalCommand);
                } else if (string.equals("Inform-Killed")) {
                    this.handleInformKilled(verticalCommand);
                } else if (string.equals("Inform-State-Changed")) {
                    this.handleInformStateChanged(verticalCommand);
                } else if (string.equals("New-MTP")) {
                    this.handleNewMTP(verticalCommand);
                } else if (string.equals("Dead-MTP")) {
                    this.handleDeadMTP(verticalCommand);
                }
            }
            catch (Throwable throwable) {
                verticalCommand.setReturnValue(throwable);
            }
            return true;
        }

        private void handleInformCreated(VerticalCommand verticalCommand) throws IMTPException, NotFoundException, NameClashException, JADESecurityException, ServiceException {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            ContainerID containerID = (ContainerID)objectArray[1];
            GenericCommand genericCommand = new GenericCommand("6", "jade.core.replication.MainReplication", null);
            genericCommand.addParam(aID);
            genericCommand.addParam(containerID);
            genericCommand.setPrincipal(verticalCommand.getPrincipal());
            genericCommand.setCredentials(verticalCommand.getCredentials());
            MainReplicationService.this.broadcastToReplicas(genericCommand, false);
        }

        private void handleInformKilled(VerticalCommand verticalCommand) throws IMTPException, NotFoundException, ServiceException {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            GenericCommand genericCommand = new GenericCommand("7", "jade.core.replication.MainReplication", null);
            genericCommand.addParam(aID);
            MainReplicationService.this.broadcastToReplicas(genericCommand, false);
        }

        private void handleInformStateChanged(VerticalCommand verticalCommand) throws IMTPException, NotFoundException, ServiceException {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            String string = (String)objectArray[1];
            if (string.equals("suspended")) {
                GenericCommand genericCommand = new GenericCommand("8", "jade.core.replication.MainReplication", null);
                genericCommand.addParam(aID);
                MainReplicationService.this.broadcastToReplicas(genericCommand, false);
            } else if (string.equals("active")) {
                GenericCommand genericCommand = new GenericCommand("9", "jade.core.replication.MainReplication", null);
                genericCommand.addParam(aID);
                MainReplicationService.this.broadcastToReplicas(genericCommand, false);
            }
        }

        private void handleNewMTP(VerticalCommand verticalCommand) throws IMTPException, ServiceException {
            Object[] objectArray = verticalCommand.getParams();
            MTPDescriptor mTPDescriptor = (MTPDescriptor)objectArray[0];
            ContainerID containerID = (ContainerID)objectArray[1];
            GenericCommand genericCommand = new GenericCommand("10", "jade.core.replication.MainReplication", null);
            genericCommand.addParam(mTPDescriptor);
            genericCommand.addParam(containerID);
            MainReplicationService.this.broadcastToReplicas(genericCommand, false);
        }

        private void handleDeadMTP(VerticalCommand verticalCommand) throws IMTPException, ServiceException {
            Object[] objectArray = verticalCommand.getParams();
            MTPDescriptor mTPDescriptor = (MTPDescriptor)objectArray[0];
            ContainerID containerID = (ContainerID)objectArray[1];
            GenericCommand genericCommand = new GenericCommand("11", "jade.core.replication.MainReplication", null);
            genericCommand.addParam(mTPDescriptor);
            genericCommand.addParam(containerID);
            MainReplicationService.this.broadcastToReplicas(genericCommand, false);
        }

        public void setBlocking(boolean bl) {
        }

        public boolean isBlocking() {
            return false;
        }

        public void setSkipping(boolean bl) {
        }

        public boolean isSkipping() {
            return false;
        }
    }

    private class CommandOutgoingFilter
    extends Filter {
        private CommandOutgoingFilter() {
        }

        public boolean accept(VerticalCommand verticalCommand) {
            try {
                String string = verticalCommand.getName();
                if (string.equals("Add-Tool")) {
                    this.handleNewTool(verticalCommand);
                } else if (string.equals("Remove-Tool")) {
                    this.handleDeadTool(verticalCommand);
                }
            }
            catch (IMTPException iMTPException) {
                verticalCommand.setReturnValue(iMTPException);
            }
            catch (ServiceException serviceException) {
                verticalCommand.setReturnValue(serviceException);
            }
            return true;
        }

        private void handleNewTool(VerticalCommand verticalCommand) throws IMTPException, ServiceException {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            GenericCommand genericCommand = new GenericCommand("12", "jade.core.replication.MainReplication", null);
            genericCommand.addParam(aID);
            MainReplicationService.this.broadcastToReplicas(genericCommand, false);
        }

        private void handleDeadTool(VerticalCommand verticalCommand) throws IMTPException, ServiceException {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            GenericCommand genericCommand = new GenericCommand("13", "jade.core.replication.MainReplication", null);
            genericCommand.addParam(aID);
            MainReplicationService.this.broadcastToReplicas(genericCommand, false);
        }

        public void setBlocking(boolean bl) {
        }

        public boolean isBlocking() {
            return false;
        }

        public void setSkipping(boolean bl) {
        }

        public boolean isSkipping() {
            return false;
        }
    }
}

