/*
 * Decompiled with CFR 0.152.
 */
package jade.core.nodeMonitoring;

import jade.core.Profile;
import jade.core.nodeMonitoring.UDPNodeFailureMonitor;
import jade.util.Logger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

class UDPMonitorServer {
    private static UDPMonitorServer instance;
    private Logger logger;
    private static int port;
    private static int pingDelayLimit;
    private static int unreachLimit;
    private DatagramChannel server;
    private Selector selector;
    private Map targets;
    private PingHandler pingHandler;
    private Timer timer;
    private HashMap deadlines;

    UDPMonitorServer(int n, int n2, int n3) {
        block2: {
            port = n;
            pingDelayLimit = n2;
            unreachLimit = n3;
            this.logger = Logger.getMyLogger(this.getClass().getName());
            this.deadlines = new HashMap();
            this.targets = new HashMap();
            try {
                this.server = DatagramChannel.open();
            }
            catch (IOException iOException) {
                if (!this.logger.isLoggable(Logger.SEVERE)) break block2;
                this.logger.log(Logger.SEVERE, "Cannot open UDP channel.");
            }
        }
    }

    private synchronized void startServer() {
        block4: {
            try {
                this.server.configureBlocking(false);
                this.server.socket().setReuseAddress(true);
                this.server.socket().bind(new InetSocketAddress(Profile.getDefaultNetworkName(), port));
                this.selector = Selector.open();
                this.server.register(this.selector, 1);
                this.pingHandler = new PingHandler("UDPNodeFailureMonitor-PingHandler");
                this.pingHandler.start();
                this.timer = new Timer();
                if (this.logger.isLoggable(Logger.INFO)) {
                    this.logger.log(Logger.INFO, "UDP monitoring server has been initialized and started.");
                }
                if (this.logger.isLoggable(Logger.CONFIG)) {
                    this.logger.log(Logger.CONFIG, "(UDP port: " + port + ", ping_delay_limit: " + pingDelayLimit + ", unreachable_limit: " + unreachLimit + ")");
                }
            }
            catch (IOException iOException) {
                if (!this.logger.isLoggable(Logger.SEVERE)) break block4;
                this.logger.log(Logger.SEVERE, "UDP monitoring server cannot be started");
            }
        }
    }

    private synchronized void stopServer() {
        block3: {
            try {
                this.pingHandler.stop();
                this.timer.cancel();
                this.deadlines.clear();
                this.server.disconnect();
                if (this.logger.isLoggable(Logger.INFO)) {
                    this.logger.log(Logger.INFO, "UDP monitoring server has been stopped.");
                }
            }
            catch (Exception exception) {
                if (!this.logger.isLoggable(Logger.SEVERE)) break block3;
                this.logger.log(Logger.SEVERE, "Error shutting down the UDP monitor server");
            }
        }
    }

    public synchronized void register(UDPNodeFailureMonitor uDPNodeFailureMonitor) {
        if (this.targets.size() == 0) {
            this.startServer();
        }
        String string = uDPNodeFailureMonitor.getNode().getName();
        this.targets.put(string, uDPNodeFailureMonitor);
        this.addDeadline(string, pingDelayLimit);
    }

    public synchronized void deregister(UDPNodeFailureMonitor uDPNodeFailureMonitor) {
        String string = uDPNodeFailureMonitor.getNode().getName();
        this.targets.remove(string);
        if (this.targets.size() == 0) {
            this.stopServer();
        }
    }

    protected synchronized void pingReceived(String string, boolean bl) {
        UDPNodeFailureMonitor uDPNodeFailureMonitor;
        if (this.logger.isLoggable(Logger.FINEST)) {
            this.logger.log(Logger.FINEST, "UDP ping message for node '" + string + "' received. (termination-flag: " + bl + ")");
        }
        if ((uDPNodeFailureMonitor = (UDPNodeFailureMonitor)this.targets.get(string)) != null) {
            uDPNodeFailureMonitor.setLastPing(System.currentTimeMillis());
            this.addDeadline(string, pingDelayLimit);
            int n = uDPNodeFailureMonitor.getState();
            if (n == 0 && bl) {
                uDPNodeFailureMonitor.setState(2);
            } else if (n == 1 && !bl) {
                uDPNodeFailureMonitor.setState(0);
                this.addDeadline(string, pingDelayLimit);
            } else if (n == 1 && bl) {
                uDPNodeFailureMonitor.setState(2);
            }
        } else if (this.logger.isLoggable(Logger.INFO)) {
            this.logger.log(Logger.INFO, "UDP ping message with the unknown node ID '" + string + "' has been received");
        }
    }

    protected synchronized void timeout(String string) {
        int n;
        UDPNodeFailureMonitor uDPNodeFailureMonitor = (UDPNodeFailureMonitor)this.targets.get(string);
        int n2 = n = uDPNodeFailureMonitor.getState();
        if (this.logger.isLoggable(Logger.FINEST)) {
            this.logger.log(Logger.FINEST, "Timeout for '" + string + "'");
        }
        if (n == 0) {
            n2 = 1;
            this.addDeadline(string, unreachLimit);
        } else if (n == 1) {
            n2 = 2;
        }
        if (n2 != n) {
            uDPNodeFailureMonitor.setState(n2);
        }
    }

    private void addDeadline(String string, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(14, n);
        Date date = calendar.getTime();
        Deadline deadline = new Deadline(string);
        UDPNodeFailureMonitor uDPNodeFailureMonitor = (UDPNodeFailureMonitor)this.targets.get(string);
        if (uDPNodeFailureMonitor != null) {
            uDPNodeFailureMonitor.setDeadline(deadline.getTime());
            this.deadlines.put(string, deadline);
            this.timer.schedule((TimerTask)deadline, n);
        }
    }

    private class PingHandler
    implements Runnable {
        private final byte TERMINATING_INFO = 1;
        private boolean interrupted = false;
        private Thread thread;

        public PingHandler(String string) {
            this.thread = new Thread((Runnable)this, string);
        }

        private void handlePing() throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
            SocketAddress socketAddress = UDPMonitorServer.this.server.receive(byteBuffer);
            byteBuffer.position(0);
            if (socketAddress != null) {
                TimerTask timerTask;
                int n = byteBuffer.getInt();
                byte[] byArray = new byte[n];
                byteBuffer.get(byArray, 0, n);
                String string = new String(byArray);
                byte by = byteBuffer.get();
                boolean bl = false;
                if ((by & 1) != 0) {
                    bl = true;
                }
                if ((timerTask = (TimerTask)UDPMonitorServer.this.deadlines.get(string)) != null) {
                    timerTask.cancel();
                }
                UDPMonitorServer.this.pingReceived(string, bl);
            }
        }

        public void run() {
            while (!this.interrupted) {
                try {
                    UDPMonitorServer.this.selector.select();
                    Set<SelectionKey> set = UDPMonitorServer.this.selector.selectedKeys();
                    this.interrupted = set.size() == 0;
                    Iterator<SelectionKey> iterator = set.iterator();
                    while (iterator.hasNext()) {
                        SelectionKey selectionKey = iterator.next();
                        iterator.remove();
                        if (!selectionKey.isValid() || !selectionKey.isReadable()) continue;
                        this.handlePing();
                    }
                }
                catch (IOException iOException) {
                    if (!UDPMonitorServer.this.logger.isLoggable(Logger.SEVERE)) continue;
                    UDPMonitorServer.this.logger.log(Logger.SEVERE, "UDP Connection error ");
                }
            }
        }

        public void start() {
            this.thread.start();
        }

        public void stop() {
            this.interrupted = true;
        }
    }

    private class Deadline
    extends TimerTask {
        private String nodeID;
        private long time;

        public Deadline(String string) {
            this.nodeID = string;
            this.time = System.currentTimeMillis();
        }

        public long getTime() {
            return this.time;
        }

        public String getNodeID() {
            return this.nodeID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = UDPMonitorServer.this.targets;
            synchronized (map) {
                UDPNodeFailureMonitor uDPNodeFailureMonitor = (UDPNodeFailureMonitor)UDPMonitorServer.this.targets.get(this.nodeID);
                if (uDPNodeFailureMonitor != null && uDPNodeFailureMonitor.getDeadline() == this.time) {
                    UDPMonitorServer.this.timeout(this.nodeID);
                }
            }
        }
    }
}

