/*
 * Decompiled with CFR 0.152.
 */
package jade.core.mobility;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.AgentDescriptor;
import jade.core.BaseService;
import jade.core.CaseInsensitiveString;
import jade.core.Command;
import jade.core.ContainerID;
import jade.core.Filter;
import jade.core.GenericCommand;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.LifeCycle;
import jade.core.Location;
import jade.core.MainContainer;
import jade.core.NameClashException;
import jade.core.Node;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.ServiceFinder;
import jade.core.ServiceHelper;
import jade.core.Sink;
import jade.core.VerticalCommand;
import jade.core.mobility.AgentMobilityHelper;
import jade.core.mobility.AgentMobilitySlice;
import jade.core.mobility.MobileAgentClassLoader;
import jade.core.mobility.Movable;
import jade.lang.acl.ACLMessage;
import jade.security.Credentials;
import jade.security.CredentialsHelper;
import jade.security.JADEPrincipal;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.List;
import jade.util.leap.Map;
import jade.util.leap.Serializable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AgentMobilityService
extends BaseService {
    public static final int AP_TRANSIT = 7;
    public static final int AP_COPY = 8;
    public static final int AP_GONE = 9;
    private static final String[] OWNED_COMMANDS = new String[]{"Request-Move", "Request-Clone", "Inform-Moved", "Inform-Cloned"};
    static final boolean MIGRATION = false;
    static final boolean CLONING = true;
    static final boolean CREATE_AND_START = true;
    static final boolean CREATE_ONLY = false;
    static final boolean TRANSFER_ABORT = false;
    static final boolean TRANSFER_COMMIT = true;
    private static Logger logger = Logger.getMyLogger((class$jade$core$mobility$AgentMobilityService == null ? (class$jade$core$mobility$AgentMobilityService = AgentMobilityService.class$("jade.core.mobility.AgentMobilityService")) : class$jade$core$mobility$AgentMobilityService).getName());
    private final Map loaders = new HashMap();
    private final Map sites = new HashMap();
    private AgentContainer myContainer;
    private final ServiceComponent localSlice = new ServiceComponent();
    private final CommandSourceSink senderSink = new CommandSourceSink();
    private final CommandTargetSink receiverSink = new CommandTargetSink();
    static /* synthetic */ Class class$jade$core$mobility$AgentMobilityService;
    static /* synthetic */ Class class$jade$core$mobility$AgentMobilitySlice;

    public void init(AgentContainer agentContainer, Profile profile) throws ProfileException {
        super.init(agentContainer, profile);
        this.myContainer = agentContainer;
    }

    public String getName() {
        return "jade.core.mobility.AgentMobility";
    }

    public Class getHorizontalInterface() {
        return class$jade$core$mobility$AgentMobilitySlice == null ? (class$jade$core$mobility$AgentMobilitySlice = AgentMobilityService.class$("jade.core.mobility.AgentMobilitySlice")) : class$jade$core$mobility$AgentMobilitySlice;
    }

    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    public ServiceHelper getHelper(Agent agent) {
        return new AgentMobilityHelperImpl();
    }

    public Filter getCommandFilter(boolean bl) {
        return null;
    }

    public Sink getCommandSink(boolean bl) {
        if (!bl) {
            return this.senderSink;
        }
        return this.receiverSink;
    }

    public String[] getOwnedCommands() {
        return OWNED_COMMANDS;
    }

    protected Service.Slice getFreshSlice(String string) throws ServiceException {
        return super.getFreshSlice(string);
    }

    private void initCredentials(Command command, AID aID) {
        Agent agent = this.myContainer.acquireLocalAgent(aID);
        if (agent != null) {
            try {
                CredentialsHelper credentialsHelper = (CredentialsHelper)((Object)agent.getHelper("jade.core.security.Security"));
                command.setPrincipal(credentialsHelper.getPrincipal());
                command.setCredentials(credentialsHelper.getCredentials());
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        this.myContainer.releaseLocalAgent(aID);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class GoneLifeCycle
    extends LifeCycle {
        private Movable myMovable;

        private GoneLifeCycle(Movable movable) {
            super(9);
            this.myMovable = movable;
        }

        public boolean alive() {
            return false;
        }

        public void transitionFrom(LifeCycle lifeCycle) {
            if (this.myMovable != null) {
                this.myMovable.beforeMove();
            }
        }
    }

    private static class CopyLifeCycle
    extends LifeCycle {
        private Location myDestination;
        private String myNewName;
        private Movable myMovable;
        private transient AgentMobilityService myService;

        private CopyLifeCycle(Location location, String string, Movable movable, AgentMobilityService agentMobilityService) {
            super(8);
            this.myDestination = location;
            this.myNewName = string;
            this.myMovable = movable;
            this.myService = agentMobilityService;
        }

        public void init() {
            this.myAgent.restoreBufferedState();
            if (this.myMovable != null) {
                this.myMovable.afterClone();
            }
        }

        public void execute() throws JADESecurityException, InterruptedException, InterruptedIOException {
            if (this.myMovable != null) {
                this.myMovable.beforeClone();
            }
            try {
                this.informCloned(this.myAgent.getAID(), this.myDestination, this.myNewName);
            }
            catch (Exception exception) {
                if (this.myAgent.getState() == this.myState) {
                    this.myDestination = null;
                    this.myNewName = null;
                    this.myAgent.restoreBufferedState();
                    if (exception instanceof JADESecurityException) {
                        throw (JADESecurityException)exception;
                    }
                    exception.printStackTrace();
                    return;
                }
                throw new Agent.Interrupted();
            }
            this.myAgent.restoreBufferedState();
        }

        public boolean transitionTo(LifeCycle lifeCycle) {
            int n = lifeCycle.getState();
            return n == 2 || n == 6;
        }

        public void end() {
            if (logger.isLoggable(Logger.SEVERE)) {
                logger.log(Logger.SEVERE, "***  Agent " + this.myAgent.getName() + " cloned in a forbidden situation ***");
            }
            this.myAgent.clean(true);
        }

        public void informCloned(AID aID, Location location, String string) throws ServiceException, JADESecurityException, IMTPException, NotFoundException, NameClashException {
            GenericCommand genericCommand = new GenericCommand("Inform-Cloned", "jade.core.mobility.AgentMobility", null);
            genericCommand.addParam(aID);
            genericCommand.addParam(location);
            genericCommand.addParam(string);
            this.myService.initCredentials(genericCommand, aID);
            Object object = this.myService.submit(genericCommand);
            if (object != null) {
                if (object instanceof JADESecurityException) {
                    throw (JADESecurityException)object;
                }
                if (object instanceof NotFoundException) {
                    throw (NotFoundException)object;
                }
                if (object instanceof IMTPException) {
                    throw (IMTPException)object;
                }
                if (object instanceof NameClashException) {
                    throw (NameClashException)object;
                }
            }
        }
    }

    private static class TransitLifeCycle
    extends LifeCycle {
        private Location myDestination;
        private Movable myMovable;
        private transient AgentMobilityService myService;

        private TransitLifeCycle(Location location, Movable movable, AgentMobilityService agentMobilityService) {
            super(7);
            this.myDestination = location;
            this.myMovable = movable;
            this.myService = agentMobilityService;
        }

        public void init() {
            this.myAgent.restoreBufferedState();
            if (this.myMovable != null) {
                this.myMovable.afterMove();
            }
        }

        public void execute() throws JADESecurityException, InterruptedException, InterruptedIOException {
            try {
                this.informMoved(this.myAgent.getAID(), this.myDestination);
            }
            catch (Exception exception) {
                if (this.myAgent.getState() == this.myState) {
                    this.myAgent.restoreBufferedState();
                    this.myDestination = null;
                    if (exception instanceof JADESecurityException) {
                        throw (JADESecurityException)exception;
                    }
                    exception.printStackTrace();
                }
                throw new Agent.Interrupted();
            }
        }

        public void end() {
            if (logger.isLoggable(Logger.SEVERE)) {
                logger.log(Logger.SEVERE, "***  Agent " + this.myAgent.getName() + " moved in a forbidden situation ***");
            }
            this.myAgent.clean(true);
        }

        public boolean transitionTo(LifeCycle lifeCycle) {
            int n = lifeCycle.getState();
            return n == 9 || n == 2 || n == 6;
        }

        public void informMoved(AID aID, Location location) throws ServiceException, JADESecurityException, NotFoundException, IMTPException {
            GenericCommand genericCommand = new GenericCommand("Inform-Moved", "jade.core.mobility.AgentMobility", null);
            genericCommand.addParam(aID);
            genericCommand.addParam(location);
            this.myService.initCredentials(genericCommand, aID);
            Object object = this.myService.submit(genericCommand);
            if (object != null) {
                if (object instanceof JADESecurityException) {
                    throw (JADESecurityException)object;
                }
                if (object instanceof NotFoundException) {
                    throw (NotFoundException)object;
                }
                if (object instanceof IMTPException) {
                    throw (IMTPException)object;
                }
            }
        }
    }

    private class AgentMobilityHelperImpl
    implements AgentMobilityHelper {
        private Agent myAgent;
        private Movable myMovable;

        private AgentMobilityHelperImpl() {
        }

        public void init(Agent agent) {
            this.myAgent = agent;
        }

        public void registerMovable(Movable movable) {
            this.myMovable = movable;
        }

        public void move(Location location) {
            this.myAgent.changeStateTo(new TransitLifeCycle(location, this.myMovable, AgentMobilityService.this));
        }

        public void clone(Location location, String string) {
            this.myAgent.changeStateTo(new CopyLifeCycle(location, string, this.myMovable, AgentMobilityService.this));
        }

        void gone() {
            this.myAgent.changeStateTo(new GoneLifeCycle(this.myMovable));
        }
    }

    private class Deserializer
    extends ObjectInputStream {
        private String classSiteName;
        private ServiceFinder finder;

        public Deserializer(InputStream inputStream, String string, ServiceFinder serviceFinder) throws IOException {
            super(inputStream);
            this.classSiteName = string;
            this.finder = serviceFinder;
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            MobileAgentClassLoader mobileAgentClassLoader = (MobileAgentClassLoader)AgentMobilityService.this.loaders.get(this.classSiteName);
            if (mobileAgentClassLoader == null) {
                mobileAgentClassLoader = new MobileAgentClassLoader(this.classSiteName, this.finder, AgentMobilityService.this.myLogger);
                AgentMobilityService.this.loaders.put(this.classSiteName, mobileAgentClassLoader);
            }
            Class<?> clazz = mobileAgentClassLoader.loadClass(objectStreamClass.getName());
            return clazz;
        }
    }

    private class ServiceComponent
    implements Service.Slice {
        private ServiceComponent() {
        }

        public Service getService() {
            return AgentMobilityService.this;
        }

        public Node getNode() throws ServiceException {
            try {
                return AgentMobilityService.this.getLocalNode();
            }
            catch (IMTPException iMTPException) {
                throw new ServiceException("Problem in contacting the IMTP Manager", iMTPException);
            }
        }

        public VerticalCommand serve(HorizontalCommand horizontalCommand) {
            Command command;
            block17: {
                command = null;
                try {
                    String string = horizontalCommand.getName();
                    Object[] objectArray = horizontalCommand.getParams();
                    if (string.equals("1")) {
                        AID aID = (AID)objectArray[0];
                        byte[] byArray = (byte[])objectArray[1];
                        String string2 = (String)objectArray[2];
                        boolean bl = (Boolean)objectArray[3];
                        boolean bl2 = (Boolean)objectArray[4];
                        this.createAgent(aID, byArray, string2, bl, bl2);
                    } else if (string.equals("2")) {
                        String string3 = (String)objectArray[0];
                        horizontalCommand.setReturnValue(this.fetchClassFile(string3));
                    } else if (string.equals("3")) {
                        GenericCommand genericCommand = new GenericCommand("Request-Move", "jade.core.mobility.AgentMobility", null);
                        AID aID = (AID)objectArray[0];
                        Location location = (Location)objectArray[1];
                        genericCommand.addParam(aID);
                        genericCommand.addParam(location);
                        command = genericCommand;
                    } else if (string.equals("4")) {
                        GenericCommand genericCommand = new GenericCommand("Request-Clone", "jade.core.mobility.AgentMobility", null);
                        AID aID = (AID)objectArray[0];
                        Location location = (Location)objectArray[1];
                        String string4 = (String)objectArray[2];
                        genericCommand.addParam(aID);
                        genericCommand.addParam(location);
                        genericCommand.addParam(string4);
                        command = genericCommand;
                    } else if (string.equals("5")) {
                        horizontalCommand.setReturnValue(new Boolean(this.prepare()));
                    } else if (string.equals("6")) {
                        AID aID = (AID)objectArray[0];
                        Location location = (Location)objectArray[1];
                        Location location2 = (Location)objectArray[2];
                        horizontalCommand.setReturnValue(new Boolean(this.transferIdentity(aID, location, location2)));
                    } else if (string.equals("7")) {
                        AID aID = (AID)objectArray[0];
                        boolean bl = (Boolean)objectArray[1];
                        List list = (List)objectArray[2];
                        this.handleTransferResult(aID, bl, list);
                    } else if (string.equals("8")) {
                        GenericCommand genericCommand = new GenericCommand("Inform-Cloned", "jade.core.mobility.AgentMobility", null);
                        AID aID = (AID)objectArray[0];
                        ContainerID containerID = (ContainerID)objectArray[1];
                        Credentials credentials = (Credentials)objectArray[2];
                        genericCommand.addParam(aID);
                        genericCommand.addParam(containerID);
                        genericCommand.addParam(credentials);
                        command = genericCommand;
                    }
                }
                catch (Throwable throwable) {
                    horizontalCommand.setReturnValue(throwable);
                    if (command == null) break block17;
                    command.setReturnValue(throwable);
                }
            }
            return command;
        }

        private void createAgent(AID aID, byte[] byArray, String string, boolean bl, boolean bl2) throws IMTPException, ServiceException, NotFoundException, NameClashException, JADESecurityException {
            try {
                Serializable serializable;
                if (logger.isLoggable(Logger.INFO)) {
                    logger.log(Logger.INFO, "Incoming agent " + aID);
                }
                Deserializer deserializer = new Deserializer(new ByteArrayInputStream(byArray), string, AgentMobilityService.this.myContainer.getServiceFinder());
                Agent agent = (Agent)deserializer.readObject();
                if (logger.isLoggable(Logger.INFO)) {
                    logger.log(Logger.INFO, "Agent " + aID + " reconstructed");
                }
                Credentials credentials = null;
                if (bl) {
                    serializable = (AgentMobilitySlice)AgentMobilityService.this.getSlice("$$$Main-Slice$$$");
                    try {
                        serializable.clonedAgent(aID, AgentMobilityService.this.myContainer.getID(), credentials);
                    }
                    catch (IMTPException iMTPException) {
                        serializable = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice("$$$Main-Slice$$$");
                        serializable.clonedAgent(aID, AgentMobilityService.this.myContainer.getID(), credentials);
                    }
                }
                AgentMobilityService.this.sites.put(agent, string);
                serializable = AgentMobilityService.this.myContainer.addLocalAgent(aID, agent);
                if (bl2) {
                    AgentMobilityService.this.myContainer.powerUpLocalAgent(aID);
                }
                if (logger.isLoggable(Logger.INFO)) {
                    logger.log(Logger.INFO, "Agent " + aID + " inserted into LADT");
                }
            }
            catch (IOException iOException) {
                throw new IMTPException("An I/O error occurred during de-serialization", iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IMTPException("A class was not found during de-serialization", classNotFoundException);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new IMTPException("Unexpected error.", throwable);
            }
        }

        private byte[] fetchClassFile(String string) throws IMTPException, ClassNotFoundException {
            Object object;
            Object object2;
            if (logger.isLoggable(Logger.FINE)) {
                logger.log(Logger.FINE, "Fetching class " + string);
            }
            String string2 = string.replace('.', '/') + ".class";
            int n = -1;
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(string2);
            if (inputStream == null) {
                if (logger.isLoggable(Logger.FINER)) {
                    logger.log(Logger.FINER, "Class not found as a system resource. Try manually");
                }
                object2 = System.getProperty("java.class.path");
                object = new StringTokenizer((String)object2, ";");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    try {
                        File file;
                        String string3 = ((StringTokenizer)object).nextToken();
                        if (logger.isLoggable(Logger.FINER)) {
                            logger.log(Logger.FINER, "Searching in path " + string3);
                        }
                        if (string3.endsWith(".jar")) {
                            ZipFile zipFile;
                            ZipEntry zipEntry;
                            if (logger.isLoggable(Logger.FINER)) {
                                logger.log(Logger.FINER, "It's a jar file");
                            }
                            if ((file = new File(string3)).exists() && logger.isLoggable(Logger.FINER)) {
                                logger.log(Logger.FINER, "Jar file exists");
                            }
                            if ((zipEntry = (zipFile = new ZipFile(file)).getEntry(string2)) == null) continue;
                            if (logger.isLoggable(Logger.FINER)) {
                                logger.log(Logger.FINER, "Entry " + string2 + " found");
                            }
                            n = (int)zipEntry.getSize();
                            inputStream = zipFile.getInputStream(zipEntry);
                            break;
                        }
                        if (logger.isLoggable(Logger.FINER)) {
                            logger.log(Logger.FINER, "Trying file " + string3 + "/" + string2);
                        }
                        if (!(file = new File(string3 + "/" + string2)).exists()) continue;
                        if (logger.isLoggable(Logger.FINER)) {
                            logger.log(Logger.FINER, "File exists");
                        }
                        inputStream = new FileInputStream(file);
                        break;
                    }
                    catch (Exception exception) {
                        if (!logger.isLoggable(Logger.WARNING)) continue;
                        logger.log(Logger.WARNING, exception.toString());
                    }
                }
            }
            if (inputStream == null) {
                if (logger.isLoggable(Logger.WARNING)) {
                    logger.log(Logger.WARNING, "Class " + string + " not found");
                }
                throw new ClassNotFoundException(string);
            }
            try {
                if (n == -1) {
                    n = inputStream.available();
                }
                object2 = new byte[n];
                if (logger.isLoggable(Logger.FINER)) {
                    logger.log(Logger.FINER, "Class " + string + " fetched. Length is " + n);
                }
                object = new DataInputStream(inputStream);
                ((DataInputStream)object).readFully((byte[])object2);
                return object2;
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException("IOException reading class bytes. " + iOException.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleTransferResult(AID aID, boolean bl, List list) throws IMTPException, NotFoundException {
            if (logger.isLoggable(Logger.FINER)) {
                logger.log(Logger.FINER, "Activating incoming agent " + aID);
            }
            try {
                Agent agent = AgentMobilityService.this.myContainer.acquireLocalAgent(aID);
                if (agent == null || agent.getState() != 7) {
                    throw new NotFoundException("handleTransferResult() unable to find a suitable agent.");
                }
                if (!bl) {
                    AgentMobilityService.this.myContainer.removeLocalAgent(aID);
                } else {
                    int n = list.size();
                    while (n > 0) {
                        agent.putBack((ACLMessage)list.get(n - 1));
                        --n;
                    }
                    AgentMobilityService.this.myContainer.powerUpLocalAgent(aID);
                    if (logger.isLoggable(Logger.INFO)) {
                        logger.log(Logger.INFO, "Incoming agent " + aID + " activated");
                    }
                }
                Object var7_6 = null;
                AgentMobilityService.this.myContainer.releaseLocalAgent(aID);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                AgentMobilityService.this.myContainer.releaseLocalAgent(aID);
                throw throwable;
            }
        }

        private boolean prepare() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean transferIdentity(AID aID, Location location, Location location2) throws IMTPException, NotFoundException {
            MainContainer mainContainer;
            if (logger.isLoggable(Logger.INFO)) {
                logger.log(Logger.INFO, "Transferring identity of agent " + aID + " from " + location.getName() + " to " + location2.getName());
            }
            if ((mainContainer = AgentMobilityService.this.myContainer.getMain()) != null) {
                AgentDescriptor agentDescriptor = mainContainer.acquireAgentDescriptor(aID);
                if (agentDescriptor != null) {
                    block16: {
                        AgentMobilitySlice agentMobilitySlice = (AgentMobilitySlice)AgentMobilityService.this.getSlice(location.getName());
                        AgentMobilitySlice agentMobilitySlice2 = (AgentMobilitySlice)AgentMobilityService.this.getSlice(location2.getName());
                        boolean bl = false;
                        boolean bl2 = false;
                        try {
                            bl = agentMobilitySlice.prepare();
                        }
                        catch (IMTPException iMTPException) {
                            agentMobilitySlice = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice(location.getName());
                            bl = agentMobilitySlice.prepare();
                        }
                        if (logger.isLoggable(Logger.INFO)) {
                            logger.log(Logger.INFO, "Source " + location.getName() + " " + bl);
                        }
                        try {
                            bl2 = agentMobilitySlice2.prepare();
                        }
                        catch (IMTPException iMTPException) {
                            agentMobilitySlice2 = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice(location2.getName());
                            bl2 = agentMobilitySlice2.prepare();
                        }
                        if (logger.isLoggable(Logger.INFO)) {
                            logger.log(Logger.INFO, "Destination " + location2.getName() + " " + bl2);
                        }
                        if (!bl || !bl2) break block16;
                        mainContainer.movedAgent(aID, (ContainerID)location, (ContainerID)location2);
                        boolean bl3 = true;
                        Object var12_17 = null;
                        mainContainer.releaseAgentDescriptor(aID);
                        return bl3;
                    }
                    try {
                        boolean bl = false;
                        Object var12_18 = null;
                        mainContainer.releaseAgentDescriptor(aID);
                        return bl;
                    }
                    catch (Exception exception) {
                        try {
                            if (logger.isLoggable(Logger.WARNING)) {
                                logger.log(Logger.WARNING, "Link failure!");
                            }
                            boolean bl = false;
                            Object var12_19 = null;
                            mainContainer.releaseAgentDescriptor(aID);
                            return bl;
                        }
                        catch (Throwable throwable) {
                            Object var12_20 = null;
                            mainContainer.releaseAgentDescriptor(aID);
                            throw throwable;
                        }
                    }
                }
                throw new NotFoundException("Agent agentID not found");
            }
            if (logger.isLoggable(Logger.WARNING)) {
                logger.log(Logger.WARNING, "Not a main!");
            }
            return false;
        }
    }

    private class CommandTargetSink
    implements Sink {
        private CommandTargetSink() {
        }

        public void consume(VerticalCommand verticalCommand) {
            try {
                String string = verticalCommand.getName();
                if (string.equals("Request-Move")) {
                    this.handleRequestMove(verticalCommand);
                } else if (string.equals("Request-Clone")) {
                    this.handleRequestClone(verticalCommand);
                } else if (string.equals("Inform-Moved")) {
                    this.handleInformMoved(verticalCommand);
                } else if (string.equals("Inform-Cloned")) {
                    this.handleInformCloned(verticalCommand);
                }
            }
            catch (Throwable throwable) {
                verticalCommand.setReturnValue(throwable);
            }
        }

        private void handleRequestMove(VerticalCommand verticalCommand) throws IMTPException, NotFoundException {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            Location location = (Location)objectArray[1];
            this.moveAgent(aID, location);
        }

        private void handleRequestClone(VerticalCommand verticalCommand) throws IMTPException, NotFoundException {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            Location location = (Location)objectArray[1];
            String string = (String)objectArray[2];
            this.copyAgent(aID, location, string);
        }

        private void handleInformMoved(VerticalCommand verticalCommand) {
        }

        private void handleInformCloned(VerticalCommand verticalCommand) throws JADESecurityException, NotFoundException, NameClashException {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            ContainerID containerID = (ContainerID)objectArray[1];
            Credentials credentials = (Credentials)objectArray[2];
            this.clonedAgent(aID, containerID, credentials);
        }

        private void moveAgent(AID aID, Location location) throws IMTPException, NotFoundException {
            Agent agent = AgentMobilityService.this.myContainer.acquireLocalAgent(aID);
            if (agent == null) {
                throw new NotFoundException("Move-Agent failed to find " + aID);
            }
            agent.doMove(location);
            AgentMobilityService.this.myContainer.releaseLocalAgent(aID);
        }

        private void copyAgent(AID aID, Location location, String string) throws IMTPException, NotFoundException {
            Agent agent = AgentMobilityService.this.myContainer.acquireLocalAgent(aID);
            if (agent == null) {
                throw new NotFoundException("Clone-Agent failed to find " + aID);
            }
            agent.doClone(location, string);
            AgentMobilityService.this.myContainer.releaseLocalAgent(aID);
        }

        private void clonedAgent(AID aID, ContainerID containerID, Credentials credentials) throws JADESecurityException, NotFoundException, NameClashException {
            block6: {
                JADEPrincipal jADEPrincipal;
                MainContainer mainContainer = AgentMobilityService.this.myContainer.getMain();
                if (mainContainer == null) break block6;
                String string = "NONE";
                if (credentials != null && (jADEPrincipal = credentials.getOwner()) != null) {
                    string = jADEPrincipal.getName();
                }
                try {
                    mainContainer.bornAgent(aID, containerID, null, string, false);
                }
                catch (NameClashException nameClashException) {
                    try {
                        ContainerID containerID2 = mainContainer.getContainerID(aID);
                        Node node = mainContainer.getContainerNode(containerID2).getNode();
                        node.ping(false);
                        throw nameClashException;
                    }
                    catch (NameClashException nameClashException2) {
                        throw nameClashException2;
                    }
                    catch (Exception exception) {
                        mainContainer.bornAgent(aID, containerID, null, string, true);
                    }
                }
            }
        }
    }

    private class CommandSourceSink
    implements Sink {
        private CommandSourceSink() {
        }

        public void consume(VerticalCommand verticalCommand) {
            try {
                String string = verticalCommand.getName();
                if (string.equals("Request-Move")) {
                    this.handleRequestMove(verticalCommand);
                } else if (string.equals("Request-Clone")) {
                    this.handleRequestClone(verticalCommand);
                } else if (string.equals("Inform-Moved")) {
                    this.handleInformMoved(verticalCommand);
                } else if (string.equals("Inform-Cloned")) {
                    this.handleInformCloned(verticalCommand);
                }
            }
            catch (IMTPException iMTPException) {
                verticalCommand.setReturnValue(iMTPException);
            }
            catch (NotFoundException notFoundException) {
                verticalCommand.setReturnValue(notFoundException);
            }
            catch (NameClashException nameClashException) {
                verticalCommand.setReturnValue(nameClashException);
            }
            catch (JADESecurityException jADESecurityException) {
                verticalCommand.setReturnValue(jADESecurityException);
            }
            catch (ServiceException serviceException) {
                verticalCommand.setReturnValue(new IMTPException("Service error", serviceException));
            }
        }

        private void handleRequestMove(VerticalCommand verticalCommand) throws IMTPException, ServiceException, NotFoundException {
            block2: {
                Object[] objectArray = verticalCommand.getParams();
                AID aID = (AID)objectArray[0];
                Location location = (Location)objectArray[1];
                MainContainer mainContainer = AgentMobilityService.this.myContainer.getMain();
                if (mainContainer == null) break block2;
                ContainerID containerID = mainContainer.getContainerID(aID);
                AgentMobilitySlice agentMobilitySlice = (AgentMobilitySlice)AgentMobilityService.this.getSlice(containerID.getName());
                try {
                    agentMobilitySlice.moveAgent(aID, location);
                }
                catch (IMTPException iMTPException) {
                    agentMobilitySlice = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice(containerID.getName());
                    agentMobilitySlice.moveAgent(aID, location);
                }
            }
        }

        private void handleRequestClone(VerticalCommand verticalCommand) throws IMTPException, ServiceException, NotFoundException {
            block2: {
                Object[] objectArray = verticalCommand.getParams();
                AID aID = (AID)objectArray[0];
                Location location = (Location)objectArray[1];
                String string = (String)objectArray[2];
                MainContainer mainContainer = AgentMobilityService.this.myContainer.getMain();
                if (mainContainer == null) break block2;
                ContainerID containerID = mainContainer.getContainerID(aID);
                AgentMobilitySlice agentMobilitySlice = (AgentMobilitySlice)AgentMobilityService.this.getSlice(containerID.getName());
                try {
                    agentMobilitySlice.copyAgent(aID, location, string);
                }
                catch (IMTPException iMTPException) {
                    agentMobilitySlice = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice(containerID.getName());
                    agentMobilitySlice.copyAgent(aID, location, string);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleInformMoved(VerticalCommand verticalCommand) throws IMTPException, ServiceException, JADESecurityException, NotFoundException {
            block58: {
                Agent agent;
                Object[] objectArray = verticalCommand.getParams();
                AID aID = (AID)objectArray[0];
                Location location = (Location)objectArray[1];
                if (logger.isLoggable(Logger.INFO)) {
                    logger.log(Logger.INFO, "Moving agent " + aID + " on container " + location.getName());
                }
                if ((agent = AgentMobilityService.this.myContainer.acquireLocalAgent(aID)) == null) {
                    if (logger.isLoggable(Logger.SEVERE)) {
                        logger.log(Logger.SEVERE, "Internal error: handleMove() called with a wrong name (" + aID + ") !!!");
                    }
                    return;
                }
                String string = location.getProtocol();
                if (!CaseInsensitiveString.equalsIgnoreCase(string, "JADE-IMTP")) {
                    if (logger.isLoggable(Logger.SEVERE)) {
                        logger.log(Logger.SEVERE, "Mobility protocol not supported. Aborting transfer");
                    }
                    agent.restoreBufferedState();
                    return;
                }
                int n = 0;
                ArrayList arrayList = new ArrayList();
                AgentMobilitySlice agentMobilitySlice = null;
                try {
                    String string2;
                    if (CaseInsensitiveString.equalsIgnoreCase(location.getName(), AgentMobilityService.this.myContainer.here().getName())) {
                        return;
                    }
                    agentMobilitySlice = (AgentMobilitySlice)AgentMobilityService.this.getSlice(location.getName());
                    if (agentMobilitySlice == null) {
                        if (logger.isLoggable(Logger.SEVERE)) {
                            logger.log(Logger.SEVERE, "Destination does not exist or does not support mobility");
                        }
                        return;
                    }
                    if (logger.isLoggable(Logger.INFO)) {
                        logger.log(Logger.INFO, "Destination container for agent " + aID + " found");
                    }
                    n = 1;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                    objectOutputStream.writeObject(agent);
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    if (logger.isLoggable(Logger.INFO)) {
                        logger.log(Logger.INFO, "Agent " + aID + " correctly serialized");
                    }
                    if ((string2 = (String)AgentMobilityService.this.sites.get(agent)) == null) {
                        string2 = AgentMobilityService.this.getLocalNode().getName();
                    }
                    try {
                        agentMobilitySlice.createAgent(aID, byArray, string2, false, false);
                    }
                    catch (IMTPException iMTPException) {
                        agentMobilitySlice = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice(location.getName());
                        agentMobilitySlice.createAgent(aID, byArray, string2, false, false);
                    }
                    n = 2;
                    if (logger.isLoggable(Logger.INFO)) {
                        logger.log(Logger.INFO, "Agent " + aID + " correctly created on destination container");
                    }
                    AgentMobilitySlice agentMobilitySlice2 = (AgentMobilitySlice)AgentMobilityService.this.getSlice("$$$Main-Slice$$$");
                    boolean bl = false;
                    try {
                        bl = agentMobilitySlice2.transferIdentity(aID, (ContainerID)AgentMobilityService.this.myContainer.here(), (ContainerID)location);
                    }
                    catch (IMTPException iMTPException) {
                        agentMobilitySlice2 = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice("$$$Main-Slice$$$");
                        bl = agentMobilitySlice2.transferIdentity(aID, (ContainerID)AgentMobilityService.this.myContainer.here(), (ContainerID)location);
                    }
                    n = 3;
                    if (bl) {
                        if (logger.isLoggable(Logger.INFO)) {
                            logger.log(Logger.INFO, "Identity of agent " + aID + " correctly transferred");
                        }
                        AgentMobilityService.this.myContainer.fillListFromMessageQueue(arrayList, agent);
                        agentMobilitySlice.handleTransferResult(aID, bl, arrayList);
                        try {
                            AgentMobilityHelperImpl agentMobilityHelperImpl = (AgentMobilityHelperImpl)agent.getHelper("jade.core.mobility.AgentMobility");
                            agentMobilityHelperImpl.gone();
                            AgentMobilityService.this.myContainer.removeLocalAgent(agent.getAID());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        AgentMobilityService.this.sites.remove(agent);
                        if (logger.isLoggable(Logger.INFO)) {
                            logger.log(Logger.INFO, "Agent " + aID + " correctly gone");
                        }
                        break block58;
                    }
                    logger.log(Logger.WARNING, "Error transferring identity of agent " + aID);
                    agent.restoreBufferedState();
                    agentMobilitySlice.handleTransferResult(aID, bl, arrayList);
                    logger.log(Logger.WARNING, "Migration of agent " + aID + "aborted");
                }
                catch (IOException iOException) {
                    if (logger.isLoggable(Logger.SEVERE)) {
                        logger.log(Logger.SEVERE, "Error in agent serialization. Abort transfer. " + iOException);
                    }
                }
                catch (JADESecurityException jADESecurityException) {
                    if (logger.isLoggable(Logger.SEVERE)) {
                        logger.log(Logger.SEVERE, "Permission to move not owned. Abort transfer. " + jADESecurityException.getMessage());
                    }
                }
                catch (NotFoundException notFoundException) {
                    if (n == 0) {
                        if (logger.isLoggable(Logger.SEVERE)) {
                            logger.log(Logger.SEVERE, "Destination container does not exist. Abort transfer. " + notFoundException.getMessage());
                        }
                    } else if (n == 2) {
                        if (logger.isLoggable(Logger.SEVERE)) {
                            logger.log(Logger.SEVERE, "Transferring agent does not seem to be part of the platform. Abort transfer. " + notFoundException.getMessage());
                        }
                    } else if (n == 3 && logger.isLoggable(Logger.SEVERE)) {
                        logger.log(Logger.SEVERE, "Transferred agent not found on destination container. Can't roll back. " + notFoundException.getMessage());
                    }
                }
                catch (NameClashException nameClashException) {
                    nameClashException.printStackTrace();
                }
                catch (IMTPException iMTPException) {
                    if (n == 0) {
                        if (logger.isLoggable(Logger.SEVERE)) {
                            logger.log(Logger.SEVERE, "Can't retrieve destination container. Abort transfer. " + iMTPException.getMessage());
                        }
                    } else if (n == 1) {
                        if (logger.isLoggable(Logger.SEVERE)) {
                            logger.log(Logger.SEVERE, "Error creating agent on destination container. Abort transfer. " + iMTPException.getMessage());
                        }
                    } else if (n == 2) {
                        if (logger.isLoggable(Logger.SEVERE)) {
                            logger.log(Logger.SEVERE, "Error transferring agent identity. Abort transfer. " + iMTPException.getMessage());
                        }
                        try {
                            agentMobilitySlice.handleTransferResult(aID, false, arrayList);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (n == 3 && logger.isLoggable(Logger.SEVERE)) {
                        logger.log(Logger.SEVERE, "Error activating transferred agent. Can't roll back!!!. " + iMTPException.getMessage());
                    }
                }
                finally {
                    if (n <= 2) {
                        agent.restoreBufferedState();
                    }
                    AgentMobilityService.this.myContainer.releaseLocalAgent(aID);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleInformCloned(VerticalCommand verticalCommand) throws IMTPException, NotFoundException, NameClashException, JADESecurityException {
            AID aID;
            block18: {
                block17: {
                    Object[] objectArray = verticalCommand.getParams();
                    aID = (AID)objectArray[0];
                    Location location = (Location)objectArray[1];
                    String string = (String)objectArray[2];
                    try {
                        try {
                            String string2;
                            Agent agent;
                            if (logger.isLoggable(Logger.INFO)) {
                                logger.log(Logger.INFO, "Cloning agent " + aID + " on container " + location.getName());
                            }
                            if ((agent = AgentMobilityService.this.myContainer.acquireLocalAgent(aID)) == null) {
                                if (logger.isLoggable(Logger.SEVERE)) {
                                    logger.log(Logger.SEVERE, "Internal error: handleClone() called with a wrong name (" + aID + ") !!!");
                                }
                                Object var16_8 = null;
                                AgentMobilityService.this.myContainer.releaseLocalAgent(aID);
                                return;
                            }
                            String string3 = location.getProtocol();
                            if (!CaseInsensitiveString.equalsIgnoreCase(string3, "JADE-IMTP")) {
                                if (logger.isLoggable(Logger.SEVERE)) {
                                    logger.log(Logger.SEVERE, "Mobility protocol not supported. Abort cloning");
                                }
                                break block17;
                            }
                            AgentMobilitySlice agentMobilitySlice = (AgentMobilitySlice)AgentMobilityService.this.getSlice(location.getName());
                            if (logger.isLoggable(Logger.INFO)) {
                                logger.log(Logger.INFO, "Destination container for agent " + aID + " found");
                            }
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                            objectOutputStream.writeObject(agent);
                            byte[] byArray = byteArrayOutputStream.toByteArray();
                            if (logger.isLoggable(Logger.INFO)) {
                                logger.log(Logger.INFO, "Agent " + aID + " correctly serialized");
                            }
                            if ((string2 = (String)AgentMobilityService.this.sites.get(agent)) == null) {
                                string2 = AgentMobilityService.this.getLocalNode().getName();
                            }
                            AID aID2 = new AID(string, false);
                            try {
                                agentMobilitySlice.createAgent(aID2, byArray, string2, true, true);
                            }
                            catch (IMTPException iMTPException) {
                                agentMobilitySlice = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice(location.getName());
                                agentMobilitySlice.createAgent(aID2, byArray, string2, true, true);
                            }
                            if (logger.isLoggable(Logger.INFO)) {
                                logger.log(Logger.INFO, "Cloned Agent " + aID2 + " correctly created on destination container");
                            }
                            break block18;
                        }
                        catch (IOException iOException) {
                            throw new IMTPException("I/O serialization error in handleInformCloned()", iOException);
                        }
                        catch (ServiceException serviceException) {
                            throw new IMTPException("Destination container not found in handleInformCloned()", serviceException);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var16_11 = null;
                        AgentMobilityService.this.myContainer.releaseLocalAgent(aID);
                        throw throwable;
                    }
                }
                Object var16_9 = null;
                AgentMobilityService.this.myContainer.releaseLocalAgent(aID);
                return;
            }
            Object var16_10 = null;
            AgentMobilityService.this.myContainer.releaseLocalAgent(aID);
        }
    }
}

