/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.Profile;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessageManager;
import jade.core.messaging.MessageStorage;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import jade.util.leap.Map;
import java.io.IOException;

class PersistentDeliveryManager {
    private static final long DEFAULT_SENDFAILUREPERIOD = 60000L;
    private static final String DEFAULT_STORAGE = "jade.core.messaging.PersistentDeliveryManager$DummyStorage";
    private static PersistentDeliveryManager theInstance;
    private MessageManager myMessageManager;
    private MessageManager.Channel deliveryChannel;
    private long sendFailurePeriod;
    private long users;
    private Map pendingMessages = new HashMap();
    private ExpirationChecker failureSender;
    private MessageStorage storage;

    public static synchronized PersistentDeliveryManager instance(Profile profile, MessageManager.Channel channel) {
        if (theInstance == null) {
            theInstance = new PersistentDeliveryManager();
            theInstance.initialize(profile, channel);
        }
        return theInstance;
    }

    public void initialize(Profile profile, MessageManager.Channel channel) {
        block5: {
            String string;
            this.users = 0L;
            this.myMessageManager = MessageManager.instance(profile);
            this.deliveryChannel = channel;
            try {
                string = profile.getParameter("persistent-delivery-storagemethod", DEFAULT_STORAGE);
                this.storage = (MessageStorage)Class.forName(string).newInstance();
                this.storage.init(profile);
                this.storage.loadAll(new MessageStorage.LoadListener(){

                    public void loadStarted(String string) {
                        System.out.println("--> Load BEGIN <--");
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void itemLoaded(String string, GenericMessage genericMessage, AID aID) {
                        Map map = PersistentDeliveryManager.this.pendingMessages;
                        synchronized (map) {
                            List list = (List)PersistentDeliveryManager.this.pendingMessages.get(aID);
                            if (list == null) {
                                list = new LinkedList();
                                PersistentDeliveryManager.this.pendingMessages.put(aID, list);
                            }
                            DeliveryItem deliveryItem = new DeliveryItem(genericMessage, aID, PersistentDeliveryManager.this.deliveryChannel, string);
                            list.add(deliveryItem);
                        }
                        System.out.println("Message for <" + aID.getLocalName() + ">");
                    }

                    public void loadEnded(String string) {
                        System.out.println("--> Load END <--");
                    }
                });
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.sendFailurePeriod = 60000L;
            string = profile.getParameter("persistent-delivery-sendfailureperiod", null);
            if (string == null) break block5;
            try {
                this.sendFailurePeriod = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeMessage(String string, GenericMessage genericMessage, AID aID) throws IOException {
        Map map = this.pendingMessages;
        synchronized (map) {
            List list = (List)this.pendingMessages.get(aID);
            if (list == null) {
                list = new LinkedList();
                this.pendingMessages.put(aID, list);
            }
            String string2 = this.storage.store(genericMessage, aID);
            list.add(new DeliveryItem(genericMessage, aID, this.deliveryChannel, string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int flushMessages(AID aID) {
        int n = 0;
        List list = null;
        Map map = this.pendingMessages;
        synchronized (map) {
            list = (List)this.pendingMessages.remove(aID);
        }
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DeliveryItem deliveryItem = (DeliveryItem)iterator.next();
                this.retry(deliveryItem);
                ++n;
            }
        }
        return n;
    }

    public synchronized void start() {
        if (this.users == 0L) {
            this.failureSender = new ExpirationChecker(this.sendFailurePeriod);
            this.failureSender.start();
        }
        ++this.users;
    }

    public synchronized void stop() {
        --this.users;
        if (this.users == 0L) {
            this.failureSender.stop();
        }
    }

    private PersistentDeliveryManager() {
    }

    private void retry(DeliveryItem deliveryItem) {
        try {
            this.storage.delete(deliveryItem.getStoreName(), deliveryItem.getReceiver());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.myMessageManager.deliver(deliveryItem.getMessage(), deliveryItem.getReceiver(), deliveryItem.getChannel());
    }

    public static class DummyStorage
    implements MessageStorage {
        public void init(Profile profile) {
        }

        public String store(GenericMessage genericMessage, AID aID) throws IOException {
            return null;
        }

        public void delete(String string, AID aID) throws IOException {
        }

        public void loadAll(MessageStorage.LoadListener loadListener) throws IOException {
        }
    }

    private class ExpirationChecker
    implements Runnable {
        private boolean active = false;
        private long period;
        private Thread myThread;

        public ExpirationChecker(long l) {
            this.period = l;
            this.myThread = new Thread((Runnable)this, "Persistent Delivery Service -- Expiration Checker Thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.active) {
                try {
                    Thread.sleep(this.period);
                    Map map = PersistentDeliveryManager.this.pendingMessages;
                    synchronized (map) {
                        Object[] objectArray = PersistentDeliveryManager.this.pendingMessages.keySet().toArray();
                        int n = 0;
                        while (n < objectArray.length) {
                            PersistentDeliveryManager.this.flushMessages((AID)objectArray[n]);
                            ++n;
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void start() {
            this.active = true;
            this.myThread.start();
        }

        public void stop() {
            this.active = false;
            this.myThread.interrupt();
        }
    }

    private static class DeliveryItem {
        private GenericMessage toDeliver;
        private AID receiver;
        private MessageManager.Channel channel;
        private String storeName;

        public DeliveryItem(GenericMessage genericMessage, AID aID, MessageManager.Channel channel, String string) {
            this.toDeliver = genericMessage;
            this.receiver = aID;
            this.channel = channel;
            this.storeName = string;
        }

        public GenericMessage getMessage() {
            return this.toDeliver;
        }

        public AID getReceiver() {
            return this.receiver;
        }

        public MessageManager.Channel getChannel() {
            return this.channel;
        }

        public String getStoreName() {
            return this.storeName;
        }
    }
}

