/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.Filter;
import jade.core.VerticalCommand;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessagingService;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.lang.acl.ACLCodec;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.LEAPACLCodec;
import jade.util.leap.Iterator;
import jade.util.leap.Map;

public class IncomingEncodingFilter
extends Filter {
    private Map messageEncodings;

    public IncomingEncodingFilter(Map map) {
        this.messageEncodings = map;
        this.setPreferredPosition(50);
    }

    public boolean accept(VerticalCommand verticalCommand) {
        String string = verticalCommand.getName();
        Object[] objectArray = verticalCommand.getParams();
        if (string.equals("Send-Message")) {
            GenericMessage genericMessage = (GenericMessage)objectArray[1];
            if (genericMessage.getPayload() == null) {
                return true;
            }
            Envelope envelope = genericMessage.getEnvelope();
            byte[] byArray = genericMessage.getPayload();
            try {
                ACLMessage aCLMessage = this.decodeMessage(envelope, byArray);
                aCLMessage.setEnvelope(envelope);
                if (envelope != null) {
                    AID aID = aCLMessage.getSender();
                    if (aID == null) {
                        System.err.println("ERROR: Trying to dispatch a message with a null sender.");
                        System.err.println("Aborting send operation...");
                        return true;
                    }
                    Iterator iterator = aID.getAllAddresses();
                    if (!iterator.hasNext()) {
                        aCLMessage.setSender(envelope.getFrom());
                    }
                }
                ((GenericMessage)objectArray[1]).update(aCLMessage, null, null);
            }
            catch (MessagingService.UnknownACLEncodingException unknownACLEncodingException) {
                unknownACLEncodingException.printStackTrace();
                verticalCommand.setReturnValue(unknownACLEncodingException);
                return false;
            }
            catch (ACLCodec.CodecException codecException) {
                codecException.printStackTrace();
                verticalCommand.setReturnValue(codecException);
                return false;
            }
        }
        return true;
    }

    public ACLMessage decodeMessage(Envelope envelope, byte[] byArray) throws MessagingService.UnknownACLEncodingException, ACLCodec.CodecException {
        String string = envelope != null ? envelope.getAclRepresentation() : LEAPACLCodec.NAME.toLowerCase();
        if (string != null) {
            ACLCodec aCLCodec = (ACLCodec)this.messageEncodings.get(string.toLowerCase());
            if (aCLCodec != null) {
                String string2;
                if (envelope == null || (string2 = envelope.getPayloadEncoding()) == null) {
                    string2 = "US-ASCII";
                }
                return aCLCodec.decode(byArray, string2);
            }
            throw new MessagingService.UnknownACLEncodingException("Unknown ACL encoding: " + string + ".");
        }
        throw new MessagingService.UnknownACLEncodingException("No ACL encoding set.");
    }
}

