/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.LEAPACLCodec;
import jade.security.Credentials;
import jade.security.JADEPrincipal;
import jade.util.leap.Serializable;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class GenericMessage
implements Serializable {
    private transient ACLMessage msg;
    private Envelope env;
    private byte[] payload;
    private transient JADEPrincipal senderPrincipal;
    private transient Credentials senderCredentials;
    private boolean isAMSFailure = false;
    private transient boolean foreignReceiver = false;
    private transient int attemptCnt = 0;

    public GenericMessage() {
    }

    public GenericMessage(ACLMessage aCLMessage) {
        this.msg = aCLMessage;
    }

    public GenericMessage(Envelope envelope, byte[] byArray) {
        this.env = envelope;
        this.payload = byArray;
    }

    public final byte[] getPayload() {
        return this.payload;
    }

    public final Envelope getEnvelope() {
        return this.env;
    }

    public final ACLMessage getACLMessage() {
        return this.msg;
    }

    public final void setACLMessage(ACLMessage aCLMessage) {
        this.msg = aCLMessage;
    }

    public final void update(ACLMessage aCLMessage, Envelope envelope, byte[] byArray) {
        this.msg = aCLMessage;
        this.env = envelope;
        this.payload = byArray;
    }

    final void setSenderPrincipal(JADEPrincipal jADEPrincipal) {
        this.senderPrincipal = jADEPrincipal;
    }

    final JADEPrincipal getSenderPrincipal() {
        return this.senderPrincipal;
    }

    final void setSenderCredentials(Credentials credentials) {
        this.senderCredentials = credentials;
    }

    final Credentials getSenderCredentials() {
        return this.senderCredentials;
    }

    public final boolean isAMSFailure() {
        return this.isAMSFailure;
    }

    public final void setAMSFailure(boolean bl) {
        this.isAMSFailure = bl;
    }

    final boolean hasForeignReceiver() {
        return this.foreignReceiver;
    }

    final void setForeignReceiver(boolean bl) {
        this.foreignReceiver = bl;
    }

    final int getAttemptCnt() {
        return this.attemptCnt;
    }

    final void incAttemptCnt() {
        ++this.attemptCnt;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.payload == null) {
            this.payload = new LEAPACLCodec().encode(this.msg, null);
        }
        objectOutputStream.defaultWriteObject();
    }

    public final AID getSender() {
        if (this.msg != null) {
            return this.msg.getSender();
        }
        if (this.env != null) {
            return this.env.getFrom();
        }
        return null;
    }

    public String toString() {
        return "GenericMessage\n\t" + this.msg + "\n\t" + this.env + "\n\t" + (this.payload == null ? "null payload" : this.payload.toString()) + "\n";
    }

    public final int length() {
        byte[] byArray;
        int n = 0;
        if (this.payload != null) {
            n = this.payload.length;
        } else if (this.msg != null && (byArray = this.msg.getByteSequenceContent()) != null) {
            n = byArray.length;
        }
        return n;
    }
}

