/*
 * Decompiled with CFR 0.152.
 */
package jade.core.management;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarClassLoader
extends ClassLoader {
    private JarFile _file = null;

    public JarClassLoader(String string, ClassLoader classLoader) throws IOException {
        super(classLoader);
        File file = new File(string);
        if (file.exists()) {
            this._file = new JarFile(new File(string));
        }
    }

    public void close() throws IOException {
        if (this._file != null) {
            this._file.close();
        }
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        if (this._file != null) {
            ZipEntry zipEntry = this._file.getEntry(string.replace('.', '/') + ".class");
            try {
                InputStream inputStream = this._file.getInputStream(zipEntry);
                int n = inputStream.available();
                byte[] byArray = new byte[n];
                inputStream.read(byArray);
                inputStream.close();
                return this.defineClass(string, byArray, 0, n);
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException("IOError while reading jar file for class " + string + ". " + iOException);
            }
        }
        throw new ClassNotFoundException(string);
    }
}

