/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.core.Agent;
import jade.core.behaviours.CompositeBehaviour;
import jade.core.behaviours.DataStore;
import jade.util.leap.Serializable;

public abstract class Behaviour
implements Serializable {
    private static final long serialVersionUID = 3487495895819001L;
    protected static final int NOTIFY_UP = -1;
    protected static final int NOTIFY_DOWN = 1;
    public static final String STATE_READY = "READY";
    public static final String STATE_BLOCKED = "BLOCKED";
    public static final String STATE_RUNNING = "RUNNING";
    private String myName;
    private boolean startFlag = true;
    protected Agent myAgent;
    private boolean runnableState = true;
    protected RunnableChangedEvent myEvent = new RunnableChangedEvent();
    protected CompositeBehaviour parent;
    private DataStore myStore;
    private Long persistentID;

    final void setParent(CompositeBehaviour compositeBehaviour) {
        this.parent = compositeBehaviour;
        if (this.parent != null) {
            this.myAgent = this.parent.myAgent;
        }
    }

    protected CompositeBehaviour getParent() {
        return this.parent;
    }

    public Behaviour() {
        int n;
        this.myName = this.getClass().getName();
        int n2 = this.myName.lastIndexOf(46);
        int n3 = this.myName.lastIndexOf(36);
        int n4 = n = n2 > n3 ? n2 : n3;
        if (n != -1) {
            this.myName = this.myName.substring(n + 1);
        }
    }

    public Behaviour(Agent agent) {
        this();
        this.myAgent = agent;
    }

    public final void setBehaviourName(String string) {
        this.myName = string;
    }

    public final String getBehaviourName() {
        return this.myName;
    }

    public abstract void action();

    public abstract boolean done();

    public int onEnd() {
        return 0;
    }

    public void onStart() {
    }

    public final void actionWrapper() {
        if (this.startFlag) {
            this.onStart();
            this.startFlag = false;
        }
        this.myAgent.notifyChangeBehaviourState(this, STATE_READY, STATE_RUNNING);
        this.action();
        if (this.myAgent != null) {
            this.myAgent.notifyChangeBehaviourState(this, STATE_RUNNING, STATE_READY);
        }
    }

    public void reset() {
        this.startFlag = true;
        this.restart();
    }

    protected void handle(RunnableChangedEvent runnableChangedEvent) {
        this.setRunnable(runnableChangedEvent.isRunnable());
        if (this.parent != null && runnableChangedEvent.isUpwards()) {
            this.parent.handle(runnableChangedEvent);
        }
    }

    public Behaviour root() {
        if (this.parent != null) {
            return this.parent.root();
        }
        return this;
    }

    void setRunnable(boolean bl) {
        this.runnableState = bl;
    }

    public boolean isRunnable() {
        return this.runnableState;
    }

    public void block() {
        this.myEvent.init(false, -1);
        this.handle(this.myEvent);
    }

    public void block(long l) {
        this.block();
        this.myAgent.restartLater(this, l);
    }

    public void restart() {
        this.myEvent.init(true, -1);
        this.handle(this.myEvent);
        if (this.myAgent != null) {
            this.myAgent.notifyRestarted(this);
        }
    }

    public void setAgent(Agent agent) {
        this.myAgent = agent;
    }

    private Agent getAgent() {
        return this.myAgent;
    }

    public DataStore getDataStore() {
        if (this.myStore == null) {
            this.myStore = new DataStore();
        }
        return this.myStore;
    }

    public void setDataStore(DataStore dataStore) {
        this.myStore = dataStore;
    }

    private Long getPersistentID() {
        return this.persistentID;
    }

    private void setPersistentID(Long l) {
        this.persistentID = l;
    }

    protected class RunnableChangedEvent
    implements Serializable {
        private static final long serialVersionUID = 3487495895819002L;
        private boolean runnable;
        private int direction;

        protected RunnableChangedEvent() {
        }

        public void init(boolean bl, int n) {
            this.runnable = bl;
            this.direction = n;
        }

        public Behaviour getSource() {
            return Behaviour.this;
        }

        public boolean isRunnable() {
            return this.runnable;
        }

        public boolean isUpwards() {
            return this.direction == -1;
        }
    }
}

