/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Service;
import jade.util.leap.Serializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ServiceDescriptor
implements Serializable {
    private String myName;
    private transient Service myService;
    private String serviceClass;

    public ServiceDescriptor(String string, Service service) {
        this.myName = string;
        this.myService = service;
    }

    public ServiceDescriptor() {
        this(null, null);
    }

    public void setName(String string) {
        this.myName = string;
    }

    public String getName() {
        return this.myName;
    }

    public void setService(Service service) {
        this.myService = service;
    }

    public Service getService() {
        return this.myService;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.myService != null) {
            this.serviceClass = this.myService.getClass().getName();
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serviceClass != null) {
            try {
                this.myService = (Service)Class.forName(this.serviceClass).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw classNotFoundException;
            }
            catch (Throwable throwable) {
                throw new IOException("Can't create service " + this.serviceClass + ". " + throwable.getMessage());
            }
        }
    }
}

