/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.AgentContainerImpl;
import jade.core.Profile;
import jade.core.TimerDispatcher;
import jade.util.Logger;
import jade.util.leap.LinkedList;
import jade.wrapper.AgentContainer;

public class Runtime {
    private static final int MULTIPLE_MODE = 0;
    private static final int SINGLE_MODE = 1;
    private static final int UNKNOWN_MODE = 2;
    private static Runtime theInstance = new Runtime();
    private ThreadGroup criticalThreads;
    private int activeContainers = 0;
    private LinkedList terminators = new LinkedList();
    private AgentContainerImpl theContainer = null;
    private int mode = 2;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    private Runtime() {
    }

    public static Runtime instance() {
        return theInstance;
    }

    public AgentContainer createAgentContainer(Profile profile) {
        if (this.mode == 2 || this.mode == 0) {
            this.mode = 0;
            profile.setParameter("main", "false");
            AgentContainerImpl agentContainerImpl = new AgentContainerImpl(profile);
            this.beginContainer();
            if (agentContainerImpl.joinPlatform()) {
                return agentContainerImpl.getContainerController();
            }
            return null;
        }
        throw new IllegalStateException("Single-container modality already activated");
    }

    public AgentContainer createMainContainer(Profile profile) {
        if (this.mode == 2 || this.mode == 0) {
            this.mode = 0;
            profile.setParameter("main", "true");
            AgentContainerImpl agentContainerImpl = new AgentContainerImpl(profile);
            this.beginContainer();
            if (agentContainerImpl.joinPlatform()) {
                return agentContainerImpl.getContainerController();
            }
            return null;
        }
        throw new IllegalStateException("Single-container modality already activated");
    }

    public void setCloseVM(boolean bl) {
        if (bl) {
            this.terminators.addLast(new Runnable(){

                public void run() {
                    Thread.yield();
                    Runtime.this.myLogger.log(Logger.INFO, "JADE is closing down now.");
                    System.exit(0);
                }
            });
        }
    }

    public void startUp(Profile profile) {
        if (this.mode == 0) {
            throw new IllegalStateException("Multiple-container modality already activated");
        }
        if (this.mode == 2) {
            this.mode = 1;
            this.theContainer = new AgentContainerImpl(profile);
            this.beginContainer();
            this.theContainer.joinPlatform();
        }
    }

    public void shutDown() {
        if (this.theContainer != null) {
            this.theContainer.shutDown();
        }
    }

    public void invokeOnTermination(Runnable runnable) {
        this.terminators.addFirst(runnable);
    }

    void beginContainer() {
        this.myLogger.log(Logger.INFO, "----------------------------------\n" + Runtime.getCopyrightNotice() + "----------------------------------------");
        if (this.activeContainers == 0) {
            TimerDispatcher timerDispatcher = new TimerDispatcher();
            this.criticalThreads = new ThreadGroup("JADE time-critical threads");
            this.criticalThreads.setMaxPriority(10);
            Thread thread = new Thread(this.criticalThreads, timerDispatcher);
            thread.setPriority(this.criticalThreads.getMaxPriority());
            thread.setName("JADE Timer dispatcher");
            timerDispatcher.setThread(thread);
            TimerDispatcher.setTimerDispatcher(timerDispatcher);
            timerDispatcher.start();
        }
        ++this.activeContainers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endContainer() {
        --this.activeContainers;
        if (this.activeContainers == 0) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    int n = 0;
                    while (n < Runtime.this.terminators.size()) {
                        Runnable runnable = (Runnable)Runtime.this.terminators.get(n);
                        runnable.run();
                        ++n;
                    }
                }
            });
            thread.setDaemon(false);
            TimerDispatcher.getTimerDispatcher().stop();
            this.mode = 2;
            this.theContainer = null;
            try {
                try {
                    this.criticalThreads.destroy();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    this.myLogger.log(Logger.WARNING, "Time-critical threads still active: ");
                    this.criticalThreads.list();
                    Object var4_3 = null;
                    this.criticalThreads = null;
                }
                Object var4_2 = null;
                this.criticalThreads = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.criticalThreads = null;
                throw throwable;
            }
            thread.start();
        }
    }

    public TimerDispatcher getTimerDispatcher() {
        return TimerDispatcher.getTimerDispatcher();
    }

    public static String getCopyrightNotice() {
        return "    This is " + Runtime.instance().getVersionInfo() + "\n    downloaded in Open Source, under LGPL restrictions,\n    at http://jade.cselt.it/\n";
    }

    public String getVersionInfo() {
        int n;
        String string = "$Name: JADE-3_3 $";
        String string2 = "$Date: 2005/03/02 16:11:05 $";
        int n2 = string.indexOf(":");
        String string3 = string.substring(n2 + 1, n = string.lastIndexOf(36));
        if (string3.indexOf("JADE") == -1) {
            string3 = "JADE snapshot";
        } else {
            string3 = string3.replace('-', ' ');
            string3 = string3.replace('_', '.');
            string3 = string3.trim();
        }
        n2 = string2.indexOf(58);
        n = string2.lastIndexOf(36);
        String string4 = string2.substring(n2 + 1, n);
        string4 = string4.trim();
        return string3 + " - " + string4;
    }
}

