/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.CaseInsensitiveString;
import jade.core.CommandProcessor;
import jade.core.IMTPException;
import jade.core.IMTPManager;
import jade.core.MainContainerImpl;
import jade.core.PlatformManager;
import jade.core.PlatformManagerImpl;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.ResourceManager;
import jade.core.ServiceFinder;
import jade.core.ServiceManager;
import jade.core.ServiceManagerImpl;
import jade.core.Specifier;
import jade.util.BasicProperties;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import jade.util.leap.Properties;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class ProfileImpl
extends Profile {
    private Properties props = null;
    private static final String RESOURCE = "resource";
    public static final int DEFAULT_PORT = 1099;
    private static final String DEFAULT_IMTPMANAGER_CLASS = "jade.imtp.rmi.RMIIMTPManager";
    private MainContainerImpl myMain = null;
    private PlatformManager myPlatformManager = null;
    private ServiceManager myServiceManager = null;
    private CommandProcessor myCommandProcessor = null;
    private IMTPManager myIMTPManager = null;
    private ResourceManager myResourceManager = null;
    private boolean udpMonitoring;
    private int udpMonitoringPort;
    private int udpMonitoringPingDelay;
    private int udpMonitoringTimeLimit;

    public ProfileImpl(Properties properties) {
        this.props = properties;
        this.init();
    }

    public ProfileImpl(boolean bl) {
        this.props = new BasicProperties();
        this.props.setProperty("main", new Boolean(bl).toString());
        this.init();
    }

    public ProfileImpl() {
        this(true);
    }

    public ProfileImpl(String string) throws ProfileException {
        this.props = new Properties();
        if (string != null) {
            try {
                this.props.load(string);
            }
            catch (IOException iOException) {
                throw new ProfileException("Can't load properties: " + iOException.getMessage());
            }
        }
        this.init();
    }

    public ProfileImpl(String string, int n, String string2) {
        this.props = new BasicProperties();
        if (string != null) {
            this.props.setProperty("host", string);
        }
        if (n > 0) {
            this.setIntProperty("port", n);
        }
        if (string2 != null) {
            this.props.setProperty("platform-id", string2);
        }
        this.init();
    }

    private void init() {
        Object object;
        Object object2;
        String string;
        String string2;
        String string3;
        if (this.props.getProperty("jvm") == null) {
            this.props.setProperty("jvm", "j2se");
        }
        this.setPropertyIfNot("main", "true");
        String string4 = this.props.getProperty("host");
        if (string4 == null) {
            string4 = Profile.getDefaultNetworkName();
            this.props.setProperty("host", string4);
        }
        if ((string3 = this.props.getProperty("port")) == null) {
            string2 = this.props.getProperty("local-port");
            string3 = this.isFirstMain() ? (string2 != null ? string2 : Integer.toString(1099)) : Integer.toString(1099);
            this.props.setProperty("port", string3);
        }
        if ((string2 = this.props.getProperty("local-host")) == null) {
            string2 = this.isFirstMain() ? string4 : Profile.getDefaultNetworkName();
            this.props.setProperty("local-host", string2);
        }
        if ((string = this.props.getProperty("local-port")) == null) {
            string = this.isFirstMain() ? string3 : Integer.toString(1099);
            this.props.setProperty("local-port", string);
        }
        this.setPropertyIfNot("services", "jade.core.mobility.AgentMobilityService;jade.core.event.NotificationService");
        try {
            object2 = this.getSpecifiers("agents");
            object = this.props.getProperty("gui");
            if (object != null && CaseInsensitiveString.equalsIgnoreCase((String)object, "true")) {
                Specifier specifier = new Specifier();
                specifier.setName("rma");
                specifier.setClassName("jade.tools.rma.rma");
                object2.add(0, specifier);
                this.props.put("agents", object2);
            }
        }
        catch (ProfileException profileException) {
            profileException.printStackTrace();
        }
        if (this.isMain() && !this.getBooleanProperty("nomtp", false) && this.props.getProperty("mtps") == null) {
            object2 = new Specifier();
            ((Specifier)object2).setClassName("jade.mtp.http.MessageTransportProtocol");
            object = new ArrayList(1);
            object.add(object2);
            this.props.put("mtps", object);
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setParameter(String string, String string2) {
        this.props.setProperty(string, string2);
    }

    public void setSpecifiers(String string, List list) {
        this.props.put(string, list);
    }

    public String getParameter(String string, String string2) {
        String string3;
        String string4 = this.props.getProperty(string);
        if (string4 == null) {
            string3 = string.replace('_', '.');
            string4 = this.props.getProperty(string3);
        }
        if (string4 == null) {
            string3 = string.replace('.', '_');
            string4 = this.props.getProperty(string3);
        }
        return string4 != null ? string4.trim() : string2;
    }

    public List getSpecifiers(String string) throws ProfileException {
        List list = null;
        try {
            list = (List)this.props.get(string);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (list != null) {
            return list;
        }
        String string2 = this.getParameter(string, null);
        try {
            Vector vector = Specifier.parseSpecifierList(string2);
            ArrayList arrayList = new ArrayList(vector.size());
            int n = 0;
            while (n < vector.size()) {
                arrayList.add(vector.elementAt(n));
                ++n;
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new ProfileException("Error parsing specifier list " + string2 + ".", exception);
        }
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        String string2 = this.props.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        if (CaseInsensitiveString.equalsIgnoreCase(string2, "true")) {
            return true;
        }
        if (CaseInsensitiveString.equalsIgnoreCase(string2, "false")) {
            return false;
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("(Profile");
        String[] stringArray = this.propsToStringArray();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(" " + stringArray[n]);
                ++n;
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected PlatformManager getPlatformManager() throws ProfileException {
        if (this.myPlatformManager == null) {
            this.createPlatformManager();
        }
        return this.myPlatformManager;
    }

    protected ServiceManager getServiceManager() throws ProfileException {
        if (this.myServiceManager == null) {
            this.myServiceManager = new ServiceManagerImpl(this, this.getPlatformManager());
        }
        return this.myServiceManager;
    }

    protected ServiceFinder getServiceFinder() throws ProfileException {
        return (ServiceFinder)((Object)this.getServiceManager());
    }

    protected CommandProcessor getCommandProcessor() throws ProfileException {
        if (this.myCommandProcessor == null) {
            this.myCommandProcessor = new CommandProcessor();
        }
        return this.myCommandProcessor;
    }

    protected MainContainerImpl getMain() throws ProfileException {
        return this.myMain;
    }

    protected IMTPManager getIMTPManager() throws ProfileException {
        if (this.myIMTPManager == null) {
            this.createIMTPManager();
        }
        return this.myIMTPManager;
    }

    public ResourceManager getResourceManager() throws ProfileException {
        if (this.myResourceManager == null) {
            this.createResourceManager();
        }
        return this.myResourceManager;
    }

    private void createPlatformManager() throws ProfileException {
        try {
            this.myIMTPManager = this.getIMTPManager();
            if (this.isMain()) {
                PlatformManagerImpl platformManagerImpl = new PlatformManagerImpl(this);
                this.myIMTPManager.exportPlatformManager(platformManagerImpl);
                this.myMain = platformManagerImpl.getMain();
                this.myPlatformManager = platformManagerImpl;
                return;
            }
            this.myPlatformManager = this.myIMTPManager.getPlatformManagerProxy();
        }
        catch (IMTPException iMTPException) {
            throw new ProfileException("Can't get a proxy to the Platform Manager", iMTPException);
        }
    }

    private void createIMTPManager() throws ProfileException {
        String string = this.getParameter("imtp", DEFAULT_IMTPMANAGER_CLASS);
        try {
            this.myIMTPManager = (IMTPManager)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new ProfileException("Error loading IMTPManager class " + string);
        }
    }

    private void createResourceManager() throws ProfileException {
        String string = this.getParameter(RESOURCE, "jade.core.FullResourceManager");
        try {
            this.myResourceManager = (ResourceManager)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new ProfileException("Error loading ResourceManager class " + string);
        }
    }

    private void setPropertyIfNot(String string, String string2) {
        String string3 = this.props.getProperty(string);
        if (string3 == null) {
            this.props.setProperty(string, string2);
        }
    }

    private void setIntProperty(String string, int n) {
        this.props.setProperty(string, Integer.toString(n));
    }

    private String[] propsToStringArray() {
        String[] stringArray = new String[this.props.size()];
        int n = 0;
        Enumeration<Object> enumeration = this.props.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.props.getProperty(string);
            stringArray[n++] = string2 != null ? string + "=" + string2 : string + "=";
        }
        return stringArray;
    }

    protected boolean isMain() {
        return this.getBooleanProperty("main", false);
    }

    protected boolean isFirstMain() {
        return this.isMain() && !this.getBooleanProperty("backupmain", false);
    }
}

