/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.AgentDescriptor;
import jade.core.AgentManager;
import jade.core.AgentState;
import jade.core.CaseInsensitiveString;
import jade.core.Channel;
import jade.core.CommandProcessor;
import jade.core.ContainerID;
import jade.core.ContainerTable;
import jade.core.GADT;
import jade.core.GenericCommand;
import jade.core.IMTPException;
import jade.core.IMTPManager;
import jade.core.Location;
import jade.core.MainContainer;
import jade.core.NameClashException;
import jade.core.NodeDescriptor;
import jade.core.NotFoundException;
import jade.core.PlatformManager;
import jade.core.PlatformManagerImpl;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.UnreachableException;
import jade.core.behaviours.Behaviour;
import jade.core.event.MTPEvent;
import jade.core.event.PlatformEvent;
import jade.domain.FIPAAgentManagement.AMSAgentDescription;
import jade.domain.FIPAAgentManagement.AlreadyRegistered;
import jade.domain.FIPAAgentManagement.NotRegistered;
import jade.domain.ams;
import jade.domain.df;
import jade.mtp.MTPDescriptor;
import jade.mtp.MTPException;
import jade.security.Credentials;
import jade.security.JADEPrincipal;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import jade.util.leap.Serializable;

public class MainContainerImpl
implements MainContainer,
AgentManager {
    private ams theAMS;
    private df defaultDF;
    private ContainerID localContainerID;
    private IMTPManager myIMTPManager;
    private PlatformManagerImpl myPlatformManager;
    private CommandProcessor myCommandProcessor;
    private List platformListeners = new LinkedList();
    private List platformAddresses = new LinkedList();
    private List agentTools = new LinkedList();
    private ContainerTable containers = new ContainerTable();
    private GADT platformAgents = new GADT();
    private Profile myProfile;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    public MainContainerImpl(Profile profile, PlatformManagerImpl platformManagerImpl) throws ProfileException {
        this.myProfile = profile;
        this.myIMTPManager = profile.getIMTPManager();
        this.myCommandProcessor = profile.getCommandProcessor();
        this.myPlatformManager = platformManagerImpl;
    }

    public PlatformManager getPlatformManager() {
        return this.myPlatformManager;
    }

    void addLocalContainer(ContainerID containerID) {
        this.containers.addContainer(containerID);
        this.localContainerID = containerID;
    }

    void removeLocalContainer(ContainerID containerID) {
        Agent agent = this.defaultDF;
        agent.doDelete();
        agent.join();
        agent.resetToolkit();
        agent = this.theAMS;
        agent.doDelete();
        agent.join();
        agent.resetToolkit();
        this.removeListener(this.theAMS);
    }

    void addRemoteContainer(ContainerID containerID) {
        this.containers.addContainer(containerID);
        this.fireAddedContainer(containerID);
    }

    void removeRemoteContainer(ContainerID containerID) {
        this.removeAllMTPs(containerID);
        this.containers.removeContainer(containerID);
        this.removeAllAgents(containerID);
        this.fireRemovedContainer(containerID);
    }

    void initSystemAgents(AgentContainer agentContainer, boolean bl) throws IMTPException, NotFoundException, JADESecurityException {
        ContainerID containerID = agentContainer.getID();
        this.theAMS = new ams(this);
        this.fireAddedContainer(containerID);
        this.defaultDF = new df();
        if (bl) {
            this.startSystemAgents(agentContainer);
        }
    }

    void startSystemAgents(AgentContainer agentContainer) throws IMTPException, NotFoundException, JADESecurityException {
        AID aID;
        ContainerID containerID = agentContainer.getID();
        NodeDescriptor nodeDescriptor = this.getDescriptor(containerID.getName());
        JADEPrincipal jADEPrincipal = nodeDescriptor.getOwnerPrincipal();
        Credentials credentials = nodeDescriptor.getOwnerCredentials();
        try {
            this.theAMS.resetEvents(true);
            aID = agentContainer.getAMS();
            agentContainer.initAgent(aID, this.theAMS, jADEPrincipal, null);
            agentContainer.powerUpLocalAgent(aID);
            this.theAMS.waitUntilStarted();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IMTPException("Exception during AMS startup", exception);
        }
        try {
            aID = agentContainer.getDefaultDF();
            agentContainer.initAgent(aID, this.defaultDF, jADEPrincipal, null);
            agentContainer.powerUpLocalAgent(aID);
            this.defaultDF.waitUntilStarted();
        }
        catch (Exception exception) {
            throw new IMTPException("Exception during Default DF startup", exception);
        }
    }

    void installAMSBehaviour(Behaviour behaviour) {
        this.theAMS.addBehaviour(behaviour);
    }

    void uninstallAMSBehaviour(Behaviour behaviour) {
        this.theAMS.removeBehaviour(behaviour);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void bornAgent(AID aID, ContainerID containerID, JADEPrincipal jADEPrincipal, String string, boolean bl) throws NameClashException, NotFoundException {
        AgentDescriptor agentDescriptor = new AgentDescriptor(false);
        agentDescriptor.setContainerID(containerID);
        agentDescriptor.setPrincipal(jADEPrincipal);
        AMSAgentDescription aMSAgentDescription = new AMSAgentDescription();
        aMSAgentDescription.setName(aID);
        aMSAgentDescription.setOwnership(string);
        aMSAgentDescription.setState("active");
        agentDescriptor.setDescription(aMSAgentDescription);
        AgentDescriptor agentDescriptor2 = this.platformAgents.put(aID, agentDescriptor);
        if (agentDescriptor2 != null) {
            if (!agentDescriptor2.isNative()) {
                this.platformAgents.put(aID, agentDescriptor2);
                throw new NameClashException("Agent " + aID + " already registered to the platform ");
            }
            if (!bl) {
                this.platformAgents.put(aID, agentDescriptor2);
                throw new NameClashException("Agent " + aID + " already present in the platform ");
            }
            System.out.println("Replacing a dead agent ...");
            this.fireDeadAgent(agentDescriptor2.getContainerID(), aID);
        }
        this.fireBornAgent(containerID, aID, string);
    }

    public void deadAgent(AID aID) throws NotFoundException {
        AgentDescriptor agentDescriptor = this.platformAgents.acquire(aID);
        if (agentDescriptor == null) {
            throw new NotFoundException("DeadAgent failed to find " + aID);
        }
        ContainerID containerID = agentDescriptor.getContainerID();
        this.platformAgents.remove(aID);
        this.fireDeadAgent(containerID, aID);
    }

    public void suspendedAgent(AID aID) throws NotFoundException {
        AgentDescriptor agentDescriptor = this.platformAgents.acquire(aID);
        if (agentDescriptor == null) {
            throw new NotFoundException("SuspendedAgent failed to find " + aID);
        }
        AMSAgentDescription aMSAgentDescription = agentDescriptor.getDescription();
        if (aMSAgentDescription != null) {
            aMSAgentDescription.setState("suspended");
        }
        ContainerID containerID = agentDescriptor.getContainerID();
        this.platformAgents.release(aID);
        this.fireSuspendedAgent(containerID, aID);
    }

    public void resumedAgent(AID aID) throws NotFoundException {
        AgentDescriptor agentDescriptor = this.platformAgents.acquire(aID);
        if (agentDescriptor == null) {
            throw new NotFoundException("ResumedAgent failed to find " + aID);
        }
        AMSAgentDescription aMSAgentDescription = agentDescriptor.getDescription();
        if (aMSAgentDescription != null) {
            aMSAgentDescription.setState("active");
        }
        ContainerID containerID = agentDescriptor.getContainerID();
        this.platformAgents.release(aID);
        this.fireResumedAgent(containerID, aID);
    }

    public void movedAgent(AID aID, ContainerID containerID, ContainerID containerID2) throws NotFoundException {
        AgentDescriptor agentDescriptor = this.platformAgents.acquire(aID);
        if (agentDescriptor == null) {
            throw new NotFoundException("Agent " + aID.getName() + " not found in GADT");
        }
        agentDescriptor.setContainerID(containerID2);
        this.fireMovedAgent(containerID, containerID2, aID);
        this.platformAgents.release(aID);
    }

    public void frozenAgent(AID aID, ContainerID containerID) throws NotFoundException {
        AgentDescriptor agentDescriptor = this.platformAgents.acquire(aID);
        if (agentDescriptor == null) {
            throw new NotFoundException("FrozenAgent failed to find " + aID);
        }
        AMSAgentDescription aMSAgentDescription = agentDescriptor.getDescription();
        if (aMSAgentDescription != null) {
            aMSAgentDescription.setState("suspended");
        }
        ContainerID containerID2 = agentDescriptor.getContainerID();
        this.platformAgents.release(aID);
        this.fireFrozenAgent(containerID2, aID, containerID);
    }

    public void thawedAgent(AID aID, ContainerID containerID) throws NotFoundException {
        AgentDescriptor agentDescriptor = this.platformAgents.acquire(aID);
        if (agentDescriptor == null) {
            throw new NotFoundException("ThawedAgent failed to find " + aID);
        }
        AMSAgentDescription aMSAgentDescription = agentDescriptor.getDescription();
        if (aMSAgentDescription != null) {
            aMSAgentDescription.setState("active");
        }
        ContainerID containerID2 = agentDescriptor.getContainerID();
        this.platformAgents.release(aID);
        this.fireThawedAgent(containerID2, aID, containerID);
    }

    public void newMTP(MTPDescriptor mTPDescriptor, ContainerID containerID) throws IMTPException {
        try {
            String string = containerID.getName();
            String[] stringArray = mTPDescriptor.getAddresses();
            String string2 = stringArray[0];
            this.platformAddresses.add(string2);
            this.containers.addMTP(containerID, mTPDescriptor);
            AID[] aIDArray = this.platformAgents.keys();
            int n = 0;
            while (n < aIDArray.length) {
                AgentDescriptor agentDescriptor = this.platformAgents.acquire(aIDArray[n]);
                AMSAgentDescription aMSAgentDescription = agentDescriptor.getDescription();
                if (aMSAgentDescription != null && agentDescriptor.isNative()) {
                    AID aID = aMSAgentDescription.getName();
                    aID.addAddresses(string2);
                }
                this.platformAgents.release(aIDArray[n]);
                ++n;
            }
            this.fireAddedMTP(mTPDescriptor, containerID);
        }
        catch (NotFoundException notFoundException) {
            System.out.println("Error: the container " + containerID.getName() + " was not found.");
        }
    }

    public void deadMTP(MTPDescriptor mTPDescriptor, ContainerID containerID) throws IMTPException {
        try {
            String string = containerID.getName();
            String[] stringArray = mTPDescriptor.getAddresses();
            String string2 = stringArray[0];
            this.platformAddresses.remove(string2);
            this.containers.removeMTP(containerID, mTPDescriptor);
            AID[] aIDArray = this.platformAgents.keys();
            int n = 0;
            while (n < aIDArray.length) {
                AgentDescriptor agentDescriptor = this.platformAgents.acquire(aIDArray[n]);
                AMSAgentDescription aMSAgentDescription = agentDescriptor.getDescription();
                if (agentDescriptor.isNative()) {
                    AID aID = aMSAgentDescription.getName();
                    aID.removeAddresses(string2);
                }
                this.platformAgents.release(aIDArray[n]);
                ++n;
            }
            this.fireRemovedMTP(mTPDescriptor, containerID);
        }
        catch (NotFoundException notFoundException) {
            System.out.println("Error: the container " + containerID.getName() + " was not found.");
        }
    }

    public void addTool(AID aID) {
        GenericCommand genericCommand = new GenericCommand("Add-Tool", "jade.core.management.AgentManagement", null);
        genericCommand.addParam(aID);
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null && object instanceof Throwable) {
            ((Throwable)object).printStackTrace();
        }
    }

    public void removeTool(AID aID) {
        GenericCommand genericCommand = new GenericCommand("Remove-Tool", "jade.core.management.AgentManagement", null);
        genericCommand.addParam(aID);
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null && object instanceof Throwable) {
            ((Throwable)object).printStackTrace();
        }
    }

    public void create(String string, String string2, String[] stringArray, ContainerID containerID, JADEPrincipal jADEPrincipal, Credentials credentials, JADEPrincipal jADEPrincipal2, Credentials credentials2) throws UnreachableException, JADESecurityException, NotFoundException, NameClashException {
        if (containerID == null || containerID.getName() == null) {
            containerID = this.localContainerID;
        }
        GenericCommand genericCommand = new GenericCommand("Request-Create", "jade.core.management.AgentManagement", null);
        genericCommand.addParam(string);
        genericCommand.addParam(string2);
        genericCommand.addParam(stringArray);
        genericCommand.addParam(containerID);
        genericCommand.addParam(jADEPrincipal);
        genericCommand.addParam(credentials);
        genericCommand.setPrincipal(jADEPrincipal2);
        genericCommand.setCredentials(credentials2);
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null) {
            if (object instanceof NotFoundException) {
                throw (NotFoundException)object;
            }
            if (object instanceof NameClashException) {
                throw (NameClashException)object;
            }
            if (object instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)object);
            }
            if (object instanceof JADESecurityException) {
                throw (JADESecurityException)object;
            }
            if (object instanceof Throwable) {
                ((Throwable)object).printStackTrace();
                throw new RuntimeException(((Throwable)object).getMessage());
            }
        }
    }

    public void kill(AID aID, JADEPrincipal jADEPrincipal, Credentials credentials) throws NotFoundException, UnreachableException, JADESecurityException {
        GenericCommand genericCommand = new GenericCommand("Request-Kill", "jade.core.management.AgentManagement", null);
        genericCommand.addParam(aID);
        genericCommand.setPrincipal(jADEPrincipal);
        genericCommand.setCredentials(credentials);
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null) {
            if (object instanceof NotFoundException) {
                throw (NotFoundException)object;
            }
            if (object instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)object);
            }
            if (object instanceof JADESecurityException) {
                throw (JADESecurityException)object;
            }
            if (object instanceof Throwable) {
                throw new RuntimeException(((Throwable)object).getMessage());
            }
        }
    }

    public void suspend(AID aID) throws NotFoundException, UnreachableException, JADESecurityException {
        GenericCommand genericCommand = new GenericCommand("Request-State-Change", "jade.core.management.AgentManagement", null);
        genericCommand.addParam(aID);
        genericCommand.addParam(AgentState.getInstance(4));
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null) {
            if (object instanceof NotFoundException) {
                throw (NotFoundException)object;
            }
            if (object instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)object);
            }
            if (object instanceof JADESecurityException) {
                throw (JADESecurityException)object;
            }
            if (object instanceof Throwable) {
                throw new RuntimeException(((Throwable)object).getMessage());
            }
        }
    }

    public void activate(AID aID) throws NotFoundException, UnreachableException, JADESecurityException {
        GenericCommand genericCommand = new GenericCommand("Request-State-Change", "jade.core.management.AgentManagement", null);
        genericCommand.addParam(aID);
        genericCommand.addParam(AgentState.getInstance(2));
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null) {
            if (object instanceof NotFoundException) {
                throw (NotFoundException)object;
            }
            if (object instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)object);
            }
            if (object instanceof JADESecurityException) {
                throw (JADESecurityException)object;
            }
            if (object instanceof Throwable) {
                throw new RuntimeException(((Throwable)object).getMessage());
            }
        }
    }

    public void wait(AID aID, String string) throws NotFoundException, UnreachableException {
        GenericCommand genericCommand = new GenericCommand("Request-State-Change", "jade.core.management.AgentManagement", null);
        genericCommand.addParam(aID);
        genericCommand.addParam(AgentState.getInstance(5));
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null) {
            if (object instanceof NotFoundException) {
                throw (NotFoundException)object;
            }
            if (object instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)object);
            }
            if (object instanceof Throwable) {
                throw new RuntimeException(((Throwable)object).getMessage());
            }
        }
    }

    public void wake(AID aID, String string) throws NotFoundException, UnreachableException {
        GenericCommand genericCommand = new GenericCommand("Request-State-Change", "jade.core.management.AgentManagement", null);
        genericCommand.addParam(aID);
        genericCommand.addParam(AgentState.getInstance(2));
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null) {
            if (object instanceof NotFoundException) {
                throw (NotFoundException)object;
            }
            if (object instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)object);
            }
            if (object instanceof Throwable) {
                throw new RuntimeException(((Throwable)object).getMessage());
            }
        }
    }

    public void move(AID aID, Location location) throws NotFoundException, UnreachableException, JADESecurityException {
        ContainerID containerID = this.getContainerID(aID);
        ContainerID containerID2 = (ContainerID)location;
        this.getDescriptor(containerID2.getName());
        GenericCommand genericCommand = new GenericCommand("Request-Move", "jade.core.mobility.AgentMobility", null);
        genericCommand.addParam(aID);
        genericCommand.addParam(location);
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null) {
            if (object instanceof NotFoundException) {
                throw (NotFoundException)object;
            }
            if (object instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)object);
            }
            if (object instanceof JADESecurityException) {
                throw (JADESecurityException)object;
            }
            if (object instanceof Throwable) {
                throw new RuntimeException(((Throwable)object).getMessage());
            }
        }
    }

    public void copy(AID aID, Location location, String string) throws NotFoundException, NameClashException, UnreachableException, JADESecurityException {
        ContainerID containerID = this.getContainerID(aID);
        ContainerID containerID2 = (ContainerID)location;
        this.getDescriptor(containerID2.getName());
        GenericCommand genericCommand = new GenericCommand("Request-Clone", "jade.core.mobility.AgentMobility", null);
        genericCommand.addParam(aID);
        genericCommand.addParam(location);
        genericCommand.addParam(string);
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null) {
            if (object instanceof NotFoundException) {
                throw (NotFoundException)object;
            }
            if (object instanceof NameClashException) {
                throw (NameClashException)object;
            }
            if (object instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)object);
            }
            if (object instanceof JADESecurityException) {
                throw (JADESecurityException)object;
            }
            if (object instanceof Throwable) {
                throw new RuntimeException(((Throwable)object).getMessage());
            }
        }
    }

    public void killContainer(ContainerID containerID, JADEPrincipal jADEPrincipal, Credentials credentials) throws NotFoundException, UnreachableException, JADESecurityException {
        GenericCommand genericCommand = new GenericCommand("Kill-Container", "jade.core.management.AgentManagement", null);
        genericCommand.addParam(containerID);
        genericCommand.setPrincipal(jADEPrincipal);
        genericCommand.setCredentials(credentials);
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null) {
            if (object instanceof NotFoundException) {
                throw (NotFoundException)object;
            }
            if (object instanceof JADESecurityException) {
                throw (JADESecurityException)object;
            }
            if (object instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)object);
            }
            if (object instanceof Throwable) {
                throw new RuntimeException(object.toString());
            }
        }
    }

    public void shutdownPlatform(JADEPrincipal jADEPrincipal, Credentials credentials) throws JADESecurityException {
        block20: {
            Serializable serializable;
            Serializable serializable2;
            if (this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "Shutting down agent platform.");
            }
            int n = 0;
            ContainerID[] containerIDArray = this.containers.names();
            int n2 = 0;
            while (n2 < containerIDArray.length) {
                ContainerID containerID = containerIDArray[n2];
                serializable2 = this.myPlatformManager.getDescriptor(containerID.getName());
                if (serializable2 != null) {
                    if (((NodeDescriptor)serializable2).getParentNode() != null) {
                        this.shutdownContainer(containerID, "Container", jADEPrincipal, credentials);
                        ++n;
                    }
                } else {
                    this.removeRemoteContainer(containerID);
                }
                ++n2;
            }
            if (n > 0 && this.myLogger.isLoggable(Logger.FINER)) {
                this.myLogger.log(Logger.FINER, "Containers on child nodes shutdown completed.");
            }
            n = 0;
            containerIDArray = this.containers.names();
            int n3 = 0;
            while (n3 < containerIDArray.length) {
                serializable2 = containerIDArray[n3];
                serializable = this.myPlatformManager.getDescriptor(((ContainerID)serializable2).getName());
                if (serializable != null) {
                    if (!((NodeDescriptor)serializable).getNode().hasPlatformManager()) {
                        this.shutdownContainer((ContainerID)serializable2, "Container", jADEPrincipal, credentials);
                        ++n;
                    }
                } else {
                    this.removeRemoteContainer((ContainerID)serializable2);
                }
                ++n3;
            }
            if (n > 0 && this.myLogger.isLoggable(Logger.FINER)) {
                this.myLogger.log(Logger.FINER, "Peripheral containers shutdown completed.");
            }
            this.myPlatformManager.shutdown();
            n = 0;
            containerIDArray = this.containers.names();
            int n4 = 0;
            while (n4 < containerIDArray.length) {
                serializable = containerIDArray[n4];
                if (!((ContainerID)serializable).equals(this.localContainerID)) {
                    this.shutdownContainer((ContainerID)serializable, "Main Container", jADEPrincipal, credentials);
                    ++n;
                }
                ++n4;
            }
            if (n > 0 && this.myLogger.isLoggable(Logger.FINER)) {
                this.myLogger.log(Logger.FINER, "Backup Main Containers shutdown completed.");
            }
            try {
                if (this.myLogger.isLoggable(Logger.FINEST)) {
                    this.myLogger.log(Logger.FINEST, "Killing local node " + this.localContainerID.getName());
                }
                this.killContainer(this.localContainerID, jADEPrincipal, credentials);
                boolean bl = this.containers.waitUntilEmpty(5000L);
                if (!bl || !this.myLogger.isLoggable(Logger.FINEST)) break block20;
                this.myLogger.log(Logger.FINEST, "Local node shutdown completed.");
            }
            catch (NotFoundException notFoundException) {
                this.myLogger.log(Logger.FINE, "Container " + this.localContainerID.getName() + " does not exist. Ignoring...");
            }
            catch (UnreachableException unreachableException) {
                this.myLogger.log(Logger.WARNING, "Cannot kill container " + this.localContainerID.getName() + ": Unreachable. " + unreachableException);
            }
            catch (JADESecurityException jADESecurityException) {
                throw jADESecurityException;
            }
            catch (Throwable throwable) {
                this.myLogger.log(Logger.WARNING, "Cannot kill container " + this.localContainerID.getName() + ": Unexpected error. " + throwable);
            }
        }
    }

    private void shutdownContainer(ContainerID containerID, String string, JADEPrincipal jADEPrincipal, Credentials credentials) throws JADESecurityException {
        try {
            if (this.myLogger.isLoggable(Logger.FINEST)) {
                this.myLogger.log(Logger.FINEST, "Killing " + string + " " + containerID.getName());
            }
            this.killContainer(containerID, jADEPrincipal, credentials);
            boolean bl = this.containers.waitForRemoval(containerID, 5000L);
            if (bl) {
                if (this.myLogger.isLoggable(Logger.FINEST)) {
                    this.myLogger.log(Logger.FINEST, string + " " + containerID.getName() + " shutdown completed");
                }
                return;
            }
        }
        catch (NotFoundException notFoundException) {
            this.myLogger.log(Logger.FINE, "Container " + containerID.getName() + " does not exist. Ignoring...");
        }
        catch (UnreachableException unreachableException) {
            this.myLogger.log(Logger.WARNING, "Cannot kill container " + containerID.getName() + ": Unreachable.");
        }
        catch (JADESecurityException jADESecurityException) {
            throw jADESecurityException;
        }
        catch (Throwable throwable) {
            this.myLogger.log(Logger.WARNING, "Cannot kill container " + containerID.getName() + ": Unexpected error. " + throwable);
        }
        this.removeRemoteContainer(containerID);
    }

    public MTPDescriptor installMTP(String string, ContainerID containerID, String string2) throws NotFoundException, UnreachableException, MTPException {
        GenericCommand genericCommand = new GenericCommand("Install-MTP", "jade.core.messaging.Messaging", null);
        genericCommand.addParam(string);
        genericCommand.addParam(containerID);
        genericCommand.addParam(string2);
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null) {
            if (object instanceof NotFoundException) {
                throw (NotFoundException)object;
            }
            if (object instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)object);
            }
            if (object instanceof MTPException) {
                throw (MTPException)object;
            }
            if (object instanceof Throwable) {
                throw new RuntimeException(((Throwable)object).getMessage());
            }
        }
        MTPDescriptor mTPDescriptor = (MTPDescriptor)object;
        return mTPDescriptor;
    }

    public void uninstallMTP(String string, ContainerID containerID) throws NotFoundException, UnreachableException, MTPException {
        GenericCommand genericCommand = new GenericCommand("Uninstall-MTP", "jade.core.messaging.Messaging", null);
        genericCommand.addParam(string);
        genericCommand.addParam(containerID);
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null) {
            if (object instanceof NotFoundException) {
                throw (NotFoundException)object;
            }
            if (object instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)object);
            }
            if (object instanceof MTPException) {
                throw (MTPException)object;
            }
            if (object instanceof Throwable) {
                throw new RuntimeException(((Throwable)object).getMessage());
            }
        }
    }

    public void take(AID aID, String string, byte[] byArray) throws NotFoundException, UnreachableException, JADESecurityException {
    }

    public void sniffOn(AID aID, List list) throws NotFoundException, UnreachableException {
        GenericCommand genericCommand = new GenericCommand("Sniff-On", "jade.core.event.Notification", null);
        genericCommand.addParam(aID);
        genericCommand.addParam(list);
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null) {
            if (object instanceof NotFoundException) {
                throw (NotFoundException)object;
            }
            if (object instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)object);
            }
            if (object instanceof Throwable) {
                throw new RuntimeException(((Throwable)object).getMessage());
            }
        }
    }

    public void sniffOff(AID aID, List list) throws NotFoundException, UnreachableException {
        GenericCommand genericCommand = new GenericCommand("Sniff-Off", "jade.core.event.Notification", null);
        genericCommand.addParam(aID);
        genericCommand.addParam(list);
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null) {
            if (object instanceof NotFoundException) {
                throw (NotFoundException)object;
            }
            if (object instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)object);
            }
            if (object instanceof Throwable) {
                throw new RuntimeException(((Throwable)object).getMessage());
            }
        }
    }

    public void debugOn(AID aID, List list) throws NotFoundException, UnreachableException {
        GenericCommand genericCommand = new GenericCommand("Debug-On", "jade.core.event.Notification", null);
        genericCommand.addParam(aID);
        genericCommand.addParam(list);
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null) {
            if (object instanceof NotFoundException) {
                throw (NotFoundException)object;
            }
            if (object instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)object);
            }
            if (object instanceof Throwable) {
                throw new RuntimeException(((Throwable)object).getMessage());
            }
        }
    }

    public void debugOff(AID aID, List list) throws NotFoundException, UnreachableException {
        GenericCommand genericCommand = new GenericCommand("Debug-Off", "jade.core.event.Notification", null);
        genericCommand.addParam(aID);
        genericCommand.addParam(list);
        Object object = this.myCommandProcessor.processOutgoing(genericCommand);
        if (object != null) {
            if (object instanceof NotFoundException) {
                throw (NotFoundException)object;
            }
            if (object instanceof IMTPException) {
                throw new UnreachableException("", (IMTPException)object);
            }
            if (object instanceof Throwable) {
                throw new RuntimeException(((Throwable)object).getMessage());
            }
        }
    }

    public void amsRegister(AMSAgentDescription aMSAgentDescription) throws AlreadyRegistered, JADESecurityException {
        AID aID = aMSAgentDescription.getName();
        AgentDescriptor agentDescriptor = this.platformAgents.acquire(aID);
        if (agentDescriptor == null) {
            System.out.println("No descriptor found for agent " + aID);
            agentDescriptor = new AgentDescriptor(true);
            agentDescriptor.setDescription(aMSAgentDescription);
            this.platformAgents.put(aID, agentDescriptor);
        } else if (agentDescriptor.getDescription() == null) {
            System.out.println("Descriptor with null AMSD found for agent " + aID);
            agentDescriptor.setDescription(aMSAgentDescription);
            this.platformAgents.release(aID);
        } else {
            System.out.println("Descriptor with NON null AMSD found for agent " + aID);
            this.platformAgents.release(aID);
            throw new AlreadyRegistered();
        }
    }

    public void amsDeregister(AMSAgentDescription aMSAgentDescription) throws NotRegistered, JADESecurityException {
        AID aID = aMSAgentDescription.getName();
        AgentDescriptor agentDescriptor = this.platformAgents.acquire(aID);
        if (agentDescriptor != null && agentDescriptor.getDescription() != null) {
            if (agentDescriptor.isNative()) {
                agentDescriptor.setDescription(null);
                this.platformAgents.release(aID);
            } else {
                this.platformAgents.remove(aID);
            }
            return;
        }
        throw new NotRegistered();
    }

    public void amsModify(AMSAgentDescription aMSAgentDescription) throws NotRegistered, NotFoundException, UnreachableException, JADESecurityException {
        AMSAgentDescription aMSAgentDescription2;
        AID aID = aMSAgentDescription.getName();
        AgentDescriptor agentDescriptor = this.platformAgents.acquire(aID);
        if (agentDescriptor != null && (aMSAgentDescription2 = agentDescriptor.getDescription()) != null) {
            agentDescriptor.setDescription(aMSAgentDescription);
            String string = aMSAgentDescription.getState();
            String string2 = aMSAgentDescription.getOwnership();
            if (string2 == null) {
                string2 = aMSAgentDescription2.getOwnership();
            }
            this.platformAgents.release(aID);
            if (agentDescriptor.isNative()) {
                if ("suspended".equals(string) && !"suspended".equals(aMSAgentDescription2.getState())) {
                    this.suspend(aID);
                }
                if ("active".equals(string) && !"active".equals(aMSAgentDescription2.getState())) {
                    this.activate(aID);
                }
                if (string2 == null || string2 != aMSAgentDescription2.getOwnership()) {
                    // empty if block
                }
            }
            return;
        }
        throw new NotRegistered();
    }

    public List amsSearch(AMSAgentDescription aMSAgentDescription, long l) {
        ArrayList arrayList = new ArrayList();
        AID[] aIDArray = this.platformAgents.keys();
        int n = 0;
        while (n < aIDArray.length) {
            try {
                AMSAgentDescription aMSAgentDescription2 = this.getAMSDescription(aIDArray[n]);
                if (this.match(aMSAgentDescription, aMSAgentDescription2)) {
                    arrayList.add(aMSAgentDescription2);
                    if ((long)arrayList.size() >= l) {
                        break;
                    }
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            ++n;
        }
        return arrayList;
    }

    public ContainerID[] containerIDs() {
        return this.containers.names();
    }

    public AID[] agentNames() {
        return this.platformAgents.keys();
    }

    public List containerMTPs(ContainerID containerID) throws NotFoundException {
        return this.containers.getMTPs(containerID);
    }

    public List containerAgents(ContainerID containerID) throws NotFoundException {
        ArrayList arrayList = new ArrayList();
        AID[] aIDArray = this.platformAgents.keys();
        int n = 0;
        while (n < aIDArray.length) {
            AID aID = aIDArray[n];
            AgentDescriptor agentDescriptor = this.platformAgents.acquire(aID);
            ContainerID containerID2 = agentDescriptor.getContainerID();
            if (containerID.equals(containerID2)) {
                arrayList.add(aID);
            }
            this.platformAgents.release(aID);
            ++n;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toolAdded(AID aID) {
        List list = this.agentTools;
        synchronized (list) {
            if (!this.agentTools.contains(aID)) {
                this.agentTools.add(aID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toolRemoved(AID aID) {
        List list = this.agentTools;
        synchronized (list) {
            this.agentTools.remove(aID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AID[] agentTools() {
        List list = this.agentTools;
        synchronized (list) {
            Object[] objectArray = this.agentTools.toArray();
            AID[] aIDArray = new AID[objectArray.length];
            int n = 0;
            while (n < aIDArray.length) {
                aIDArray[n] = (AID)objectArray[n];
                ++n;
            }
            return aIDArray;
        }
    }

    public ContainerID getContainerID(AID aID) throws NotFoundException {
        AgentDescriptor agentDescriptor = this.platformAgents.acquire(aID);
        if (agentDescriptor == null) {
            throw new NotFoundException("getContainerID() failed to find agent " + aID.getName());
        }
        ContainerID containerID = agentDescriptor.getContainerID();
        this.platformAgents.release(aID);
        return containerID;
    }

    public NodeDescriptor getContainerNode(ContainerID containerID) throws NotFoundException {
        return this.getDescriptor(containerID.getName());
    }

    public AMSAgentDescription getAMSDescription(AID aID) throws NotFoundException {
        AgentDescriptor agentDescriptor = this.platformAgents.acquire(aID);
        if (agentDescriptor == null) {
            throw new NotFoundException("getAMSDescription() failed to find agent " + aID.getName());
        }
        AMSAgentDescription aMSAgentDescription = agentDescriptor.getDescription();
        this.platformAgents.release(aID);
        return aMSAgentDescription;
    }

    public void addListener(AgentManager.Listener listener) {
        this.platformListeners.add(listener);
    }

    public void removeListener(AgentManager.Listener listener) {
        this.platformListeners.remove(listener);
    }

    private NodeDescriptor getDescriptor(String string) throws NotFoundException {
        NodeDescriptor nodeDescriptor = this.myPlatformManager.getDescriptor(string);
        if (nodeDescriptor == null) {
            throw new NotFoundException("Node  " + string + " not found.");
        }
        return nodeDescriptor;
    }

    private boolean match(AMSAgentDescription aMSAgentDescription, AMSAgentDescription aMSAgentDescription2) {
        try {
            AID aID;
            Object object;
            String string;
            String string2 = aMSAgentDescription.getOwnership();
            if (!(string2 == null || (string = aMSAgentDescription2.getOwnership()) != null && string2.equalsIgnoreCase(string))) {
                return false;
            }
            string = aMSAgentDescription.getState();
            if (!(string == null || (object = aMSAgentDescription2.getState()) != null && string.equalsIgnoreCase((String)object))) {
                return false;
            }
            object = aMSAgentDescription.getName();
            return object == null || (aID = aMSAgentDescription2.getName()) != null && this.matchAID((AID)object, aID);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    private final boolean matchAID(AID aID, AID aID2) {
        Object object;
        boolean bl;
        Object object2;
        Object object3;
        String string = aID.getName();
        if (!(string == null || (object3 = aID2.getName()) != null && string.equalsIgnoreCase((String)object3))) {
            return false;
        }
        object3 = aID.getAllAddresses();
        Iterator iterator = aID2.getAllAddresses();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            bl = false;
            while (!bl && iterator.hasNext()) {
                object = (String)iterator.next();
                bl = ((String)object2).equalsIgnoreCase((String)object);
            }
            if (bl) continue;
            return false;
        }
        object3 = aID.getAllResolvers();
        iterator = aID2.getAllResolvers();
        while (object3.hasNext()) {
            object2 = (AID)object3.next();
            bl = false;
            while (!bl && iterator.hasNext()) {
                object = (AID)iterator.next();
                bl = this.matchAID((AID)object2, (AID)object);
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private void fireAddedContainer(ContainerID containerID) {
        PlatformEvent platformEvent = new PlatformEvent(1, containerID);
        int n = 0;
        while (n < this.platformListeners.size()) {
            AgentManager.Listener listener = (AgentManager.Listener)this.platformListeners.get(n);
            listener.addedContainer(platformEvent);
            ++n;
        }
    }

    private void fireRemovedContainer(ContainerID containerID) {
        PlatformEvent platformEvent = new PlatformEvent(2, containerID);
        int n = 0;
        while (n < this.platformListeners.size()) {
            AgentManager.Listener listener = (AgentManager.Listener)this.platformListeners.get(n);
            listener.removedContainer(platformEvent);
            ++n;
        }
    }

    private void fireBornAgent(ContainerID containerID, AID aID, String string) {
        PlatformEvent platformEvent = new PlatformEvent(3, aID, containerID, null, string);
        int n = 0;
        while (n < this.platformListeners.size()) {
            AgentManager.Listener listener = (AgentManager.Listener)this.platformListeners.get(n);
            listener.bornAgent(platformEvent);
            ++n;
        }
    }

    private void fireDeadAgent(ContainerID containerID, AID aID) {
        PlatformEvent platformEvent = new PlatformEvent(4, aID, containerID);
        int n = 0;
        while (n < this.platformListeners.size()) {
            AgentManager.Listener listener = (AgentManager.Listener)this.platformListeners.get(n);
            listener.deadAgent(platformEvent);
            ++n;
        }
    }

    private void fireSuspendedAgent(ContainerID containerID, AID aID) {
        PlatformEvent platformEvent = new PlatformEvent(6, aID, containerID);
        int n = 0;
        while (n < this.platformListeners.size()) {
            AgentManager.Listener listener = (AgentManager.Listener)this.platformListeners.get(n);
            listener.suspendedAgent(platformEvent);
            ++n;
        }
    }

    private void fireResumedAgent(ContainerID containerID, AID aID) {
        PlatformEvent platformEvent = new PlatformEvent(7, aID, containerID);
        int n = 0;
        while (n < this.platformListeners.size()) {
            AgentManager.Listener listener = (AgentManager.Listener)this.platformListeners.get(n);
            listener.resumedAgent(platformEvent);
            ++n;
        }
    }

    private void fireFrozenAgent(ContainerID containerID, AID aID, ContainerID containerID2) {
        PlatformEvent platformEvent = new PlatformEvent(10, aID, containerID, containerID2);
        int n = 0;
        while (n < this.platformListeners.size()) {
            AgentManager.Listener listener = (AgentManager.Listener)this.platformListeners.get(n);
            listener.frozenAgent(platformEvent);
            ++n;
        }
    }

    private void fireThawedAgent(ContainerID containerID, AID aID, ContainerID containerID2) {
        PlatformEvent platformEvent = new PlatformEvent(11, aID, containerID, containerID2);
        int n = 0;
        while (n < this.platformListeners.size()) {
            AgentManager.Listener listener = (AgentManager.Listener)this.platformListeners.get(n);
            listener.thawedAgent(platformEvent);
            ++n;
        }
    }

    private void fireMovedAgent(ContainerID containerID, ContainerID containerID2, AID aID) {
        PlatformEvent platformEvent = new PlatformEvent(aID, containerID, containerID2);
        int n = 0;
        while (n < this.platformListeners.size()) {
            AgentManager.Listener listener = (AgentManager.Listener)this.platformListeners.get(n);
            listener.movedAgent(platformEvent);
            ++n;
        }
    }

    private void fireAddedMTP(MTPDescriptor mTPDescriptor, ContainerID containerID) {
        String string = mTPDescriptor.getName();
        String[] stringArray = mTPDescriptor.getAddresses();
        Channel channel = new Channel("FIXME: missing channel name", string, stringArray[0]);
        MTPEvent mTPEvent = new MTPEvent(1, containerID, channel);
        int n = 0;
        while (n < this.platformListeners.size()) {
            AgentManager.Listener listener = (AgentManager.Listener)this.platformListeners.get(n);
            listener.addedMTP(mTPEvent);
            ++n;
        }
    }

    private void fireRemovedMTP(MTPDescriptor mTPDescriptor, ContainerID containerID) {
        String string = mTPDescriptor.getName();
        String[] stringArray = mTPDescriptor.getAddresses();
        Channel channel = new Channel("FIXME: missing channel name", string, stringArray[0]);
        MTPEvent mTPEvent = new MTPEvent(2, containerID, channel);
        int n = 0;
        while (n < this.platformListeners.size()) {
            AgentManager.Listener listener = (AgentManager.Listener)this.platformListeners.get(n);
            listener.removedMTP(mTPEvent);
            ++n;
        }
    }

    private void removeAllAgents(ContainerID containerID) {
        String string = containerID.getName();
        AID[] aIDArray = this.platformAgents.keys();
        int n = 0;
        while (n < aIDArray.length) {
            AgentDescriptor agentDescriptor = this.platformAgents.acquire(aIDArray[n]);
            ContainerID containerID2 = agentDescriptor.getContainerID();
            this.platformAgents.release(aIDArray[n]);
            if (CaseInsensitiveString.equalsIgnoreCase(containerID2.getName(), string)) {
                try {
                    this.deadAgent(aIDArray[n]);
                }
                catch (NotFoundException notFoundException) {
                    notFoundException.printStackTrace();
                }
            }
            ++n;
        }
    }

    private void removeAllMTPs(ContainerID containerID) {
        try {
            List list = this.containers.getMTPs(containerID);
            Object[] objectArray = list.toArray();
            int n = 0;
            while (n < objectArray.length) {
                MTPDescriptor mTPDescriptor = (MTPDescriptor)objectArray[n];
                GenericCommand genericCommand = new GenericCommand("Dead-MTP", "jade.core.messaging.Messaging", null);
                genericCommand.addParam(mTPDescriptor);
                genericCommand.addParam(containerID);
                this.myCommandProcessor.processOutgoing(genericCommand);
                ++n;
            }
        }
        catch (NotFoundException notFoundException) {
            notFoundException.printStackTrace();
        }
    }

    public AgentDescriptor acquireAgentDescriptor(AID aID) {
        return this.platformAgents.acquire(aID);
    }

    public void releaseAgentDescriptor(AID aID) {
        this.platformAgents.release(aID);
    }
}

