/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.AID;
import jade.core.AgentDescriptor;
import jade.util.leap.HashMap;
import jade.util.leap.Map;

class GADT {
    private Map agents = new HashMap();

    GADT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentDescriptor put(AID aID, AgentDescriptor agentDescriptor) {
        Row row;
        Map map = this.agents;
        synchronized (map) {
            row = (Row)this.agents.get(aID);
        }
        if (row == null) {
            this.agents.put(aID, new Row(agentDescriptor));
            return null;
        }
        row.lock();
        this.agents.put(aID, new Row(agentDescriptor));
        AgentDescriptor agentDescriptor2 = row.get();
        row.unlock();
        return agentDescriptor2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentDescriptor remove(AID aID) {
        Row row;
        Map map = this.agents;
        synchronized (map) {
            row = (Row)this.agents.get(aID);
        }
        if (row == null) {
            return null;
        }
        row.lock();
        this.agents.remove(aID);
        AgentDescriptor agentDescriptor = row.get();
        row.clear();
        row.unlock();
        return agentDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentDescriptor acquire(AID aID) {
        Row row;
        Map map = this.agents;
        synchronized (map) {
            row = (Row)this.agents.get(aID);
        }
        if (row == null) {
            return null;
        }
        row.lock();
        return row.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(AID aID) {
        Row row;
        Map map = this.agents;
        synchronized (map) {
            row = (Row)this.agents.get(aID);
        }
        if (row != null) {
            row.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AID[] keys() {
        Map map = this.agents;
        synchronized (map) {
            Object[] objectArray = this.agents.keySet().toArray();
            AID[] aIDArray = new AID[objectArray.length];
            System.arraycopy(objectArray, 0, aIDArray, 0, aIDArray.length);
            return aIDArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentDescriptor[] values() {
        Map map = this.agents;
        synchronized (map) {
            Object[] objectArray = this.agents.values().toArray();
            AgentDescriptor[] agentDescriptorArray = new AgentDescriptor[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                Row row = (Row)objectArray[n];
                agentDescriptorArray[n] = row.get();
                ++n;
            }
            return agentDescriptorArray;
        }
    }

    private static class Row {
        private AgentDescriptor value;
        private Thread owner;
        private long depth;

        public Row(AgentDescriptor agentDescriptor) {
            this.value = agentDescriptor;
            this.depth = 0L;
        }

        public synchronized AgentDescriptor get() {
            return this.value;
        }

        public synchronized void clear() {
            this.value = null;
        }

        public synchronized void lock() {
            try {
                Thread thread = Thread.currentThread();
                while (this.owner != null && this.owner != thread) {
                    this.wait();
                }
                this.owner = thread;
                ++this.depth;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public synchronized void unlock() {
            if (this.owner != Thread.currentThread()) {
                return;
            }
            --this.depth;
            if (this.depth == 0L || this.value == null) {
                this.owner = null;
                this.notifyAll();
            }
        }
    }
}

