/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.content.Concept;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CompositeBehaviour;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;

public class BehaviourID
implements Concept {
    private String name;
    private String className;
    private String kind;
    private List children = new ArrayList();

    public BehaviourID() {
    }

    public BehaviourID(Behaviour behaviour) {
        this.name = behaviour.getBehaviourName();
        this.className = behaviour.getClass().getName();
        this.kind = this.getClassKind(behaviour.getClass());
        if (behaviour instanceof CompositeBehaviour) {
            CompositeBehaviour compositeBehaviour = (CompositeBehaviour)behaviour;
            Iterator iterator = compositeBehaviour.getChildren().iterator();
            while (iterator.hasNext()) {
                this.addChildren(new BehaviourID((Behaviour)iterator.next()));
            }
        }
    }

    private String getClassKind(Class clazz) {
        int n;
        int n2;
        if (clazz == null) {
            return null;
        }
        String string = clazz.getName();
        int n3 = string.lastIndexOf(46);
        int n4 = n2 = n3 > (n = string.lastIndexOf(36)) ? n3 : n;
        if (n2 == -1) {
            return string;
        }
        if (n2 == n3) {
            return string.substring(n2 + 1);
        }
        return this.getClassKind(clazz.getSuperclass());
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public String getClassName() {
        return this.className;
    }

    public void setKind(String string) {
        this.kind = string;
    }

    public String getKind() {
        return this.kind;
    }

    public void addChildren(BehaviourID behaviourID) {
        this.children.add(behaviourID);
    }

    public Iterator getAllChildren() {
        return this.children.iterator();
    }

    public boolean isSimple() {
        return this.children.size() == 0;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof BehaviourID) {
            BehaviourID behaviourID = (BehaviourID)object;
            bl = behaviourID.hashCode() == this.hashCode();
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        if (this.name != null) {
            n = this.name.hashCode();
        }
        if (this.className != null) {
            n = n * 2 + this.className.hashCode();
        }
        if (this.kind != null) {
            n = n * 2 + this.kind.hashCode();
        }
        return n;
    }

    public String toString() {
        return this.name;
    }
}

