/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.CaseInsensitiveString;
import jade.lang.acl.StringACLCodec;
import jade.util.leap.ArrayList;
import jade.util.leap.Comparable;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Properties;
import jade.util.leap.Serializable;
import java.util.Enumeration;

public class AID
implements Comparable,
Serializable {
    private static String platformID;
    private String name;
    private int hashCode;
    private static final int EXPECTED_ADDRESSES_SIZE = 0;
    private static final int EXPECTED_RESOLVERS_SIZE = 0;
    private List addresses = new ArrayList(0);
    private List resolvers = new ArrayList(0);
    private Properties userDefSlots = new Properties();
    public static final boolean ISGUID = true;
    public static final boolean ISLOCALNAME = false;
    private transient Long persistentID;

    public AID() {
        this("", true);
    }

    public AID(String string) {
        this(string, true);
    }

    public AID(String string, boolean bl) {
        if (bl) {
            this.setName(string);
        } else {
            this.setLocalName(string);
        }
    }

    static final String getPlatformID() {
        return platformID;
    }

    static final void setPlatformID(String string) {
        platformID = string;
    }

    public void setName(String string) {
        this.name = string.trim();
        this.hashCode = this.name.toLowerCase().hashCode();
    }

    public void setLocalName(String string) {
        String string2 = AID.getPlatformID();
        if (string2 == null) {
            throw new RuntimeException("Unknown Platform Name");
        }
        this.name = string.trim();
        if (this.name.length() <= string2.length() || !this.name.regionMatches(true, this.name.length() - string2.length(), string2, 0, string2.length())) {
            this.name = this.name.concat("@" + string2);
        }
        this.hashCode = this.name.toLowerCase().hashCode();
    }

    public String getName() {
        return this.name;
    }

    public void addAddresses(String string) {
        if (!this.addresses.contains(string)) {
            this.addresses.add(string);
        }
    }

    public boolean removeAddresses(String string) {
        return this.addresses.remove(string);
    }

    public void clearAllAddresses() {
        this.addresses.clear();
    }

    public Iterator getAllAddresses() {
        return this.addresses.iterator();
    }

    public void addResolvers(AID aID) {
        if (!this.resolvers.contains(aID)) {
            this.resolvers.add(aID);
        }
    }

    public boolean removeResolvers(AID aID) {
        return this.resolvers.remove(aID);
    }

    public void clearAllResolvers() {
        this.resolvers.clear();
    }

    public Iterator getAllResolvers() {
        return this.resolvers.iterator();
    }

    public void addUserDefinedSlot(String string, String string2) {
        this.userDefSlots.setProperty(string, string2);
    }

    public boolean removeUserDefinedSlot(String string) {
        return this.userDefSlots.remove(string) != null;
    }

    public String[] getAddressesArray() {
        Object[] objectArray = this.addresses.toArray();
        String[] stringArray = new String[objectArray.length];
        System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
        return stringArray;
    }

    private void setAddressesArray(String[] stringArray) {
        this.addresses.clear();
        int n = 0;
        while (n < stringArray.length) {
            this.addAddresses(stringArray[n]);
            ++n;
        }
    }

    public AID[] getResolversArray() {
        Object[] objectArray = this.resolvers.toArray();
        AID[] aIDArray = new AID[objectArray.length];
        System.arraycopy(objectArray, 0, aIDArray, 0, objectArray.length);
        return aIDArray;
    }

    private void setResolversArray(AID[] aIDArray) {
        this.resolvers.clear();
        int n = 0;
        while (n < aIDArray.length) {
            this.addResolvers(aIDArray[n]);
            ++n;
        }
    }

    public Properties getAllUserDefinedSlot() {
        return this.userDefSlots;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("( agent-identifier ");
        StringACLCodec.appendACLExpression(stringBuffer, ":name", this.name);
        if (this.addresses.size() > 0) {
            stringBuffer.append(" :addresses (sequence ");
        }
        int n = 0;
        while (n < this.addresses.size()) {
            try {
                stringBuffer.append((String)this.addresses.get(n));
                stringBuffer.append(" ");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
            }
            ++n;
        }
        if (this.addresses.size() > 0) {
            stringBuffer.append(")");
        }
        if (this.resolvers.size() > 0) {
            stringBuffer.append(" :resolvers (sequence ");
        }
        int n2 = 0;
        while (n2 < this.resolvers.size()) {
            try {
                stringBuffer.append(this.resolvers.get(n2).toString());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
            }
            stringBuffer.append(" ");
            ++n2;
        }
        if (this.resolvers.size() > 0) {
            stringBuffer.append(")");
        }
        Enumeration<?> enumeration = this.userDefSlots.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.userDefSlots.getProperty(string);
            stringBuffer.append(" :X-");
            StringACLCodec.appendACLExpression(stringBuffer, string, string2);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public synchronized Object clone() {
        AID aID = new AID(this.name, true);
        aID.persistentID = null;
        aID.addresses = (ArrayList)((ArrayList)this.addresses).clone();
        aID.resolvers = (ArrayList)((ArrayList)this.resolvers).clone();
        aID.userDefSlots = this.userDefSlots;
        return aID;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof AID) {
            return CaseInsensitiveString.equalsIgnoreCase(this.name, ((AID)object).name);
        }
        if (object instanceof String) {
            return CaseInsensitiveString.equalsIgnoreCase(this.name, (String)object);
        }
        return false;
    }

    public int compareTo(Object object) {
        AID aID = (AID)object;
        return this.name.toLowerCase().toUpperCase().compareTo(aID.name.toLowerCase().toUpperCase());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String getLocalName() {
        int n = this.name.lastIndexOf(64);
        if (n == -1) {
            return this.name;
        }
        return this.name.substring(0, n);
    }

    public String getHap() {
        int n = this.name.lastIndexOf(64);
        if (n == -1) {
            return null;
        }
        return this.name.substring(n + 1);
    }

    private Long getPersistentID() {
        return this.persistentID;
    }

    private void setPersistentID(Long l) {
        this.persistentID = l;
    }
}

