/*
 * Decompiled with CFR 0.152.
 */
package jade.content.schema.facets;

import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsTerm;
import jade.content.abs.AbsVariable;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.Facet;
import jade.content.schema.ObjectSchema;
import jade.util.leap.Iterator;

public class TypedAggregateFacet
implements Facet {
    private ObjectSchema type;

    public TypedAggregateFacet(ObjectSchema objectSchema) {
        this.type = objectSchema;
    }

    public ObjectSchema getType() {
        return this.type;
    }

    public void validate(AbsObject absObject, Ontology ontology) throws OntologyException {
        if (absObject instanceof AbsVariable) {
            return;
        }
        if (!(absObject instanceof AbsAggregate)) {
            throw new OntologyException(absObject + " is not an AbsAggregate");
        }
        AbsAggregate absAggregate = (AbsAggregate)absObject;
        Iterator iterator = absAggregate.iterator();
        while (iterator.hasNext()) {
            AbsTerm absTerm = (AbsTerm)iterator.next();
            ObjectSchema objectSchema = ontology.getSchema(absTerm.getTypeName());
            if (objectSchema.isCompatibleWith(this.type)) continue;
            throw new OntologyException("Schema " + objectSchema + " for element " + absTerm + " is not compatible with type " + this.type);
        }
    }
}

