/*
 * Decompiled with CFR 0.152.
 */
package jade.content.schema;

import jade.content.abs.AbsIRE;
import jade.content.abs.AbsObject;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.ContentElementSchema;
import jade.content.schema.ObjectSchema;
import jade.content.schema.PredicateSchema;
import jade.content.schema.TermSchema;
import jade.content.schema.VariableSchema;

public class IRESchema
extends TermSchema {
    public static final String BASE_NAME = "IRE";
    private static IRESchema baseSchema = new IRESchema();
    public static final String VARIABLE = "Variable";
    public static final String PROPOSITION = "Proposition";

    private IRESchema() {
        super(BASE_NAME);
    }

    public IRESchema(String string) {
        super(string);
        this.add(VARIABLE, VariableSchema.getBaseSchema());
        this.add(PROPOSITION, PredicateSchema.getBaseSchema());
    }

    public static ObjectSchema getBaseSchema() {
        return baseSchema;
    }

    public AbsObject newInstance() throws OntologyException {
        return new AbsIRE(this.getTypeName());
    }

    public void validate(AbsObject absObject, Ontology ontology) throws OntologyException {
        if (!(absObject instanceof AbsIRE)) {
            throw new OntologyException(absObject + " is not an AbsIRE");
        }
        this.validateSlots(absObject, ontology);
    }

    public boolean isCompatibleWith(ObjectSchema objectSchema) {
        if (objectSchema != null) {
            return objectSchema.descendsFrom(TermSchema.getBaseSchema());
        }
        return false;
    }

    protected boolean descendsFrom(ObjectSchema objectSchema) {
        if (objectSchema != null) {
            if (objectSchema.equals(IRESchema.getBaseSchema())) {
                return true;
            }
            if (super.descendsFrom(objectSchema)) {
                return true;
            }
            return ContentElementSchema.getBaseSchema().descendsFrom(objectSchema);
        }
        return false;
    }
}

