/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.sl;

import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsConcept;
import jade.content.abs.AbsContentElement;
import jade.content.abs.AbsContentElementList;
import jade.content.abs.AbsIRE;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPredicate;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsTerm;
import jade.content.abs.AbsVariable;
import jade.content.lang.Codec;
import jade.content.lang.StringCodec;
import jade.content.lang.sl.SL0Ontology;
import jade.content.lang.sl.SL1Ontology;
import jade.content.lang.sl.SL2Ontology;
import jade.content.lang.sl.SLOntology;
import jade.content.lang.sl.SLParser;
import jade.content.lang.sl.SimpleSLTokenizer;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.ObjectSchema;
import jade.core.CaseInsensitiveString;
import jade.lang.acl.ISO8601;
import jade.util.leap.Iterator;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Date;

public class SLCodec
extends StringCodec {
    private transient SLParser parser;
    private SL0Ontology slOnto;
    private Ontology domainOnto = null;

    public SLCodec() {
        this(3);
    }

    public SLCodec(int n) {
        super(n == 0 ? "fipa-sl0" : (n == 1 ? "fipa-sl1" : (n == 2 ? "fipa-sl2" : "fipa-sl")));
        if (n < 0 || n > 2) {
            n = 3;
        }
        this.slOnto = (SL0Ontology)(n == 0 ? SL0Ontology.getInstance() : (n == 1 ? SL1Ontology.getInstance() : (n == 2 ? SL2Ontology.getInstance() : SLOntology.getInstance())));
        this.parser = new SLParser(new StringReader(""));
        this.parser.setSLType(n);
    }

    public String encode(AbsContentElement absContentElement) throws Codec.CodecException {
        return this.encode(null, absContentElement);
    }

    public synchronized String encode(Ontology ontology, AbsContentElement absContentElement) throws Codec.CodecException {
        this.domainOnto = ontology;
        StringBuffer stringBuffer = new StringBuffer("(");
        if (absContentElement instanceof AbsContentElementList) {
            Iterator iterator = ((AbsContentElementList)absContentElement).iterator();
            while (iterator.hasNext()) {
                AbsObject absObject = (AbsObject)iterator.next();
                stringBuffer.append(this.toString(absObject));
                stringBuffer.append(" ");
            }
        } else {
            stringBuffer.append(this.toString(absContentElement));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String encode(String string) {
        if (SimpleSLTokenizer.isAWord(string)) {
            return string;
        }
        return SimpleSLTokenizer.quoteString(string);
    }

    /*
     * Unable to fully structure code
     */
    private String toString(AbsPredicate var1_1) throws Codec.CodecException {
        var2_2 = var1_1.getTypeName();
        if (var1_1.getCount() > 0) {
            var3_3 = this.getSlotNames(var1_1);
            var4_4 = new StringBuffer("(");
            if (this.slOnto.isUnaryLogicalOp(var2_2)) {
                var4_4.append(var2_2);
                var4_4.append(" ");
                try {
                    var4_4.append(this.toString((AbsPredicate)var1_1.getAbsObject(var3_3[0])));
                }
                catch (RuntimeException var5_5) {
                    throw new Codec.CodecException("A UnaryLogicalOp requires a formula argument", var5_5);
                }
            }
            if (this.slOnto.isBinaryLogicalOp(var2_2)) {
                var4_4.append(var2_2);
                var4_4.append(" ");
                try {
                    var4_4.append(this.toString((AbsPredicate)var1_1.getAbsObject(var3_3[0])));
                    var4_4.append(" ");
                    var4_4.append(this.toString((AbsPredicate)var1_1.getAbsObject(var3_3[1])));
                }
                catch (RuntimeException var5_6) {
                    throw new Codec.CodecException("A BinaryLogicalOp requires 2 formula arguments", var5_6);
                }
            }
            if (this.slOnto.isQuantifier(var2_2)) {
                var4_4.append(var2_2);
                var4_4.append(" ");
                try {
                    var4_4.append(this.toString((AbsVariable)var1_1.getAbsObject(var3_3[0])));
                    var4_4.append(" ");
                    var4_4.append(this.toString((AbsPredicate)var1_1.getAbsObject(var3_3[1])));
                }
                catch (RuntimeException var5_7) {
                    throw new Codec.CodecException("A Quantifier requires a variable and a formula arguments", var5_7);
                }
            }
            if (this.slOnto.isModalOp(var2_2)) {
                var4_4.append(var2_2);
                var4_4.append(" ");
                try {
                    var4_4.append(this.toString((AbsConcept)var1_1.getAbsObject(var3_3[0])));
                    var4_4.append(" ");
                    var4_4.append(this.toString((AbsPredicate)var1_1.getAbsObject(var3_3[1])));
                }
                catch (RuntimeException var5_8) {
                    throw new Codec.CodecException("A ModalOp requires a concept and a formula arguments", var5_8);
                }
            }
            if (this.slOnto.isActionOp(var2_2)) {
                var4_4.append(var2_2);
                var4_4.append(" ");
                try {
                    var4_4.append(this.toString((AbsTerm)var1_1.getAbsObject(var3_3[0])));
                    var5_9 = (AbsPredicate)var1_1.getAbsObject(var3_3[1]);
                    if (var5_9 == null) ** GOTO lbl100
                    var4_4.append(" ");
                    var4_4.append(this.toString(var5_9));
                }
                catch (RuntimeException var5_10) {
                    throw new Codec.CodecException("An ActionOp requires an actionexpression and (optionally) a formula arguments", var5_10);
                }
            } else {
                if (this.slOnto.isBinaryTermOp(var2_2)) {
                    var4_4.append(var2_2);
                    var4_4.append(" ");
                    try {
                        var4_4.append(this.toString((AbsTerm)var1_1.getAbsObject(var3_3[0])));
                        var4_4.append(" ");
                        var4_4.append(this.toString((AbsTerm)var1_1.getAbsObject(var3_3[1])));
                    }
                    catch (RuntimeException var5_11) {
                        throw new Codec.CodecException("A BinaryTermOp requires 2 term arguments", var5_11);
                    }
                }
                var4_4.append(this.encode(var2_2));
                try {
                    this.encodeSlotsByOrder(var1_1, var3_3, var4_4);
                }
                catch (RuntimeException var5_12) {
                    throw new Codec.CodecException("SL allows predicates with term arguments only", var5_12);
                }
            }
lbl100:
            // 8 sources

            var4_4.append(")");
            return var4_4.toString();
        }
        return this.encode(var2_2);
    }

    private String toString(AbsIRE absIRE) throws Codec.CodecException {
        return "(" + this.encode(absIRE.getTypeName()) + " " + this.toString(absIRE.getVariable()) + " " + this.toString(absIRE.getProposition()) + ")";
    }

    private String toString(AbsVariable absVariable) throws Codec.CodecException {
        String string = absVariable.getName();
        if (!string.startsWith("?")) {
            return "?" + this.encode(string);
        }
        return "?" + this.encode(string.substring(1));
    }

    private String toString(AbsConcept absConcept) throws Codec.CodecException {
        String string = absConcept.getTypeName();
        StringBuffer stringBuffer = new StringBuffer("(");
        String[] stringArray = this.getSlotNames(absConcept);
        if (this.slOnto.isSLFunctionWithoutSlotNames(string)) {
            stringBuffer.append(string);
            try {
                this.encodeSlotsByOrder(absConcept, stringArray, stringBuffer);
            }
            catch (RuntimeException runtimeException) {
                throw new Codec.CodecException("A FunctionalOperator requires 1 or 2 Term arguments", runtimeException);
            }
        }
        stringBuffer.append(this.encode(string));
        try {
            if (this.getEncodingByOrder(absConcept)) {
                this.encodeSlotsByOrder(absConcept, stringArray, stringBuffer);
            } else {
                this.encodeSlotsByName(absConcept, stringArray, stringBuffer);
            }
        }
        catch (RuntimeException runtimeException) {
            throw new Codec.CodecException("A FunctionalTerm requires Terms arguments", runtimeException);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String toString(AbsAggregate absAggregate) throws Codec.CodecException {
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(this.encode(absAggregate.getTypeName()));
        Iterator iterator = absAggregate.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(" ");
            stringBuffer.append(this.toString((AbsObject)iterator.next()));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String toString(AbsPrimitive absPrimitive) throws Codec.CodecException {
        Object object = absPrimitive.getObject();
        if (object instanceof Date) {
            return ISO8601.toString((Date)object);
        }
        if (object instanceof Number) {
            return object.toString();
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return "#" + byArray.length + "\"" + new String(byArray);
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        String string = object.toString();
        if (CaseInsensitiveString.equalsIgnoreCase("true", string) || CaseInsensitiveString.equalsIgnoreCase("false", string)) {
            return '\"' + string + '\"';
        }
        return this.encode(string);
    }

    private String toString(AbsObject absObject) throws Codec.CodecException {
        if (absObject instanceof AbsPrimitive) {
            return this.toString((AbsPrimitive)absObject);
        }
        if (absObject instanceof AbsPredicate) {
            return this.toString((AbsPredicate)absObject);
        }
        if (absObject instanceof AbsIRE) {
            return this.toString((AbsIRE)absObject);
        }
        if (absObject instanceof AbsVariable) {
            return this.toString((AbsVariable)absObject);
        }
        if (absObject instanceof AbsAggregate) {
            return this.toString((AbsAggregate)absObject);
        }
        if (absObject instanceof AbsConcept) {
            return this.toString((AbsConcept)absObject);
        }
        throw new Codec.CodecException("SLCodec cannot encode this object " + absObject);
    }

    public AbsContentElement decode(String string) throws Codec.CodecException {
        return this.decode(null, string);
    }

    public synchronized AbsContentElement decode(Ontology ontology, String string) throws Codec.CodecException {
        try {
            return this.parser.parse(ontology, string);
        }
        catch (Throwable throwable) {
            throw new Codec.CodecException("Parse exception", throwable);
        }
    }

    public static void main(String[] stringArray) {
        SLCodec sLCodec = null;
        try {
            sLCodec = new SLCodec(Integer.parseInt(stringArray[0]));
        }
        catch (Exception exception) {
            System.out.println("usage: SLCodec SLLevel\n  where SLLevel can be 0 for SL0, 1 for SL1, 2 for SL2, 3 or more for full SL");
            System.exit(0);
        }
        while (true) {
            try {
                while (true) {
                    System.out.println("insert an SL expression to parse (all the expression on a single line!): ");
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                    String string = bufferedReader.readLine();
                    System.out.println("\n\n");
                    AbsContentElement absContentElement = sLCodec.decode(string);
                    System.out.println("DUMP OF THE DECODE OUTPUT:");
                    System.out.println(absContentElement);
                    System.out.println("\n\n");
                    System.out.println("AFTER ENCODE:");
                    System.out.println(sLCodec.encode(absContentElement));
                    System.out.println("\n\n");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    public Ontology getInnerOntology() {
        return this.slOnto;
    }

    private String[] getSlotNames(AbsObject absObject) throws Codec.CodecException {
        String[] stringArray = null;
        String string = absObject.getTypeName();
        if (this.domainOnto != null) {
            try {
                ObjectSchema objectSchema = this.domainOnto.getSchema(string);
                if (objectSchema == null) {
                    throw new Codec.CodecException("No schema found for symbol " + string);
                }
                stringArray = objectSchema.getNames();
            }
            catch (OntologyException ontologyException) {
                throw new Codec.CodecException("Error getting schema for symbol " + string, ontologyException);
            }
        } else {
            stringArray = absObject.getNames();
        }
        return stringArray;
    }

    private boolean getEncodingByOrder(AbsObject absObject) throws Codec.CodecException {
        if (this.domainOnto != null) {
            String string = absObject.getTypeName();
            try {
                ObjectSchema objectSchema = this.domainOnto.getSchema(string);
                return objectSchema.getEncodingByOrder();
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    private void encodeSlotsByOrder(AbsObject absObject, String[] stringArray, StringBuffer stringBuffer) throws Codec.CodecException {
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            AbsTerm absTerm = (AbsTerm)absObject.getAbsObject(stringArray[n]);
            if (absTerm != null) {
                if (bl) {
                    throw new Codec.CodecException("Non-empty slot " + stringArray[n] + " follows empty slot " + stringArray[n - 1]);
                }
                stringBuffer.append(" ");
                stringBuffer.append(this.toString(absTerm));
            } else {
                bl = true;
            }
            ++n;
        }
    }

    private void encodeSlotsByName(AbsObject absObject, String[] stringArray, StringBuffer stringBuffer) throws Codec.CodecException {
        int n = 0;
        while (n < stringArray.length) {
            AbsTerm absTerm = (AbsTerm)absObject.getAbsObject(stringArray[n]);
            if (absTerm != null) {
                stringBuffer.append(" :");
                stringBuffer.append(this.encode(stringArray[n]));
                stringBuffer.append(" ");
                stringBuffer.append(this.toString(absTerm));
            }
            ++n;
        }
    }
}

