/*
 * Decompiled with CFR 0.152.
 */
package jade.util;

import jade.util.Logger;

public class RWLock {
    private int readersCnt = 0;
    private Thread currentWriter = null;
    private int writeLockDepth = 0;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());

    public synchronized void writeLock() {
        Thread thread = Thread.currentThread();
        while (this.currentWriter != null && this.currentWriter != thread || this.readersCnt > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                if (!this.logger.isLoggable(Logger.WARNING)) continue;
                this.logger.log(Logger.WARNING, "Unexpected interruption. " + interruptedException.getMessage());
            }
        }
        ++this.writeLockDepth;
        if (this.writeLockDepth == 1) {
            this.currentWriter = thread;
            this.onWriteStart();
        }
    }

    public synchronized void writeUnlock() {
        if (Thread.currentThread() == this.currentWriter) {
            --this.writeLockDepth;
            if (this.writeLockDepth == 0) {
                this.currentWriter = null;
                this.notifyAll();
                this.onWriteEnd();
            }
        }
    }

    public synchronized void readLock() {
        while (this.currentWriter != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                if (!this.logger.isLoggable(Logger.WARNING)) continue;
                this.logger.log(Logger.WARNING, "Unexpected interruption. " + interruptedException.getMessage());
            }
        }
        ++this.readersCnt;
    }

    public synchronized void readUnlock() {
        --this.readersCnt;
        if (this.readersCnt == 0) {
            this.notifyAll();
        }
    }

    protected void onWriteStart() {
    }

    protected void onWriteEnd() {
    }
}

