/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.sniffer;

import jade.core.AID;
import jade.gui.AgentTree;
import jade.tools.sniffer.ActionProcessor;
import jade.tools.sniffer.Agent;
import jade.tools.sniffer.MainMenu;
import jade.tools.sniffer.MainPanel;
import jade.tools.sniffer.MainWindow;
import jade.tools.sniffer.PopupMenuAgent;
import jade.tools.sniffer.Sniffer;
import jade.tools.sniffer.ToolBar;
import jade.util.BasicProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class MainWindow
extends JFrame {
    protected MainPanel mainPanel;
    protected ActionProcessor actPro;
    private PopupMenuAgent popA;
    private Sniffer mySniffer;
    private BasicProperties myProperties;
    private String snifferLogo = "images/sniffer.gif";

    public MainWindow(Sniffer sniffer, BasicProperties basicProperties) {
        super(sniffer.getName() + " - Sniffer Agent");
        this.mySniffer = sniffer;
        this.myProperties = basicProperties;
        this.mainPanel = new MainPanel(sniffer, this);
        this.actPro = new ActionProcessor(sniffer, this.mainPanel);
        this.setJMenuBar(new MainMenu(this, this.actPro));
        this.popA = new PopupMenuAgent(this.actPro);
        this.setForeground(Color.black);
        this.setBackground(Color.lightGray);
        Image image = this.getToolkit().getImage(this.getClass().getResource(this.snifferLogo));
        this.setIconImage(image);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MainWindow.this.mySniffer.doDelete();
            }
        });
        this.mainPanel.treeAgent.register("FIPAAGENT", this.popA, "images/runtree.gif");
        this.mainPanel.treeAgent.register("FIPACONTAINER", null, "images/foldergreen.gif");
        this.getContentPane().add((Component)new ToolBar(this.actPro), "North");
        this.getContentPane().add((Component)this.mainPanel, "Center");
    }

    public void ShowCorrect() {
        this.pack();
        this.setSize(new Dimension(700, 500));
        this.mainPanel.adjustDividerLocation();
        this.setVisible(true);
        this.toFront();
    }

    public BasicProperties getProperties() {
        return this.myProperties;
    }

    public void resetTree() {
        Runnable runnable = new Runnable(){

            public void run() {
                MainWindow.this.mainPanel.treeAgent.clearLocalPlatform();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void addContainer(final String string, final InetAddress inetAddress) {
        Runnable runnable = new Runnable(){

            public void run() {
                AgentTree.Node node = MainWindow.this.mainPanel.treeAgent.createNewNode(string, 0);
                MainWindow.this.mainPanel.treeAgent.addContainerNode((AgentTree.ContainerNode)node, "FIPACONTAINER", inetAddress);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void removeContainer(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                MainWindow.this.mainPanel.treeAgent.removeContainerNode(string);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void addAgent(final String string, final AID aID) {
        Runnable runnable = new Runnable(){

            public void run() {
                String string2 = aID.getName();
                AgentTree.Node node = MainWindow.this.mainPanel.treeAgent.createNewNode(string2, 1);
                MainWindow.this.mainPanel.treeAgent.addAgentNode((AgentTree.AgentNode)node, string, string2, "agentAddress", "FIPAAGENT");
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void removeAgent(final String string, final AID aID) {
        Runnable runnable = new Runnable(){

            public void run() {
                String string2 = aID.getName();
                MainWindow.this.mainPanel.treeAgent.removeAgentNode(string, string2);
                MainWindow.this.mainPanel.panelcan.canvAgent.removeAgent(string2);
                MainWindow.this.mainPanel.panelcan.canvAgent.repaintNoSniffedAgent(new Agent(aID));
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void showError(String string) {
        JOptionPane.showMessageDialog(null, string, "Error in " + this.mySniffer.getName(), 0);
    }

    public Dimension getPreferredSize() {
        return new Dimension(700, 500);
    }

    private void setUI(String string) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf." + string);
            SwingUtilities.updateComponentTreeUI(this);
            this.pack();
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace(System.out);
        }
    }

    public void setUI2Motif() {
        this.setUI("motif.MotifLookAndFeel");
    }

    public void setUI2Windows() {
        this.setUI("windows.WindowsLookAndFeel");
    }

    public void setUI2Multi() {
        this.setUI("multi.MultiLookAndFeel");
    }

    public void setUI2Metal() {
        this.setUI("metal.MetalLookAndFeel");
    }

    public void disposeAsync() {
        class DisposeIt
        implements Runnable {
            private Window toDispose;
            private final /* synthetic */ MainWindow this$0;

            public DisposeIt(MainWindow mainWindow, Window window) {
                this.this$0 = mainWindow;
                this.toDispose = window;
            }

            public void run() {
                this.toDispose.dispose();
            }
        }
        SwingUtilities.invokeLater(new DisposeIt(this, this));
    }
}

