/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.introspector.gui;

import jade.core.AgentState;
import jade.tools.introspector.gui.MainBarListener;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class StatePanel
extends JPanel {
    private int state;
    private ButtonGroup leds;
    private JRadioButton waitingLed;
    private JRadioButton activeLed;
    private JRadioButton suspendedLed;
    private JRadioButton deletedLed;
    private JRadioButton movingLed;
    private JRadioButton idleLed;
    private JButton suspendAction;
    private JButton waitAction;
    private JButton wakeUpAction;
    private JButton killAction;
    private Icon ledOff = new ImageIcon(this.getClass().getResource("images/rbs.gif"));
    private Icon ledOn = new ImageIcon(this.getClass().getResource("images/rbrs.gif"));
    private Icon button = new ImageIcon(this.getClass().getResource("images/rb.gif"));
    private Icon pressedButton = new ImageIcon(this.getClass().getResource("images/rbp.gif"));
    private Font myFont = new Font("Monospaced", 1, 10);
    private MainBarListener listener;
    private Map ledMap = new HashMap();

    public StatePanel(MainBarListener mainBarListener) {
        this.leds = new ButtonGroup();
        this.listener = mainBarListener;
        this.build();
    }

    public void build() {
        Border border = BorderFactory.createEtchedBorder();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentX(0.5f);
        jPanel.setBorder(BorderFactory.createTitledBorder(border, "Current State", 2, 2, new Font("Dialog", 1, 10)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentX(0.5f);
        jPanel2.setBorder(BorderFactory.createTitledBorder(border, "Change State", 2, 2, new Font("Dialog", 1, 10)));
        this.activeLed = new JRadioButton("Active", this.ledOff);
        this.activeLed.setFont(this.myFont);
        this.activeLed.setAlignmentX(0.0f);
        this.activeLed.setDisabledSelectedIcon(this.ledOn);
        this.activeLed.setDisabledIcon(this.ledOff);
        this.activeLed.setEnabled(false);
        this.leds.add(this.activeLed);
        this.ledMap.put(AgentState.getInstance(2), this.activeLed);
        jPanel.add(this.activeLed);
        this.suspendedLed = new JRadioButton("Suspended", this.ledOff);
        this.suspendedLed.setFont(this.myFont);
        this.suspendedLed.setAlignmentX(0.0f);
        this.suspendedLed.setDisabledSelectedIcon(this.ledOn);
        this.suspendedLed.setDisabledIcon(this.ledOff);
        this.suspendedLed.setEnabled(false);
        this.leds.add(this.suspendedLed);
        this.ledMap.put(AgentState.getInstance(4), this.suspendedLed);
        jPanel.add(this.suspendedLed);
        this.idleLed = new JRadioButton("Idle", this.ledOff);
        this.idleLed.setFont(this.myFont);
        this.idleLed.setAlignmentX(0.0f);
        this.idleLed.setDisabledSelectedIcon(this.ledOn);
        this.idleLed.setDisabledIcon(this.ledOff);
        this.idleLed.setEnabled(false);
        this.leds.add(this.idleLed);
        this.ledMap.put(AgentState.getInstance(3), this.idleLed);
        jPanel.add(this.idleLed);
        this.waitingLed = new JRadioButton("Waiting", this.ledOff);
        this.waitingLed.setFont(this.myFont);
        this.waitingLed.setAlignmentX(0.0f);
        this.waitingLed.setDisabledSelectedIcon(this.ledOn);
        this.waitingLed.setDisabledIcon(this.ledOff);
        this.waitingLed.setEnabled(false);
        this.leds.add(this.waitingLed);
        this.ledMap.put(AgentState.getInstance(5), this.waitingLed);
        jPanel.add(this.waitingLed);
        this.movingLed = new JRadioButton("Moving", this.ledOff);
        this.movingLed.setFont(this.myFont);
        this.movingLed.setAlignmentX(0.0f);
        this.movingLed.setDisabledSelectedIcon(this.ledOn);
        this.movingLed.setDisabledIcon(this.ledOff);
        this.movingLed.setEnabled(false);
        this.leds.add(this.movingLed);
        this.ledMap.put(AgentState.getInstance(7), this.movingLed);
        jPanel.add(this.movingLed);
        this.deletedLed = new JRadioButton("Dead", this.ledOff);
        this.deletedLed.setFont(this.myFont);
        this.deletedLed.setAlignmentX(0.0f);
        this.deletedLed.setDisabledSelectedIcon(this.ledOn);
        this.deletedLed.setDisabledIcon(this.ledOff);
        this.deletedLed.setEnabled(false);
        this.leds.add(this.deletedLed);
        this.ledMap.put(AgentState.getInstance(6), this.deletedLed);
        jPanel.add(this.deletedLed);
        this.suspendAction = new JButton("Suspend", this.button);
        this.configurePushButton(this.suspendAction);
        this.suspendAction.setMnemonic(5);
        this.waitAction = new JButton("Wait", this.button);
        this.configurePushButton(this.waitAction);
        this.waitAction.setMnemonic(7);
        this.wakeUpAction = new JButton("Wake Up", this.button);
        this.configurePushButton(this.wakeUpAction);
        this.wakeUpAction.setMnemonic(6);
        this.killAction = new JButton("Kill", this.button);
        this.configurePushButton(this.killAction);
        this.killAction.setMnemonic(4);
        jPanel2.add(this.suspendAction);
        jPanel2.add(this.waitAction);
        jPanel2.add(this.wakeUpAction);
        jPanel2.add(this.killAction);
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalStrut(15));
        this.add(jPanel);
        this.add(Box.createVerticalStrut(10));
        this.add(jPanel2);
    }

    public void switchTo(AgentState agentState) {
        JRadioButton jRadioButton = (JRadioButton)this.ledMap.get(agentState);
        if (jRadioButton != null) {
            jRadioButton.setSelected(true);
        }
    }

    private void configureLED(JRadioButton jRadioButton) {
    }

    private void configurePushButton(JButton jButton) {
        jButton.setPressedIcon(this.pressedButton);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setAlignmentX(0.0f);
        jButton.setFont(this.myFont);
        jButton.addActionListener(this.listener);
    }
}

