/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.dfgui;

import jade.core.AID;
import jade.domain.DFGUIAdapter;
import jade.domain.DFGUIInterface;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.gui.AboutJadeAction;
import jade.gui.JadeLogoButton;
import jade.tools.dfgui.AgentNameTableModel;
import jade.tools.dfgui.DFGUI;
import jade.tools.dfgui.DFGUIAboutAction;
import jade.tools.dfgui.DFGUICloseGuiAction;
import jade.tools.dfgui.DFGUIDeregisterAction;
import jade.tools.dfgui.DFGUIExitDFAction;
import jade.tools.dfgui.DFGUIFederateAction;
import jade.tools.dfgui.DFGUIModifyAction;
import jade.tools.dfgui.DFGUIRefreshAppletAction;
import jade.tools.dfgui.DFGUIRegisterAction;
import jade.tools.dfgui.DFGUISearchAction;
import jade.tools.dfgui.DFGUIViewAction;
import jade.tools.dfgui.DFGuiProperties;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;

public class DFGUI
extends JFrame
implements DFGUIInterface {
    public static int AGENT_VIEW = 0;
    public static int LASTSEARCH_VIEW = 1;
    public static int PARENT_VIEW = 2;
    public static int CHILDREN_VIEW = 3;
    DFGUIAdapter myAgent;
    AgentNameTableModel registeredModel;
    AgentNameTableModel foundModel;
    AgentNameTableModel parentModel;
    AgentNameTableModel childrenModel;
    JTable registeredTable;
    JTable foundTable;
    JTable parentTable;
    JTable childrenTable;
    JSplitPane tablePane;
    JTabbedPane tabbedPane;
    JButton modifyB;
    JButton deregB;
    JButton regNewB;
    JButton fedDFB;
    JButton viewB;
    JButton searchB;
    JButton searchWithB;
    JTextField statusField;
    JScrollPane textScroll;
    DFGUIModifyAction dfModifyAction;
    DFGUIViewAction dfViewAction;
    DFGUISearchAction dfSearchAction;
    DFGUIRegisterAction dfRegAction;
    DFGUIDeregisterAction dfDeregAction;
    DFGUIFederateAction dfFedAction;
    JButton refreshB;
    JMenuItem refreshItem;
    HashMap lastSearchResults = new HashMap();
    AID lastDF = null;

    public DFGUI() {
        Image image = this.getToolkit().getImage(this.getClass().getResource("images/df.gif"));
        this.setIconImage(image);
        this.setSize(550, 450);
        Icon icon = DFGuiProperties.getIcon("view");
        Icon icon2 = DFGuiProperties.getIcon("modify");
        Icon icon3 = DFGuiProperties.getIcon("deregister");
        Icon icon4 = DFGuiProperties.getIcon("registeragent");
        Icon icon5 = DFGuiProperties.getIcon("federatedf");
        Icon icon6 = DFGuiProperties.getIcon("search");
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("General");
        JMenuItem jMenuItem = jMenu.add(new DFGUIExitDFAction(this));
        jMenuItem = jMenu.add(new DFGUICloseGuiAction(this));
        this.refreshItem = jMenu.add(new DFGUIRefreshAppletAction(this));
        this.refreshItem.setVisible(false);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Catalogue");
        this.dfModifyAction = new DFGUIModifyAction(this);
        this.dfViewAction = new DFGUIViewAction(this);
        this.dfDeregAction = new DFGUIDeregisterAction(this);
        this.dfRegAction = new DFGUIRegisterAction(this);
        this.dfSearchAction = new DFGUISearchAction(this);
        jMenuItem = jMenu2.add(this.dfViewAction);
        jMenuItem.setIcon(icon);
        jMenuItem = jMenu2.add(this.dfModifyAction);
        jMenuItem.setIcon(icon2);
        jMenuItem = jMenu2.add(this.dfDeregAction);
        jMenuItem.setIcon(icon3);
        jMenuItem = jMenu2.add(this.dfRegAction);
        jMenuItem.setIcon(icon4);
        jMenuItem = jMenu2.add(this.dfSearchAction);
        jMenuItem.setIcon(icon6);
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu("Super DF");
        this.dfFedAction = new DFGUIFederateAction(this);
        jMenuItem = jMenu3.add(this.dfFedAction);
        jMenuItem.setIcon(icon5);
        jMenuBar.add(jMenu3);
        JMenu jMenu4 = new JMenu("Help");
        jMenuItem = jMenu4.add(new DFGUIAboutAction(this));
        jMenuItem = jMenu4.add(new AboutJadeAction(this));
        jMenuBar.add(jMenu4);
        this.setJMenuBar(jMenuBar);
        JToolBar jToolBar = new JToolBar();
        Icon icon7 = DFGuiProperties.getIcon("exitdf");
        JButton jButton = jToolBar.add(new DFGUIExitDFAction(this));
        jButton.setText("");
        jButton.setIcon(icon7);
        jButton.setToolTipText("Exit and kill the DF agent");
        Icon icon8 = DFGuiProperties.getIcon("closegui");
        JButton jButton2 = jToolBar.add(new DFGUICloseGuiAction(this));
        jButton2.setText("");
        jButton2.setIcon(icon8);
        jButton2.setToolTipText("Close the DF GUI");
        Icon icon9 = DFGuiProperties.getIcon("refreshapplet");
        this.refreshB = jToolBar.add(new DFGUIRefreshAppletAction(this));
        this.refreshB.setText("");
        this.refreshB.setIcon(icon9);
        this.refreshB.setToolTipText("Refresh the GUI");
        this.refreshB.setVisible(false);
        jToolBar.addSeparator();
        this.viewB = jToolBar.add(new DFGUIViewAction(this));
        this.viewB.setText("");
        this.viewB.setIcon(icon);
        this.viewB.setToolTipText("View the services provided by the selected agent");
        this.modifyB = jToolBar.add(new DFGUIModifyAction(this));
        this.modifyB.setText("");
        this.modifyB.setIcon(icon2);
        this.modifyB.setToolTipText("Modify the services provided by the selected agent");
        this.deregB = jToolBar.add(new DFGUIDeregisterAction(this));
        this.deregB.setText("");
        this.deregB.setIcon(icon3);
        this.deregB.setToolTipText("Deregister the selected agent");
        this.regNewB = jToolBar.add(new DFGUIRegisterAction(this));
        this.regNewB.setText("");
        this.regNewB.setIcon(icon4);
        this.regNewB.setToolTipText("Register a new agent with this DF");
        this.searchB = jToolBar.add(new DFGUISearchAction(this));
        this.searchB.setText("");
        this.searchB.setIcon(icon6);
        this.searchB.setToolTipText("Search for agents matching a given description");
        jToolBar.addSeparator();
        this.fedDFB = jToolBar.add(new DFGUIFederateAction(this));
        this.fedDFB.setText("");
        this.fedDFB.setIcon(icon5);
        this.fedDFB.setToolTipText("Federate this DF with another DF");
        jToolBar.addSeparator();
        Icon icon10 = DFGuiProperties.getIcon("about");
        JButton jButton3 = jToolBar.add(new DFGUIAboutAction(this));
        jButton3.setText("");
        jButton3.setIcon(icon10);
        jButton3.setToolTipText("About DF");
        jToolBar.addSeparator();
        jToolBar.add(Box.createHorizontalGlue());
        JadeLogoButton jadeLogoButton = new JadeLogoButton();
        jToolBar.add(jadeLogoButton);
        this.getContentPane().add((Component)jToolBar, "North");
        this.tabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.registeredModel = new AgentNameTableModel();
        this.registeredTable = new JTable(this.registeredModel);
        this.registeredTable.setRowHeight(20);
        this.registeredTable.setSelectionMode(0);
        TableColumn tableColumn = this.registeredTable.getColumn(this.registeredTable.getColumnName(0));
        tableColumn.setHeaderValue(new String("Agent name"));
        tableColumn = this.registeredTable.getColumn(this.registeredTable.getColumnName(1));
        tableColumn.setHeaderValue(new String("Addresses"));
        tableColumn = this.registeredTable.getColumn(this.registeredTable.getColumnName(2));
        tableColumn.setHeaderValue(new String("Resolvers"));
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    DFGUIViewAction dFGUIViewAction = new DFGUIViewAction(DFGUI.this);
                    dFGUIViewAction.actionPerformed(new ActionEvent(this, 0, "View"));
                }
            }
        };
        this.registeredTable.addMouseListener(mouseAdapter);
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 3 || n == 127) {
                    DFGUIDeregisterAction dFGUIDeregisterAction = new DFGUIDeregisterAction(DFGUI.this);
                    dFGUIDeregisterAction.actionPerformed(new ActionEvent(this, 0, "Deregister"));
                }
            }
        };
        this.registeredTable.addKeyListener(keyAdapter);
        jPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this.registeredTable);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.tabbedPane.addTab("Registrations with this DF", jPanel);
        this.tabbedPane.setSelectedIndex(0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.foundModel = new AgentNameTableModel();
        this.foundTable = new JTable(this.foundModel);
        this.foundTable.setRowHeight(20);
        this.foundTable.setSelectionMode(0);
        this.foundTable.setToolTipText("Double click on agent name to view the services provided by the selected agent");
        tableColumn = this.foundTable.getColumn(this.foundTable.getColumnName(0));
        tableColumn.setHeaderValue(new String("Agent name"));
        tableColumn = this.foundTable.getColumn(this.foundTable.getColumnName(1));
        tableColumn.setHeaderValue(new String("Addresses"));
        tableColumn = this.foundTable.getColumn(this.foundTable.getColumnName(2));
        tableColumn.setHeaderValue(new String("Resolvers"));
        MouseAdapter mouseAdapter2 = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    DFGUIViewAction dFGUIViewAction = new DFGUIViewAction(DFGUI.this);
                    dFGUIViewAction.actionPerformed(new ActionEvent(this, 0, "View"));
                }
            }
        };
        this.foundTable.addMouseListener(mouseAdapter2);
        jPanel2.setLayout(new BorderLayout());
        jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this.foundTable);
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.tabbedPane.addTab("Search Result", jPanel2);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setContinuousLayout(true);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        this.parentModel = new AgentNameTableModel();
        this.parentTable = new JTable(this.parentModel);
        this.parentTable.setRowHeight(20);
        this.parentTable.setSelectionMode(0);
        tableColumn = this.parentTable.getColumn(this.parentTable.getColumnName(0));
        tableColumn.setHeaderValue(new String("Agent name"));
        tableColumn = this.parentTable.getColumn(this.parentTable.getColumnName(1));
        tableColumn.setHeaderValue(new String("Addresses"));
        tableColumn = this.parentTable.getColumn(this.parentTable.getColumnName(2));
        tableColumn.setHeaderValue(new String("Resolvers"));
        MouseAdapter mouseAdapter3 = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 1) {
                    DFGUI.this.childrenTable.clearSelection();
                }
                if (mouseEvent.getClickCount() == 2) {
                    DFGUIViewAction dFGUIViewAction = new DFGUIViewAction(DFGUI.this);
                    dFGUIViewAction.actionPerformed(new ActionEvent(this, 0, "View"));
                }
            }
        };
        this.parentTable.addMouseListener(mouseAdapter3);
        jPanel3.setLayout(new BorderLayout());
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.getViewport().setView(this.parentTable);
        jPanel3.add((Component)jScrollPane2, "Center");
        jPanel3.setBorder(BorderFactory.createTitledBorder("Parents"));
        jSplitPane.setTopComponent(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        this.childrenModel = new AgentNameTableModel();
        this.childrenTable = new JTable(this.childrenModel);
        this.childrenTable.setRowHeight(20);
        this.childrenTable.setSelectionMode(0);
        tableColumn = this.childrenTable.getColumn(this.childrenTable.getColumnName(0));
        tableColumn.setHeaderValue(new String("Agent name"));
        tableColumn = this.childrenTable.getColumn(this.childrenTable.getColumnName(1));
        tableColumn.setHeaderValue(new String("Addresses"));
        tableColumn = this.childrenTable.getColumn(this.childrenTable.getColumnName(2));
        tableColumn.setHeaderValue(new String("Resolvers"));
        MouseAdapter mouseAdapter4 = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 1) {
                    DFGUI.this.parentTable.clearSelection();
                }
                if (mouseEvent.getClickCount() == 2) {
                    DFGUIViewAction dFGUIViewAction = new DFGUIViewAction(DFGUI.this);
                    dFGUIViewAction.actionPerformed(new ActionEvent(this, 0, "View"));
                }
            }
        };
        this.childrenTable.addMouseListener(mouseAdapter4);
        jScrollPane2 = new JScrollPane();
        jScrollPane2.getViewport().setView(this.childrenTable);
        jPanel4.add((Component)jScrollPane2, "Center");
        jPanel4.setBorder(BorderFactory.createTitledBorder("Children"));
        jSplitPane.setBottomComponent(jPanel4);
        jSplitPane.setDividerLocation(150);
        this.tabbedPane.addTab("DF Federation", jSplitPane);
        this.tabbedPane.addChangeListener(new tabListener());
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createTitledBorder("Status"));
        this.statusField = new JTextField();
        this.statusField.setEditable(false);
        jPanel5.add((Component)this.statusField, "Center");
        this.getContentPane().add((Component)jPanel5, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DFGUICloseGuiAction dFGUICloseGuiAction = new DFGUICloseGuiAction(DFGUI.this);
                dFGUICloseGuiAction.actionPerformed(new ActionEvent(this, 0, "Close GUI"));
            }
        });
    }

    public DFGUI(DFGUIAdapter dFGUIAdapter) {
        this();
        this.setAdapter(dFGUIAdapter);
    }

    public void setAdapter(DFGUIAdapter dFGUIAdapter) {
        try {
            this.setTitle(dFGUIAdapter.getDescriptionOfThisDF().getName().getName() + "- DF Gui");
            this.myAgent = dFGUIAdapter;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            this.setTitle("Unknown DF - DF Gui");
        }
    }

    public void showStatusMsg(String string) {
        this.statusField.setText(string);
    }

    private void setButton(int n) {
        switch (n) {
            case 0: {
                this.setDeregister(true);
                this.setRegister(true);
                this.setModify(true);
                this.setDFfed(true);
                break;
            }
            case 1: {
                this.setDeregister(true);
                this.setRegister(true);
                this.setModify(true);
                this.setDFfed(true);
                break;
            }
            case 2: {
                this.setDeregister(true);
                this.setRegister(true);
                this.setModify(false);
                this.setDFfed(true);
            }
        }
    }

    private void setRegister(boolean bl) {
        this.regNewB.setEnabled(bl);
        this.dfRegAction.setEnabled(bl);
    }

    private void setModify(boolean bl) {
        this.modifyB.setEnabled(bl);
        this.dfModifyAction.setEnabled(bl);
    }

    private void setDeregister(boolean bl) {
        this.deregB.setEnabled(bl);
        this.dfDeregAction.setEnabled(bl);
    }

    private void setDFfed(boolean bl) {
        this.fedDFB.setEnabled(bl);
        this.dfFedAction.setEnabled(bl);
    }

    public void setTab(String string, AID aID) {
        if (string.equalsIgnoreCase("Search")) {
            this.tabbedPane.setSelectedIndex(1);
            this.tabbedPane.setTitleAt(1, "Last Search on " + aID.getName());
        } else if (string.equalsIgnoreCase("Federate")) {
            this.tabbedPane.setSelectedIndex(2);
        } else {
            this.tabbedPane.setSelectedIndex(0);
        }
    }

    public AID getSelectedAgentInTable() {
        AID aID = null;
        int n = this.tabbedPane.getSelectedIndex();
        int n2 = -1;
        if (n == 0) {
            n2 = this.registeredTable.getSelectionModel().getMinSelectionIndex();
            aID = n2 != -1 ? this.registeredModel.getElementAt(n2) : null;
        } else if (n == 1) {
            n2 = this.foundTable.getSelectionModel().getMinSelectionIndex();
            aID = n2 != -1 ? this.foundModel.getElementAt(n2) : null;
        } else if (n == 2) {
            n2 = this.parentTable.getSelectionModel().getMinSelectionIndex();
            aID = n2 != -1 ? this.parentModel.getElementAt(n2) : ((n2 = this.childrenTable.getSelectionModel().getMinSelectionIndex()) != -1 ? this.childrenModel.getElementAt(n2) : null);
        }
        return aID;
    }

    public int kindOfOperation() {
        int n = -1;
        int n2 = this.tabbedPane.getSelectedIndex();
        if (n2 == 0) {
            n = AGENT_VIEW;
        } else if (n2 == 1) {
            n = LASTSEARCH_VIEW;
        } else if (n2 == 2) {
            int n3 = this.parentTable.getSelectionModel().getMinSelectionIndex();
            if (n3 != -1) {
                n = PARENT_VIEW;
            } else {
                n3 = this.childrenTable.getSelectionModel().getMinSelectionIndex();
                if (n3 != -1) {
                    n = CHILDREN_VIEW;
                }
            }
        }
        return n;
    }

    public void refresh(Iterator iterator, Iterator iterator2, Iterator iterator3) {
        this.registeredModel.clear();
        while (iterator.hasNext()) {
            this.registeredModel.add((AID)iterator.next());
        }
        this.registeredModel.fireTableDataChanged();
        this.parentModel.clear();
        while (iterator2.hasNext()) {
            this.parentModel.add((AID)iterator2.next());
        }
        this.parentModel.fireTableDataChanged();
        this.childrenModel.clear();
        while (iterator3.hasNext()) {
            this.childrenModel.add((AID)iterator3.next());
        }
        this.childrenModel.fireTableDataChanged();
        this.registeredTable.getSelectionModel().clearSelection();
        this.parentTable.getSelectionModel().clearSelection();
        this.childrenTable.getSelectionModel().clearSelection();
    }

    public void refreshLastSearchResults(List list, AID aID) {
        this.lastDF = aID;
        this.foundModel.clear();
        this.lastSearchResults.clear();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DFAgentDescription dFAgentDescription = (DFAgentDescription)iterator.next();
            this.foundModel.add(dFAgentDescription.getName());
            this.lastSearchResults.put(dFAgentDescription.getName(), dFAgentDescription);
        }
        this.foundModel.fireTableDataChanged();
        this.foundTable.clearSelection();
    }

    public void removeSearchResult(AID aID) {
        this.foundModel.remove(aID);
        this.foundModel.fireTableDataChanged();
        this.lastSearchResults.remove(aID);
        this.foundTable.clearSelection();
    }

    public AID getLastDF() {
        return this.lastDF;
    }

    public void addParent(AID aID) {
        this.parentModel.add(aID);
        this.parentModel.fireTableDataChanged();
    }

    public void addChildren(AID aID) {
        this.childrenModel.add(aID);
        this.childrenModel.fireTableDataChanged();
    }

    public void addAgentDesc(AID aID) {
        this.registeredModel.add(aID);
        this.registeredModel.fireTableDataChanged();
    }

    public void removeAgentDesc(AID aID, AID aID2) {
        this.registeredModel.remove(aID);
        this.registeredModel.fireTableDataChanged();
        this.registeredTable.clearSelection();
        try {
            if (aID2.equals(this.lastDF)) {
                this.removeSearchResult(aID);
            }
        }
        catch (Exception exception) {}
    }

    public void removeChildren(AID aID) {
        this.childrenModel.remove(aID);
        this.childrenModel.fireTableDataChanged();
        this.childrenTable.clearSelection();
    }

    public void removeParent(AID aID) {
        this.parentModel.remove(aID);
        this.parentModel.fireTableDataChanged();
        this.parentTable.clearSelection();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (int)dimension.getWidth() / 2;
            int n2 = (int)dimension.getHeight() / 2;
            this.setLocation(n - this.getWidth() / 2, n2 - this.getHeight() / 2);
        }
        super.setVisible(bl);
    }

    public void disposeAsync() {
        class DisposeIt
        implements Runnable {
            private Window toDispose;
            private final /* synthetic */ DFGUI this$0;

            public DisposeIt(DFGUI dFGUI, Window window) {
                this.this$0 = dFGUI;
                this.toDispose = window;
            }

            public void run() {
                this.toDispose.dispose();
            }
        }
        EventQueue.invokeLater(new DisposeIt(this, this));
    }

    public DFAgentDescription getDFAgentSearchDsc(AID aID) {
        return (DFAgentDescription)this.lastSearchResults.get(aID);
    }

    public void enableRefreshButton() {
        this.refreshB.setVisible(true);
        this.refreshItem.setVisible(true);
    }

    class tabListener
    implements ChangeListener {
        tabListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object == DFGUI.this.tabbedPane) {
                this.tabStateChanged(changeEvent);
            }
        }

        public void tabStateChanged(ChangeEvent changeEvent) {
            int n = DFGUI.this.tabbedPane.getSelectedIndex();
            DFGUI.this.setButton(n);
        }
    }
}

