/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.applet;

import jade.content.abs.AbsContentElement;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ACLParser;
import jade.lang.acl.ParseException;
import jade.util.Logger;
import java.io.PrintStream;

abstract class AppletRequestProto {
    ACLMessage reqMsg;
    boolean notYetReady;
    PrintStream myOut;
    ACLParser myParser;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());

    AppletRequestProto(PrintStream printStream, ACLParser aCLParser, ACLMessage aCLMessage) {
        this.myOut = printStream;
        this.myParser = aCLParser;
        this.notYetReady = true;
        try {
            this.reqMsg = (ACLMessage)aCLMessage.clone();
            this.reqMsg.setPerformative(16);
        }
        catch (Exception exception) {
            this.reqMsg = new ACLMessage(16);
        }
    }

    public void doProto() {
        block12: {
            this.sendMessage(this.reqMsg.toString());
            try {
                ACLMessage aCLMessage = this.receiveMessage();
                if (this.logger.isLoggable(Logger.INFO)) {
                    this.logger.log(Logger.INFO, "Received Message:" + aCLMessage.toString());
                }
                if (1 == aCLMessage.getPerformative()) {
                    this.handleAgree(aCLMessage);
                    ACLMessage aCLMessage2 = this.receiveMessage();
                    if (this.logger.isLoggable(Logger.INFO)) {
                        this.logger.log(Logger.INFO, aCLMessage2.toString());
                    }
                    if (7 == aCLMessage2.getPerformative()) {
                        this.handleInform(aCLMessage2);
                    } else if (6 == aCLMessage2.getPerformative()) {
                        this.handleFailure(aCLMessage2);
                    } else {
                        this.handleOtherMessage(aCLMessage2);
                    }
                    break block12;
                }
                if (7 == aCLMessage.getPerformative()) {
                    this.handleInform(aCLMessage);
                    break block12;
                }
                if (14 == aCLMessage.getPerformative()) {
                    this.handleRefuse(aCLMessage);
                    break block12;
                }
                if (10 == aCLMessage.getPerformative()) {
                    this.handleNotUnderstood(aCLMessage);
                    break block12;
                }
                this.handleOtherMessage(aCLMessage);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
        }
    }

    private ACLMessage receiveMessage() throws ParseException {
        return this.myParser.Message();
    }

    private void sendMessage(String string) {
        this.myOut.println(string);
    }

    protected abstract void handleAgree(ACLMessage var1);

    protected abstract void handleInform(ACLMessage var1);

    protected abstract void handleRefuse(ACLMessage var1);

    protected abstract void handleFailure(ACLMessage var1);

    protected abstract void handleNotUnderstood(ACLMessage var1);

    protected abstract void handleOtherMessage(ACLMessage var1);

    static String encode(Action action, SLCodec sLCodec, Ontology ontology) throws FIPAException {
        try {
            return sLCodec.encode((AbsContentElement)ontology.fromObject(action));
        }
        catch (OntologyException ontologyException) {
            throw new FIPAException(ontologyException.getMessage());
        }
        catch (Codec.CodecException codecException) {
            codecException.printStackTrace();
            throw new FIPAException(codecException.getMessage());
        }
    }

    static Result extractContent(String string, SLCodec sLCodec, Ontology ontology) throws FIPAException {
        try {
            AbsContentElement absContentElement = sLCodec.decode(ontology, string);
            return (Result)ontology.toObject(absContentElement);
        }
        catch (Codec.CodecException codecException) {
            codecException.printStackTrace();
            throw new FIPAException(codecException.getMessage());
        }
        catch (OntologyException ontologyException) {
            ontologyException.printStackTrace();
            throw new FIPAException(ontologyException.getMessage());
        }
    }
}

