/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.Initiator;
import jade.util.leap.Iterator;
import jade.util.leap.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class TwoPh2Initiator
extends Initiator {
    public final String ACCEPTANCE_KEY;
    public final String ALL_ACCEPTANCES_KEY;
    public final String REPLY_KEY;
    public final String ALL_RESPONSES_KEY;
    public final String ALL_INFORMS_KEY;
    public final String ALL_PENDINGS_KEY;
    private static final String HANDLE_INFORM = "Handle-Inform";
    private static final String HANDLE_OLD_RESPONSE = "Handle-old-response";
    private static final String HANDLE_ALL_RESPONSES = "Handle-all-responses";
    private static final int OLD_RESPONSE = 1000;
    private static final int ALL_RESPONSES_RECEIVED = 1;
    private int totSessions;
    private boolean logging;
    private boolean currentLogging;
    private String[] toBeReset;

    public TwoPh2Initiator(Agent agent, ACLMessage aCLMessage) {
        this(agent, aCLMessage, new DataStore());
    }

    public TwoPh2Initiator(Agent agent, ACLMessage aCLMessage, DataStore dataStore) {
        super(agent, aCLMessage, dataStore);
        this.ACCEPTANCE_KEY = this.INITIATION_K;
        this.ALL_ACCEPTANCES_KEY = this.ALL_INITIATIONS_K;
        this.REPLY_KEY = this.REPLY_K;
        this.ALL_RESPONSES_KEY = "__all-responses" + this.hashCode();
        this.ALL_INFORMS_KEY = "__all-informs" + this.hashCode();
        this.ALL_PENDINGS_KEY = "__all-pendings" + this.hashCode();
        this.logging = true;
        this.currentLogging = true;
        this.toBeReset = null;
        this.registerTransition("Check-in-seq", HANDLE_INFORM, 7);
        this.registerTransition("Check-in-seq", HANDLE_OLD_RESPONSE, 1000);
        this.registerDefaultTransition(HANDLE_INFORM, "Check-sessions");
        this.registerDefaultTransition(HANDLE_OLD_RESPONSE, "Check-sessions");
        this.registerTransition("Check-sessions", HANDLE_ALL_RESPONSES, 1);
        this.registerDefaultTransition(HANDLE_ALL_RESPONSES, "Dummy-final");
        OneShotBehaviour oneShotBehaviour = null;
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            int ret;

            public void action() {
                ACLMessage aCLMessage = (ACLMessage)this.getDataStore().get(TwoPh2Initiator.this.REPLY_K);
                String string = aCLMessage.getInReplyTo();
                String string2 = string.substring(string.length() - 3);
                if (string2.equals("PH0") || string2.equals("PH1")) {
                    TwoPh2Initiator.this.oldResponse(aCLMessage);
                    this.ret = 1000;
                } else {
                    this.ret = TwoPh2Initiator.this.checkInSequence(aCLMessage) ? aCLMessage.getPerformative() : -1;
                }
            }

            public int onEnd() {
                return this.ret;
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, "Check-in-seq");
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            int ret = -1;

            public void action() {
                ACLMessage aCLMessage = (ACLMessage)this.getDataStore().get(TwoPh2Initiator.this.REPLY_KEY);
                TwoPh2Initiator.this.handleInform(aCLMessage);
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_INFORM);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){

            public void action() {
                ACLMessage aCLMessage = (ACLMessage)this.getDataStore().get(TwoPh2Initiator.this.REPLY_KEY);
                TwoPh2Initiator.this.handleOldResponse(aCLMessage);
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_OLD_RESPONSE);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){

            public void action() {
                Vector vector = (Vector)this.getDataStore().get(TwoPh2Initiator.this.ALL_RESPONSES_KEY);
                TwoPh2Initiator.this.handleAllResponses(vector);
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_ALL_RESPONSES);
    }

    protected Vector prepareAcceptances(ACLMessage aCLMessage) {
        Vector<ACLMessage> vector = new Vector<ACLMessage>(1);
        vector.addElement(aCLMessage);
        return vector;
    }

    protected void handleInform(ACLMessage aCLMessage) {
    }

    protected void handleOldResponse(ACLMessage aCLMessage) {
    }

    protected void handleAllResponses(Vector vector) {
    }

    public void registerPrepareProposals(Behaviour behaviour) {
        this.registerPrepareInitiations(behaviour);
    }

    public void registerHandleInform(Behaviour behaviour) {
        this.registerState(behaviour, HANDLE_INFORM);
        behaviour.setDataStore(this.getDataStore());
    }

    public void registerHandleOldResponse(Behaviour behaviour) {
        this.registerState(behaviour, HANDLE_OLD_RESPONSE);
        behaviour.setDataStore(this.getDataStore());
    }

    public void registerHandleAllResponses(Behaviour behaviour) {
        this.registerState(behaviour, HANDLE_ALL_RESPONSES);
        behaviour.setDataStore(this.getDataStore());
    }

    protected String[] getToBeReset() {
        if (this.toBeReset == null) {
            this.toBeReset = new String[]{HANDLE_INFORM, HANDLE_OLD_RESPONSE, "Handle-not-understood", "Handle-failure", "Handle-out-of-seq"};
        }
        return this.toBeReset;
    }

    protected final Vector prepareInitiations(ACLMessage aCLMessage) {
        return this.prepareAcceptances(aCLMessage);
    }

    protected final void sendInitiations(Vector vector) {
        long l = System.currentTimeMillis();
        long l2 = -1L;
        long l3 = -1L;
        Vector<Cloneable> vector2 = new Vector<Cloneable>();
        String string = this.createConvId(vector);
        this.replyTemplate = MessageTemplate.MatchConversationId(string);
        this.totSessions = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            long l4;
            Cloneable cloneable;
            ACLMessage aCLMessage = (ACLMessage)enumeration.nextElement();
            if (aCLMessage == null) continue;
            Iterator iterator = aCLMessage.getAllReceiver();
            while (iterator.hasNext()) {
                cloneable = (ACLMessage)aCLMessage.clone();
                ((ACLMessage)cloneable).setConversationId(string);
                ((ACLMessage)cloneable).clearAllReceiver();
                AID aID = (AID)iterator.next();
                ((ACLMessage)cloneable).addReceiver(aID);
                String string2 = "R" + this.hashCode() + "_" + Integer.toString(this.totSessions) + "_PH2";
                ((ACLMessage)cloneable).setReplyWith(string2);
                this.sessions.put(string2, new Session());
                this.adjustReplyTemplate((ACLMessage)cloneable);
                this.myAgent.send((ACLMessage)cloneable);
                vector2.add(cloneable);
                ++this.totSessions;
            }
            cloneable = aCLMessage.getReplyByDate();
            if (cloneable == null || (l4 = ((Date)cloneable).getTime() - l) <= 0L || l4 >= l2 && l2 > 0L) continue;
            l2 = l4;
            l3 = ((Date)cloneable).getTime();
        }
        this.replyReceiver.setTemplate(this.replyTemplate);
        this.replyReceiver.setDeadline(l3);
        this.getDataStore().put(this.ALL_PENDINGS_KEY, vector2);
    }

    protected final boolean checkInSequence(ACLMessage aCLMessage) {
        boolean bl = false;
        String string = aCLMessage.getInReplyTo();
        Session session = (Session)this.sessions.get(string);
        if (session != null) {
            int n = aCLMessage.getPerformative();
            if (session.update(n)) {
                ((Vector)this.getDataStore().get(this.ALL_RESPONSES_KEY)).add(aCLMessage);
                if (n == 7) {
                    ((Vector)this.getDataStore().get(this.ALL_INFORMS_KEY)).add(aCLMessage);
                }
                this.updatePendings(string);
                bl = true;
            }
            if (session.isCompleted()) {
                this.sessions.remove(string);
            }
        }
        return bl;
    }

    private void updatePendings(String string) {
        Vector vector = (Vector)this.getDataStore().get(this.ALL_PENDINGS_KEY);
        int n = 0;
        while (n < vector.size()) {
            ACLMessage aCLMessage = (ACLMessage)vector.get(n);
            if (aCLMessage.getReplyWith().equals(string)) {
                vector.remove(n);
                break;
            }
            ++n;
        }
    }

    private void oldResponse(ACLMessage aCLMessage) {
        String string = aCLMessage.getInReplyTo();
        String string2 = string.substring(0, string.length() - 3) + "PH2";
        int n = aCLMessage.getPerformative();
        if (n == 6 || n == 10 || n == 5) {
            this.sessions.remove(string2);
            this.updatePendings(string2);
        }
    }

    protected final int checkSessions(ACLMessage aCLMessage) {
        if (aCLMessage == null) {
            this.sessions.clear();
        }
        if (this.sessions.size() == 0) {
            return 1;
        }
        return -1;
    }

    protected void initializeDataStore(ACLMessage aCLMessage) {
        super.initializeDataStore(aCLMessage);
        this.getDataStore().put(this.ALL_RESPONSES_KEY, new Vector());
        this.getDataStore().put(this.ALL_INFORMS_KEY, new Vector());
    }

    public void reset(ACLMessage aCLMessage) {
        super.reset(aCLMessage);
    }

    class Session
    implements Serializable {
        static final int INIT = 0;
        static final int REPLY_RECEIVED = 1;
        private int state = 0;

        Session() {
        }

        public boolean update(int n) {
            if (this.state == 0) {
                switch (n) {
                    case 6: 
                    case 7: 
                    case 10: {
                        this.state = 1;
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        public int getState() {
            return this.state;
        }

        public boolean isCompleted() {
            return this.state == 1;
        }
    }
}

