/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.Initiator;
import jade.util.leap.Iterator;
import jade.util.leap.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class TwoPh0Initiator
extends Initiator {
    public final String CFP_KEY;
    public final String ALL_CFPS_KEY;
    public final String REPLY_KEY;
    public final String ALL_RESPONSES_KEY;
    public final String ALL_PROPOSES_KEY;
    public final String ALL_PENDINGS_KEY;
    private static final String HANDLE_PROPOSE = "Handle-Propose";
    private static final String HANDLE_ALL_RESPONSES = "Handle-all-responses";
    private static final int ALL_RESPONSES_RECEIVED = 1;
    private String outputKey;
    private int totSessions;
    private boolean logging;
    private boolean currentLogging;
    private String[] toBeReset;

    public TwoPh0Initiator(Agent agent, ACLMessage aCLMessage, String string) {
        this(agent, aCLMessage, string, new DataStore());
    }

    public TwoPh0Initiator(Agent agent, ACLMessage aCLMessage, String string, DataStore dataStore) {
        super(agent, aCLMessage, dataStore);
        this.CFP_KEY = this.INITIATION_K;
        this.ALL_CFPS_KEY = this.ALL_INITIATIONS_K;
        this.REPLY_KEY = this.REPLY_K;
        this.ALL_RESPONSES_KEY = "__all-responses" + this.hashCode();
        this.ALL_PROPOSES_KEY = "__all-proposes" + this.hashCode();
        this.ALL_PENDINGS_KEY = "__all-pendings" + this.hashCode();
        this.outputKey = null;
        this.logging = true;
        this.currentLogging = true;
        this.toBeReset = null;
        this.outputKey = string;
        this.registerTransition("Check-in-seq", HANDLE_PROPOSE, 11);
        this.registerDefaultTransition(HANDLE_PROPOSE, "Check-sessions");
        this.registerTransition("Check-sessions", HANDLE_ALL_RESPONSES, 1);
        this.registerDefaultTransition(HANDLE_ALL_RESPONSES, "Dummy-final");
        OneShotBehaviour oneShotBehaviour = null;
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){

            public void action() {
                ACLMessage aCLMessage = (ACLMessage)this.getDataStore().get(TwoPh0Initiator.this.REPLY_KEY);
                TwoPh0Initiator.this.handlePropose(aCLMessage);
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_PROPOSE);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){

            public void action() {
                Vector vector = (Vector)this.getDataStore().get(TwoPh0Initiator.this.ALL_RESPONSES_KEY);
                Vector vector2 = (Vector)this.getDataStore().get(TwoPh0Initiator.this.ALL_PROPOSES_KEY);
                Vector vector3 = (Vector)this.getDataStore().get(TwoPh0Initiator.this.ALL_PENDINGS_KEY);
                Vector vector4 = (Vector)this.getDataStore().get(TwoPh0Initiator.this.outputKey);
                TwoPh0Initiator.this.handleAllResponses(vector, vector2, vector3, vector4);
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_ALL_RESPONSES);
    }

    public int onEnd() {
        Vector vector = (Vector)this.getDataStore().get(this.outputKey);
        if (vector.size() != 0) {
            return ((ACLMessage)vector.get(0)).getPerformative();
        }
        return -1;
    }

    protected Vector prepareCfps(ACLMessage aCLMessage) {
        Vector<ACLMessage> vector = new Vector<ACLMessage>(1);
        vector.addElement(aCLMessage);
        return vector;
    }

    protected void handlePropose(ACLMessage aCLMessage) {
    }

    protected void handleAllResponses(Vector vector, Vector vector2, Vector vector3, Vector vector4) {
    }

    public void registerPrepareCfps(Behaviour behaviour) {
        this.registerPrepareInitiations(behaviour);
    }

    public void registerHandlePropose(Behaviour behaviour) {
        this.registerState(behaviour, HANDLE_PROPOSE);
        behaviour.setDataStore(this.getDataStore());
    }

    public void registerHandleAllResponses(Behaviour behaviour) {
        this.registerState(behaviour, HANDLE_ALL_RESPONSES);
        behaviour.setDataStore(this.getDataStore());
    }

    protected String[] getToBeReset() {
        if (this.toBeReset == null) {
            this.toBeReset = new String[]{HANDLE_PROPOSE, "Handle-not-understood", "Handle-failure", "Handle-out-of-seq"};
        }
        return this.toBeReset;
    }

    protected final Vector prepareInitiations(ACLMessage aCLMessage) {
        return this.prepareCfps(aCLMessage);
    }

    protected final void sendInitiations(Vector vector) {
        long l = System.currentTimeMillis();
        long l2 = -1L;
        long l3 = -1L;
        Vector<Cloneable> vector2 = new Vector<Cloneable>();
        String string = this.createConvId(vector);
        this.replyTemplate = MessageTemplate.MatchConversationId(string);
        this.totSessions = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            long l4;
            Cloneable cloneable;
            ACLMessage aCLMessage = (ACLMessage)enumeration.nextElement();
            if (aCLMessage == null) continue;
            Iterator iterator = aCLMessage.getAllReceiver();
            while (iterator.hasNext()) {
                cloneable = (ACLMessage)aCLMessage.clone();
                ((ACLMessage)cloneable).setConversationId(string);
                ((ACLMessage)cloneable).clearAllReceiver();
                AID aID = (AID)iterator.next();
                ((ACLMessage)cloneable).addReceiver(aID);
                String string2 = "R" + this.hashCode() + "_" + Integer.toString(this.totSessions) + "_PH0";
                ((ACLMessage)cloneable).setReplyWith(string2);
                this.sessions.put(string2, new Session());
                this.adjustReplyTemplate((ACLMessage)cloneable);
                this.myAgent.send((ACLMessage)cloneable);
                vector2.add(cloneable);
                ++this.totSessions;
            }
            cloneable = aCLMessage.getReplyByDate();
            if (cloneable == null || (l4 = ((Date)cloneable).getTime() - l) <= 0L || l4 >= l2 && l2 > 0L) continue;
            l2 = l4;
            l3 = ((Date)cloneable).getTime();
        }
        this.replyReceiver.setTemplate(this.replyTemplate);
        this.replyReceiver.setDeadline(l3);
        this.getDataStore().put(this.ALL_PENDINGS_KEY, vector2);
    }

    protected final boolean checkInSequence(ACLMessage aCLMessage) {
        boolean bl = false;
        String string = aCLMessage.getInReplyTo();
        Session session = (Session)this.sessions.get(string);
        if (session != null) {
            int n = aCLMessage.getPerformative();
            if (session.update(n)) {
                ((Vector)this.getDataStore().get(this.ALL_RESPONSES_KEY)).add(aCLMessage);
                if (n == 11) {
                    ((Vector)this.getDataStore().get(this.ALL_PROPOSES_KEY)).add(aCLMessage);
                }
                this.updatePendings(string);
                bl = true;
            }
            if (session.isCompleted()) {
                this.sessions.remove(string);
            }
        }
        return bl;
    }

    private void updatePendings(String string) {
        Vector vector = (Vector)this.getDataStore().get(this.ALL_PENDINGS_KEY);
        int n = 0;
        while (n < vector.size()) {
            ACLMessage aCLMessage = (ACLMessage)vector.get(n);
            if (aCLMessage.getReplyWith().equals(string)) {
                vector.remove(n);
                break;
            }
            ++n;
        }
    }

    protected final int checkSessions(ACLMessage aCLMessage) {
        if (aCLMessage == null) {
            this.sessions.clear();
        }
        if (this.sessions.size() == 0) {
            DataStore dataStore = this.getDataStore();
            Vector vector = (Vector)dataStore.get(this.outputKey);
            if (vector.size() == 0) {
                Vector vector2 = (Vector)dataStore.get(this.ALL_PROPOSES_KEY);
                Vector vector3 = (Vector)dataStore.get(this.ALL_PENDINGS_KEY);
                this.fillNextPhInitiations(vector, vector2, vector3);
            }
            return 1;
        }
        return -1;
    }

    private void fillNextPhInitiations(Vector vector, Vector vector2, Vector vector3) {
        if (vector2.size() == this.totSessions) {
            int n = 0;
            while (n < vector2.size()) {
                ACLMessage aCLMessage = (ACLMessage)vector2.get(n);
                ACLMessage aCLMessage2 = aCLMessage.createReply();
                aCLMessage2.setPerformative(12);
                vector.add(aCLMessage2);
                ++n;
            }
        } else {
            ACLMessage aCLMessage;
            int n = 0;
            while (n < vector2.size()) {
                ACLMessage aCLMessage3 = (ACLMessage)vector2.get(n);
                aCLMessage = aCLMessage3.createReply();
                aCLMessage.setPerformative(15);
                vector.add(aCLMessage);
                ++n;
            }
            int n2 = 0;
            while (n2 < vector3.size()) {
                aCLMessage = (ACLMessage)vector3.get(n2);
                ACLMessage aCLMessage4 = (ACLMessage)aCLMessage.clone();
                aCLMessage4.setPerformative(15);
                vector.add(aCLMessage4);
                ++n2;
            }
        }
    }

    protected void initializeDataStore(ACLMessage aCLMessage) {
        super.initializeDataStore(aCLMessage);
        this.getDataStore().put(this.ALL_RESPONSES_KEY, new Vector());
        this.getDataStore().put(this.ALL_PROPOSES_KEY, new Vector());
        this.getDataStore().put(this.outputKey, new Vector());
    }

    public void reset(ACLMessage aCLMessage) {
        super.reset(aCLMessage);
    }

    class Session
    implements Serializable {
        static final int INIT = 0;
        static final int REPLY_RECEIVED = 1;
        private int state = 0;

        Session() {
        }

        public boolean update(int n) {
            if (this.state == 0) {
                switch (n) {
                    case 6: 
                    case 10: 
                    case 11: {
                        this.state = 1;
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        public int getState() {
            return this.state;
        }

        public boolean isCompleted() {
            return this.state == 1;
        }
    }
}

