/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.states.MsgReceiver;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.Map;
import jade.util.leap.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class ProposeInitiator
extends FSMBehaviour {
    protected final String INITIATION_K = "__initiation" + this.hashCode();
    protected final String ALL_INITIATIONS_K = "__all-initiations" + this.hashCode();
    public final String REPLY_KEY = "__reply" + this.hashCode();
    public final String ALL_RESPONSES_KEY = "__all-responses" + this.hashCode();
    protected static final String PREPARE_INITIATIONS = "Prepare-initiations";
    protected static final String SEND_INITIATIONS = "Send-initiations";
    protected static final String RECEIVE_REPLY = "Receive-reply";
    protected static final String CHECK_IN_SEQ = "Check-in-seq";
    protected static final String HANDLE_NOT_UNDERSTOOD = "Handle-not-understood";
    protected static final String HANDLE_OUT_OF_SEQ = "Handle-out-of-seq";
    protected static final String HANDLE_ALL_RESPONSES = "Handle-all-responses";
    protected static final String HANDLE_REJECT_PROPOSAL = "Handle-reject-proposal";
    protected static final String HANDLE_ACCEPT_PROPOSAL = "Handle-accept-proposal";
    private static final String CHECK_AGAIN = "Check-again";
    protected static final String CHECK_SESSIONS = "Check-sessions";
    protected static final String DUMMY_FINAL = "Dummy-final";
    protected Map sessions = new HashMap();
    protected MsgReceiver replyReceiver = null;
    protected MessageTemplate replyTemplate = null;
    private ACLMessage initiation;
    private static final int ALL_RESPONSES_RECEIVED = 1;
    private static final int TERMINATED = 2;
    protected String[] toBeReset = new String[]{"Handle-accept-proposal", "Handle-reject-proposal", "Handle-not-understood", "Handle-out-of-seq"};
    private boolean allResponsesReceived = false;

    public ProposeInitiator(Agent agent, ACLMessage aCLMessage) {
        this(agent, aCLMessage, new DataStore());
    }

    public ProposeInitiator(Agent agent, ACLMessage aCLMessage, DataStore dataStore) {
        super(agent);
        this.setDataStore(dataStore);
        this.initiation = aCLMessage;
        this.registerDefaultTransition(PREPARE_INITIATIONS, SEND_INITIATIONS);
        this.registerTransition(SEND_INITIATIONS, DUMMY_FINAL, 0);
        this.registerDefaultTransition(SEND_INITIATIONS, RECEIVE_REPLY);
        this.registerTransition(RECEIVE_REPLY, CHECK_SESSIONS, -1001);
        this.registerTransition(RECEIVE_REPLY, CHECK_SESSIONS, -1002);
        this.registerDefaultTransition(RECEIVE_REPLY, CHECK_IN_SEQ);
        this.registerTransition(CHECK_IN_SEQ, HANDLE_NOT_UNDERSTOOD, 10);
        this.registerTransition(CHECK_IN_SEQ, HANDLE_REJECT_PROPOSAL, 15);
        this.registerTransition(CHECK_IN_SEQ, HANDLE_ACCEPT_PROPOSAL, 0);
        this.registerDefaultTransition(CHECK_IN_SEQ, HANDLE_OUT_OF_SEQ);
        this.registerDefaultTransition(HANDLE_NOT_UNDERSTOOD, CHECK_SESSIONS);
        this.registerDefaultTransition(HANDLE_REJECT_PROPOSAL, CHECK_SESSIONS);
        this.registerDefaultTransition(HANDLE_ACCEPT_PROPOSAL, CHECK_SESSIONS);
        this.registerDefaultTransition(HANDLE_OUT_OF_SEQ, RECEIVE_REPLY);
        this.registerDefaultTransition(CHECK_SESSIONS, RECEIVE_REPLY, this.toBeReset);
        this.registerTransition(CHECK_SESSIONS, HANDLE_ALL_RESPONSES, 1);
        this.registerTransition(CHECK_SESSIONS, DUMMY_FINAL, 2);
        this.registerDefaultTransition(HANDLE_ALL_RESPONSES, CHECK_AGAIN);
        this.registerTransition(CHECK_AGAIN, DUMMY_FINAL, 0);
        this.registerDefaultTransition(CHECK_AGAIN, RECEIVE_REPLY, this.toBeReset);
        OneShotBehaviour oneShotBehaviour = null;
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818000L;

            public void action() {
                DataStore dataStore = this.getDataStore();
                Vector vector = ProposeInitiator.this.prepareInitiations((ACLMessage)dataStore.get(ProposeInitiator.this.INITIATION_K));
                this.getDataStore().put(ProposeInitiator.this.ALL_INITIATIONS_K, vector);
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerFirstState(oneShotBehaviour, PREPARE_INITIATIONS);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818001L;

            public void action() {
                Vector vector = (Vector)this.getDataStore().get(ProposeInitiator.this.ALL_INITIATIONS_K);
                if (vector != null) {
                    ProposeInitiator.this.sendInitiations(vector);
                }
            }

            public int onEnd() {
                return ProposeInitiator.this.sessions.size();
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, SEND_INITIATIONS);
        this.replyReceiver = new MsgReceiver(this.myAgent, null, -1L, this.getDataStore(), this.REPLY_KEY);
        this.registerState(this.replyReceiver, RECEIVE_REPLY);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            int ret;
            private static final long serialVersionUID = 3487495895818002L;

            public void action() {
                ACLMessage aCLMessage = (ACLMessage)this.getDataStore().get(ProposeInitiator.this.REPLY_KEY);
                this.ret = ProposeInitiator.this.checkInSequence(aCLMessage) ? aCLMessage.getPerformative() : -1;
            }

            public int onEnd() {
                return this.ret;
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, CHECK_IN_SEQ);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){

            public void action() {
                ProposeInitiator.this.handleAllResponses((Vector)this.getDataStore().get(ProposeInitiator.this.ALL_RESPONSES_KEY));
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_ALL_RESPONSES);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){

            public void action() {
                ProposeInitiator.this.handleAcceptProposal((ACLMessage)this.getDataStore().get(ProposeInitiator.this.REPLY_KEY));
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_ACCEPT_PROPOSAL);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){

            public void action() {
                ProposeInitiator.this.handleRejectProposal((ACLMessage)this.getDataStore().get(ProposeInitiator.this.REPLY_KEY));
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_REJECT_PROPOSAL);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818005L;

            public void action() {
                ProposeInitiator.this.handleNotUnderstood((ACLMessage)this.getDataStore().get(ProposeInitiator.this.REPLY_KEY));
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_NOT_UNDERSTOOD);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818008L;

            public void action() {
                ProposeInitiator.this.handleOutOfSequence((ACLMessage)this.getDataStore().get(ProposeInitiator.this.REPLY_KEY));
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_OUT_OF_SEQ);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            int ret;
            private static final long serialVersionUID = 3487495895818009L;

            public void action() {
                ACLMessage aCLMessage = (ACLMessage)this.getDataStore().get(ProposeInitiator.this.REPLY_KEY);
                this.ret = ProposeInitiator.this.checkSessions(aCLMessage);
            }

            public int onEnd() {
                return this.ret;
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, CHECK_SESSIONS);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){

            public void action() {
            }

            public int onEnd() {
                return ProposeInitiator.this.sessions.size();
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, CHECK_AGAIN);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818010L;

            public void action() {
            }
        };
        this.registerLastState(oneShotBehaviour, DUMMY_FINAL);
    }

    protected void initializeDataStore(ACLMessage aCLMessage) {
        this.getDataStore().put(this.INITIATION_K, this.initiation);
        Vector vector = new Vector();
        this.getDataStore().put(this.ALL_RESPONSES_KEY, vector);
    }

    protected void sendInitiations(Vector vector) {
        long l = System.currentTimeMillis();
        long l2 = -1L;
        long l3 = -1L;
        String string = this.createConvId(vector);
        this.replyTemplate = MessageTemplate.MatchConversationId(string);
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            long l4;
            Comparable<Date> comparable;
            ACLMessage aCLMessage = (ACLMessage)enumeration.nextElement();
            if (aCLMessage == null) continue;
            ACLMessage aCLMessage2 = (ACLMessage)aCLMessage.clone();
            aCLMessage2.setProtocol("fipa-propose");
            aCLMessage2.setConversationId(string);
            Iterator iterator = aCLMessage.getAllReceiver();
            while (iterator.hasNext()) {
                aCLMessage2.clearAllReceiver();
                comparable = (AID)iterator.next();
                aCLMessage2.addReceiver((AID)comparable);
                String string2 = "R" + this.hashCode() + "_" + Integer.toString(n);
                aCLMessage2.setReplyWith(string2);
                this.sessions.put(string2, new Session());
                this.adjustReplyTemplate(aCLMessage2);
                this.myAgent.send(aCLMessage2);
                this.getDataStore().put(comparable, aCLMessage2);
                ++n;
            }
            comparable = aCLMessage.getReplyByDate();
            if (comparable == null || (l4 = ((Date)comparable).getTime() - l) <= 0L || l4 >= l2 && l2 > 0L) continue;
            l2 = l4;
            l3 = ((Date)comparable).getTime();
        }
        this.replyReceiver.setTemplate(this.replyTemplate);
        this.replyReceiver.setDeadline(l3);
    }

    protected boolean checkInSequence(ACLMessage aCLMessage) {
        int n;
        String string = aCLMessage.getInReplyTo();
        Session session = (Session)this.sessions.get(string);
        if (session != null && session.update(n = aCLMessage.getPerformative())) {
            switch (session.getState()) {
                case 2: 
                case 3: {
                    Vector vector = (Vector)this.getDataStore().get(this.ALL_RESPONSES_KEY);
                    vector.addElement(aCLMessage);
                    break;
                }
                default: {
                    return false;
                }
            }
            if (session.isCompleted()) {
                this.sessions.remove(string);
            }
            return true;
        }
        return false;
    }

    protected int checkSessions(ACLMessage aCLMessage) {
        Object object;
        Object object2;
        int n = -1;
        if (this.getLastExitValue() == -1001) {
            if (!this.allResponsesReceived) {
                Iterator iterator;
                object2 = new ArrayList(this.sessions.size());
                object = this.sessions.keySet().iterator();
                while (object.hasNext()) {
                    iterator = object.next();
                    Session session = (Session)this.sessions.get(iterator);
                    if (session.getState() != 0) continue;
                    object2.add(iterator);
                }
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    this.sessions.remove(iterator.next());
                }
                object2 = null;
            } else {
                this.sessions.clear();
            }
        }
        if (!this.allResponsesReceived) {
            this.allResponsesReceived = true;
            object2 = this.sessions.values().iterator();
            while (object2.hasNext()) {
                object = (Session)object2.next();
                if (((Session)object).getState() != 0) continue;
                this.allResponsesReceived = false;
                break;
            }
            if (this.allResponsesReceived) {
                this.replyReceiver.setDeadline(-1L);
                n = 1;
            }
        } else if (this.sessions.size() == 0) {
            n = 2;
        }
        return n;
    }

    protected Vector prepareInitiations(ACLMessage aCLMessage) {
        Vector<ACLMessage> vector = new Vector<ACLMessage>(1);
        vector.addElement(aCLMessage);
        return vector;
    }

    protected void handleAcceptProposal(ACLMessage aCLMessage) {
    }

    protected void handleRejectProposal(ACLMessage aCLMessage) {
    }

    protected void handleNotUnderstood(ACLMessage aCLMessage) {
    }

    protected void handleOutOfSequence(ACLMessage aCLMessage) {
    }

    public void registerHandleAllResponses(Behaviour behaviour) {
        this.registerState(behaviour, HANDLE_ALL_RESPONSES);
        behaviour.setDataStore(this.getDataStore());
    }

    public void registerHandleAcceptProposal(Behaviour behaviour) {
        this.registerState(behaviour, HANDLE_ACCEPT_PROPOSAL);
        behaviour.setDataStore(this.getDataStore());
    }

    public void registerHandleRejectProposal(Behaviour behaviour) {
        this.registerState(behaviour, HANDLE_REJECT_PROPOSAL);
        behaviour.setDataStore(this.getDataStore());
    }

    public void registerHandleNotUnderstood(Behaviour behaviour) {
        this.registerState(behaviour, HANDLE_NOT_UNDERSTOOD);
        behaviour.setDataStore(this.getDataStore());
    }

    public void registerHandleOutOfSequence(Behaviour behaviour) {
        this.registerState(behaviour, HANDLE_OUT_OF_SEQ);
        behaviour.setDataStore(this.getDataStore());
    }

    protected void handleAllResponses(Vector vector) {
    }

    public void reset() {
        this.reset(null);
    }

    public void reset(ACLMessage aCLMessage) {
        super.reset();
        this.replyReceiver.reset(null, -1L, this.getDataStore(), this.REPLY_KEY);
        this.initiation = aCLMessage;
        this.sessions.clear();
        this.allResponsesReceived = false;
    }

    public void onStart() {
        this.initializeDataStore(this.initiation);
    }

    public void setDataStore(DataStore dataStore) {
        super.setDataStore(dataStore);
        Iterator iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            Behaviour behaviour = (Behaviour)iterator.next();
            behaviour.setDataStore(dataStore);
        }
    }

    protected String createConvId(Vector vector) {
        String string = null;
        if (vector.size() > 0) {
            ACLMessage aCLMessage = (ACLMessage)vector.elementAt(0);
            string = aCLMessage == null || aCLMessage.getConversationId() == null ? "C" + this.hashCode() + "_" + System.currentTimeMillis() : aCLMessage.getConversationId();
        }
        return string;
    }

    protected void adjustReplyTemplate(ACLMessage aCLMessage) {
        AID aID = (AID)aCLMessage.getAllReceiver().next();
        if (this.myAgent.getAID().equals(aID)) {
            this.replyTemplate = MessageTemplate.and(this.replyTemplate, MessageTemplate.not(MessageTemplate.MatchCustom(aCLMessage, true)));
        }
    }

    private static class Session
    implements Serializable {
        static final int INIT = 0;
        static final int NEGATIVE_RESPONSE_RECEIVED = 2;
        static final int RESULT_NOTIFICATION_RECEIVED = 3;
        private int state = 0;

        private Session() {
        }

        boolean update(int n) {
            switch (this.state) {
                case 0: {
                    switch (n) {
                        case 10: {
                            this.state = 2;
                            return true;
                        }
                        case 0: 
                        case 15: {
                            this.state = 3;
                            return true;
                        }
                    }
                    return false;
                }
            }
            return false;
        }

        int getState() {
            return this.state;
        }

        boolean isCompleted() {
            return this.state == 2 || this.state == 3;
        }
    }
}

