/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.Agent;
import jade.core.CaseInsensitiveString;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.domain.FIPANames;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.states.MsgReceiver;
import jade.proto.states.ReplySender;

public class AchieveREResponder
extends FSMBehaviour
implements FIPANames.InteractionProtocol {
    public final String REQUEST_KEY = "__request" + this.hashCode();
    public final String RESPONSE_KEY = "__response" + this.hashCode();
    public final String RESULT_NOTIFICATION_KEY = "__result-notification" + this.hashCode();
    private static final String RECEIVE_REQUEST = "Receive-request";
    private static final String PREPARE_RESPONSE = "Prepare-response";
    private static final String SEND_RESPONSE = "Send-response";
    private static final String PREPARE_RESULT_NOTIFICATION = "Prepare-result-notification";
    private static final String SEND_RESULT_NOTIFICATION = "Send-result-notification";
    MsgReceiver rec = null;

    public static MessageTemplate createMessageTemplate(String string) {
        if (CaseInsensitiveString.equalsIgnoreCase("fipa-request", string)) {
            return MessageTemplate.and(MessageTemplate.MatchProtocol("fipa-request"), MessageTemplate.MatchPerformative(16));
        }
        if (CaseInsensitiveString.equalsIgnoreCase("fipa-query", string)) {
            return MessageTemplate.and(MessageTemplate.MatchProtocol("fipa-query"), MessageTemplate.or(MessageTemplate.MatchPerformative(12), MessageTemplate.MatchPerformative(13)));
        }
        return MessageTemplate.MatchProtocol(string);
    }

    public AchieveREResponder(Agent agent, MessageTemplate messageTemplate) {
        this(agent, messageTemplate, new DataStore());
    }

    public AchieveREResponder(Agent agent, MessageTemplate messageTemplate, DataStore dataStore) {
        super(agent);
        this.setDataStore(dataStore);
        this.registerDefaultTransition(RECEIVE_REQUEST, PREPARE_RESPONSE);
        this.registerDefaultTransition(PREPARE_RESPONSE, SEND_RESPONSE);
        this.registerTransition(SEND_RESPONSE, PREPARE_RESULT_NOTIFICATION, 1);
        this.registerTransition(SEND_RESPONSE, PREPARE_RESULT_NOTIFICATION, -1);
        this.registerDefaultTransition(SEND_RESPONSE, RECEIVE_REQUEST);
        this.registerDefaultTransition(PREPARE_RESULT_NOTIFICATION, SEND_RESULT_NOTIFICATION);
        this.registerDefaultTransition(SEND_RESULT_NOTIFICATION, RECEIVE_REQUEST);
        OneShotBehaviour oneShotBehaviour = null;
        this.rec = new MsgReceiver(this.myAgent, messageTemplate, -1L, this.getDataStore(), this.REQUEST_KEY);
        this.registerFirstState(this.rec, RECEIVE_REQUEST);
        oneShotBehaviour = new PrepareResponse(this.myAgent);
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, PREPARE_RESPONSE);
        oneShotBehaviour = new SendResponse(this.myAgent, this.RESPONSE_KEY, this.REQUEST_KEY);
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, SEND_RESPONSE);
        oneShotBehaviour = new PrepareResult(this.myAgent);
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, PREPARE_RESULT_NOTIFICATION);
        oneShotBehaviour = new SendResult(this.myAgent, this.RESULT_NOTIFICATION_KEY, this.REQUEST_KEY);
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, SEND_RESULT_NOTIFICATION);
    }

    private AchieveREResponder() {
    }

    public void reset() {
        super.reset();
        DataStore dataStore = this.getDataStore();
        dataStore.remove(this.REQUEST_KEY);
        dataStore.remove(this.RESPONSE_KEY);
        dataStore.remove(this.RESULT_NOTIFICATION_KEY);
    }

    public void reset(MessageTemplate messageTemplate) {
        this.reset();
        this.rec.reset(messageTemplate, -1L, this.getDataStore(), this.REQUEST_KEY);
    }

    protected ACLMessage prepareResponse(ACLMessage aCLMessage) throws NotUnderstoodException, RefuseException {
        System.out.println("prepareResponse() method not re-defined");
        return null;
    }

    protected ACLMessage prepareResultNotification(ACLMessage aCLMessage, ACLMessage aCLMessage2) throws FailureException {
        System.out.println("prepareResultNotification() method not re-defined");
        return null;
    }

    public void registerPrepareResponse(Behaviour behaviour) {
        this.registerState(behaviour, PREPARE_RESPONSE);
        behaviour.setDataStore(this.getDataStore());
    }

    public void registerPrepareResultNotification(Behaviour behaviour) {
        this.registerState(behaviour, PREPARE_RESULT_NOTIFICATION);
        behaviour.setDataStore(this.getDataStore());
    }

    private static class SendResult
    extends ReplySender {
        public SendResult(Agent agent, String string, String string2) {
            super(agent, string, string2);
        }

        private SendResult() {
        }

        public int onEnd() {
            AchieveREResponder achieveREResponder = (AchieveREResponder)this.getParent();
            achieveREResponder.reset();
            return super.onEnd();
        }
    }

    private static class PrepareResult
    extends OneShotBehaviour {
        public PrepareResult(Agent agent) {
            super(agent);
        }

        private PrepareResult() {
        }

        public void action() {
            DataStore dataStore = this.getDataStore();
            AchieveREResponder achieveREResponder = (AchieveREResponder)this.getParent();
            ACLMessage aCLMessage = (ACLMessage)dataStore.get(achieveREResponder.REQUEST_KEY);
            ACLMessage aCLMessage2 = (ACLMessage)dataStore.get(achieveREResponder.RESPONSE_KEY);
            ACLMessage aCLMessage3 = null;
            try {
                aCLMessage3 = achieveREResponder.prepareResultNotification(aCLMessage, aCLMessage2);
            }
            catch (FailureException failureException) {
                aCLMessage3 = failureException.getACLMessage();
            }
            dataStore.put(achieveREResponder.RESULT_NOTIFICATION_KEY, aCLMessage3);
        }
    }

    private static class SendResponse
    extends ReplySender {
        public SendResponse(Agent agent, String string, String string2) {
            super(agent, string, string2);
        }

        private SendResponse() {
        }

        public int onEnd() {
            int n = super.onEnd();
            if (n != 1 && n != -1) {
                AchieveREResponder achieveREResponder = (AchieveREResponder)this.getParent();
                achieveREResponder.reset();
            }
            return n;
        }
    }

    private static class PrepareResponse
    extends OneShotBehaviour {
        public PrepareResponse(Agent agent) {
            super(agent);
        }

        public void action() {
            DataStore dataStore = this.getDataStore();
            AchieveREResponder achieveREResponder = (AchieveREResponder)this.getParent();
            ACLMessage aCLMessage = (ACLMessage)dataStore.get(achieveREResponder.REQUEST_KEY);
            ACLMessage aCLMessage2 = null;
            try {
                aCLMessage2 = achieveREResponder.prepareResponse(aCLMessage);
            }
            catch (NotUnderstoodException notUnderstoodException) {
                aCLMessage2 = notUnderstoodException.getACLMessage();
            }
            catch (RefuseException refuseException) {
                aCLMessage2 = refuseException.getACLMessage();
            }
            dataStore.put(achieveREResponder.RESPONSE_KEY, aCLMessage2);
        }

        private PrepareResponse() {
        }
    }
}

