/*
 * Decompiled with CFR 0.152.
 */
package jade.mtp.iiop;

import FIPA.MTS;
import FIPA.MTSHelper;
import jade.mtp.MTPException;
import jade.mtp.TransportAddress;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;

class IIOPAddress
implements TransportAddress {
    public static final byte BIG_ENDIAN = 0;
    public static final byte LITTLE_ENDIAN = 1;
    private static final String FIPA_2000_TYPE_ID = "IDL:FIPA/MTS:1.0";
    private static final String NS_TYPE_ID = "IDL:omg.org/CosNaming/NamingContext";
    private static final int TAG_INTERNET_IOP = 0;
    private static final byte IIOP_MAJOR = 1;
    private static final byte IIOP_MINOR = 0;
    private static final byte ASCII_PERCENT = IIOPAddress.getASCIIByte("%");
    private static final byte ASCII_UPPER_A = IIOPAddress.getASCIIByte("A");
    private static final byte ASCII_UPPER_Z = IIOPAddress.getASCIIByte("Z");
    private static final byte ASCII_LOWER_A = IIOPAddress.getASCIIByte("a");
    private static final byte ASCII_LOWER_Z = IIOPAddress.getASCIIByte("z");
    private static final byte ASCII_ZERO = IIOPAddress.getASCIIByte("0");
    private static final byte ASCII_NINE = IIOPAddress.getASCIIByte("9");
    private static final byte ASCII_MINUS = IIOPAddress.getASCIIByte("-");
    private static final byte ASCII_UNDERSCORE = IIOPAddress.getASCIIByte("_");
    private static final byte ASCII_DOT = IIOPAddress.getASCIIByte(".");
    private static final byte ASCII_BANG = IIOPAddress.getASCIIByte("!");
    private static final byte ASCII_TILDE = IIOPAddress.getASCIIByte("~");
    private static final byte ASCII_STAR = IIOPAddress.getASCIIByte("*");
    private static final byte ASCII_QUOTE = IIOPAddress.getASCIIByte("'");
    private static final byte ASCII_OPEN_BRACKET = IIOPAddress.getASCIIByte("(");
    private static final byte ASCII_CLOSED_BRACKET = IIOPAddress.getASCIIByte("$");
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final ORB orb;
    private String ior;
    private String host;
    private short port;
    private String objectKey;
    private String anchor;
    private CDRCodec codecStrategy;

    private static final byte getASCIIByte(String string) {
        try {
            return string.getBytes("US-ASCII")[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return 0;
        }
    }

    public IIOPAddress(ORB oRB, MTS mTS) throws MTPException {
        this(oRB, oRB.object_to_string((Object)mTS));
    }

    public IIOPAddress(ORB oRB, String string) throws MTPException {
        this.orb = oRB;
        if (string.toLowerCase().startsWith("ior:")) {
            this.initFromIOR(string);
        } else if (string.toLowerCase().startsWith("corbaloc:")) {
            this.initFromURL(string, (short)0);
        } else if (string.toLowerCase().startsWith("corbaname:")) {
            this.initFromNS(string);
        } else {
            throw new MTPException("Invalid string prefix");
        }
    }

    void initFromIOR(String string) throws MTPException {
        this.parseIOR(string, FIPA_2000_TYPE_ID);
        this.anchor = "";
    }

    private void initFromURL(String string, short s) throws MTPException {
        if ((string = string.substring(9)).toLowerCase().startsWith("iiop:")) {
            string = string.substring(5);
        } else if (string.startsWith(":")) {
            string = string.substring(1);
        } else {
            throw new MTPException("Invalid 'corbaloc' URL: neither 'iiop:' nor ':' was specified.");
        }
        this.buildIOR(string, FIPA_2000_TYPE_ID, s);
    }

    private void initFromNS(String string) throws MTPException {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.replace(0, 11, "corbaloc::");
        this.buildIOR(string.substring(11), NS_TYPE_ID, (short)0);
        Object object = this.orb.string_to_object(this.ior);
        NamingContext namingContext = NamingContextHelper.narrow((Object)object);
        try {
            java.lang.Object object2;
            java.lang.Object object3;
            StringTokenizer stringTokenizer = new StringTokenizer(this.anchor, "/.", true);
            ArrayList<NameComponent> arrayList = new ArrayList<NameComponent>();
            while (stringTokenizer.hasMoreTokens()) {
                object3 = stringTokenizer.nextToken();
                object2 = new NameComponent();
                object2.id = object3;
                arrayList.add((NameComponent)object2);
                if (!stringTokenizer.hasMoreTokens()) break;
                object3 = stringTokenizer.nextToken();
                if (((String)object3).equals(".")) {
                    object2.kind = object3 = stringTokenizer.nextToken();
                    continue;
                }
                if (((String)object3).equals("/")) continue;
                throw new MTPException("Ill-formed path into the Naming Service: Unknown separator.");
            }
            object3 = arrayList.toArray(new NameComponent[arrayList.size()]);
            object = namingContext.resolve((NameComponent[])object3);
            object2 = this.orb.object_to_string(object);
            this.initFromIOR((String)object2);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new MTPException("Ill-formed path into the Naming Service.", noSuchElementException);
        }
        catch (UserException userException) {
            throw new MTPException("CORBA Naming Service user exception.", userException);
        }
        catch (SystemException systemException) {
            throw new MTPException("CORBA Naming Service system exception.", systemException);
        }
    }

    private void parseIOR(String string, String string2) throws MTPException {
        try {
            this.ior = new String(string.toUpperCase());
            String string3 = this.ior.substring(4);
            short s = Short.parseShort(string3.substring(0, 2), 16);
            switch (s) {
                case 0: {
                    this.codecStrategy = new BigEndianCodec(string3);
                    break;
                }
                case 1: {
                    this.codecStrategy = new LittleEndianCodec(string3);
                    break;
                }
                default: {
                    throw new MTPException("Invalid endianness specifier");
                }
            }
            try {
                String string4 = this.codecStrategy.readString();
                if (!string4.equalsIgnoreCase(string2)) {
                    throw new MTPException("Invalid type ID" + string4);
                }
            }
            catch (Exception exception) {
                throw new MTPException("Invalid type ID");
            }
            int n = this.codecStrategy.readLong();
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.codecStrategy.readLong();
                byte[] byArray = this.codecStrategy.readOctetSequence();
                if (n3 == 0) {
                    CDRCodec cDRCodec;
                    switch (byArray[0]) {
                        case 0: {
                            cDRCodec = new BigEndianCodec(byArray);
                            break;
                        }
                        case 1: {
                            cDRCodec = new LittleEndianCodec(byArray);
                            break;
                        }
                        default: {
                            throw new MTPException("Invalid endianness specifier");
                        }
                    }
                    byte by = cDRCodec.readOctet();
                    byte by2 = cDRCodec.readOctet();
                    if (by != 1) {
                        throw new MTPException("IIOP version not supported");
                    }
                    try {
                        this.host = cDRCodec.readString();
                    }
                    catch (Exception exception) {
                        throw new MTPException("Invalid host string");
                    }
                    this.port = cDRCodec.readShort();
                    byte[] byArray2 = cDRCodec.readOctetSequence();
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int n4 = 0;
                    while (n4 < byArray2.length) {
                        byte by3 = byArray2[n4];
                        if (this.isUnreservedURIChar(by3)) {
                            byteArrayOutputStream.write(by3);
                        } else {
                            byteArrayOutputStream.write(ASCII_PERCENT);
                            byteArrayOutputStream.write(HEX[(by3 & 0xF0) >> 4]);
                            byteArrayOutputStream.write(HEX[by3 & 0xF]);
                        }
                        ++n4;
                    }
                    this.objectKey = byteArrayOutputStream.toString("US-ASCII");
                    this.codecStrategy = null;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            throw new MTPException(exception.getMessage());
        }
    }

    private void buildIOR(String string, String string2, short s) throws MTPException {
        CDRCodec cDRCodec;
        int n = string.indexOf(58);
        int n2 = string.indexOf(47);
        int n3 = string.indexOf(35);
        if (n == -1 || n2 == -1) {
            throw new MTPException("Invalid URL string");
        }
        this.host = new String(string.substring(0, n));
        this.port = Short.parseShort(string.substring(n + 1, n2));
        if (n3 == -1) {
            this.objectKey = new String(string.substring(n2 + 1, string.length()));
            this.anchor = "";
        } else {
            this.objectKey = new String(string.substring(n2 + 1, n3));
            this.anchor = new String(string.substring(n3 + 1, string.length()));
        }
        switch (s) {
            case 0: {
                this.codecStrategy = new BigEndianCodec(new byte[0]);
                break;
            }
            case 1: {
                this.codecStrategy = new LittleEndianCodec(new byte[0]);
                break;
            }
            default: {
                throw new MTPException("Invalid endianness specifier");
            }
        }
        this.codecStrategy.writeString(string2);
        this.codecStrategy.writeLong(1);
        this.codecStrategy.writeLong(0);
        switch (s) {
            case 0: {
                cDRCodec = new BigEndianCodec(new byte[0]);
                break;
            }
            case 1: {
                cDRCodec = new LittleEndianCodec(new byte[0]);
                break;
            }
            default: {
                throw new MTPException("Invalid endianness specifier");
            }
        }
        cDRCodec.writeOctet((byte)1);
        cDRCodec.writeOctet((byte)0);
        cDRCodec.writeString(this.host);
        cDRCodec.writeShort(this.port);
        try {
            String string3;
            byte[] byArray = this.objectKey.getBytes("US-ASCII");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n4 = 0;
            while (n4 < byArray.length) {
                byte by = byArray[n4];
                if (by != ASCII_PERCENT) {
                    byteArrayOutputStream.write(by);
                } else {
                    try {
                        string3 = new String(byArray, n4 + 1, 2, "US-ASCII");
                        short s2 = Short.parseShort(string3, 16);
                        by = s2 > 127 ? (byte)(s2 + -256) : (byte)s2;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        by = 0;
                    }
                    byteArrayOutputStream.write(by);
                    n4 += 2;
                }
                ++n4;
            }
            cDRCodec.writeOctetSequence(byteArrayOutputStream.toByteArray());
            byte[] byArray2 = cDRCodec.writtenBytes();
            this.codecStrategy.writeOctetSequence(byArray2);
            string3 = this.codecStrategy.writtenString();
            this.ior = "IOR:" + string3;
            this.codecStrategy = null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    private boolean isUnreservedURIChar(byte by) {
        if (ASCII_UPPER_A <= by && ASCII_UPPER_Z >= by) {
            return true;
        }
        if (ASCII_LOWER_A <= by && ASCII_LOWER_Z >= by) {
            return true;
        }
        if (ASCII_ZERO <= by && ASCII_NINE >= by) {
            return true;
        }
        return by == ASCII_MINUS || by == ASCII_UNDERSCORE || by == ASCII_DOT || by == ASCII_BANG || by == ASCII_TILDE || by == ASCII_STAR || by == ASCII_QUOTE || by == ASCII_OPEN_BRACKET || by == ASCII_CLOSED_BRACKET;
    }

    public String getURL() {
        int n = this.port;
        if (n < 0) {
            n += 65536;
        }
        return "corbaloc::" + this.host + ":" + n + "/" + this.objectKey;
    }

    public String getIOR() {
        return this.ior;
    }

    public MTS getObject() {
        return MTSHelper.narrow(this.orb.string_to_object(this.ior));
    }

    public String getProto() {
        return "iiop";
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return Short.toString(this.port);
    }

    public String getFile() {
        return this.objectKey;
    }

    public String getAnchor() {
        return this.anchor;
    }

    private static class LittleEndianCodec
    extends CDRCodec {
        public LittleEndianCodec(String string) {
            super(string);
            this.writeOctet((byte)1);
        }

        public LittleEndianCodec(byte[] byArray) {
            super(byArray);
            this.writeOctet((byte)1);
        }

        public short readShort() {
            this.setReadAlignment(2);
            short s = (short)(this.readBuffer[this.readIndex++] + (this.readBuffer[this.readIndex++] << 8));
            return s;
        }

        public int readLong() {
            this.setReadAlignment(4);
            int n = this.readBuffer[this.readIndex++] + (this.readBuffer[this.readIndex++] << 8) + (this.readBuffer[this.readIndex++] << 16) + (this.readBuffer[this.readIndex++] << 24);
            return n;
        }

        public long readLongLong() {
            this.setReadAlignment(8);
            long l = this.readBuffer[this.readIndex++] + (this.readBuffer[this.readIndex++] << 8);
            l += (long)((this.readBuffer[this.readIndex++] << 16) + (this.readBuffer[this.readIndex++] << 24));
            l += (long)((this.readBuffer[this.readIndex++] << 32) + (this.readBuffer[this.readIndex++] << 40));
            return l += (long)((this.readBuffer[this.readIndex++] << 48) + (this.readBuffer[this.readIndex++] << 56));
        }

        public void writeShort(short s) {
            this.setWriteAlignment(2);
            this.writeOctet((byte)(s & 0xFF));
            this.writeOctet((byte)((s & 0xFF00) >> 8));
        }

        public void writeLong(int n) {
            this.setWriteAlignment(4);
            this.writeOctet((byte)(n & 0xFF));
            this.writeOctet((byte)((n & 0xFF00) >> 8));
            this.writeOctet((byte)((n & 0xFF0000) >> 16));
            this.writeOctet((byte)((n & 0xFF000000) >> 24));
        }

        public void writeLongLong(long l) {
            this.setWriteAlignment(8);
            this.writeOctet((byte)(l & 0xFFL));
            this.writeOctet((byte)((l & 0xFF00L) >> 8));
            this.writeOctet((byte)((l & 0xFF0000L) >> 16));
            this.writeOctet((byte)((l & 0xFF000000L) >> 24));
            this.writeOctet((byte)((l & 0xFF00000000L) >> 32));
            this.writeOctet((byte)((l & 0xFF0000000000L) >> 40));
            this.writeOctet((byte)((l & 0xFF000000000000L) >> 48));
            this.writeOctet((byte)((l & 0xFF00000000000000L) >> 56));
        }
    }

    private static class BigEndianCodec
    extends CDRCodec {
        public BigEndianCodec(String string) {
            super(string);
            this.writeOctet((byte)0);
        }

        public BigEndianCodec(byte[] byArray) {
            super(byArray);
            this.writeOctet((byte)0);
        }

        public short readShort() {
            this.setReadAlignment(2);
            short s = (short)((this.readBuffer[this.readIndex++] << 8) + this.readBuffer[this.readIndex++]);
            return s;
        }

        public int readLong() {
            this.setReadAlignment(4);
            int n = (this.readBuffer[this.readIndex++] << 24) + (this.readBuffer[this.readIndex++] << 16);
            return n += (this.readBuffer[this.readIndex++] << 8) + this.readBuffer[this.readIndex++];
        }

        public long readLongLong() {
            this.setReadAlignment(8);
            long l = (this.readBuffer[this.readIndex++] << 56) + (this.readBuffer[this.readIndex++] << 48);
            l += (long)((this.readBuffer[this.readIndex++] << 40) + (this.readBuffer[this.readIndex++] << 32));
            l += (long)((this.readBuffer[this.readIndex++] << 24) + (this.readBuffer[this.readIndex++] << 16));
            return l += (long)((this.readBuffer[this.readIndex++] << 8) + this.readBuffer[this.readIndex++]);
        }

        public void writeShort(short s) {
            this.setWriteAlignment(2);
            this.writeOctet((byte)((s & 0xFF00) >> 8));
            this.writeOctet((byte)(s & 0xFF));
        }

        public void writeLong(int n) {
            this.setWriteAlignment(4);
            this.writeOctet((byte)((n & 0xFF000000) >> 24));
            this.writeOctet((byte)((n & 0xFF0000) >> 16));
            this.writeOctet((byte)((n & 0xFF00) >> 8));
            this.writeOctet((byte)(n & 0xFF));
        }

        public void writeLongLong(long l) {
            this.setWriteAlignment(8);
            this.writeOctet((byte)((l & 0xFF00000000000000L) >> 56));
            this.writeOctet((byte)((l & 0xFF000000000000L) >> 48));
            this.writeOctet((byte)((l & 0xFF0000000000L) >> 40));
            this.writeOctet((byte)((l & 0xFF00000000L) >> 32));
            this.writeOctet((byte)((l & 0xFF000000L) >> 24));
            this.writeOctet((byte)((l & 0xFF0000L) >> 16));
            this.writeOctet((byte)((l & 0xFF00L) >> 8));
            this.writeOctet((byte)(l & 0xFFL));
        }
    }

    private static abstract class CDRCodec {
        protected byte[] readBuffer;
        protected StringBuffer writeBuffer;
        protected int readIndex = 0;
        protected int writeIndex = 0;

        protected CDRCodec(String string) {
            this.readBuffer = this.bytesFromHexString(string);
            this.readIndex = 1;
            this.writeBuffer = new StringBuffer(255);
        }

        protected CDRCodec(byte[] byArray) {
            this.readBuffer = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.readBuffer, 0, this.readBuffer.length);
            this.readIndex = 1;
            this.writeBuffer = new StringBuffer(255);
        }

        public String writtenString() {
            return new String(this.writeBuffer);
        }

        public byte[] writtenBytes() {
            return this.bytesFromHexString(new String(this.writeBuffer));
        }

        public byte readOctet() {
            return this.readBuffer[this.readIndex++];
        }

        public byte[] readOctetSequence() {
            int n = this.readLong();
            byte[] byArray = new byte[n];
            System.arraycopy(this.readBuffer, this.readIndex, byArray, 0, n);
            this.readIndex += n;
            return byArray;
        }

        public String readString() {
            int n = this.readLong();
            String string = new String(this.readBuffer, this.readIndex, n - 1);
            this.readIndex += n;
            return string;
        }

        public abstract short readShort();

        public abstract int readLong();

        public abstract long readLongLong();

        public void writeOctet(byte by) {
            char[] cArray = new char[]{HEX[(by & 0xF0) >> 4], HEX[by & 0xF]};
            this.writeBuffer.append(cArray);
            ++this.writeIndex;
        }

        public void writeOctetSequence(byte[] byArray) {
            int n = byArray.length;
            this.writeLong(n);
            int n2 = 0;
            while (n2 < n) {
                this.writeOctet(byArray[n2]);
                ++n2;
            }
        }

        public void writeString(String string) {
            int n = string.length() + 1;
            this.writeLong(n);
            byte[] byArray = string.getBytes();
            int n2 = 0;
            while (n2 < string.length()) {
                this.writeOctet(byArray[n2]);
                ++n2;
            }
            this.writeOctet((byte)0);
        }

        public abstract void writeShort(short var1);

        public abstract void writeLong(int var1);

        public abstract void writeLongLong(long var1);

        protected void setReadAlignment(int n) {
            while (this.readIndex % n != 0) {
                ++this.readIndex;
            }
        }

        protected void setWriteAlignment(int n) {
            while (this.writeIndex % n != 0) {
                this.writeOctet((byte)0);
            }
        }

        private byte[] bytesFromHexString(String string) {
            int n = string.length() / 2;
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                String string2 = string.substring(2 * n2, 2 * (n2 + 1));
                Short s = Short.valueOf(string2, 16);
                byArray[n2] = s.byteValue();
                ++n2;
            }
            return byArray;
        }
    }
}

